"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Yaml = void 0;
const fs = require("fs");
const YAML = require("yaml");
/**
 * YAML utilities.
 */
class Yaml {
    /**
     * Saves a set of objects as a multi-document YAML file.
     *
     * @param filePath The output path
     * @param docs The set of objects
     */
    static save(filePath, docs) {
        const data = `# Generated by cdk-threagile\n\n${this.stringify(...docs)}`;
        fs.writeFileSync(filePath, data, { encoding: "utf8" });
    }
    /**
     * Stringify a document (or multiple documents) into YAML
     *
     * Undefined values become null.
     * Undefiend documents will be ignored.
     *
     * @param docs A set of objects to convert to YAML
     * @returns a YAML string. Multiple docs are separated by `---`.
     */
    static stringify(...docs) {
        return docs
            .map((r) => r === undefined
            ? "\n"
            : YAML.stringify(r, { keepUndefined: true, lineWidth: 0 }))
            .join("---\n");
    }
}
exports.Yaml = Yaml;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoieWFtbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy95YW1sLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHlCQUF5QjtBQUN6Qiw2QkFBNkI7QUFFN0I7O0dBRUc7QUFDSCxNQUFhLElBQUk7SUFDZjs7Ozs7T0FLRztJQUNJLE1BQU0sQ0FBQyxJQUFJLENBQUMsUUFBZ0IsRUFBRSxJQUFXO1FBQzlDLE1BQU0sSUFBSSxHQUFHLG1DQUFtQyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsSUFBSSxDQUFDLEVBQUUsQ0FBQztRQUMxRSxFQUFFLENBQUMsYUFBYSxDQUFDLFFBQVEsRUFBRSxJQUFJLEVBQUUsRUFBRSxRQUFRLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBRUQ7Ozs7Ozs7O09BUUc7SUFDSSxNQUFNLENBQUMsU0FBUyxDQUFDLEdBQUcsSUFBVztRQUNwQyxPQUFPLElBQUk7YUFDUixHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUNULENBQUMsS0FBSyxTQUFTO1lBQ2IsQ0FBQyxDQUFDLElBQUk7WUFDTixDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxhQUFhLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUM3RDthQUNBLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUNuQixDQUFDO0NBQ0Y7QUE5QkQsb0JBOEJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZnMgZnJvbSBcImZzXCI7XG5pbXBvcnQgKiBhcyBZQU1MIGZyb20gXCJ5YW1sXCI7XG5cbi8qKlxuICogWUFNTCB1dGlsaXRpZXMuXG4gKi9cbmV4cG9ydCBjbGFzcyBZYW1sIHtcbiAgLyoqXG4gICAqIFNhdmVzIGEgc2V0IG9mIG9iamVjdHMgYXMgYSBtdWx0aS1kb2N1bWVudCBZQU1MIGZpbGUuXG4gICAqXG4gICAqIEBwYXJhbSBmaWxlUGF0aCBUaGUgb3V0cHV0IHBhdGhcbiAgICogQHBhcmFtIGRvY3MgVGhlIHNldCBvZiBvYmplY3RzXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHNhdmUoZmlsZVBhdGg6IHN0cmluZywgZG9jczogYW55W10pIHtcbiAgICBjb25zdCBkYXRhID0gYCMgR2VuZXJhdGVkIGJ5IGNkay10aHJlYWdpbGVcXG5cXG4ke3RoaXMuc3RyaW5naWZ5KC4uLmRvY3MpfWA7XG4gICAgZnMud3JpdGVGaWxlU3luYyhmaWxlUGF0aCwgZGF0YSwgeyBlbmNvZGluZzogXCJ1dGY4XCIgfSk7XG4gIH1cblxuICAvKipcbiAgICogU3RyaW5naWZ5IGEgZG9jdW1lbnQgKG9yIG11bHRpcGxlIGRvY3VtZW50cykgaW50byBZQU1MXG4gICAqXG4gICAqIFVuZGVmaW5lZCB2YWx1ZXMgYmVjb21lIG51bGwuXG4gICAqIFVuZGVmaWVuZCBkb2N1bWVudHMgd2lsbCBiZSBpZ25vcmVkLlxuICAgKlxuICAgKiBAcGFyYW0gZG9jcyBBIHNldCBvZiBvYmplY3RzIHRvIGNvbnZlcnQgdG8gWUFNTFxuICAgKiBAcmV0dXJucyBhIFlBTUwgc3RyaW5nLiBNdWx0aXBsZSBkb2NzIGFyZSBzZXBhcmF0ZWQgYnkgYC0tLWAuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHN0cmluZ2lmeSguLi5kb2NzOiBhbnlbXSkge1xuICAgIHJldHVybiBkb2NzXG4gICAgICAubWFwKChyKSA9PlxuICAgICAgICByID09PSB1bmRlZmluZWRcbiAgICAgICAgICA/IFwiXFxuXCJcbiAgICAgICAgICA6IFlBTUwuc3RyaW5naWZ5KHIsIHsga2VlcFVuZGVmaW5lZDogdHJ1ZSwgbGluZVdpZHRoOiAwIH0pXG4gICAgICApXG4gICAgICAuam9pbihcIi0tLVxcblwiKTtcbiAgfVxufVxuIl19