"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrustBoundaryType = exports.TrustBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const uuid_1 = require("uuid");
class TrustBoundary extends constructs_1.Construct {
    constructor(model, id, props) {
        super(model, id);
        this.uuid = uuid_1.v4();
        this.description = props.description;
        this.type = props.type;
        this.technicalAssetsInside = new Set();
        this.trustBoundariesNested = new Set();
    }
    addTechnicalAssets(...assets) {
        assets.forEach((a) => {
            this.technicalAssetsInside.add(a.uuid);
        });
    }
    addTrustBoundary(boundary) {
        this.trustBoundariesNested.add(boundary.uuid);
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.type,
                technical_assets_inside: Array.from(this.technicalAssetsInside),
                trust_boundaries_nested: Array.from(this.trustBoundariesNested),
            },
        };
    }
}
exports.TrustBoundary = TrustBoundary;
_a = JSII_RTTI_SYMBOL_1;
TrustBoundary[_a] = { fqn: "cdktg.TrustBoundary", version: "0.0.11" };
var TrustBoundaryType;
(function (TrustBoundaryType) {
    TrustBoundaryType["NETWORK_ON_PREM"] = "network-on-prem";
    TrustBoundaryType["NETWORK_DEDICATED_HOSTER"] = "network-dedicated-hoster";
    TrustBoundaryType["NETWORK_VIRTUAL_LAN"] = "network-virtual-lan";
    TrustBoundaryType["NETWORK_CLOUD_PROVIDER"] = "network-cloud-provider";
    TrustBoundaryType["NETWORK_CLOUD_SECURITY_GROUP"] = "network-cloud-security-group";
    TrustBoundaryType["NETWORK_POLICY_NAMESPACE_ISOLATION"] = "network-policy-namespace-isolation";
    TrustBoundaryType["EXECUTION_ENVIRONMENT"] = "execution-environment";
})(TrustBoundaryType = exports.TrustBoundaryType || (exports.TrustBoundaryType = {}));
//# sourceMappingURL=data:application/json;base64,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