import { Construct } from "constructs";
import * as spec from "./spec/threatgile.generated";
import { TechnicalAsset } from "./technical-asset";
export interface TrustBoundaryProps {
    readonly description: string;
    readonly type: TrustBoundaryType;
}
export declare class TrustBoundary extends Construct {
    readonly uuid: string;
    readonly description: string;
    readonly type: TrustBoundaryType;
    private technicalAssetsInside;
    private trustBoundariesNested;
    constructor(model: Construct, id: string, props: TrustBoundaryProps);
    addTechnicalAssets(...assets: TechnicalAsset[]): void;
    addTrustBoundary(boundary: TrustBoundary): void;
    /**
     * @internal
     */
    _toThreagile(): spec.Threagile["trust_boundaries"];
}
export declare enum TrustBoundaryType {
    NETWORK_ON_PREM = "network-on-prem",
    NETWORK_DEDICATED_HOSTER = "network-dedicated-hoster",
    NETWORK_VIRTUAL_LAN = "network-virtual-lan",
    NETWORK_CLOUD_PROVIDER = "network-cloud-provider",
    NETWORK_CLOUD_SECURITY_GROUP = "network-cloud-security-group",
    NETWORK_POLICY_NAMESPACE_ISOLATION = "network-policy-namespace-isolation",
    EXECUTION_ENVIRONMENT = "execution-environment"
}
