"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.Encryption = exports.Machine = exports.Technology = exports.Size = exports.AssetType = exports.TechnicalAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const asset_1 = require("./asset");
const communication_1 = require("./communication");
const scope_1 = require("./scope");
class TechnicalAsset extends asset_1.Asset {
    constructor(model, id, props) {
        super(model, id, props);
        this.assetType = props.assetType;
        this.humanUse = props.humanUse;
        this.internet = props.internet;
        this.scope = props.scope ?? new scope_1.InScope();
        this.size = props.size;
        this.technology = props.technology;
        this.machine = props.machine;
        this.encryption = props.encryption;
        this.owner = props.owner;
        this.multiTenant = props.multiTenant;
        this.redundant = props.redundant;
        this.dataAssetsProcessed = new Set();
        this.dataAssetsStored = new Set();
        this.communications = new Array();
        if (props.trustBoundary) {
            props.trustBoundary.addTechnicalAssets(this);
        }
    }
    process(...assets) {
        assets.forEach((a) => {
            this.dataAssetsProcessed.add(a.uuid);
        });
    }
    store(...assets) {
        assets.forEach((a) => {
            this.dataAssetsStored.add(a.uuid);
        });
    }
    communicateWith(id, target, options) {
        const communication = new communication_1.Communication(id, {
            target: target,
            ...options,
        });
        this.communications.push(communication);
        return communication;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.assetType,
                usage: this.usage,
                used_as_client_by_human: this.humanUse,
                ...this.scope?._toThreagile(),
                size: this.size,
                technology: this.technology,
                internet: this.internet,
                machine: this.machine,
                encryption: this.encryption,
                owner: this.owner,
                ...this.ciaTriad._toThreagile(),
                multitenant: this.multiTenant,
                redundant: this.redundant,
                data_assets_processed: Array.from(this.dataAssetsProcessed),
                data_assets_stored: Array.from(this.dataAssetsStored),
            },
        };
        if (this.communications.length > 0) {
            threagile[this.node.id].communication_links = {};
            this.communications.forEach((c) => {
                threagile[this.node.id].communication_links = {
                    ...threagile[this.node.id].communication_links,
                    ...c._toThreagile(),
                };
            });
        }
        return threagile;
    }
}
exports.TechnicalAsset = TechnicalAsset;
_a = JSII_RTTI_SYMBOL_1;
TechnicalAsset[_a] = { fqn: "cdktg.TechnicalAsset", version: "0.0.11" };
var AssetType;
(function (AssetType) {
    AssetType["EXTERNAL_ENTITY"] = "external-entity";
    AssetType["PROCESS"] = "process";
    AssetType["DATASTORE"] = "datastore";
})(AssetType = exports.AssetType || (exports.AssetType = {}));
var Size;
(function (Size) {
    Size["SYSTEM"] = "system";
    Size["SERVICE"] = "service";
    Size["APPLICATION"] = "application";
    Size["COMPONENT"] = "component";
})(Size = exports.Size || (exports.Size = {}));
var Technology;
(function (Technology) {
    Technology["UNKNOWN"] = "unknown-technology";
    Technology["CLIENT_SYSTEM"] = "client-system";
    Technology["BROWSER"] = "browser";
    Technology["DESKTOP"] = "desktop";
    Technology["MOBILE_APP"] = "mobile-app";
    Technology["DEVOPS_CLIENT"] = "devops-client";
    Technology["WEB_SERVER"] = "web-server";
    Technology["WEB_APPLICATION"] = "web-application";
    Technology["APPLICATION_SERVER"] = "application-server";
    Technology["DATABASE"] = "database";
    Technology["FILE_SERVER"] = "file-server";
    Technology["LOCAL_FILE_SERVER"] = "local-file-system";
    Technology["ERP"] = "erp";
    Technology["CMS"] = "cms";
    Technology["WEB_SERVICE_REST"] = "web-service-rest";
    Technology["WEB_SERVICE_SOAP"] = "web-service-soap";
    Technology["EJB"] = "ejb";
    Technology["SEARCH_INDEX"] = "search-index";
    Technology["SEARCH_ENGINE"] = "search-engine";
    Technology["SERVICE_REGISTRY"] = "service-registry";
    Technology["REVERSE_PROXY"] = "reverse-proxy";
    Technology["LOAD_BALANCER"] = "load-balancer";
    Technology["BUILD_PIPELINE"] = "build-pipeline";
    Technology["SOURCECODE_REPOSITORY"] = "sourcecode-repository";
    Technology["ARTIFACT_REGISTRY"] = "artifact-registry";
    Technology["CODE_INSPECTION_PLATFORM"] = "code-inspection-platform";
    Technology["MONITORING"] = "monitoring";
    Technology["LDAP_SERVER"] = "ldap-server";
    Technology["CONTAINER_PLATFORM"] = "container-platform";
    Technology["BATCH_PROCESSING"] = "batch-processing";
    Technology["EVENT_LISTENER"] = "event-listener";
    Technology["IDENTITIY_PROVIDER"] = "identity-provider";
    Technology["IDENTITY_STORE_LDAP"] = "identity-store-ldap";
    Technology["IDENTITY_STORE_DATABASE"] = "identity-store-database";
    Technology["TOOL"] = "tool";
    Technology["CLI"] = "cli";
    Technology["TASK"] = "task";
    Technology["FUNCTION"] = "function";
    Technology["GATEWAY"] = "gateway";
    Technology["IOT_DEVICE"] = "iot-device";
    Technology["MESSAGE_QUEUE"] = "message-queue";
    Technology["STREAM_PROCESSING"] = "stream-processing";
    Technology["SERVICE_MESH"] = "service-mesh";
    Technology["DATA_LAKE"] = "data-lake";
    Technology["REPORT_ENGINE"] = "report-engine";
    Technology["AI"] = "ai";
    Technology["MAIL_SERVER"] = "mail-server";
    Technology["VAULT"] = "vault";
    Technology["HASM"] = "hsm";
    Technology["WAF"] = "waf";
    Technology["IDS"] = "ids";
    Technology["IPS"] = "ips";
    Technology["SCHEDULER"] = "scheduler";
    Technology["MAINFRAME"] = "mainframe";
    Technology["BLOCK_STORAGE"] = "block-storage";
    Technology["LIBRARY"] = "library";
})(Technology = exports.Technology || (exports.Technology = {}));
var Machine;
(function (Machine) {
    Machine["PHYSICAL"] = "physical";
    Machine["VIRTUAL"] = "virtual";
    Machine["CONTAINER"] = "container";
    Machine["SERVERLESS"] = "serverless";
})(Machine = exports.Machine || (exports.Machine = {}));
var Encryption;
(function (Encryption) {
    Encryption["NONE"] = "none";
    Encryption["TRANSPARENT"] = "transparent";
    Encryption["SYMMETRIC_SHARED_KEY"] = "data-with-symmetric-shared-key";
    Encryption["ASYMMETRIC_SHARED_KEY"] = "data-with-asymmetric-shared-key";
    Encryption["ENDUSER_INDIVIDUAL_KEY"] = "data-with-enduser-individual-key";
})(Encryption = exports.Encryption || (exports.Encryption = {}));
var DataFormat;
(function (DataFormat) {
    DataFormat["JSON"] = "json";
    DataFormat["XML"] = "xml";
    DataFormat["SERIALIZATION"] = "serialization";
    DataFormat["FILE"] = "file";
    DataFormat["CSV"] = "csv";
})(DataFormat = exports.DataFormat || (exports.DataFormat = {}));
//# sourceMappingURL=data:application/json;base64,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