import { Construct } from "constructs";
import { Asset, AssetProps } from "./asset";
import { Communication, CommunicationOptions } from "./communication";
import { DataAsset } from "./data-asset";
import { Scope } from "./scope";
import * as spec from "./spec/threatgile.generated";
import { TrustBoundary } from "./trust-boundary";
export interface TechnicalAssetProps extends AssetProps {
    readonly assetType: AssetType;
    readonly humanUse: boolean;
    readonly scope?: Scope;
    readonly size: Size;
    readonly technology: Technology;
    readonly internet: boolean;
    readonly machine: Machine;
    readonly encryption: Encryption;
    readonly owner: string;
    readonly multiTenant: boolean;
    readonly redundant: boolean;
    readonly trustBoundary?: TrustBoundary;
}
export declare class TechnicalAsset extends Asset {
    readonly assetType: AssetType;
    readonly internet: boolean;
    readonly humanUse: boolean;
    readonly scope?: Scope;
    readonly size: Size;
    readonly technology: Technology;
    readonly machine: Machine;
    readonly encryption: Encryption;
    readonly owner: string;
    readonly multiTenant: boolean;
    readonly redundant: boolean;
    private dataAssetsProcessed;
    private dataAssetsStored;
    private communications;
    constructor(model: Construct, id: string, props: TechnicalAssetProps);
    process(...assets: DataAsset[]): void;
    store(...assets: DataAsset[]): void;
    communicateWith(id: string, target: TechnicalAsset, options: CommunicationOptions): Communication;
    /**
     * @internal
     */
    _toThreagile(): spec.Threagile["technical_assets"];
}
export declare enum AssetType {
    EXTERNAL_ENTITY = "external-entity",
    PROCESS = "process",
    DATASTORE = "datastore"
}
export declare enum Size {
    SYSTEM = "system",
    SERVICE = "service",
    APPLICATION = "application",
    COMPONENT = "component"
}
export declare enum Technology {
    UNKNOWN = "unknown-technology",
    CLIENT_SYSTEM = "client-system",
    BROWSER = "browser",
    DESKTOP = "desktop",
    MOBILE_APP = "mobile-app",
    DEVOPS_CLIENT = "devops-client",
    WEB_SERVER = "web-server",
    WEB_APPLICATION = "web-application",
    APPLICATION_SERVER = "application-server",
    DATABASE = "database",
    FILE_SERVER = "file-server",
    LOCAL_FILE_SERVER = "local-file-system",
    ERP = "erp",
    CMS = "cms",
    WEB_SERVICE_REST = "web-service-rest",
    WEB_SERVICE_SOAP = "web-service-soap",
    EJB = "ejb",
    SEARCH_INDEX = "search-index",
    SEARCH_ENGINE = "search-engine",
    SERVICE_REGISTRY = "service-registry",
    REVERSE_PROXY = "reverse-proxy",
    LOAD_BALANCER = "load-balancer",
    BUILD_PIPELINE = "build-pipeline",
    SOURCECODE_REPOSITORY = "sourcecode-repository",
    ARTIFACT_REGISTRY = "artifact-registry",
    CODE_INSPECTION_PLATFORM = "code-inspection-platform",
    MONITORING = "monitoring",
    LDAP_SERVER = "ldap-server",
    CONTAINER_PLATFORM = "container-platform",
    BATCH_PROCESSING = "batch-processing",
    EVENT_LISTENER = "event-listener",
    IDENTITIY_PROVIDER = "identity-provider",
    IDENTITY_STORE_LDAP = "identity-store-ldap",
    IDENTITY_STORE_DATABASE = "identity-store-database",
    TOOL = "tool",
    CLI = "cli",
    TASK = "task",
    FUNCTION = "function",
    GATEWAY = "gateway",
    IOT_DEVICE = "iot-device",
    MESSAGE_QUEUE = "message-queue",
    STREAM_PROCESSING = "stream-processing",
    SERVICE_MESH = "service-mesh",
    DATA_LAKE = "data-lake",
    REPORT_ENGINE = "report-engine",
    AI = "ai",
    MAIL_SERVER = "mail-server",
    VAULT = "vault",
    HASM = "hsm",
    WAF = "waf",
    IDS = "ids",
    IPS = "ips",
    SCHEDULER = "scheduler",
    MAINFRAME = "mainframe",
    BLOCK_STORAGE = "block-storage",
    LIBRARY = "library"
}
export declare enum Machine {
    PHYSICAL = "physical",
    VIRTUAL = "virtual",
    CONTAINER = "container",
    SERVERLESS = "serverless"
}
export declare enum Encryption {
    NONE = "none",
    TRANSPARENT = "transparent",
    SYMMETRIC_SHARED_KEY = "data-with-symmetric-shared-key",
    ASYMMETRIC_SHARED_KEY = "data-with-asymmetric-shared-key",
    ENDUSER_INDIVIDUAL_KEY = "data-with-enduser-individual-key"
}
export declare enum DataFormat {
    JSON = "json",
    XML = "xml",
    SERIALIZATION = "serialization",
    FILE = "file",
    CSV = "csv"
}
