"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessCriticality = exports.Model = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const data_asset_1 = require("./data-asset");
const synthesizer_1 = require("./synthesizer");
const technical_asset_1 = require("./technical-asset");
const trust_boundary_1 = require("./trust-boundary");
const MODEL_SYMBOL = Symbol.for("cdktg/Model");
class Model extends constructs_1.Construct {
    constructor(project, id, props) {
        super(project, id);
        this.rawOverrides = {};
        this.version = props.version;
        this.title = props.title ?? id;
        this.date = props.date;
        this.author = props.author;
        this.businessCriticality = props.businessCriticality;
        this.synthesizer = new synthesizer_1.ModelSynthesizer(this, false);
        Object.defineProperty(this, MODEL_SYMBOL, { value: true });
    }
    static isModel(x) {
        return x !== null && typeof x === "object" && MODEL_SYMBOL in x;
    }
    addOverride(path, value) {
        const parts = path.split(".");
        let curr = this.rawOverrides;
        while (parts.length > 1) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const key = parts.shift();
            // if we can't recurse further or the previous value is not an
            // object overwrite it with an object.
            const isObject = curr[key] != null &&
                typeof curr[key] === "object" &&
                !Array.isArray(curr[key]);
            if (!isObject) {
                curr[key] = {};
            }
            curr = curr[key];
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const lastKey = parts.shift();
        curr[lastKey] = value;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const dataAssets = new Array();
        const technicalAssets = new Array();
        const trustBoundaries = new Array();
        this.node.findAll().map((n) => {
            if (n instanceof data_asset_1.DataAsset) {
                dataAssets.push(n);
            }
            else if (n instanceof technical_asset_1.TechnicalAsset) {
                technicalAssets.push(n);
            }
            else if (n instanceof trust_boundary_1.TrustBoundary) {
                trustBoundaries.push(n);
            }
        });
        const threagile = {
            threagile_version: this.version,
            title: this.title,
            data: this.date?.toISOString().split("T")[0],
            author: this.author._toThreagile(),
            business_criticality: this.businessCriticality,
        };
        if (dataAssets.length > 0) {
            threagile.data_assets = {};
            dataAssets.forEach((a) => {
                const obj = a._toThreagile();
                const k = Object.keys(obj)[0];
                threagile.data_assets[k] = obj[k];
            });
        }
        if (technicalAssets.length > 0) {
            threagile.technical_assets = {};
            technicalAssets.forEach((a) => {
                const obj = a._toThreagile();
                const k = Object.keys(obj)[0];
                threagile.technical_assets[k] = obj[k];
            });
        }
        if (trustBoundaries.length > 0) {
            threagile.trust_boundaries = {};
            trustBoundaries.forEach((t) => {
                const obj = t._toThreagile();
                if (obj) {
                    const k = Object.keys(obj)[0];
                    threagile.trust_boundaries[k] = obj[k];
                }
            });
        }
        return {
            ...threagile,
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { stack: Object.keys(this.rawOverrides) } }
                : {}),
        };
    }
}
exports.Model = Model;
_a = JSII_RTTI_SYMBOL_1;
Model[_a] = { fqn: "cdktg.Model", version: "0.0.11" };
var BusinessCriticality;
(function (BusinessCriticality) {
    BusinessCriticality["ARCHIVE"] = "archive";
    BusinessCriticality["OPERATIONAL"] = "operational";
    BusinessCriticality["IMPORTANT"] = "important";
    BusinessCriticality["CRITICAL"] = "critical";
    BusinessCriticality["MISSION_CRITICAL"] = "mission-critical";
})(BusinessCriticality = exports.BusinessCriticality || (exports.BusinessCriticality = {}));
//# sourceMappingURL=data:application/json;base64,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