"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Manifest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
class Manifest {
    constructor(version, outdir) {
        this.version = version;
        this.outdir = outdir;
        this.models = {};
        const modelsPath = path.join(this.outdir, Manifest.modelsFolder);
        if (!fs.existsSync(modelsPath))
            fs.mkdirSync(modelsPath);
    }
    static fromPath(dir) {
        const { version, models } = fs.readJSONSync(path.join(dir, Manifest.fileName));
        const manifest = new Manifest(version, dir);
        Object.keys(models).forEach((k) => {
            manifest.models[k] = models[k];
        });
        return manifest;
    }
    forModel(model) {
        const node = model.node;
        const name = node.id;
        if (this.models[name]) {
            return this.models[name];
        }
        const sanitizedName = `${`${name}`.replace(/[^0-9a-zA-Z-_.]/g, "")}`;
        const manifest = {
            name,
            sanitizedName,
            constructPath: node.path,
            workingDirectory: path.join(Manifest.modelsFolder),
            synthesizedModelPath: path.join(Manifest.modelsFolder, `${sanitizedName}.yml`),
            annotations: [],
        };
        this.models[name] = manifest;
        return manifest;
    }
    buildManifest() {
        return {
            version: this.version,
            models: this.models,
        };
    }
    writeToFile() {
        fs.writeJSONSync(path.join(this.outdir, Manifest.fileName), this.buildManifest(), {
            spaces: 4,
        });
    }
}
exports.Manifest = Manifest;
_a = JSII_RTTI_SYMBOL_1;
Manifest[_a] = { fqn: "cdktg.Manifest", version: "0.0.11" };
Manifest.fileName = "manifest.json";
Manifest.modelsFolder = "models";
//# sourceMappingURL=data:application/json;base64,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