"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Quantity = exports.DataAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const asset_1 = require("./asset");
class DataAsset extends asset_1.Asset {
    constructor(model, id, props) {
        super(model, id, props);
        this.origin = props.origin;
        this.owner = props.owner;
        this.quantity = props.quantity;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                usage: this.usage,
                origin: this.origin,
                owner: this.owner,
                quantity: this.quantity,
                ...this.ciaTriad._toThreagile(),
            },
        };
    }
}
exports.DataAsset = DataAsset;
_a = JSII_RTTI_SYMBOL_1;
DataAsset[_a] = { fqn: "cdktg.DataAsset", version: "0.0.11" };
var Quantity;
(function (Quantity) {
    Quantity["VERY_FEW"] = "very-few";
    Quantity["FEW"] = "few";
    Quantity["MANY"] = "many";
    Quantity["VERY_MANY"] = "very-many";
})(Quantity = exports.Quantity || (exports.Quantity = {}));
//# sourceMappingURL=data:application/json;base64,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