"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynthCommand = void 0;
const execa = require("execa");
const fs = require("fs-extra");
class SynthCommand {
    constructor() {
        this.command = "synth <filename>";
        this.describe = "synthesize the models";
        this.builder = (args) => {
            args.positional("filename", { demandOption: true, type: "string" });
            args.option("watch", {
                boolean: true,
                alias: "w",
                describe: "get watch with it!",
            });
            return args;
        };
        this.handler = async (args) => {
            const { filename } = args;
            if (!fs.existsSync(filename)) {
                throw new Error(`File ${filename} not exist!`);
            }
            const command = require.resolve("ts-node/dist/bin");
            execa(command, [filename], {
                stdio: ["ignore", "inherit", "inherit"],
            });
        };
    }
}
exports.SynthCommand = SynthCommand;
//# sourceMappingURL=data:application/json;base64,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