"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const cloudFormation = new aws_sdk_1.CloudFormation();
async function handler() {
    var _a;
    const res = [];
    let nextToken;
    let finished = false;
    while (!finished) {
        const response = await cloudFormation.describeStacks({ NextToken: nextToken }).promise();
        res.push(...((_a = response.Stacks) !== null && _a !== void 0 ? _a : []).map(s => s.StackName));
        nextToken = response.NextToken;
        if (nextToken === undefined) {
            finished = true;
        }
    }
    return res;
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0LXN0YWNrLW5hbWVzLmxhbWJkYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy90b29sa2l0LWNsZWFuZXIvZ2V0LXN0YWNrLW5hbWVzLmxhbWJkYS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxxQ0FBeUMsQ0FBQyx3REFBd0Q7QUFFbEcsTUFBTSxjQUFjLEdBQUcsSUFBSSx3QkFBYyxFQUFFLENBQUM7QUFFckMsS0FBSyxVQUFVLE9BQU87O0lBQzNCLE1BQU0sR0FBRyxHQUFhLEVBQUUsQ0FBQztJQUV6QixJQUFJLFNBQTZCLENBQUM7SUFDbEMsSUFBSSxRQUFRLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLE9BQU8sQ0FBQyxRQUFRLEVBQUU7UUFDaEIsTUFBTSxRQUFRLEdBQUcsTUFBTSxjQUFjLENBQUMsY0FBYyxDQUFDLEVBQUUsU0FBUyxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDekYsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLE9BQUMsUUFBUSxDQUFDLE1BQU0sbUNBQUksRUFBRSxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7UUFFM0QsU0FBUyxHQUFHLFFBQVEsQ0FBQyxTQUFTLENBQUM7UUFDL0IsSUFBSSxTQUFTLEtBQUssU0FBUyxFQUFFO1lBQzNCLFFBQVEsR0FBRyxJQUFJLENBQUM7U0FDakI7S0FDRjtJQUVELE9BQU8sR0FBRyxDQUFDO0FBQ2IsQ0FBQztBQWhCRCwwQkFnQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDbG91ZEZvcm1hdGlvbiB9IGZyb20gJ2F3cy1zZGsnOyAvLyBlc2xpbnQtZGlzYWJsZS1saW5lIGltcG9ydC9uby1leHRyYW5lb3VzLWRlcGVuZGVuY2llc1xuXG5jb25zdCBjbG91ZEZvcm1hdGlvbiA9IG5ldyBDbG91ZEZvcm1hdGlvbigpO1xuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gaGFuZGxlcigpIHtcbiAgY29uc3QgcmVzOiBzdHJpbmdbXSA9IFtdO1xuXG4gIGxldCBuZXh0VG9rZW46IHN0cmluZyB8IHVuZGVmaW5lZDtcbiAgbGV0IGZpbmlzaGVkID0gZmFsc2U7XG4gIHdoaWxlICghZmluaXNoZWQpIHtcbiAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IGNsb3VkRm9ybWF0aW9uLmRlc2NyaWJlU3RhY2tzKHsgTmV4dFRva2VuOiBuZXh0VG9rZW4gfSkucHJvbWlzZSgpO1xuICAgIHJlcy5wdXNoKC4uLihyZXNwb25zZS5TdGFja3MgPz8gW10pLm1hcChzID0+IHMuU3RhY2tOYW1lKSk7XG5cbiAgICBuZXh0VG9rZW4gPSByZXNwb25zZS5OZXh0VG9rZW47XG4gICAgaWYgKG5leHRUb2tlbiA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICBmaW5pc2hlZCA9IHRydWU7XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHJlcztcbn1cbiJdfQ==