import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as ses from 'aws-cdk-lib/aws-ses';
import { Construct } from 'constructs';
/**
 * Properties for an EmailReceiver
 */
export interface EmailReceiverProps {
    /**
     * The SES receipt rule set where a receipt rule will be added
     */
    readonly receiptRuleSet: ses.IReceiptRuleSet;
    /**
     * The recipients for which emails should be received
     */
    readonly recipients: string[];
    /**
     * A Lambda function to invoke after the message is saved to S3. The Lambda
     * function will be invoked with a SESMessage as event.
     */
    readonly function: lambda.IFunction;
    /**
     * A regular expression to whitelist source email addresses
     *
     * @default - no whitelisting of source email addresses
     */
    readonly sourceWhitelist?: string;
    /**
     * An existing rule after which the new rule will be placed in the rule set.
     *
     * @default - The new rule is inserted at the beginning of the rule list.
     */
    readonly afterRule?: ses.IReceiptRule;
}
/**
 * Receive emails through SES, save them to S3 and invokes a
 * Lambda function
 */
export declare class EmailReceiver extends Construct {
    constructor(scope: Construct, id: string, props: EmailReceiverProps);
}
