var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/email-receiver/whitelist.lambda.ts
var whitelist_lambda_exports = {};
__export(whitelist_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(whitelist_lambda_exports);
async function handler(event) {
  console.log("Event: %j", event);
  const sesNotification = event.Records[0].ses;
  if (!process.env.SOURCE_WHITELIST) {
    console.log("Missing SOURCE_WHITELIST");
    return { disposition: "STOP_RULE" };
  }
  if (!new RegExp(process.env.SOURCE_WHITELIST).test(sesNotification.mail.source)) {
    console.log(`${sesNotification.mail.source} does not match /${process.env.SOURCE_WHITELIST}/`);
    return { disposition: "STOP_RULE" };
  }
  return { disposition: "CONTINUE" };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
