"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackCapabilities = void 0;
/**
 * Acknowledge IAM resources in AWS CloudFormation templates.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities
 */
var StackCapabilities;
(function (StackCapabilities) {
    /** Acknowledge your stack includes IAM resources */
    StackCapabilities["IAM"] = "CAPABILITY_IAM";
    /** Acknowledge your stack includes custom names for IAM resources */
    StackCapabilities["NAMED_IAM"] = "CAPABILITY_NAMED_IAM";
    /** Acknowledge your stack contains one or more macros */
    StackCapabilities["AUTO_EXPAND"] = "CAPABILITY_AUTO_EXPAND";
})(StackCapabilities = exports.StackCapabilities || (exports.StackCapabilities = {}));
//# sourceMappingURL=data:application/json;base64,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