from unittest import TestCase

from pkg_resources import resource_filename

import pyproteininference

TEST_DATABASE = resource_filename("pyproteininference", "../tests/data/test_database.fasta")
PARAMETER_FILE = resource_filename("pyproteininference", "../tests/data/test_params_inclusion.yaml")


class TestDigest(TestCase):
    def test_pyteomics_digest(self):

        # STEP 1: Load parameter file #
        # STEP 1: Load parameter file #
        # STEP 1: Load parameter file #
        protein_inference_parameters = pyproteininference.parameters.ProteinInferenceParameter(
            yaml_param_filepath=PARAMETER_FILE
        )

        # STEP 2: Start with running an In Silico Digestion #
        # STEP 2: Start with running an In Silico Digestion #
        # STEP 2: Start with running an In Silico Digestion #
        digest = pyproteininference.in_silico_digest.PyteomicsDigest(
            database_path=TEST_DATABASE,
            digest_type=protein_inference_parameters.digest_type,
            missed_cleavages=protein_inference_parameters.missed_cleavages,
            reviewed_identifier_symbol=protein_inference_parameters.reviewed_identifier_symbol,
            max_peptide_length=None,
            id_splitting=True,
        )
        digest.digest_fasta_database()

        self.assertSetEqual(
            digest.swiss_prot_protein_set,
            {
                "ARAF_HUMAN|P10398",
                "##ARAF_HUMAN|##P10398",
                "##BRAF_HUMAN|##P15056",
                "HNRPU_HUMAN|Q00839",
                "BRAF_HUMAN|P15056",
                "##RPOC_SHIF8|##Q0SY12",
                "TCAF1_HUMAN|Q9Y4C2-2",
                "##TCAF2_HUMAN|##A6NFQ2-3",
                "RAF1_HUMAN|P04049",
                "RPOC_SHIF8|Q0SY12",
                "##TCAF2_HUMAN|##A6NFQ2",
                "TCAF2_HUMAN|A6NFQ2-3",
                "##RAF1_HUMAN|##P04049",
                "##TCAF1_HUMAN|##Q9Y4C2-2",
                "TCAF2_HUMAN|A6NFQ2",
                "##TCAF1_HUMAN|##Q9Y4C2",
                "##HNRPU_HUMAN|##Q00839",
                "##TCAF2_HUMAN|##A6NFQ2-2",
                "TCAF2_HUMAN|A6NFQ2-2",
                "TCAF1_HUMAN|Q9Y4C2",
            },
        )

        self.assertSetEqual(
            digest.protein_to_peptide_dictionary["ARAF_HUMAN|P10398"],
            {
                "NIIHRDLKSNNIFLHEGLTVK",
                "FQR",
                "RIGTGSFGTVFRGR",
                "EERPLFPQILATIELLQR",
                "KTR",
                "LLSDCLKFQR",
                "RLLSDCLK",
                "IERSASEPSLHRTQADELPACLLSAAR",
                "AVGTVKVYLPNKQRTVVTVR",
                "VPTVCVDMSTNRQQFYHSVQDLSGGSRQHEAPSNRPLNELLTPQGPSPRTQHCDPEHFPFPAPANAPLQR",
                "FHQHCSSKVPTVCVDMSTNR",
                "GPPANGAEPSR",
                "TQHCDPEHFPFPAPANAPLQR",
                "NEMQVLR",
                "TRHVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTRFDMVQLIDVAR",
                "WSGAQPLEQPSGSVLWMAAEVIRMQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCR",
                "DGMSVYDSLDKALK",
                "TRWSGAQPLEQPSGSVLWMAAEVIR",
                "LLSDCLK",
                "VLKVSQPTAEQAQAFKNEMQVLR",
                "MQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCRDQIIFMVGRGYLSPDLSKISSNCPK",
                "WSGAQPLEQPSGSVLWMAAEVIRMQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCRDQIIFMVGR",
                "AMR",
                "GSPSPASVSSGR",
                "WHGDVAVKVLKVSQPTAEQAQAFKNEMQVLR",
                "TR",
                "SPHSKSPAEQR",
                "SLADDKK",
                "NLGYRDSGYYWEVPPSEVQLLKRIGTGSFGTVFR",
                "WHGDVAVKVLK",
                "NIIHRDLKSNNIFLHEGLTVKIGDFGLATVK",
                "TRWSGAQPLEQPSGSVLWMAAEVIRMQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCRDQIIFMVGR",
                "EERPLFPQILATIELLQRSLPKIER",
                "EERPLFPQILATIELLQRSLPKIERSASEPSLHR",
                "MQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCRDQIIFMVGR",
                "IGDFGLATVKTRWSGAQPLEQPSGSVLWMAAEVIRMQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCR",
                "FQREERPLFPQILATIELLQRSLPKIER",
                "TVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVRKTFFSLAFCDFCLK",
                "KSPHSKSPAEQR",
                "QTAQGMDYLHAKNIIHR",
                "SNNIFLHEGLTVKIGDFGLATVK",
                "ERK",
                "TVVTVRDGMSVYDSLDK",
                "VRGLNQDCCVVYRLIK",
                "AVGTVK",
                "QQFYHSVQDLSGGSRQHEAPSNRPLNELLTPQGPSPRTQHCDPEHFPFPAPANAPLQR",
                "KSPHSKSPAEQRER",
                "LLSDCLKFQREERPLFPQILATIELLQR",
                "WHGDVAVKVLKVSQPTAEQAQAFK",
                "TVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVRKTFFSLAFCDFCLKFLFHGFR",
                "RIGTGSFGTVFR",
                "R",
                "KSLADDK",
                "ISSNCPKAMRRLLSDCLK",
                "MEPPR",
                "NEMQVLRKTRHVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTR",
                "CQTCGYKFHQHCSSK",
                "QRTVVTVRDGMSVYDSLDK",
                "SASEPSLHR",
                "NLGYR",
                "ER",
                "KTFFSLAFCDFCLKFLFHGFR",
                "QHEAPSNRPLNELLTPQGPSPRTQHCDPEHFPFPAPANAPLQR",
                "ISSNCPKAMRR",
                "TFFSLAFCDFCLKFLFHGFR",
                "STSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSR",
                "DQIIFMVGR",
                "KSPHSK",
                "DLKSNNIFLHEGLTVKIGDFGLATVK",
                "NIIHRDLK",
                "GRWHGDVAVK",
                "IGTGSFGTVFRGRWHGDVAVK",
                "QTAQGMDYLHAK",
                "VSQPTAEQAQAFKNEMQVLR",
                "DGMSVYDSLDK",
                "EPPRGPPANGAEPSR",
                "EPPRGPPANGAEPSRAVGTVKVYLPNK",
                "ALKVRGLNQDCCVVYRLIK",
                "STSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSRGGSDGTPRGSPSPASVSSGR",
                "IRSTSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSRGGSDGTPRGSPSPASVSSGR",
                "SPAEQRERKSLADDK",
                "FLFHGFRCQTCGYK",
                "QQFYHSVQDLSGGSRQHEAPSNRPLNELLTPQGPSPR",
                "FDMVQLIDVAR",
                "NLGYRDSGYYWEVPPSEVQLLK",
                "QTAQGMDYLHAKNIIHRDLKSNNIFLHEGLTVK",
                "MEPPRGPPANGAEPSR",
                "LLSDCLKFQREERPLFPQILATIELLQRSLPK",
                "GLNQDCCVVYRLIKGR",
                "GGSDGTPRGSPSPASVSSGR",
                "SPAEQR",
                "GPPANGAEPSRAVGTVKVYLPNKQR",
                "TVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVR",
                "GPPANGAEPSRAVGTVK",
                "WSGAQPLEQPSGSVLWMAAEVIRMQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCRDQIIFMVGRGYLSPDLSK",
                "CQTCGYK",
                "KSLADDKK",
                "RLLSDCLKFQR",
                "VR",
                "KVK",
                "DSGYYWEVPPSEVQLLKR",
                "TRHVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTRFDMVQLIDVARQTAQGMDYLHAK",
                "FHQHCSSKVPTVCVDMSTNRQQFYHSVQDLSGGSR",
                "KSLADDKKK",
                "EERPLFPQILATIELLQRSLPK",
                "TVVTVRDGMSVYDSLDKALK",
                "KTFFSLAFCDFCLK",
                "GGSDGTPR",
                "ALKVR",
                "VKNLGYRDSGYYWEVPPSEVQLLK",
                "QHEAPSNRPLNELLTPQGPSPRTQHCDPEHFPFPAPANAPLQRIRSTSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSR",
                "IRSTSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSR",
                "FHQHCSSKVPTVCVDMSTNRQQFYHSVQDLSGGSRQHEAPSNRPLNELLTPQGPSPR",
                "VPTVCVDMSTNRQQFYHSVQDLSGGSRQHEAPSNRPLNELLTPQGPSPR",
                "QHEAPSNRPLNELLTPQGPSPRTQHCDPEHFPFPAPANAPLQRIR",
                "DSGYYWEVPPSEVQLLKRIGTGSFGTVFRGR",
                "VSQPTAEQAQAFKNEMQVLRKTR",
                "GRKTVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVR",
                "KTVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVRK",
                "TRHVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTR",
                "FHQHCSSK",
                "TQADELPACLLSAARLVP",
                "DGMSVYDSLDKALKVRGLNQDCCVVYR",
                "CQTCGYKFHQHCSSKVPTVCVDMSTNRQQFYHSVQDLSGGSR",
                "KTRHVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTRFDMVQLIDVAR",
                "VYLPNKQRTVVTVR",
                "VK",
                "STSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSRGGSDGTPRGSPSPASVSSGRK",
                "DQIIFMVGRGYLSPDLSKISSNCPK",
                "AVGTVKVYLPNK",
                "ISSNCPKAMR",
                "TQHCDPEHFPFPAPANAPLQRIRSTSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSRGGSDGTPR",
                "RIGTGSFGTVFRGRWHGDVAVK",
                "GLNQDCCVVYRLIK",
                "NEMQVLRKTR",
                "IGTGSFGTVFR",
                "IGDFGLATVKTRWSGAQPLEQPSGSVLWMAAEVIR",
                "TFFSLAFCDFCLK",
                "SLPKIER",
                "IGTGSFGTVFRGRWHGDVAVKVLK",
                "GR",
                "IRSTSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSRGGSDGTPR",
                "KTFFSLAFCDFCLKFLFHGFRCQTCGYK",
                "EPPRGPPANGAEPSRAVGTVK",
                "FLFHGFRCQTCGYKFHQHCSSK",
                "VRGLNQDCCVVYRLIKGR",
                "QQFYHSVQDLSGGSRQHEAPSNRPLNELLTPQGPSPRTQHCDPEHFPFPAPANAPLQRIR",
                "ERKSLADDK",
                "FDMVQLIDVARQTAQGMDYLHAK",
                "TQADELPACLLSAAR",
                "QRTVVTVRDGMSVYDSLDKALK",
                "FLFHGFRCQTCGYKFHQHCSSKVPTVCVDMSTNR",
                "SPHSK",
                "GRKTVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVRK",
                "TRWSGAQPLEQPSGSVLWMAAEVIRMQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCR",
                "SLPK",
                "DLKSNNIFLHEGLTVK",
                "VYLPNK",
                "GGSDGTPRGSPSPASVSSGRK",
                "WSGAQPLEQPSGSVLWMAAEVIR",
                "SASEPSLHRTQADELPACLLSAAR",
                "NLGYRDSGYYWEVPPSEVQLLKR",
                "SNNIFLHEGLTVK",
                "GYLSPDLSKISSNCPK",
                "GLNQDCCVVYR",
                "VLKVSQPTAEQAQAFKNEMQVLRK",
                "SLADDK",
                "MQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCR",
                "KKVK",
                "ALK",
                "LIKGRK",
                "GSPSPASVSSGRKSPHSK",
                "K",
                "DQIIFMVGRGYLSPDLSK",
                "TQHCDPEHFPFPAPANAPLQRIRSTSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSR",
                "GYLSPDLSKISSNCPKAMRR",
                "FQREERPLFPQILATIELLQRSLPK",
                "DGMSVYDSLDKALKVR",
                "AVGTVKVYLPNKQR",
                "GPPANGAEPSRAVGTVKVYLPNK",
                "TVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVRK",
                "QR",
                "DSGYYWEVPPSEVQLLKRIGTGSFGTVFR",
                "GGSDGTPRGSPSPASVSSGRKSPHSK",
                "KVKNLGYR",
                "NEMQVLRK",
                "AMRRLLSDCLK",
                "TFFSLAFCDFCLKFLFHGFRCQTCGYK",
                "LIKGRKTVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVR",
                "KKVKNLGYR",
                "HVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTR",
                "CQTCGYKFHQHCSSKVPTVCVDMSTNR",
                "GYLSPDLSKISSNCPKAMR",
                "KVKNLGYRDSGYYWEVPPSEVQLLK",
                "HVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTRFDMVQLIDVARQTAQGMDYLHAK",
                "GRWHGDVAVKVLKVSQPTAEQAQAFK",
                "SPAEQRER",
                "RLLSDCLKFQREERPLFPQILATIELLQR",
                "GRK",
                "SNNIFLHEGLTVKIGDFGLATVKTR",
                "VRGLNQDCCVVYR",
                "HVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTRFDMVQLIDVAR",
                "TVVTVR",
                "LIK",
                "TVVTVRDGMSVYDSLDKALKVR",
                "ALKVRGLNQDCCVVYR",
                "GSPSPASVSSGRK",
                "QHEAPSNRPLNELLTPQGPSPR",
                "IER",
                "DLKSNNIFLHEGLTVKIGDFGLATVKTR",
                "VLKVSQPTAEQAQAFK",
                "SLADDKKKVK",
                "IR",
                "SASEPSLHRTQADELPACLLSAARLVP",
                "DSGYYWEVPPSEVQLLK",
                "GRWHGDVAVKVLK",
                "VSQPTAEQAQAFK",
                "VKNLGYR",
                "IGDFGLATVKTR",
                "VYLPNKQR",
                "GYLSPDLSK",
                "VPTVCVDMSTNR",
                "FDMVQLIDVARQTAQGMDYLHAKNIIHRDLK",
                "IGDFGLATVK",
                "AMRRLLSDCLKFQR",
                "SLPKIERSASEPSLHR",
                "IGTGSFGTVFRGR",
                "VYLPNKQRTVVTVRDGMSVYDSLDK",
                "MEPPRGPPANGAEPSRAVGTVKVYLPNK",
                "VSQPTAEQAQAFKNEMQVLRK",
                "KK",
                "FDMVQLIDVARQTAQGMDYLHAKNIIHR",
                "VLK",
                "ISSNCPK",
                "IERSASEPSLHRTQADELPACLLSAARLVP",
                "DLK",
                "AMRR",
                "DQIIFMVGRGYLSPDLSKISSNCPKAMR",
                "TQHCDPEHFPFPAPANAPLQRIR",
                "SPHSKSPAEQRERK",
                "WHGDVAVK",
                "LIKGR",
                "QRTVVTVR",
                "SPAEQRERK",
                "FQREERPLFPQILATIELLQR",
                "QQFYHSVQDLSGGSR",
                "QTAQGMDYLHAKNIIHRDLK",
                "KTVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVR",
                "FLFHGFR",
                "MQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCRDQIIFMVGRGYLSPDLSK",
                "ERKSLADDKK",
                "SNNIFLHEGLTVKIGDFGLATVKTRWSGAQPLEQPSGSVLWMAAEVIR",
                "EPPR",
                "VKNLGYRDSGYYWEVPPSEVQLLKR",
                "MEPPRGPPANGAEPSRAVGTVK",
                "VPTVCVDMSTNRQQFYHSVQDLSGGSR",
                "KTVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVRKTFFSLAFCDFCLK",
                "HVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTRFDMVQLIDVARQTAQGMDYLHAKNIIHR",
                "TFFSLAFCDFCLKFLFHGFRCQTCGYKFHQHCSSK",
                "LVP",
                "NIIHR",
                "GSPSPASVSSGRKSPHSKSPAEQR",
                "SLPKIERSASEPSLHRTQADELPACLLSAAR",
                "KTRHVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTR",
                "STSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSRGGSDGTPR",
                "SPHSKSPAEQRER",
                "SLADDKKK",
                "IERSASEPSLHR",
                "GLNQDCCVVYRLIKGRK",
            },
        )

        self.assertEqual(len(digest.peptide_to_protein_dictionary), 5079)

        protein_inference_parameters.missed_cleavages = 2
        digest2 = pyproteininference.in_silico_digest.PyteomicsDigest(
            database_path=TEST_DATABASE,
            digest_type=protein_inference_parameters.digest_type,
            missed_cleavages=protein_inference_parameters.missed_cleavages,
            reviewed_identifier_symbol=protein_inference_parameters.reviewed_identifier_symbol,
            max_peptide_length=None,
            id_splitting=True,
        )
        digest2.digest_fasta_database()

        self.assertSetEqual(
            digest2.swiss_prot_protein_set,
            {
                "ARAF_HUMAN|P10398",
                "##ARAF_HUMAN|##P10398",
                "##BRAF_HUMAN|##P15056",
                "HNRPU_HUMAN|Q00839",
                "BRAF_HUMAN|P15056",
                "##RPOC_SHIF8|##Q0SY12",
                "TCAF1_HUMAN|Q9Y4C2-2",
                "##TCAF2_HUMAN|##A6NFQ2-3",
                "RAF1_HUMAN|P04049",
                "RPOC_SHIF8|Q0SY12",
                "##TCAF2_HUMAN|##A6NFQ2",
                "TCAF2_HUMAN|A6NFQ2-3",
                "##RAF1_HUMAN|##P04049",
                "##TCAF1_HUMAN|##Q9Y4C2-2",
                "TCAF2_HUMAN|A6NFQ2",
                "##TCAF1_HUMAN|##Q9Y4C2",
                "##HNRPU_HUMAN|##Q00839",
                "##TCAF2_HUMAN|##A6NFQ2-2",
                "TCAF2_HUMAN|A6NFQ2-2",
                "TCAF1_HUMAN|Q9Y4C2",
            },
        )

        self.assertSetEqual(
            digest2.protein_to_peptide_dictionary["ARAF_HUMAN|P10398"],
            {
                "QTAQGMDYLHAKNIIHR",
                "VLKVSQPTAEQAQAFKNEMQVLR",
                "SLADDK",
                "QTAQGMDYLHAKNIIHRDLK",
                "LLSDCLK",
                "ALK",
                "ALKVR",
                "FDMVQLIDVARQTAQGMDYLHAKNIIHR",
                "VR",
                "LIKGR",
                "TQHCDPEHFPFPAPANAPLQRIRSTSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSR",
                "GR",
                "VSQPTAEQAQAFK",
                "TR",
                "GSPSPASVSSGRK",
                "KK",
                "IGDFGLATVK",
                "DGMSVYDSLDKALK",
                "KTFFSLAFCDFCLKFLFHGFR",
                "QRTVVTVRDGMSVYDSLDK",
                "TVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVRK",
                "NLGYRDSGYYWEVPPSEVQLLKR",
                "KTR",
                "TFFSLAFCDFCLKFLFHGFR",
                "VLKVSQPTAEQAQAFK",
                "SLADDKKK",
                "GPPANGAEPSRAVGTVKVYLPNK",
                "DLKSNNIFLHEGLTVKIGDFGLATVK",
                "QRTVVTVR",
                "GRKTVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVR",
                "SLADDKK",
                "IGTGSFGTVFRGR",
                "QHEAPSNRPLNELLTPQGPSPRTQHCDPEHFPFPAPANAPLQR",
                "GYLSPDLSKISSNCPKAMR",
                "RIGTGSFGTVFRGR",
                "EERPLFPQILATIELLQRSLPK",
                "FHQHCSSKVPTVCVDMSTNRQQFYHSVQDLSGGSR",
                "FDMVQLIDVAR",
                "TFFSLAFCDFCLK",
                "HVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTRFDMVQLIDVARQTAQGMDYLHAK",
                "DGMSVYDSLDKALKVR",
                "ALKVRGLNQDCCVVYR",
                "SPHSK",
                "KTFFSLAFCDFCLK",
                "FHQHCSSK",
                "KSLADDK",
                "DSGYYWEVPPSEVQLLK",
                "TVVTVRDGMSVYDSLDKALK",
                "FLFHGFRCQTCGYK",
                "VRGLNQDCCVVYR",
                "IGTGSFGTVFRGRWHGDVAVK",
                "KTVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVRK",
                "TRHVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTR",
                "DGMSVYDSLDK",
                "TQHCDPEHFPFPAPANAPLQRIR",
                "QHEAPSNRPLNELLTPQGPSPRTQHCDPEHFPFPAPANAPLQRIR",
                "DQIIFMVGR",
                "SNNIFLHEGLTVKIGDFGLATVKTR",
                "NEMQVLRK",
                "KVK",
                "IRSTSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSRGGSDGTPR",
                "TRWSGAQPLEQPSGSVLWMAAEVIRMQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCR",
                "FHQHCSSKVPTVCVDMSTNR",
                "MEPPRGPPANGAEPSRAVGTVK",
                "WSGAQPLEQPSGSVLWMAAEVIRMQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCR",
                "SLPKIER",
                "MEPPR",
                "VSQPTAEQAQAFKNEMQVLRK",
                "TVVTVRDGMSVYDSLDK",
                "GLNQDCCVVYR",
                "GGSDGTPR",
                "IER",
                "ISSNCPKAMR",
                "EPPRGPPANGAEPSR",
                "TRHVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTRFDMVQLIDVAR",
                "GGSDGTPRGSPSPASVSSGRK",
                "HVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTRFDMVQLIDVAR",
                "GRWHGDVAVKVLK",
                "ISSNCPK",
                "WHGDVAVK",
                "MEPPRGPPANGAEPSR",
                "MQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCRDQIIFMVGR",
                "NIIHRDLK",
                "QQFYHSVQDLSGGSRQHEAPSNRPLNELLTPQGPSPR",
                "QTAQGMDYLHAK",
                "VYLPNKQRTVVTVR",
                "IGTGSFGTVFR",
                "HVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTR",
                "TQHCDPEHFPFPAPANAPLQR",
                "AVGTVK",
                "QR",
                "VLK",
                "MQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCRDQIIFMVGRGYLSPDLSK",
                "EERPLFPQILATIELLQR",
                "VSQPTAEQAQAFKNEMQVLR",
                "IERSASEPSLHR",
                "FDMVQLIDVARQTAQGMDYLHAK",
                "ISSNCPKAMRR",
                "GPPANGAEPSR",
                "DLKSNNIFLHEGLTVK",
                "AMRRLLSDCLK",
                "RIGTGSFGTVFR",
                "SNNIFLHEGLTVKIGDFGLATVK",
                "NLGYRDSGYYWEVPPSEVQLLK",
                "R",
                "IERSASEPSLHRTQADELPACLLSAAR",
                "TQADELPACLLSAAR",
                "FLFHGFR",
                "DLK",
                "SLPK",
                "STSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSRGGSDGTPRGSPSPASVSSGR",
                "ERKSLADDK",
                "SASEPSLHRTQADELPACLLSAARLVP",
                "LIKGRK",
                "EPPR",
                "SPHSKSPAEQR",
                "VK",
                "NIIHRDLKSNNIFLHEGLTVK",
                "NIIHR",
                "AMR",
                "ERK",
                "DQIIFMVGRGYLSPDLSKISSNCPK",
                "SPAEQRER",
                "WSGAQPLEQPSGSVLWMAAEVIRMQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCRDQIIFMVGR",
                "SASEPSLHR",
                "WHGDVAVKVLK",
                "TVVTVR",
                "SPAEQRERK",
                "VKNLGYRDSGYYWEVPPSEVQLLK",
                "GRWHGDVAVK",
                "GYLSPDLSKISSNCPK",
                "LLSDCLKFQREERPLFPQILATIELLQR",
                "IRSTSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSR",
                "WHGDVAVKVLKVSQPTAEQAQAFK",
                "TVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVRKTFFSLAFCDFCLK",
                "KSPHSKSPAEQR",
                "AVGTVKVYLPNK",
                "NLGYR",
                "LLSDCLKFQR",
                "KTVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVR",
                "EERPLFPQILATIELLQRSLPKIER",
                "GSPSPASVSSGR",
                "FLFHGFRCQTCGYKFHQHCSSK",
                "WSGAQPLEQPSGSVLWMAAEVIR",
                "VRGLNQDCCVVYRLIK",
                "AVGTVKVYLPNKQR",
                "EPPRGPPANGAEPSRAVGTVK",
                "TVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVR",
                "FQREERPLFPQILATIELLQR",
                "GLNQDCCVVYRLIKGR",
                "NEMQVLRKTR",
                "GYLSPDLSK",
                "TQADELPACLLSAARLVP",
                "AMRR",
                "SPHSKSPAEQRER",
                "ER",
                "VPTVCVDMSTNR",
                "QHEAPSNRPLNELLTPQGPSPR",
                "KKVK",
                "QQFYHSVQDLSGGSR",
                "KSLADDKK",
                "VPTVCVDMSTNRQQFYHSVQDLSGGSRQHEAPSNRPLNELLTPQGPSPR",
                "STSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSR",
                "MQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCR",
                "STSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSRGGSDGTPR",
                "GSPSPASVSSGRKSPHSK",
                "VYLPNK",
                "IGDFGLATVKTRWSGAQPLEQPSGSVLWMAAEVIR",
                "TRWSGAQPLEQPSGSVLWMAAEVIR",
                "VKNLGYR",
                "GRK",
                "CQTCGYKFHQHCSSKVPTVCVDMSTNR",
                "VYLPNKQR",
                "SASEPSLHRTQADELPACLLSAAR",
                "CQTCGYKFHQHCSSK",
                "IR",
                "VPTVCVDMSTNRQQFYHSVQDLSGGSR",
                "FQREERPLFPQILATIELLQRSLPK",
                "DQIIFMVGRGYLSPDLSK",
                "LIK",
                "CQTCGYK",
                "DSGYYWEVPPSEVQLLKR",
                "RLLSDCLKFQR",
                "IGDFGLATVKTR",
                "FQR",
                "LVP",
                "KSPHSK",
                "SLPKIERSASEPSLHR",
                "GPPANGAEPSRAVGTVK",
                "SPAEQR",
                "QQFYHSVQDLSGGSRQHEAPSNRPLNELLTPQGPSPRTQHCDPEHFPFPAPANAPLQR",
                "K",
                "DSGYYWEVPPSEVQLLKRIGTGSFGTVFR",
                "TFFSLAFCDFCLKFLFHGFRCQTCGYK",
                "RLLSDCLK",
                "GGSDGTPRGSPSPASVSSGR",
                "SNNIFLHEGLTVK",
                "NEMQVLR",
                "KTRHVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTR",
                "KVKNLGYR",
                "GLNQDCCVVYRLIK",
            },
        )
        self.assertEqual(len(digest2.peptide_to_protein_dictionary), 3710)

        protein_inference_parameters.missed_cleavages = 1
        digest3 = pyproteininference.in_silico_digest.PyteomicsDigest(
            database_path=TEST_DATABASE,
            digest_type=protein_inference_parameters.digest_type,
            missed_cleavages=protein_inference_parameters.missed_cleavages,
            reviewed_identifier_symbol=protein_inference_parameters.reviewed_identifier_symbol,
            max_peptide_length=None,
            id_splitting=True,
        )
        digest3.digest_fasta_database()

        self.assertSetEqual(
            digest3.swiss_prot_protein_set,
            {
                "ARAF_HUMAN|P10398",
                "##ARAF_HUMAN|##P10398",
                "##BRAF_HUMAN|##P15056",
                "HNRPU_HUMAN|Q00839",
                "BRAF_HUMAN|P15056",
                "##RPOC_SHIF8|##Q0SY12",
                "TCAF1_HUMAN|Q9Y4C2-2",
                "##TCAF2_HUMAN|##A6NFQ2-3",
                "RAF1_HUMAN|P04049",
                "RPOC_SHIF8|Q0SY12",
                "##TCAF2_HUMAN|##A6NFQ2",
                "TCAF2_HUMAN|A6NFQ2-3",
                "##RAF1_HUMAN|##P04049",
                "##TCAF1_HUMAN|##Q9Y4C2-2",
                "TCAF2_HUMAN|A6NFQ2",
                "##TCAF1_HUMAN|##Q9Y4C2",
                "##HNRPU_HUMAN|##Q00839",
                "##TCAF2_HUMAN|##A6NFQ2-2",
                "TCAF2_HUMAN|A6NFQ2-2",
                "TCAF1_HUMAN|Q9Y4C2",
            },
        )

        self.assertSetEqual(
            digest3.protein_to_peptide_dictionary["ARAF_HUMAN|P10398"],
            {
                "QTAQGMDYLHAKNIIHR",
                "SLADDK",
                "LLSDCLK",
                "ALK",
                "ALKVR",
                "VR",
                "LIKGR",
                "GR",
                "VSQPTAEQAQAFK",
                "TR",
                "GSPSPASVSSGRK",
                "KK",
                "IGDFGLATVK",
                "DGMSVYDSLDKALK",
                "KTR",
                "TVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVRK",
                "TFFSLAFCDFCLKFLFHGFR",
                "VLKVSQPTAEQAQAFK",
                "QRTVVTVR",
                "SLADDKK",
                "IGTGSFGTVFRGR",
                "QHEAPSNRPLNELLTPQGPSPRTQHCDPEHFPFPAPANAPLQR",
                "EERPLFPQILATIELLQRSLPK",
                "FDMVQLIDVAR",
                "TFFSLAFCDFCLK",
                "SPHSK",
                "KTFFSLAFCDFCLK",
                "FHQHCSSK",
                "KSLADDK",
                "DSGYYWEVPPSEVQLLK",
                "FLFHGFRCQTCGYK",
                "VRGLNQDCCVVYR",
                "TRHVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTR",
                "DGMSVYDSLDK",
                "TQHCDPEHFPFPAPANAPLQRIR",
                "DQIIFMVGR",
                "NEMQVLRK",
                "KVK",
                "FHQHCSSKVPTVCVDMSTNR",
                "WSGAQPLEQPSGSVLWMAAEVIRMQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCR",
                "SLPKIER",
                "MEPPR",
                "TVVTVRDGMSVYDSLDK",
                "GLNQDCCVVYR",
                "GGSDGTPR",
                "IER",
                "ISSNCPKAMR",
                "EPPRGPPANGAEPSR",
                "HVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTRFDMVQLIDVAR",
                "ISSNCPK",
                "WHGDVAVK",
                "MEPPRGPPANGAEPSR",
                "MQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCRDQIIFMVGR",
                "NIIHRDLK",
                "QQFYHSVQDLSGGSRQHEAPSNRPLNELLTPQGPSPR",
                "QTAQGMDYLHAK",
                "HVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTR",
                "IGTGSFGTVFR",
                "AVGTVK",
                "TQHCDPEHFPFPAPANAPLQR",
                "QR",
                "VLK",
                "IERSASEPSLHR",
                "EERPLFPQILATIELLQR",
                "VSQPTAEQAQAFKNEMQVLR",
                "FDMVQLIDVARQTAQGMDYLHAK",
                "GPPANGAEPSR",
                "DLKSNNIFLHEGLTVK",
                "RIGTGSFGTVFR",
                "SNNIFLHEGLTVKIGDFGLATVK",
                "NLGYRDSGYYWEVPPSEVQLLK",
                "R",
                "TQADELPACLLSAAR",
                "FLFHGFR",
                "DLK",
                "SLPK",
                "EPPR",
                "SPHSKSPAEQR",
                "VK",
                "NIIHR",
                "ERK",
                "SPAEQRER",
                "SASEPSLHR",
                "WHGDVAVKVLK",
                "TVVTVR",
                "GRWHGDVAVK",
                "GYLSPDLSKISSNCPK",
                "IRSTSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSR",
                "LLSDCLKFQR",
                "AVGTVKVYLPNK",
                "NLGYR",
                "KTVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVR",
                "GSPSPASVSSGR",
                "WSGAQPLEQPSGSVLWMAAEVIR",
                "TVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVR",
                "FQREERPLFPQILATIELLQR",
                "GYLSPDLSK",
                "TQADELPACLLSAARLVP",
                "AMRR",
                "ER",
                "VPTVCVDMSTNR",
                "QHEAPSNRPLNELLTPQGPSPR",
                "QQFYHSVQDLSGGSR",
                "STSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSR",
                "MQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCR",
                "STSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSRGGSDGTPR",
                "VYLPNK",
                "TRWSGAQPLEQPSGSVLWMAAEVIR",
                "VKNLGYR",
                "GRK",
                "VYLPNKQR",
                "SASEPSLHRTQADELPACLLSAAR",
                "CQTCGYKFHQHCSSK",
                "IR",
                "VPTVCVDMSTNRQQFYHSVQDLSGGSR",
                "DQIIFMVGRGYLSPDLSK",
                "LIK",
                "CQTCGYK",
                "DSGYYWEVPPSEVQLLKR",
                "FQR",
                "IGDFGLATVKTR",
                "LVP",
                "KSPHSK",
                "GPPANGAEPSRAVGTVK",
                "SPAEQR",
                "K",
                "RLLSDCLK",
                "GGSDGTPRGSPSPASVSSGR",
                "SNNIFLHEGLTVK",
                "NEMQVLR",
                "AMR",
                "GLNQDCCVVYRLIK",
            },
        )
        self.assertEqual(len(digest3.peptide_to_protein_dictionary), 2336)

        protein_inference_parameters.missed_cleavages = 0
        digest4 = pyproteininference.in_silico_digest.PyteomicsDigest(
            database_path=TEST_DATABASE,
            digest_type=protein_inference_parameters.digest_type,
            missed_cleavages=protein_inference_parameters.missed_cleavages,
            reviewed_identifier_symbol=protein_inference_parameters.reviewed_identifier_symbol,
            max_peptide_length=None,
            id_splitting=True,
        )
        digest4.digest_fasta_database()

        self.assertSetEqual(
            digest4.swiss_prot_protein_set,
            {
                "ARAF_HUMAN|P10398",
                "##ARAF_HUMAN|##P10398",
                "##BRAF_HUMAN|##P15056",
                "HNRPU_HUMAN|Q00839",
                "BRAF_HUMAN|P15056",
                "##RPOC_SHIF8|##Q0SY12",
                "TCAF1_HUMAN|Q9Y4C2-2",
                "##TCAF2_HUMAN|##A6NFQ2-3",
                "RAF1_HUMAN|P04049",
                "RPOC_SHIF8|Q0SY12",
                "##TCAF2_HUMAN|##A6NFQ2",
                "TCAF2_HUMAN|A6NFQ2-3",
                "##RAF1_HUMAN|##P04049",
                "##TCAF1_HUMAN|##Q9Y4C2-2",
                "TCAF2_HUMAN|A6NFQ2",
                "##TCAF1_HUMAN|##Q9Y4C2",
                "##HNRPU_HUMAN|##Q00839",
                "##TCAF2_HUMAN|##A6NFQ2-2",
                "TCAF2_HUMAN|A6NFQ2-2",
                "TCAF1_HUMAN|Q9Y4C2",
            },
        )

        self.assertSetEqual(
            digest4.protein_to_peptide_dictionary["ARAF_HUMAN|P10398"],
            {
                "ER",
                "SLADDK",
                "TQADELPACLLSAAR",
                "VPTVCVDMSTNR",
                "DGMSVYDSLDK",
                "FLFHGFR",
                "QHEAPSNRPLNELLTPQGPSPR",
                "DLK",
                "LLSDCLK",
                "SLPK",
                "DQIIFMVGR",
                "QQFYHSVQDLSGGSR",
                "STSTPNVHMVSTTAPMDSNLIQLTGQSFSTDAAGSR",
                "MQDPNPYSFQSDVYAYGVVLYELMTGSLPYSHIGCR",
                "EPPR",
                "VK",
                "VR",
                "NIIHR",
                "GR",
                "VSQPTAEQAQAFK",
                "VYLPNK",
                "MEPPR",
                "TR",
                "GLNQDCCVVYR",
                "IGDFGLATVK",
                "GGSDGTPR",
                "SASEPSLHR",
                "IER",
                "TVVTVR",
                "IR",
                "ISSNCPK",
                "WHGDVAVK",
                "LIK",
                "CQTCGYK",
                "NLGYR",
                "FQR",
                "FDMVQLIDVAR",
                "TFFSLAFCDFCLK",
                "GSPSPASVSSGR",
                "QTAQGMDYLHAK",
                "LVP",
                "HVNILLFMGFMTRPGFAIITQWCEGSSLYHHLHVADTR",
                "IGTGSFGTVFR",
                "AVGTVK",
                "TQHCDPEHFPFPAPANAPLQR",
                "SPAEQR",
                "WSGAQPLEQPSGSVLWMAAEVIR",
                "QR",
                "FHQHCSSK",
                "TVTAWDTAIAPLDGEELIVEVLEDVPLTMHNFVR",
                "SPHSK",
                "DSGYYWEVPPSEVQLLK",
                "K",
                "VLK",
                "EERPLFPQILATIELLQR",
                "GPPANGAEPSR",
                "SNNIFLHEGLTVK",
                "NEMQVLR",
                "GYLSPDLSK",
                "AMR",
                "ALK",
                "R",
            },
        )
        self.assertEqual(len(digest4.peptide_to_protein_dictionary), 1019)
