"use strict";
const assert_1 = require("@aws-cdk/assert");
const lib_1 = require("../lib");
const util_1 = require("./util");
/* eslint-disable max-len */
const CLUSTER_VERSION = lib_1.KubernetesVersion.V1_16;
module.exports = {
    'basic usage'(test) {
        // GIVEN
        const { stack } = util_1.testFixtureNoVpc();
        const cluster = new lib_1.Cluster(stack, 'cluster', { version: CLUSTER_VERSION });
        const manifest = [
            {
                apiVersion: 'v1',
                kind: 'Service',
                metadata: {
                    name: 'hello-kubernetes',
                },
                spec: {
                    type: 'LoadBalancer',
                    ports: [
                        { port: 80, targetPort: 8080 },
                    ],
                    selector: {
                        app: 'hello-kubernetes',
                    },
                },
            },
            {
                apiVersion: 'apps/v1',
                kind: 'Deployment',
                metadata: {
                    name: 'hello-kubernetes',
                },
                spec: {
                    replicas: 2,
                    selector: {
                        matchLabels: {
                            app: 'hello-kubernetes',
                        },
                    },
                    template: {
                        metadata: {
                            labels: {
                                app: 'hello-kubernetes',
                            },
                        },
                        spec: {
                            containers: [
                                {
                                    name: 'hello-kubernetes',
                                    image: 'paulbouwer/hello-kubernetes:1.5',
                                    ports: [
                                        { containerPort: 8080 },
                                    ],
                                },
                            ],
                        },
                    },
                },
            },
        ];
        // WHEN
        new lib_1.KubernetesManifest(stack, 'manifest', {
            cluster,
            manifest,
        });
        assert_1.expect(stack).to(assert_1.haveResource(lib_1.KubernetesManifest.RESOURCE_TYPE, {
            Manifest: JSON.stringify(manifest),
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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