import { IVpc, ISecurityGroup, SubnetSelection } from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import { Construct, NestedStack } from '@aws-cdk/core';
import * as cr from '@aws-cdk/custom-resources';
export interface KubectlProviderProps {
    /**
     * Connect the provider to a VPC.
     *
     * @default - no vpc attachement.
     */
    readonly vpc?: IVpc;
    /**
     * Select the Vpc subnets to attach to the provider.
     *
     * @default - no subnets.
     */
    readonly vpcSubnets?: SubnetSelection;
    /**
     * Attach security groups to the provider.
     *
     * @default - no security groups.
     */
    readonly securityGroups?: ISecurityGroup[];
    /**
     * Environment variables to inject to the provider function.
     */
    readonly env?: {
        [key: string]: string;
    };
}
export declare class KubectlProvider extends NestedStack {
    /**
     * The custom resource provider.
     */
    readonly provider: cr.Provider;
    /**
     * The IAM role used to execute this provider.
     */
    readonly role: iam.IRole;
    constructor(scope: Construct, id: string, props?: KubectlProviderProps);
    /**
     * The custom resource provider service token.
     */
    get serviceToken(): string;
}
