import * as iam from '@aws-cdk/aws-iam';
import { ArnComponents, Construct } from '@aws-cdk/core';
import { CfnClusterProps } from './eks.generated';
export interface ClusterResourceProps extends CfnClusterProps {
    /**
     * Enable private endpoint access to the cluster.
     */
    readonly endpointPrivateAccess: boolean;
    /**
     * Enable public endpoint access to the cluster.
     */
    readonly endpointPublicAccess: boolean;
    /**
     * Limit public address with CIDR blocks.
     */
    readonly publicAccessCidrs?: string[];
}
/**
 * A low-level CFN resource Amazon EKS cluster implemented through a custom
 * resource.
 *
 * Implements EKS create/update/delete through a CloudFormation custom resource
 * in order to allow us to control the IAM role which creates the cluster. This
 * is required in order to be able to allow CloudFormation to interact with the
 * cluster via `kubectl` to enable Kubernetes management capabilities like apply
 * manifest and IAM role/user RBAC mapping.
 */
export declare class ClusterResource extends Construct {
    readonly attrEndpoint: string;
    readonly attrArn: string;
    readonly attrCertificateAuthorityData: string;
    readonly attrClusterSecurityGroupId: string;
    readonly attrEncryptionConfigKeyArn: string;
    readonly attrOpenIdConnectIssuerUrl: string;
    readonly attrOpenIdConnectIssuer: string;
    readonly ref: string;
    /**
     * The IAM role which created the cluster. Initially this is the only IAM role
     * that gets administrator privilages on the cluster (`system:masters`), and
     * will be able to issue `kubectl` commands against it.
     */
    readonly creationRole: iam.Role;
    private readonly trustedPrincipals;
    constructor(scope: Construct, id: string, props: ClusterResourceProps);
    /**
     * Grants `trustedRole` permissions to assume the creation role.
     */
    addTrustedRole(trustedRole: iam.IRole): void;
}
export declare function clusterArnComponents(clusterName: string): ArnComponents;
