#!/usr/bin/python
# -*- coding: utf-8 -*-

  ############################################################################
  # Copyright (c) 2011, Vasudeva Kamath <kamathvasudev at gmail dot com>     #
  #                                                                          #
  # Permission to use, copy, modify, and/or distribute this software for any #
  # purpose with or without fee is hereby granted, provided that the above   #
  # copyright notice and this permission notice appear in all copies.        #
  #                                                                          #
  # THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES #
  # WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF         #
  # MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR  #
  # ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   #
  # WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN    #
  # ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF  #
  # OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.           #
  ############################################################################

__all__ = ["CMU_MALAYALAM_MAP","CMU_KANNADA_MAP"]

CMU_MALAYALAM_MAP = {
	"AA" : "ഓ",
	"AH" : "അ",
	"AE" : "ഏ",
	"AO" : "ഓ",
	"AW" : "ഔ",
	"AY" : "ഐ",
	"B"  : "ബ്",
	"CH" : "ച്ച്",
	"D"  : "ഡ്",
	"DH" : "ദ്",
	"EA" : "ഈ",
	"EH" : "എ",
	"ER" : "എര്‍",
	"EY" : "എയ്",
	"F"  : "ഫ്",
	"G"  : "ഗ്",
	"HH"  : "ഹ്",
	"IH" : "ഇ",
	"IY" : "ഈ",
	"J"   : "ജ്",
	"JH"  : "ജ്",
	"K"  : "ക്",
	"L"  : "ല്‍",
	"M"  : "മ്",
	"N"  : "ന്‍",
	"NG"  : "ങ്",
	"OW"  : "ഒ",
	"P"  : "പ്",
	"R"  : "ര്‍",
	"S"  : "സ്",
	"SH"  : "ഷ്",
	"T"  : "റ്റ്",
	"TH"  : "ത്",
	"Y"  :  "യ്",
	"UW" : "ഉ",
	"W"  : "വ്",
	"V" : "വ്",
	"Z"  : "സ്",
}		

CMU_KANNADA_MAP = {
	"AA" : "ಆ",
	"AH" : "ಅ",
	"AE" : "ಏ",
	"AO" : "ಓ",
	"AW" : "ಔ",
	"AY" : "ಐ",
	"B"  : "ಬ್",
	"CH" : "ಚ್",
	"D"  : "ಡ್",
	"DH" : "ದ್",
	"EA" : "ಈ",
	"EH" : "ಎ",
	"ER" : "ಅರ್",
	"EY" : "ಎಯ್",
	"F"  : "ಫ್",
	"G"  : "ಗ್",
	"HH"  : "ಹ್",
	"IH" : "ಇ",
	"IY" : "ಈ",
	"J"   : "ಜ್",
	"JH"  : "ಜ್",
	"K"  : "ಕ್",
	"L"  : "ಲ್",
	"M"  : "ಮ್",
	"N"  : "ನ್",
	"NG"  : "ಂಗ್",
	"OW"  : "ಒ",
	"P"  : "ಪ್",
	"R"  : "ರ್",
	"S"  : "ಸ್",
	"SH"  : "ಷ್",
	"T"  : "ಟ್",
	"TH"  : "ತ್",
	"Y"  :  "ಯ್",
	"UW" : "ಊ",
	"UH":"ಉ",
	"W"  : "ವ್",
	"V" : "ವ್",
	"Z":"ಸ್",
	"ZH":"ಷ್",
}
