# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['snick']

package_data = \
{'': ['*']}

install_requires = \
['pprintpp>=0.4.0,<0.5.0']

setup_kwargs = {
    'name': 'snick',
    'version': '1.2.0',
    'description': '',
    'long_description': '# Gadgets for managing indented text\n\nThis library provides several text manipulation gadgets that are useful when\ndealing with indentation in text. You might find them helpful when you are:\n\n* logging blocks of text\n* testing output\n* formatting machine generated text in a human readable way\n\n\n## What\'s with the name?\n\nThere\'s really no very good synonyms for the verb, \'indent\'. However, there\nare several for the act of creating a small dent in something. one of my\nfavorites was \'snick\'. It means "to cut a small notch or incision in". I\nthink I\'ll use that!\n\n\n## Methods\n\nMost of these methods have additional options and arguments that can be used\nto augment their output. This is just a cursory over-view. Please consult the\nsource code for more details\n\n\n### dedent\n\nThis method unindents a block of text by aligning all lines with the left most\n\nThis is very good if you wish to use python triple-quote strings in your code,\nlike to start the text on its own line, but do not wish to leave them indented:\n\n```\nclass Whatever:\n\n    @staticmethod\n    def print_some_stuff():\n        print(snick.dedent("""\n            Here is some text\n                here is some other text\n                we don\'t want this indented\n                when it\'s printed\n                  (to the console)\n        """))\n```\n\ncalling `Whatever.print_some_stuff()` will result in dedented output:\n\n```\nHere is some text\n    here is some other text\n    we don\'t want this indented\n    when it\'s printed\n      (to the console)\n```\n\n\nThe dedent method also has an optional `should_strip` parameter that, if set to False,\nwill preserve the newlines before and after triple quoted text:\n\n```python\n    dummy_text = """\n        Here is some text\n            here is some other text\n            we don\'t want this indented\n            when it\'s printed\n              (to the console)\n    """\n```\n\ncalling `print(snick.dedent(dummy_text, should_strip=False)` will result in dedented\noutput that preserves leading and following newlines like so:\n\n```\n\nHere is some text\n    here is some other text\n    we don\'t want this indented\n    when it\'s printed\n      (to the console)\n\n```\n\n\n### indent\n\nThis method indents a block of text. It\'s a thin wrapper around `textwrap.indent()`.\nHowever, it includes a default prefix of 4 spaces. This could be handy if you want\nto indent some lines of text that you join with newline:\n\n```\nprint(snick.indent(\'\\n\'.join([\n    \'would be so nice\',\n    \'to indent these\',\n    \'i guess\',\n])))\n```\n\nThe snippet above will produce:\n\n```\n   would be so nice\n   to indent these\n   i guess\n```\n\n\n### dedent_all\n\nThis function just applies a dedent to each argument you pass it separately and then\njoins them together. This is useful if you want to dynamically produce some items\nthat you need to add to some other long string. Here\'s an example:\n\n```\nprint(snick.dedent_all(\n    """\n    Here is a long bit of text\n    as an introduction to the\n    folowing dynamic items:\n    --------------------------\n    """,\n    *(f"* Item #{i}" for i in range(1, 4)),\n))\n```\n\nThe snippet above would produce:\n\n```\nHere is a long bit of text\nas an introduction to the\nfolowing dynamic items:\n--------------------------\n* Item #1\n* Item #2\n* Item #3\n```\n\n\n### unwrap\n\nThis method unwraps a block of text. It does this by joining all lines into\na single string. It works on indented text as well. This might be convenient\nif you have a very indented block of code and you need to type a long string\nout. You could unwrap a triple-quoted block:\n\n```\nif True:\n    if True:\n        if True:\n            if True:\n                if True:\n                    if True:\n                        if True:\n                            if True:\n                                print(snick.unwrap("""\n                                    I need to have a very long string here, but\n                                    it would go way outside of the line length\n                                    limit and cause me all sorts of grief with\n                                    the style checker. So, unwrap can help me\n                                    here\n                                """))\n```\n\nThe above code block would print this:\n```\nI need to have a very long string here, but it would go way outside of the line length limit and cause me all sorts of grief with the style checker. So, unwrap can help me here\n```\n\n\n### conjoin\n\nThis method is a lot like the python built-in `join`. The difference is that you don\'t\nneed to wrap the stuff to wrap in an iterable like a list or tuple. Instead, you can\njust pass the items as arguments to the `conjoin()` function. Here\'s an example:\n\n```\nprint(snick.conjoin(\n    "Here are some lines",\n    "that I would like to join",\n    "and it would be silly",\n    "to have to wrap them in a",\n    "list instead of just passing",\n    "them as plain old arguments",\n))\n```\n\nThe above code would print this:\n```\nHere are some lines\nthat I would like to join\nand it would be silly\nto have to wrap them in a\nlist instead of just passing\nthem as plain old arguments\n```\n\nThe `conjoin()` function also has a keyword argument `join_str` where you can override\nthe default value (newline) with string you like.\n\n\n### strip_whitespace\n\nThis method just removes all whitespace from a string. This includes newlines,\ntabs, spaces, etc. This method is handy for writing tests that need to ignore\nwhitespace used for readability/formatting:\n\n```\nprint(snick.strip_whitespace("""\n    some text with    whitespace\n    and whatnot\n"""))\n```\n\nThe above code block would print out the following:\n```\nsometextwithwhitespaceandwhatnot\n```\n\n\n### indent_wrap\n\nThis method is used to wrap a long string and indent each wrapped line. It might\nbe useful for wrapping and indenting some string that\'s produced programatically\n\n```\nprint("Here\'s some filler text:")\nprint(f"    {snick.indent_wrap(lorem.text())}")\n```\n\nThe code block above might generate somethign like this:\n\n```\nHere\'s some filler text:\n    Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod\n    tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,\n    quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo\n    consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse\n    cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat\n    non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n```\n\n\n### pretty_print\n\nThis method can be used to pretty-print a dictionary:\n\n```\nsnick.pretty_print("\'a\': {\'b\': 1, \'c\': {\'d\': 2}, \'e\': 3}, \'f\': 4}")\n```\n\nThe code block above would produce formatted output like this:\n```\n{\n  \'a\': {\n    \'b\': 1,\n    \'c\': {\n      \'d\': 2,\n    },\n    \'e\': 3,\n  },\n  \'f\': 4,\n}\n```\n\n\n### pretty_format\n\nThis method is the same as pretty_print but returns the string instead of\nprinting to a IO stream\n\n\n### enboxify\n\nThis method just draws a box around some text. This is especially useful for\nlogging when you want to make something really pop out:\n\n```\nprint(snick.enboxify("""\n    here\'s some text that we\n    want to put into a box.\n    That will make it look\n    so very nice\n"""))\n```\n\nThe code-block above will produce output like this:\n```\n****************************\n* here\'s some text that we *\n* want to put into a box.  *\n* That will make it look   *\n* so very nice             *\n****************************\n```\n',
    'author': 'Tucker Beck',
    'author_email': 'tucker.beck@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
