"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLogsAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * (experimental) The action to send data to Amazon CloudWatch Logs.
 *
 * @experimental
 */
class CloudWatchLogsAction {
    /**
     * @param logGroup The CloudWatch log group to which the action sends data.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(logGroup, props = {}) {
        this.logGroup = logGroup;
        this.role = props.role;
    }
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule) {
        var _b;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        this.logGroup.grantWrite(role);
        this.logGroup.grant(role, 'logs:DescribeLogStreams');
        return {
            configuration: {
                cloudwatchLogs: {
                    logGroupName: this.logGroup.logGroupName,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.CloudWatchLogsAction = CloudWatchLogsAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchLogsAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.CloudWatchLogsAction", version: "1.132.0" };
//# sourceMappingURL=data:application/json;base64,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