import * as iam from '@aws-cdk/aws-iam';
import * as iot from '@aws-cdk/aws-iot';
import * as logs from '@aws-cdk/aws-logs';
/**
 * (experimental) Configuration properties of an action for CloudWatch Logs.
 *
 * @experimental
 */
export interface CloudWatchLogsActionProps {
    /**
     * (experimental) The IAM role that allows access to the CloudWatch log group.
     *
     * @default a new role will be created
     * @experimental
     */
    readonly role?: iam.IRole;
}
/**
 * (experimental) The action to send data to Amazon CloudWatch Logs.
 *
 * @experimental
 */
export declare class CloudWatchLogsAction implements iot.IAction {
    private readonly logGroup;
    private readonly role?;
    /**
     * @param logGroup The CloudWatch log group to which the action sends data.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(logGroup: logs.ILogGroup, props?: CloudWatchLogsActionProps);
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
