"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const assignment_1 = require("./assignment");
const permissionset_common_1 = require("./private/permissionset-common");
/**
 * The base permission set class
 */
class PermissionSetBase extends aws_cdk_lib_1.Resource {
    grant(id, assignmentOptions) {
        return new assignment_1.Assignment(this, id, {
            permissionSet: this,
            principal: assignmentOptions.principal,
            targetId: assignmentOptions.targetId,
            targetType: assignmentOptions.targetType,
        });
    }
}
;
class PermissionSet extends PermissionSetBase {
    constructor(scope, id, props) {
        super(scope, id);
        let managedPolicies = [];
        if (props.awsManagedPolicies) {
            managedPolicies = props.awsManagedPolicies.map(policy => policy.managedPolicyArn);
        }
        if (!props.ssoInstanceArn.match(/arn:(aws|aws-us-gov|aws-cn|aws-iso|aws-iso-b):sso:::instance\/(sso)?ins-[a-zA-Z0-9-.]{16}/)) {
            throw new Error(`Invalid SSO instance ARN: ${props.ssoInstanceArn}`);
        }
        if (!props.name.match(/[\w+=,.@-]+/)) {
            throw new Error(`Invalid permission set name. Name may only contain alphanumeric characters and any of: +=,.@-: ${props.name}`);
        }
        if (props.relayStateType && !props.relayStateType.match(/[a-zA-Z0-9&$@#\\\/%?=~\-_'"|!:,.;*+\[\]\ \(\)\{\}]+/)) {
            throw new Error(`Invalid relay state type: ${props.relayStateType}`);
        }
        this.cfnPermissionSet = new aws_cdk_lib_1.aws_sso.CfnPermissionSet(this, 'permissionSet', {
            instanceArn: props.ssoInstanceArn,
            name: props.name,
            customerManagedPolicyReferences: props.customerManagedPolicyReferences,
            description: props.description,
            inlinePolicy: props.inlinePolicy,
            managedPolicies,
            permissionsBoundary: props.permissionsBoundary,
            relayStateType: props.relayStateType,
            sessionDuration: props.sessionDuration ? props.sessionDuration.toIsoString() : undefined,
        });
        this.ssoInstanceArn = props.ssoInstanceArn;
        this.permissionSetArn = this.cfnPermissionSet.attrPermissionSetArn;
    }
    /**
     * Reference an existing permission set by ARN
     */
    static fromPermissionSetArn(scope, id, permissionSetArn) {
        class Import extends PermissionSetBase {
            constructor() {
                super(...arguments);
                this.permissionSetArn = permissionSetArn;
                this.ssoInstanceArn = `arn:aws:sso:::instance/${permissionset_common_1.permissionSetParseArn(permissionSetArn).resourceName.split('/')[0]}`;
            }
        }
        ;
        const permissionSet = new Import(scope, id);
        return permissionSet;
    }
}
exports.PermissionSet = PermissionSet;
_a = JSII_RTTI_SYMBOL_1;
PermissionSet[_a] = { fqn: "@renovosolutions/cdk-library-aws-sso.PermissionSet", version: "0.1.105" };
//# sourceMappingURL=data:application/json;base64,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