from temporalio.converter import EncodingPayloadConverter
from typing import Any, Optional, Type
from temporalio.api.common.v1 import Payload
from temporalio.converter import CompositePayloadConverter, DefaultPayloadConverter, EncodingPayloadConverter

class GcsEncodingPayloadConverter(EncodingPayloadConverter):
    @property
    def encoding(self) -> str:
        return "gcs"
    
    def to_payload(self, value: Any) -> Payload:
        return Payload(data=value, metadata={"encoding": self.encoding.encode()})
    
    def from_payload(self, payload: Payload, type_hint: Optional[Type] = None) -> Any:
        return payload.data

class GcsCompositePayloadConverter(CompositePayloadConverter):
    def __init__(self) -> None:
        super().__init__(
            *DefaultPayloadConverter.default_encoding_payload_converters,
            GcsEncodingPayloadConverter()
        )