# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/05_data.block.ipynb (unless otherwise specified).

__all__ = ['DQN', 'TestDatasetNoModule', 'TestDataset']

# Cell
# Python native modules
import os
# Third party libs
from fastcore.all import *
from fastai.torch_basics import *
from fastai.data.all import *
from fastai.basics import *
from torch.utils.data import Dataset
from torch import nn


import numpy as np
import gym
import time,sys

# Local modules

# Cell
class DQN(Module):
    def __init__(self):
        self.policy=nn.Sequential(
            nn.Linear(4,50),
            nn.ReLU(),
            nn.Linear(50,2)
        )

    def forward(self,x):
        return torch.argmax(self.policy(x),dim=0)

# Cell
class TestDatasetNoModule(Dataset):
    def __init__(self,device='cpu'):
        self.device=device

    def __len__(self): return 10
    def __getitem__(self,idx):
        print('starting')
        sys.stdout.flush()
        try:
            print('making env')
#             env=gym.make('CartPole-v1')
            return torch.rand(1,4).to(device=self.device)
        except Exception as e:
            print(e,'it crashed lol omg')
            sys.stdout.flush()
            return torch.rand(1,4).to(device=self.device)

# Cell
class TestDataset(Dataset):
    def __init__(self,policy,device='cpu'):
        self.policy=policy
        self.device=device
        self.policy.to(device=self.device)

    def __len__(self): return 100
    def __getitem__(self,idx):
        try:
            env=gym.make('CartPole-v1')
            next_state=env.reset()
            print(id(env),' ')
            next_state, r, is_done, _=env.step(self.policy(Tensor(next_state).to(device=self.device)).cpu().numpy())
            if is_done:next_state=env.reset()
            return Tensor(next_state).to(device=self.device)
        except Exception as e:
            print(e)
            return Tensor(np.random.rand(0,4)).to(device=self.device)