"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallApiGatewayRestApiEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const base_1 = require("./base");
/**
 * Call REST API endpoint as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 * @stability stable
 */
class CallApiGatewayRestApiEndpoint extends base_1.CallApiGatewayEndpointBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.apiEndpoint = this.getApiEndpoint();
        this.arnForExecuteApi = props.api.arnForExecuteApi(props.method, props.apiPath, props.stageName);
        this.stageName = props.stageName;
        this.taskPolicies = this.createPolicyStatements();
    }
    getApiEndpoint() {
        const apiStack = cdk.Stack.of(this.props.api);
        return `${this.props.api.restApiId}.execute-api.${apiStack.region}.${apiStack.urlSuffix}`;
    }
}
exports.CallApiGatewayRestApiEndpoint = CallApiGatewayRestApiEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CallApiGatewayRestApiEndpoint[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.CallApiGatewayRestApiEndpoint", version: "1.128.0" };
//# sourceMappingURL=data:application/json;base64,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