"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCredentials = exports.AwsCredentialsProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_credentials_1 = require("./private/aws-credentials");
const github = require("./workflows-model");
/**
 * AWS credential provider
 */
class AwsCredentialsProvider {
}
exports.AwsCredentialsProvider = AwsCredentialsProvider;
_a = JSII_RTTI_SYMBOL_1;
AwsCredentialsProvider[_a] = { fqn: "cdk-pipelines-github.AwsCredentialsProvider", version: "0.3.60" };
/**
 * AWS credential provider from GitHub secrets
 */
class GitHubSecretsProvider extends AwsCredentialsProvider {
    constructor(props) {
        super();
        this.accessKeyId = props?.accessKeyId ?? 'AWS_ACCESS_KEY_ID';
        this.secretAccessKey = props?.secretAccessKey ?? 'AWS_SECRET_ACCESS_KEY';
        this.sessionToken = props?.sessionToken;
    }
    jobPermission() {
        return github.JobPermission.NONE;
    }
    credentialSteps(region, assumeRoleArn) {
        return [
            aws_credentials_1.awsCredentialStep('Authenticate Via GitHub Secrets', {
                region,
                accessKeyId: `\${{ secrets.${this.accessKeyId} }}`,
                secretAccessKey: `\${{ secrets.${this.secretAccessKey} }}`,
                ...(this.sessionToken ? {
                    sessionToken: `\${{ secrets.${this.sessionToken} }}`,
                } : undefined),
                ...(assumeRoleArn ? {
                    roleToAssume: assumeRoleArn,
                    roleExternalId: 'Pipeline',
                } : undefined),
            }),
        ];
    }
}
/**
 * AWS credential provider from OpenId Connect
 */
class OpenIdConnectProvider extends AwsCredentialsProvider {
    constructor(props) {
        super();
        this.gitHubActionRoleArn = props.gitHubActionRoleArn;
    }
    jobPermission() {
        return github.JobPermission.WRITE;
    }
    credentialSteps(region, assumeRoleArn) {
        function getDeployRole(arn) {
            return arn.replace('cfn-exec', 'deploy');
        }
        let steps = [];
        steps.push(aws_credentials_1.awsCredentialStep('Authenticate Via OIDC Role', {
            region,
            roleToAssume: this.gitHubActionRoleArn,
        }));
        if (assumeRoleArn) {
            // Result of initial credentials with GitHub Action role are these environment variables
            steps.push(aws_credentials_1.awsCredentialStep('Assume CDK Deploy Role', {
                region,
                accessKeyId: '${{ env.AWS_ACCESS_KEY_ID }}',
                secretAccessKey: '${{ env.AWS_SECRET_ACCESS_KEY }}',
                sessionToken: '${{ env.AWS_SESSION_TOKEN }}',
                roleToAssume: getDeployRole(assumeRoleArn),
                roleExternalId: 'Pipeline',
            }));
        }
        return steps;
    }
}
/**
 * Dummy AWS credential provider
 */
class NoCredentialsProvider extends AwsCredentialsProvider {
    jobPermission() {
        return github.JobPermission.NONE;
    }
    credentialSteps(_region, _assumeRoleArn) {
        return [];
    }
}
/**
 * Provides AWS credenitals to the pipeline jobs
 */
class AwsCredentials {
    /**
     * Reference credential secrets to authenticate with AWS. This method assumes
     * that your credentials will be stored as long-lived GitHub Secrets.
     */
    static fromGitHubSecrets(props) {
        return new GitHubSecretsProvider(props);
    }
    /**
     * Provide AWS credentials using OpenID Connect.
     */
    static fromOpenIdConnect(props) {
        return new OpenIdConnectProvider(props);
    }
    /**
     * Don't provide any AWS credentials, use this if runners have preconfigured credentials.
     */
    static runnerHasPreconfiguredCreds() {
        return new NoCredentialsProvider();
    }
}
exports.AwsCredentials = AwsCredentials;
_b = JSII_RTTI_SYMBOL_1;
AwsCredentials[_b] = { fqn: "cdk-pipelines-github.AwsCredentials", version: "0.3.60" };
//# sourceMappingURL=data:application/json;base64,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