"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustSupportRole = exports.BillingRole = exports.AdminRole = exports.GeneralRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
/**
 * The role that you are going to assume (switch role)
 *
 * Explores how the S3 Object Lambda works.
 */
class GeneralRole extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const policyName = props.policyName ?? 'general-role-s3olap-policy';
        const objectLambdaAccessPointName = props.objectLambdaAccessPointName ?? 'accessctl-s3olap-survey-results-unknown-pii';
        const iamRoleName = props.iamRoleName ?? 'GeneralRole';
        const generalRole = new iam.Role(this, 'IamRole', {
            roleName: iamRoleName,
            assumedBy: new iam.AccountRootPrincipal(),
            inlinePolicies: {
                [policyName]: new iam.PolicyDocument({
                    assignSids: true,
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'AllowListingObjects',
                            effect: iam.Effect.ALLOW,
                            actions: ['s3:ListBucket'],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowListingBucketsAndAccessPoints',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3:GetAccessPointForObjectLambda',
                                's3:GetAccessPointConfigurationForObjectLambda',
                                's3:ListAccessPointsForObjectLambda',
                                's3:ListAllMyBuckets',
                                's3:ListAccessPoints',
                                's3:GetAccessPoint',
                                's3:GetAccountPublicAccessBlock',
                                's3:GetBucketPublicAccessBlock',
                                's3:GetBucketPolicyStatus',
                                's3:GetBucketAcl',
                                's3:GetAccessPointPolicyStatus',
                            ],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowObjectLambdaAccess',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3-object-lambda:Get*',
                                's3-object-lambda:List*',
                            ],
                            resources: [`arn:${cdk.Aws.PARTITION}:s3-object-lambda:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:accesspoint/${objectLambdaAccessPointName}`],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowStandardAccessPointAccess',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3:Get*',
                                's3:List*',
                            ],
                            resources: ['*'],
                            conditions: {
                                ['ForAnyValue:StringEquals']: {
                                    'aws:CalledVia': ['s3-object-lambda.amazonaws.com'],
                                },
                            },
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowLambdaInvocation',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'lambda:InvokeFunction',
                            ],
                            resources: ['*'],
                            conditions: {
                                ['ForAnyValue:StringEquals']: {
                                    'aws:CalledVia': ['s3-object-lambda.amazonaws.com'],
                                },
                            },
                        }),
                    ],
                }),
            },
        });
        this.roleArn = generalRole.roleArn;
        this.roleName = generalRole.roleName;
        this.roleId = generalRole.roleId;
    }
}
exports.GeneralRole = GeneralRole;
_a = JSII_RTTI_SYMBOL_1;
GeneralRole[_a] = { fqn: "cdk-comprehend-s3olap.GeneralRole", version: "2.0.108" };
class AdminRole extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const policyName = props?.policyName ?? 'admin-role-s3olap-policy';
        const objectLambdaAccessPointName = props?.objectLambdaAccessPointName ?? 'admin-s3olap-call-transcripts-known-pii';
        const iamRoleName = props?.iamRoleName ?? 'RedactionAdminRole';
        const adminRole = new iam.Role(this, 'RedactionAdminRole', {
            roleName: iamRoleName,
            assumedBy: new iam.AccountRootPrincipal(),
            inlinePolicies: {
                [policyName]: new iam.PolicyDocument({
                    assignSids: true,
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'AllowListingObjects',
                            effect: iam.Effect.ALLOW,
                            actions: ['s3:ListBucket'],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowListingBucketsAndAccessPoints',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3:GetAccessPointForObjectLambda',
                                's3:GetAccessPointConfigurationForObjectLambda',
                                's3:ListAccessPointsForObjectLambda',
                                's3:ListAllMyBuckets',
                                's3:ListAccessPoints',
                                's3:GetAccessPoint',
                                's3:GetAccountPublicAccessBlock',
                                's3:GetBucketPublicAccessBlock',
                                's3:GetBucketPolicyStatus',
                                's3:GetBucketAcl',
                                's3:GetAccessPointPolicyStatus',
                            ],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowObjectLambdaAccess',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3-object-lambda:Get*',
                                's3-object-lambda:List*',
                            ],
                            resources: [`arn:${cdk.Aws.PARTITION}:s3-object-lambda:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:accesspoint/${objectLambdaAccessPointName}`],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowStandardAccessPointAccess',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3:Get*',
                                's3:List*',
                            ],
                            resources: ['*'],
                            conditions: {
                                ['ForAnyValue:StringEquals']: {
                                    'aws:CalledVia': ['s3-object-lambda.amazonaws.com'],
                                },
                            },
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowLambdaInvocation',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'lambda:InvokeFunction',
                            ],
                            resources: ['*'],
                            conditions: {
                                ['ForAnyValue:StringEquals']: {
                                    'aws:CalledVia': ['s3-object-lambda.amazonaws.com'],
                                },
                            },
                        }),
                    ],
                }),
            },
        });
        this.roleArn = adminRole.roleArn;
        this.roleName = adminRole.roleName;
        this.roleId = adminRole.roleId;
    }
}
exports.AdminRole = AdminRole;
_b = JSII_RTTI_SYMBOL_1;
AdminRole[_b] = { fqn: "cdk-comprehend-s3olap.AdminRole", version: "2.0.108" };
class BillingRole extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const policyName = props?.policyName ?? 'billing-role-s3olap-policy';
        const objectLambdaAccessPointName = props?.objectLambdaAccessPointName ?? 'billing-s3olap-call-transcripts-known-pii';
        const iamRoleName = props?.iamRoleName ?? 'RedactionBillingRole';
        const billingRole = new iam.Role(this, 'RedactionBillingRole', {
            roleName: iamRoleName,
            assumedBy: new iam.AccountRootPrincipal(),
            inlinePolicies: {
                [policyName]: new iam.PolicyDocument({
                    assignSids: true,
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'AllowListingObjects',
                            effect: iam.Effect.ALLOW,
                            actions: ['s3:ListBucket'],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowListingBucketsAndAccessPoints',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3:GetAccessPointForObjectLambda',
                                's3:GetAccessPointConfigurationForObjectLambda',
                                's3:ListAccessPointsForObjectLambda',
                                's3:ListAllMyBuckets',
                                's3:ListAccessPoints',
                                's3:GetAccessPoint',
                                's3:GetAccountPublicAccessBlock',
                                's3:GetBucketPublicAccessBlock',
                                's3:GetBucketPolicyStatus',
                                's3:GetBucketAcl',
                                's3:GetAccessPointPolicyStatus',
                            ],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowObjectLambdaAccess',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3-object-lambda:Get*',
                                's3-object-lambda:List*',
                            ],
                            resources: [`arn:${cdk.Aws.PARTITION}:s3-object-lambda:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:accesspoint/${objectLambdaAccessPointName}`],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowStandardAccessPointAccess',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3:Get*',
                                's3:List*',
                            ],
                            resources: ['*'],
                            conditions: {
                                ['ForAnyValue:StringEquals']: {
                                    'aws:CalledVia': ['s3-object-lambda.amazonaws.com'],
                                },
                            },
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowLambdaInvocation',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'lambda:InvokeFunction',
                            ],
                            resources: ['*'],
                            conditions: {
                                ['ForAnyValue:StringEquals']: {
                                    'aws:CalledVia': ['s3-object-lambda.amazonaws.com'],
                                },
                            },
                        }),
                    ],
                }),
            },
        });
        this.roleArn = billingRole.roleArn;
        this.roleName = billingRole.roleName;
        this.roleId = billingRole.roleId;
    }
}
exports.BillingRole = BillingRole;
_c = JSII_RTTI_SYMBOL_1;
BillingRole[_c] = { fqn: "cdk-comprehend-s3olap.BillingRole", version: "2.0.108" };
class CustSupportRole extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const policyName = props?.policyName ?? 'customersupport-role-s3olap-policy';
        const objectLambdaAccessPointName = props?.objectLambdaAccessPointName ?? 'custsupport-s3olap-call-transcripts-known-pii';
        const iamRoleName = props?.iamRoleName ?? 'RedactionCustSupportRole';
        const custSupportRole = new iam.Role(this, 'RedactionCustSupportRole', {
            roleName: iamRoleName,
            assumedBy: new iam.AccountRootPrincipal(),
            inlinePolicies: {
                [policyName]: new iam.PolicyDocument({
                    assignSids: true,
                    statements: [
                        new iam.PolicyStatement({
                            sid: 'AllowListingObjects',
                            effect: iam.Effect.ALLOW,
                            actions: ['s3:ListBucket'],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowListingBucketsAndAccessPoints',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3:GetAccessPointForObjectLambda',
                                's3:GetAccessPointConfigurationForObjectLambda',
                                's3:ListAccessPointsForObjectLambda',
                                's3:ListAllMyBuckets',
                                's3:ListAccessPoints',
                                's3:GetAccessPoint',
                                's3:GetAccountPublicAccessBlock',
                                's3:GetBucketPublicAccessBlock',
                                's3:GetBucketPolicyStatus',
                                's3:GetBucketAcl',
                                's3:GetAccessPointPolicyStatus',
                            ],
                            resources: ['*'],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowObjectLambdaAccess',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3-object-lambda:Get*',
                                's3-object-lambda:List*',
                            ],
                            resources: [`arn:${cdk.Aws.PARTITION}:s3-object-lambda:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:accesspoint/${objectLambdaAccessPointName}`],
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowStandardAccessPointAccess',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                's3:Get*',
                                's3:List*',
                            ],
                            resources: ['*'],
                            conditions: {
                                ['ForAnyValue:StringEquals']: {
                                    'aws:CalledVia': ['s3-object-lambda.amazonaws.com'],
                                },
                            },
                        }),
                        new iam.PolicyStatement({
                            sid: 'AllowLambdaInvocation',
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'lambda:InvokeFunction',
                            ],
                            resources: ['*'],
                            conditions: {
                                ['ForAnyValue:StringEquals']: {
                                    'aws:CalledVia': ['s3-object-lambda.amazonaws.com'],
                                },
                            },
                        }),
                    ],
                }),
            },
        });
        this.roleArn = custSupportRole.roleArn;
        this.roleName = custSupportRole.roleName;
        this.roleId = custSupportRole.roleId;
    }
}
exports.CustSupportRole = CustSupportRole;
_d = JSII_RTTI_SYMBOL_1;
CustSupportRole[_d] = { fqn: "cdk-comprehend-s3olap.CustSupportRole", version: "2.0.108" };
//# sourceMappingURL=data:application/json;base64,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