# Generated by Django 3.0.7 on 2021-03-14 16:43

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('npl_portfolio', '0003_auto_20210204_0958'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='counterparty',
            name='date_of_entering_into_current_legal_process',
        ),
        migrations.RemoveField(
            model_name='counterparty',
            name='legal_actions_completed',
        ),
        migrations.RemoveField(
            model_name='counterparty',
            name='legal_procedure_name',
        ),
        migrations.RemoveField(
            model_name='counterparty',
            name='legal_status',
        ),
        migrations.RemoveField(
            model_name='portfoliosnapshot',
            name='notes',
        ),
        migrations.AddField(
            model_name='counterparty',
            name='additional_name_of_insolvency_or_restructuring_proceedings',
            field=models.TextField(blank=True, help_text='Name of the insolvency or restructuring proceedings. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Additional_Name_of_InsolvencyorRestructuring_Proceedings">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='additional_stage_reached_in_insolvency_procedure',
            field=models.TextField(blank=True, help_text='Additional indication of how advanced the relevant procedure has become as a result of various legal steps in the legal procedure having been completeted. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Additional_Stage_Reached_in_InsolvencyorRestructuring_procedure">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='borrower_type',
            field=models.IntegerField(blank=True, choices=[(0, '(a) Private Individual'), (1, '(b) Corporate')], help_text='The borrower type (individual or corporate', null=True),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='commencement_date_of_insolvency_or_restructuring_proceedings',
            field=models.DateField(blank=True, help_text='Date that the Counterparty commenced Insolvency / Restructuring Proceedings <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Commencement_Date_of_Insolvency_or_Restructuring_Proceedings">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='correspondence_address_of_appointed_insolvency_practitioner',
            field=models.TextField(blank=True, help_text='https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Correspondence_address_of_appointed_insolvency_practitioner. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Country_of_Registered_Location">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='description_of_legal_procedure_type',
            field=models.TextField(blank=True, choices=[(0, '(a) Corporate Restructuring Procedures, which also include funds'), (1, '(b) Corporate Insolvency Procedures, which also include funds'), (2, '(c) Private Individual Counterparty Debt Compromise Procedures'), (3, '(d) Private Individual Counterparty Insolvency Procedures'), (4, '(e) Partnership Restructuring Procedures'), (5, '(f) Partnership Insolvency Procedures')], help_text='Type of the insolvency process the Counterparty is currently in. Choice fields are provided indicating per country the possible procedures. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Description_of_Legal_Procedure_Type">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='distribution_made_to_the_seller',
            field=models.NullBooleanField(help_text='https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Distribution_made_to_the_Seller. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Country_of_Registered_Location">Documentation</a>'),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='insolvency_practitioner_reference',
            field=models.TextField(blank=True, help_text='Insolvency Practitioner Reference" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Insolvency_Practitioner_Reference">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='name_of_insolvency_or_restructuring_proceedings',
            field=models.TextField(blank=True, help_text='Name of the insolvency or restructuring proceedings. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Name_of_InsolvencyorRestructuring_Proceedings">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='notice_for_procedure_termination',
            field=models.NullBooleanField(help_text='Indicator as to whether the notice of the end of the procedure has been given to the seller. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Notice_for_Procedure_Termination">Documentation</a>'),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='occupation_description',
            field=models.TextField(blank=True, help_text='Description of the occupation of the Private Individual Counterparty, providing more detail for field Occupation Type. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Occupation_Description">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='occupation_type',
            field=models.TextField(blank=True, help_text='Main occupation of the Private Individual Counterparty, where (a), (b), (c) or (d) is selected in the field Employment Status. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Occupation_Type">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='proof_of_claim_filed_by_the_seller',
            field=models.NullBooleanField(help_text='Proof of Claim Filed by the seller. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Proof_of_Claim_Filed_by_the_seller">Documentation</a>'),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='stage_reached_in_insolvency_or_restructuring_procedure',
            field=models.IntegerField(blank=True, choices=[(0, '(a) A creditors committee has been formed'), (1, '(b) A moratorium against enforcement is in place'), (2, '(c) A restructuring plan has been proposed'), (3, '(d) A restructuring plan has been approved'), (4, '(e) A proof of claim has been filed'), (5, '(f) A bar date for claims has been issued'), (6, '(g) A notice of intention to sell secured assets has been given'), (7, '(h) A distribution has been made to secured creditors'), (8, '(i) A distribution has been made to unsecured creditors'), (9, '(j) A notice of the end of the procedure has been given')], help_text='Stage Reached in Insolvency/Restructuring procedure  <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Stage_Reached_in_InsolvencyorRestructuring_procedure">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='enforcement',
            name='collateral_repossessed_date',
            field=models.DateField(blank=True, help_text='Date that the collateral is repossessed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Collateral_Repossessed_Date">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='loan',
            name='balance_at_default',
            field=models.BigIntegerField(blank=True, help_text='Balance of the Loan when the Loan has defaulted (CRR Art.178). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Balance_at_default">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='loan',
            name='marp_applicable',
            field=models.NullBooleanField(help_text='Indicator as to whether the Institution operates a Mortgage Arrears Resolution Process when dealing with Corporates or Private Individual Counterparties in Mortgage Arrears. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.MARP_Applicable">Documentation</a>'),
        ),
        migrations.AddField(
            model_name='loan',
            name='marp_entry',
            field=models.DateField(blank=True, help_text='Date loan entered current MARP status. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.MARP_Entry">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='loan',
            name='marp_status',
            field=models.IntegerField(blank=True, choices=[(0, '(a) Not in MARP'), (1, '(b) Exited MARP'), (2, '(c) Provision 23 - 31 days in arrears'), (3, '(d) Provision 24 - Financial difficulty'), (4, '(e) Provision 28 - Not co-operating warning'), (5, '(f) Provision 29 - Not co-operating'), (6, '(g) Provision 42 - Restructure offer'), (7, '(h) Provision 45 - Restructure declined by seller'), (8, '(i) Provision 47 - Restructure declined by borrower'), (9, '(j) Self-Cure'), (10, '(k) Alternative Repayment Arrangement (ARA)')], help_text='The status of the current Mortgage Arrears Resolution Process; Not in MARP, Exited MARP, Provision 23,24,28,29,42,45,47,Self Cure, Alternative Repayment Arrangement (ARA). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.MARP_Status">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='loan',
            name='recourse_to_other_assets',
            field=models.NullBooleanField(help_text='Indicator as to whether the Institution has the legal right to access other assets of the Borrower. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Recourse_to_Other_Assets">Documentation</a>'),
        ),
        migrations.AddField(
            model_name='nonpropertycollateral',
            name='asset_purchase_obligation',
            field=models.NullBooleanField(help_text='Indicator as to whether there is an obligation for the Borrower to purchase the Collateral at the end of the lease. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty_Collateral.Asset_Purchase_Obligation">Documentation</a>'),
        ),
        migrations.AddField(
            model_name='nonpropertycollateral',
            name='configuration',
            field=models.TextField(blank=True, help_text='Specification and option list of the Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty_Collateral.Configuration">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='nonpropertycollateral',
            name='current_country_of_registration',
            field=models.TextField(blank=True, help_text='Country that the Collateral is currently registered in as at cut-off date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty_Collateral.Current_Country_of_Registration">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='nonpropertycollateral',
            name='date_of_the_latest_residual_valuation',
            field=models.DateField(blank=True, help_text='Date that the latest residual value of the Collateral was assessed, residual value refers to how much the Collateral will be worth at end of the loan term. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty_Collateral.Date_of_the_Latest_Residual_Valuation">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='nonpropertycollateral',
            name='estimated_useful_life',
            field=models.IntegerField(blank=True, help_text='Estimated remaining useful life as at cut-off date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty_Collateral.Estimated_Useful_Life">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='nonpropertycollateral',
            name='initial_residual_valuation_date',
            field=models.DateField(blank=True, help_text='Date at which the initial residual value of the Collateral was assessed, residual value refers to how much the Collateral will be worth at end of the loan term. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty_Collateral.Initial_Residual_Valuation_Date">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='nonpropertycollateral',
            name='initial_residual_value',
            field=models.FloatField(blank=True, help_text='Estimated residual value of the Collateral at loan origination, residual value refers to how much the Collateral will be worth at end of the loan term . <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty_Collateral.Initial_Residual_Value">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='nonpropertycollateral',
            name='latest_residual_value',
            field=models.FloatField(blank=True, help_text='Estimated residual value of the Collateral when last assessed, residual value refers to how much the Collateral will be worth at end of the loan term. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty_Collateral.Latest_Residual_Value">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='nonpropertycollateral',
            name='option_to_buy_price',
            field=models.FloatField(blank=True, help_text='Amount the Borrower will pay at the end of the lease in order to take ownership of the Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty_Collateral.Option_to_Buy_Price">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='nonpropertycollateral',
            name='original_country_of_registration',
            field=models.TextField(blank=True, help_text='Country that the Collateral was originally registered in. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty_Collateral.Original_Country_of_Registration">Documentation</a>', null=True),
        ),
        migrations.AddField(
            model_name='portfolio',
            name='description',
            field=models.TextField(blank=True, help_text='Description of the portfolio', null=True),
        ),
        migrations.AlterField(
            model_name='portfoliosnapshot',
            name='name',
            field=models.CharField(blank=True, help_text='An assigned name to help identify the snapshot. By convention the name of the portfolio plus the cutoff date', max_length=200, null=True),
        ),
        migrations.AlterField(
            model_name='propertycollateral',
            name='geographic_region_of_property',
            field=models.TextField(blank=True, help_text='Province / Region where the Property is located at. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.11.01.Property Collateral.Geographic_Region_of_Property">Documentation</a>', null=True),
        ),
    ]
