# Generated by Django 3.0.7 on 2020-12-21 10:39

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Counterparty',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('counterparty_identifier', models.TextField(help_text='Unique internal identifier for the Counterparty. One or multiple Counterparties can be part of a Counterparty. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Counterparty_Identifier">Documentation</a>', unique=True)),
                ('address_of_registered_location', models.TextField(blank=True, help_text='Address where the Corporate Counterparty is registered, including flat / house number. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Address_of_Registered_Location">Documentation</a>', null=True)),
                ('annual_ebit', models.BigIntegerField(blank=True, help_text='Amount of annual EBIT held by the Corporate Counterparty as per the latest available financial statements. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Annual_EBIT">Documentation</a>', null=True)),
                ('annual_revenue', models.BigIntegerField(blank=True, help_text='Amount of annual revenue held by the Corporate Counterparty as per the latest available financial statements. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Annual_Revenue">Documentation</a>', null=True)),
                ('basis_of_financial_statements', models.IntegerField(blank=True, choices=[(0, '(a) IFRS'), (1, '(b) National GAAP '), (2, '(c) Other')], help_text='Financial reporting practice the Corporate Counterparty has adopted i.e. IFRS, National GAAP, Not Available. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Basis_of_Financial_Statements">Documentation</a>', null=True)),
                ('business_description', models.TextField(blank=True, help_text='Description of the business operations of the Corporate Counterparty, providing more detail for field "Industry Segment". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Business_Description">Documentation</a>', null=True)),
                ('cash_and_cash_equivalent_items', models.BigIntegerField(blank=True, help_text='Amount of cash and cash equivalent items held by the Corporate Counterparty as  per the latest available financial statements. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Cash_and_Cash_Equivalent_Items">Documentation</a>', null=True)),
                ('city_of_registered_location', models.TextField(blank=True, help_text='City where the Corporate Counterparty is registered. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.City_of_Registered_Location">Documentation</a>', null=True)),
                ('comments_on_other_litigation_related_process', models.TextField(blank=True, help_text='Further comments / details if there is other litigation processes in place. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Comments_on_Other_Litigation_Related_Process">Documentation</a>', null=True)),
                ('contingent_obligations', models.TextField(blank=True, help_text='Indicator as to whether the Corporate Counterparty has contingent obligations which will be part of the sale, e.g. the Institution provided a guarantee to a real estate developer on their development. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Contingent_Obligations">Documentation</a>', null=True)),
                ('counterparty_group_identifier', models.TextField(blank=True, help_text='Institutions internal identifier for the Counterparty Group. Where Counterparty Group is defined as a group of related Counterparties. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Counterparty_Group_Identifier">Documentation</a>', null=True)),
                ('counterparty_role', models.IntegerField(blank=True, choices=[(0, '(a) Guarantor'), (1, '(b) Borrower'), (2, '(c) Tenant')], help_text='Type of the Counterparty i.e. Guarantor, Borrower, Tenant. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Counterparty_Role">Documentation</a>', null=True)),
                ('country_of_registered_location', models.TextField(blank=True, help_text='Country where the Corporate Counterparty is registered. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Country_of_Registered_Location">Documentation</a>', null=True)),
                ('cross_collateralisation_for_counterparty', models.IntegerField(blank=True, choices=[(0, '(a) Full'), (1, '(b) Partial'), (2, '(c) None')], help_text='Indicator as to whether all / some of the loans held by the Counterparty are secured by all / some of the collaterals held by the Counterparty. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Cross_Collateralisation_for_Counterparty">Documentation</a>', null=True)),
                ('cross_default_for_counterparty', models.IntegerField(blank=True, choices=[(0, '(a) Full'), (1, '(b) Partial'), (2, '(c) None')], help_text='Indicator as to whether contractual breach of any loans held by the Counterparty would trigger the default event of any other loans. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Cross_Default_for_Counterparty">Documentation</a>', null=True)),
                ('currency_of_deposit', models.TextField(blank=True, help_text='Currency that the deposit held with the Institution is expressed in. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Currency_of_Deposit">Documentation</a>', null=True)),
                ('currency_of_financial_statements', models.TextField(blank=True, help_text='Currency that the latest available financial statements are expressed in. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Currency_of_Financial_Statements">Documentation</a>', null=True)),
                ('current_assets', models.BigIntegerField(blank=True, help_text='Amount of current assets held by the Corporate Counterparty, excluding cash and cash equivalent items as per the latest available financial statements. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Current_Assets">Documentation</a>', null=True)),
                ('current_external_credit_rating', models.TextField(blank=True, help_text='External credit rating issued to the Corporate Counterparty at NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Current_External_Credit_Rating">Documentation</a>', null=True)),
                ('current_internal_credit_rating', models.TextField(blank=True, help_text='Internal credit rating issued to the Counterparty at the NPL Portfolio Cut-Off Date and please provide the internal methodology used to decide the rating as a part of the transaction documents. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Current_Internal_Credit_Rating">Documentation</a>', null=True)),
                ('date_of_appointment', models.DateField(blank=True, help_text='Date that the insolvency practitioner was appointed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Date_of_Appointment">Documentation</a>', null=True)),
                ('date_of_entering_into_current_legal_process', models.DateField(blank=True, help_text='Date that the Counterparty entered into their current legal status. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Date_of_Entering_Into_Current_Legal_Process">Documentation</a>', null=True)),
                ('date_of_external_demand_issuance', models.DateField(blank=True, help_text='Date that a demand notice was sent by solicitors who act on behalf of the Institution. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Date_of_External_Demand_Issuance">Documentation</a>', null=True)),
                ('date_of_incorporation', models.DateField(blank=True, help_text='Date that the Corporate Counterparty was incorporated as a company, partnership or fund, and therefore became a separate legal entity from its owners, with its own rights and obligations. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Date_of_Incorporation">Documentation</a>', null=True)),
                ('date_of_internal_demand_issuance', models.DateField(blank=True, help_text='Date that a demand notice was sent by the Institution itself. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Date_of_Internal_Demand_Issuance">Documentation</a>', null=True)),
                ('date_of_last_contact', models.DateField(blank=True, help_text='Date of last direct contact with the Counterparty. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Date_of_Last_Contact">Documentation</a>', null=True)),
                ('date_of_latest_annual_financial_statements', models.DateField(blank=True, help_text='Date of the latest available Financial Statements. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Date_of_Latest_Annual_Financial_Statements">Documentation</a>', null=True)),
                ('date_of_obtaining_order_for_possession', models.DateField(blank=True, help_text='Date that the Order for Possession is granted by the court. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Date_of_Obtaining_Order_for_Possession">Documentation</a>', null=True)),
                ('date_when_reservation_of_rights_letter_was_issued', models.DateField(blank=True, help_text='Date that the Reservation of Rights Letter was issued by the Institution. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Date_when_Reservation_of_Rights_Letter_Was_Issued">Documentation</a>', null=True)),
                ('deposit_balance_with_institution', models.BigIntegerField(blank=True, help_text='Deposit amount the Counterparty holds with the Institution as defined by annex II, Part two of the ECB BSI Regulation. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Deposit_Balance_with_Institution">Documentation</a>', null=True)),
                ('description_of_contingent_obligations', models.TextField(blank=True, help_text='Description of contingent obligations when "Yes" is selected in field "Contingent Obligations". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Description_of_Contingent_Obligations">Documentation</a>', null=True)),
                ('description_of_cross_collateralisation', models.TextField(blank=True, help_text='Description of cross collateralisation when "Partial" is selected in field "Cross Collateralisation for Counterparty". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Description_of_Cross_Collateralisation">Documentation</a>', null=True)),
                ('description_of_cross_default', models.TextField(blank=True, help_text='Description of cross default when "Partial" is selected in field "Cross Default for Counterparty". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Description_of_Cross_Default">Documentation</a>', null=True)),
                ('description_of_related_party', models.TextField(blank=True, help_text='Further comments / details on the nature of the relation between the institution and the related party when "Yes" is selected in field "Related Party". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Description_of_Related_Party">Documentation</a>', null=True)),
                ('eligibility_for_deposit_to_offset', models.TextField(blank=True, help_text='Indicator as to whether the deposit held with the Institution can be used to pay down the loan. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Eligibility_for_Deposit_to_Offset">Documentation</a>', null=True)),
                ('enterprise_size', models.IntegerField(blank=True, choices=[(0, '(a) Micro-enterprise'), (1, '(b) Small enterprise'), (2, '(c) Medium enterprise'), (3, '(d) Large enterprise')], help_text='Classification of enterprises by size for the Corporate Counterparty i.e. Microenterprise, Small enterprise, Medium enterprise and Large enterprise. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Enterprise_Size">Documentation</a>', null=True)),
                ('eviction_date', models.DateField(blank=True, help_text='Date that the Counterparty is evicted. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Eviction_Date">Documentation</a>', null=True)),
                ('external_credit_rating_at_origination', models.TextField(blank=True, help_text='External credit rating issued to the Corporate Counterparty applicable at the point in time when the Counterparty became a customer and choose the lowest one if there are multiple ratings. In case several ratings are assigned, the approach described in Art. 138 of the CRR applies.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.External_Credit_Rating_at_Origination">Documentation</a>', null=True)),
                ('financial_statements_type', models.IntegerField(blank=True, choices=[(0, '(a) Consolidated'), (1, '(b) Counterparty level')], help_text='Indicator as to whether the financial statements have been prepared at the Consolidated or at the Counterparty level. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Financial_Statements_Type">Documentation</a>', null=True)),
                ('financials_audited', models.TextField(blank=True, help_text='Indicator as to whether the financial statements have been audited or not by the Corporate Counterparty. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Financials_Audited">Documentation</a>', null=True)),
                ('fixed_assets', models.BigIntegerField(blank=True, help_text='Amount of fixed assets held by the Corporate Counterparty as per the latest available financial statements. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Fixed_Assets">Documentation</a>', null=True)),
                ('geographic_region_classification', models.IntegerField(blank=True, choices=[(0, '(a) NUTS3 2013'), (1, '(b) NUTS3 2010'), (2, '(c) NUTS3 2006'), (3, '(d) NUTS3 2003'), (4, '(e) Other')], help_text='NUTS3 classification used for the field "Geographic Region of Registered Location", i.e. NUTS3 2013 (1), NUTS3 2010 (2), NUTS3 2006 (3), NUTS3 2003 (4), Other (5). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Geographic_Region_Classification">Documentation</a>', null=True)),
                ('geographic_region_of_registered_location', models.TextField(blank=True, help_text='Province or Region where the Corporate Counterparty is registered. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Geographic_Region_of_Registered_Location">Documentation</a>', null=True)),
                ('indicator_of_counterparty_cooperation', models.TextField(blank=True, help_text='Indicator as to whether the Corporate or Private Individual Counterparty is cooperative or not. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Indicator_of_Counterparty_Cooperation">Documentation</a>', null=True)),
                ('industry_segment', models.TextField(blank=True, help_text='Industry in which the Corporate Counterparty mainly operates. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Industry_Segment">Documentation</a>', null=True)),
                ('insolvency_practitioner_appointed', models.TextField(blank=True, help_text='Indicator as to whether an insolvency practitioner has been appointed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Insolvency_Practitioner_Appointed">Documentation</a>', null=True)),
                ('internal_credit_rating_at_origination', models.TextField(blank=True, help_text='Internal credit rating issued to the Counterparty applicable at the point in time when the Counterparty became a customer. Please provide the internal methodology used to decide the rating as a part of the transaction documents. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Internal_Credit_Rating_at_Origination">Documentation</a>', null=True)),
                ('jurisdiction_of_court', models.TextField(blank=True, help_text='Location of the court where the case is being heard. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Jurisdiction_of_Court">Documentation</a>', null=True)),
                ('legal_actions_completed', models.TextField(blank=True, help_text='Description of the legal actions completed for the Counterparty. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Legal_Actions_Completed">Documentation</a>', null=True)),
                ('legal_entity_identifier', models.TextField(blank=True, help_text='Global standard 20-character corporate identifier of the Corporate Counterparty. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Legal_entity_identifier">Documentation</a>', null=True)),
                ('legal_fees_accrued', models.BigIntegerField(blank=True, help_text='Total amount of legal fees accrued at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Legal_Fees_Accrued">Documentation</a>', null=True)),
                ('legal_procedure_name', models.IntegerField(blank=True, choices=[(0, 'Country Specific: Annex I')], help_text='Name of the legal procedure which provides an indication of how advanced the relevant procedure has become, depending on the country where the Counterparty is located. choice fields indicate country specifics features). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Legal_Procedure_Name">Documentation</a>', null=True)),
                ('legal_procedure_type', models.IntegerField(blank=True, choices=[(0, '(a) Corporate Restructuring Procedures, which also include funds'), (1, '(b) Corporate Insolvency Procedures, which also include funds'), (2, '(c) Private Individual Counterparty Debt Compromise Procedures'), (3, '(d) Private Individual Counterparty Insolvency Procedures'), (4, '(e) Partnership Restructuring Procedures'), (5, '(f) Partnership Insolvency Procedures')], help_text='Type of the insolvency process the Counterparty is currently in. Choice fields are provided indicating per country the possible procedures. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Legal_Procedure_Type">Documentation</a>', null=True)),
                ('legal_status', models.IntegerField(blank=True, choices=[(0, '(a) Listed Corporate is a Corporate entity whose shares are quoted and traded on a Stock Exchange'), (1, '(b) Unlisted Corporate is a Corporate entity whose shares are not quoted and traded on a stock exchange, however an unlisted corporate may have an unlimited number of shareholders to raise capital for any commercial venture'), (2, '(c) Listed Fund is a fund whose shares are quoted and traded on a Stock exchange'), (3, '(d) Unlisted Fund is a fund whose shares are not quoted and traded on a Stock exchange'), (4, '(e) Partnership is where the Sponsor constitutes a group of individuals who form a legal partnership, where profits and liabilities are shared; or,'), (5, '(f) Private Individual')], help_text='The type of legal status of the Counterparty. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Legal_status">Documentation</a>', null=True)),
                ('legal_type_of_counterparty', models.IntegerField(blank=True, choices=[(0, '(a) Listed Corporate is a Corporate entity whose shares are quoted and traded on a Stock Exchange'), (1, '(b) Unlisted Corporate is a Corporate entity whose shares are not quoted and traded on a stock exchange, however an unlisted corporate may have an unlimited number of shareholders to raise capital for any commercial venture'), (2, '(c) Listed Fund is a fund whose shares are quoted and traded on a Stock exchange'), (3, '(d) Unlisted Fund is a fund whose shares are not quoted and traded on a Stock exchange'), (4, '(e) Partnership is where the Sponsor constitutes a group of individuals who form a legal partnership, where profits and liabilities are shared; or,'), (5, '(f) Private Individual')], help_text='Type of the Counterparty i.e. Private Individual, Listed Corporate, Unlisted Corporate and Partnership. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Legal_Type_of_Counterparty">Documentation</a>', null=True)),
                ('market_capitalisation', models.BigIntegerField(blank=True, help_text='Market capitalisation of a listed Corporate Counterparty. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Market_Capitalisation">Documentation</a>', null=True)),
                ('name_of_counterparty', models.TextField(blank=True, help_text='Name used to refer to the Counterparty. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Name_of_Counterparty">Documentation</a>', null=True)),
                ('name_of_insolvency_practitioner', models.TextField(blank=True, help_text='Name of the insolvency practitioner. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Name_of_Insolvency_Practitioner">Documentation</a>', null=True)),
                ('net_assets', models.BigIntegerField(blank=True, help_text='Amount of net assets held by the Corporate Counterparty as per the latest available financial statements. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Net_Assets">Documentation</a>', null=True)),
                ('number_of_fte', models.BigIntegerField(blank=True, help_text='Number of full-time employees (or equivalent) working for the Corporate Counterparty as at the last financial reporting date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Number_of_FTE">Documentation</a>', null=True)),
                ('number_of_joint_counterparties', models.BigIntegerField(blank=True, help_text='Number of joint Counterparties who jointly own parts of the Loan.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Number_of_Joint_Counterparties">Documentation</a>', null=True)),
                ('other_products_with_institution', models.TextField(blank=True, help_text='Other products that the Counterparty holds with the Institution that are not included in the NPL Portfolio. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Other_Products_with_Institution">Documentation</a>', null=True)),
                ('postcode_of_registered_location', models.TextField(blank=True, help_text='Postcode where the Corporate Counterparty is registered. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Postcode_of_Registered_Location">Documentation</a>', null=True)),
                ('registration_number', models.TextField(blank=True, help_text='Company registration number of the Corporate Counterparty according to the country specific registration office. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Registration_number">Documentation</a>', null=True)),
                ('related_party', models.TextField(blank=True, help_text='Indicator as to whether the Counterparty is a related party to the Institution, e.g. Counterparty is an employee of the Institution. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Related_Party">Documentation</a>', null=True)),
                ('sheriff_or_bailiff_acquisition_date', models.DateField(blank=True, help_text='Date that sheriff / bailiff is acquired by the court. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Sheriff_or_Bailiff_Acquisition_Date">Documentation</a>', null=True)),
                ('source_of_current_external_credit_rating', models.TextField(blank=True, help_text='Agency which provided the external credit rating at cut-off date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Source_of_Current_External_Credit_Rating">Documentation</a>', null=True)),
                ('source_of_external_credit_rating_at_origination', models.TextField(blank=True, help_text='From which agency the external credit rating at the point in time when the Counterparty became a customer. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Source_of_External_Credit_Rating_at_Origination">Documentation</a>', null=True)),
                ('total_assets', models.BigIntegerField(blank=True, help_text='Amount of total assets held by the Corporate Counterparty as per the latest available financial statements. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Total_Assets">Documentation</a>', null=True)),
                ('total_debt', models.BigIntegerField(blank=True, help_text='Amount of total debt held by the Corporate Counterparty as per the latest available financial statements. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Total_Debt">Documentation</a>', null=True)),
                ('total_liabilities', models.BigIntegerField(blank=True, help_text='Amount of total liabilities held by the Corporate Counterparty on the balance sheet as defined by the applicable accounting standard as per the latest available financial statements. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty.Total_Liabilities">Documentation</a>', null=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('last_change_date', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Counterparty',
                'verbose_name_plural': 'Counterparties',
            },
        ),
        migrations.CreateModel(
            name='CounterpartyGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('counterparty_group_identifier', models.TextField(unique=True)),
                ('cross_collateralisation_in_counterparty_group', models.IntegerField(blank=True, choices=[(0, '(d) Full'), (1, '(e) Partial'), (2, '(f) None')], help_text='Indicator as to whether all / some of the loans in the Counterparty Group are secured by all / some of the collaterals within the Counterparty Group ("Full", "Partial", "none"). <a target="_blank" class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty Group.Cross_Collateralisation_in_Counterparty_Group">Documentation</a>', null=True)),
                ('cross_default_in_counterparty_group', models.IntegerField(blank=True, choices=[(0, '(a) Full'), (1, '(b) Partial'), (2, '(c) None')], help_text='The indicator as to whether Contractual breach of any loans in the Counterparty Group would trigger the contractual default event of the other loans. ("Full", "Partial", "none"). <a target="_blank" class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty Group.Cross_Default_in_Counterparty_Group">Documentation</a>', null=True)),
                ('description_of_cross_collateralisation', models.TextField(blank=True, help_text='Description of cross collateralisation when "Partial" is selected in field "Cross Collateralisation in Borrower Group". <a target="_blank" class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty Group.Description_of_Cross_Collateralisation">Documentation</a>', null=True)),
                ('description_of_cross_default', models.TextField(blank=True, help_text='Description of cross default when "Partial" is selected in field "Cross Default in Borrower Group". <a target="_blank" class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty Group.Description_of_Cross_Default">Documentation</a>', null=True)),
                ('description_of_sponsor', models.TextField(blank=True, help_text='Description and related narrative on the Sponsor, e.g. the Sponsor is a high net worth individual and owns the Borrower via a fund. <a target="_blank" class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty Group.Description_of_Sponsor">Documentation</a>', null=True)),
                ('industry_segment_of_counterparty_group', models.TextField(blank=True, help_text='Industry in which the Counterparty Group mainly operates. <a target="_blank" class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty Group.Industry_Segment_of_Counterparty_Group">Documentation</a>', null=True)),
                ('name_of_counterparty_group', models.TextField(blank=True, help_text='Name used to refer to the Counterparty Group. <a target="_blank" class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty Group.Name_of_Counterparty_Group">Documentation</a>', null=True)),
                ('name_of_sponsor', models.TextField(blank=True, help_text='Name used to refer to the main decision maker / key individual in relation to the Counterparty Group. <a target="_blank" class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty Group.Name_of_Sponsor">Documentation</a>', null=True)),
                ('type_of_sponsor', models.IntegerField(blank=True, choices=[(0, '(a) Listed Corporate is a Corporate entity whose shares are quoted and traded on a Stock Exchange'), (1, '(b) Unlisted Corporate is a Corporate entity whose shares are not quoted and traded on a stock exchange, however an unlisted corporate may have an unlimited number of shareholders to raise capital for any commercial venture'), (2, '(c) Listed Fund is a fund whose shares are quoted and traded on a Stock exchange'), (3, '(d) Unlisted Fund is a fund whose shares are not quoted and traded on a Stock exchange'), (4, '(e) Partnership is where the Sponsor constitutes a group of individuals who form a legal partnership, where profits and liabilities are shared; or,'), (5, '(f) Private Individual')], help_text='Type of entity the sponsor is i.e. Listed Corporate, Unlisted Corporate, Listed Fund, Unlisted Fund and High Net Worth Individual. <a target="_blank" class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Counterparty Group.Type_of_Sponsor">Documentation</a>', null=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('last_change_date', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Counterparty Group',
                'verbose_name_plural': 'Counterparty Groups',
            },
        ),
        migrations.CreateModel(
            name='Enforcement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enforcement_identifier', models.TextField(unique=True)),
                ('amount_of_outstanding_liabilities', models.FloatField(blank=True, help_text='Amount of accrued costs and fees paid by the receiver and to be invoiced to the Institution. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Amount_of_Outstanding_Liabilities">Documentation</a>', null=True)),
                ('annual_insurance_payment', models.FloatField(blank=True, help_text='Annual insurance payment to be paid by receiver. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Annual_Insurance_Payment">Documentation</a>', null=True)),
                ('contracted_date', models.DateField(blank=True, help_text='Contracted date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Contracted_Date">Documentation</a>', null=True)),
                ('costs_accrued_to_buyer', models.FloatField(blank=True, help_text='Costs accrued to the buyer. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Costs_Accrued_to_Buyer">Documentation</a>', null=True)),
                ('costs_at_end_of_sale', models.FloatField(blank=True, help_text='Total costs accrued to the seller at end of sale process. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Costs_at_End_of_Sale">Documentation</a>', null=True)),
                ('court_appraisal_amount', models.FloatField(blank=True, help_text='Court appraisal amount of the Property / Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Court_Appraisal_Amount">Documentation</a>', null=True)),
                ('court_auction_identifier', models.TextField(blank=True, help_text='Unique identifier for the auction process. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Court_Auction_identifier">Documentation</a>', null=True)),
                ('court_auction_reserve_price_for_first_auction', models.FloatField(blank=True, help_text='Court set reserve price for first auction, i.e. minimum price required by the court. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Court_Auction_Reserve_Price_for_First_Auction">Documentation</a>', null=True)),
                ('court_auction_reserve_price_for_last_auction', models.FloatField(blank=True, help_text='Court set reserve price for last auction, i.e. minimum price required by the court. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Court_Auction_Reserve_Price_for_Last_Auction">Documentation</a>', null=True)),
                ('court_auction_reserve_price_for_next_auction', models.FloatField(blank=True, help_text='Court set reserve price for next auction, i.e. minimum price required by the court. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Court_Auction_Reserve_Price_for_Next_Auction">Documentation</a>', null=True)),
                ('currency_of_enforcement', models.TextField(blank=True, help_text='Currency that the items related to enforcement are expressed in. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Currency_of_Enforcement">Documentation</a>', null=True)),
                ('current_market_status', models.IntegerField(blank=True, choices=[(0, '(a) On the market, is when the collateral is advertised and marketed for sale'), (1, '(b) Off the market, is when the collateral is not marketed or up for sale')], help_text='Current market status of the Property / Collateral as at cut-off date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Current_Market_Status">Documentation</a>', null=True)),
                ('date_next_insurance_payment_is_due', models.DateField(blank=True, help_text='Date that the next insurance payment is due. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Date_Next_Insurance_Payment_Is_Due">Documentation</a>', null=True)),
                ('date_of_court_appraisal', models.DateField(blank=True, help_text='Date that the court appraisal happened. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Date_of_Court_Appraisal">Documentation</a>', null=True)),
                ('date_of_receiver_appointment', models.DateField(blank=True, help_text='Date that the receiver was appointed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Date_of_Receiver_Appointment">Documentation</a>', null=True)),
                ('enforcement_description', models.TextField(blank=True, help_text='Comments or description of the stage of enforcement. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Enforcement_Description">Documentation</a>', null=True)),
                ('fees_of_receivership', models.FloatField(blank=True, help_text='Annual fees charged by the receiver. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Fees_of_Receivership">Documentation</a>', null=True)),
                ('first_auction_date', models.DateField(blank=True, help_text='Date that the first auction has been performed in order to sell the Property / Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.First_Auction_Date">Documentation</a>', null=True)),
                ('funds_remitted_full_date', models.DateField(blank=True, help_text='Date that the funds were remitted fully. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Funds_Remitted_Full_Date">Documentation</a>', null=True)),
                ('funds_remitted_partial_date', models.DateField(blank=True, help_text='Date that the funds were remitted partially. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Funds_Remitted_Partial_Date">Documentation</a>', null=True)),
                ('gross_sale_proceeds', models.FloatField(blank=True, help_text='Gross sale proceeds, i.e. sales proceeds and costs incurred from the disposal. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Gross_Sale_Proceeds">Documentation</a>', null=True)),
                ('indicator_of_enforcement', models.NullBooleanField(help_text='Indicator as to whether the Enforcement process has been entered into by a Corporate or Private Individual Counterparty. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Indicator_of_Enforcement">Documentation</a>')),
                ('indicator_of_receivership', models.NullBooleanField(help_text='Indicator as to whether the Corporate or Private Individual Counterparty is in Receivership. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Indicator_of_Receivership">Documentation</a>')),
                ('insurance', models.NullBooleanField(help_text='Indicator as to whether the receiver has insured the Property / Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Insurance">Documentation</a>')),
                ('insurance_coverage_amount', models.FloatField(blank=True, help_text='Amount that the insurance covers. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Insurance_Coverage_Amount">Documentation</a>', null=True)),
                ('insurance_provider', models.TextField(blank=True, help_text='Name of the insurance provider. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Insurance_Provider">Documentation</a>', null=True)),
                ('jurisdiction_of_court', models.TextField(blank=True, help_text='Location of the court where the case is being heard in. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Jurisdiction_of_Court">Documentation</a>', null=True)),
                ('last_auction_date', models.DateField(blank=True, help_text='Date that the last auction was performed in order to sell the Property / Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Last_Auction_Date">Documentation</a>', null=True)),
                ('name_of_legal_firm', models.TextField(blank=True, help_text='Name of legal firm acting on behalf of the Institution. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Name_of_Legal_Firm">Documentation</a>', null=True)),
                ('name_of_receiver', models.TextField(blank=True, help_text='Name of the receiver appointed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Name_of_Receiver">Documentation</a>', null=True)),
                ('net_sale_proceeds', models.FloatField(blank=True, help_text='Net sale proceeds. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Net_Sale_Proceeds">Documentation</a>', null=True)),
                ('next_auction_date', models.DateField(blank=True, help_text='Date that the next intended auction has been performed in order to sell the Property / Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Next_Auction_Date">Documentation</a>', null=True)),
                ('number_of_failed_auctions', models.FloatField(blank=True, help_text='Number of failed previous auctions for the Property / Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Number_of_Failed_Auctions">Documentation</a>', null=True)),
                ('offer_price', models.FloatField(blank=True, help_text='The highest price offered by potential buyers. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Offer_Price">Documentation</a>', null=True)),
                ('on_market_offer_date', models.DateField(blank=True, help_text='On market offer date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.On_Market_Offer_Date">Documentation</a>', null=True)),
                ('on_market_price', models.FloatField(blank=True, help_text='Price of the Property / Collateral for which it is on the market. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.On_Market_Price">Documentation</a>', null=True)),
                ('other_ongoing_enforcement_proceedings', models.TextField(blank=True, help_text='Further comments / details if there is other proceedings in place. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Other_ongoing_enforcement_proceedings">Documentation</a>', null=True)),
                ('prepare_property_for_sale_date', models.DateField(blank=True, help_text='Prepare property for sale date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Prepare_Property_for_Sale_Date">Documentation</a>', null=True)),
                ('property_on_market_date', models.DateField(blank=True, help_text='Property on market date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Property_on_Market_Date">Documentation</a>', null=True)),
                ('protection_identifier', models.TextField(blank=True, help_text='Unique Institution internal identifier for the Property / Collateral as defined in sections "Property Collateral" and "Non-Property Collateral". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Protection_identifier">Documentation</a>', null=True)),
                ('sale_agreed_date', models.DateField(blank=True, help_text='Sale agreed date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Sale_Agreed_Date">Documentation</a>', null=True)),
                ('sale_agreed_price', models.FloatField(blank=True, help_text='Agreed price for the disposal of the Property / Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Sale_Agreed_Price">Documentation</a>', null=True)),
                ('sold_date', models.DateField(blank=True, help_text='Sold date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Enforcement.Sold_Date">Documentation</a>', null=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('last_change_date', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Enforcement',
                'verbose_name_plural': 'Enforcements',
            },
        ),
        migrations.CreateModel(
            name='ExternalCollection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('external_collection_identifier', models.TextField(unique=True)),
                ('balance_amount_sent_to_agent', models.FloatField(blank=True, help_text='The Balance that was sent to the External Debt Collection Agent. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Balance_Amount_Sent_to_Agent">Documentation</a>', null=True)),
                ('cash_recoveries', models.FloatField(blank=True, help_text='Total cash recoveries collected by the external collection agent. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Cash_Recoveries">Documentation</a>', null=True)),
                ('costs_accrued', models.FloatField(blank=True, help_text='Total amount of costs accrued for external collection as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Costs_Accrued">Documentation</a>', null=True)),
                ('date_returned_from_agent', models.DateField(blank=True, help_text='Date that the Loan was received back from the external collection agent, i.e. when the agent stopped recovery efforts and passed the Loan back to the Institution. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Date_Returned_From_Agent">Documentation</a>', null=True)),
                ('date_sent_to_agent', models.DateField(blank=True, help_text='Date that the Loan was sent to the external collection agent. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Date_Sent_to_Agent">Documentation</a>', null=True)),
                ('institutions_internal_identifier_for_the_loan_or_counterparty', models.TextField(blank=True, help_text='Institutions internal identifier for the Counterparty or the Loan.<a class ="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Institutions_internal_identifier_for_the_Loan_or_Counterparty" >Documentation</a>', null=True)),
                ('instrument_identifier', models.TextField(blank=True, help_text='Institutions internal identifier for the Loan part. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Instrument_Identifier">Documentation</a>', null=True)),
                ('legal_entity_identifier', models.TextField(blank=True, help_text='Global standard 20-character corporate identifier of the external collection agent. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Legal_entity_identifier">Documentation</a>', null=True)),
                ('name_of_external_debt_collection_agent', models.TextField(blank=True, help_text='Name of the external collection agent. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Name_of_External_Debt_Collection_Agent">Documentation</a>', null=True)),
                ('principal_forgiveness', models.FloatField(blank=True, help_text='Amount of the principal that was forgiven by the external collection agent as part of recovery negotiations. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Principal_Forgiveness">Documentation</a>', null=True)),
                ('quantity_returned_from_agent', models.FloatField(blank=True, help_text='Amount of times the at the Loan was received back from the external debt collection agent. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Quantity_Returned_From_Agent">Documentation</a>', null=True)),
                ('registration_number', models.TextField(blank=True, help_text='Company registration number of the external collection agent according to the registration with the country specific registration office. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Registration_number">Documentation</a>', null=True)),
                ('repayment_plan', models.NullBooleanField(help_text='Indicator as to whether a repayment plan has been agreed with the external collection agency. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Repayment_Plan">Documentation</a>')),
                ('repayment_plan_description', models.TextField(blank=True, help_text='Description of the repayment plan which has been agreed with the external collection agency. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Repayment_Plan_Description">Documentation</a>', null=True)),
                ('type_of_identifier', models.IntegerField(blank=True, choices=[(0, '(a) Counterparty'), (1, '(b) Loan')], help_text='Indicator as to whether the external collections have been prepares on a Counterparty level or on a Loan Level. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.External Collection.Type_of_Identifier">Documentation</a>', null=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('last_change_date', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'External Collection',
                'verbose_name_plural': 'External Collections',
            },
        ),
        migrations.CreateModel(
            name='Forbearance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('forbearance_identifier', models.TextField(unique=True)),
                ('amount_of_repayment_step_up', models.FloatField(blank=True, help_text='Additional amount that the current agreed forbearance amount is increased by. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Amount_of_Repayment_Step_Up">Documentation</a>', null=True)),
                ('clause_to_stop_forbearance', models.NullBooleanField(help_text='Indicator as to whether a clause exists to allow the Institution to stop the current forbearance. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Clause_to_Stop_Forbearance">Documentation</a>')),
                ('date_of_first_forbearance', models.DateField(blank=True, help_text='Date that the first forbearance happened. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Date_of_First_Forbearance">Documentation</a>', null=True)),
                ('date_of_principal_forgiveness', models.DateField(blank=True, help_text='Date that the principal forgiveness happened. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Date_of_Principal_Forgiveness">Documentation</a>', null=True)),
                ('date_of_repayment_step_up', models.DateField(blank=True, help_text='Date at which the current agreed forbearance amount is increased. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Date_of_Repayment_Step_Up">Documentation</a>', null=True)),
                ('description_of_forbearance', models.TextField(blank=True, help_text='Further comments / details on the current forbearance. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Description_of_Forbearance">Documentation</a>', null=True)),
                ('description_of_the_forbearance_clause', models.TextField(blank=True, help_text='Further comments / details on the clause if "Yes" is selected in field "Clause to Stop Forbearance". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Description_of_the_Forbearance_Clause">Documentation</a>', null=True)),
                ('end_date_of_forbearance', models.DateField(blank=True, help_text='Date that the current forbearance arrangement ends. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.End_Date_of_Forbearance">Documentation</a>', null=True)),
                ('institutions_internal_identifier_for_the_loan_or_counterparty', models.TextField(blank=True, help_text='Institutions internal identifier for the Counterparty or the Loan.<a class ="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Institutions_internal_identifier_for_the_Loan_or_Counterparty" > Documentation </a>', null=True)),
                ('instrument_identifier', models.TextField(blank=True, help_text='Institutions internal identifier for the Loan part. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Instrument_Identifier">Documentation</a>', null=True)),
                ('interest_rate_under_forbearance', models.FloatField(blank=True, help_text='Interest rate that the Institution and Counterparty agreed under the current forbearance terms. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Interest_Rate_Under_Forbearance">Documentation</a>', null=True)),
                ('number_of_historical_forbearance', models.FloatField(blank=True, help_text='Number of forbearance(s) that happened in the past. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Number_of_Historical_Forbearance">Documentation</a>', null=True)),
                ('principal_forgiveness', models.FloatField(blank=True, help_text='Amount of the principal that was forgiven as part of current forbearance, including principal forgiveness agreed by external collection agencies. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Principal_Forgiveness">Documentation</a>', null=True)),
                ('repayment_amount_under_forbearance', models.FloatField(blank=True, help_text='Periodic repayment amount that the Institution and Counterparty agreed under the current forbearance terms. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Repayment_Amount_Under_Forbearance">Documentation</a>', null=True)),
                ('repayment_frequency_under_forbearance', models.IntegerField(blank=True, choices=[(0, '(a) Monthly'), (1, '(b) Quarterly'), (2, '(c) Semi-Annually'), (3, '(d) Annually'), (4, '(e) Daily'), (5, '(f) Other')], help_text='Frequency that the repayment under current forbearance terms is made. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Repayment_Frequency_Under_Forbearance">Documentation</a>', null=True)),
                ('start_date_of_forbearance', models.DateField(blank=True, help_text='Date that the current forbearance arrangement starts. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Start_Date_of_Forbearance">Documentation</a>', null=True)),
                ('type_of_forbearance', models.IntegerField(blank=True, choices=[(0, '(a) Loan maturity date extension'), (1, '(b) Amortisation change'), (2, '(c) Principal write-off'), (3, '(d) Temporary rate reduction'), (4, '(e) Capitalisation of interest'), (5, '(f) Capitalisation of costs advanced: which is insurance and ground rent'), (6, '(g) Combination '), (7, '(h) Other')], help_text='Type of current forbearance. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Type_of_Forbearance">Documentation</a>', null=True)),
                ('type_of_identifier', models.IntegerField(blank=True, choices=[(0, '(a) Counterparty'), (1, '(b) Loan')], help_text='Indicator as to whether forbearance has been prepared on a Counterparty level or a Loan level. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Forbearance.Type_of_Identifier">Documentation</a>', null=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('last_change_date', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Forbearance',
                'verbose_name_plural': 'Forbearances',
            },
        ),
        migrations.CreateModel(
            name='Loan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contract_identifier', models.TextField(blank=True, null=True)),
                ('accounting_stages_of_asset_quality', models.IntegerField(blank=True, choices=[(0, '(a) IFRS Stage 1'), (1, '(b) IFRS Stage 2'), (2, '(c) IFRS Stage 3 (Impaired)'), (3, '(d) Fair Value Through P rofit and Loss'), (4, '(e) Other Accounting Standard - Impaired Asset'), (5, '(f) Other Accounting Standard - Not Impaired')], help_text='Accounting stages of asset quality, i.e. IFRS Stage 1, IFRS Stage 2, IFRS Stage 3 (impaired), Fair Value Through P&L, Other Accounting Standard - impaired asset, Other Accounting Standard - Not impaired. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Accounting_stages_of_Asset_Quality">Documentation</a>', null=True)),
                ('accrued_interest_balance_off_book', models.BigIntegerField(blank=True, help_text='Amount of interest that has been accrued but not capitalised to the Loan,  as not recognised on the balance sheet. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Accrued_Interest_Balance_Off_book">Documentation</a>', null=True)),
                ('accrued_interest_balance_on_book', models.BigIntegerField(blank=True, help_text='Current amount of outstanding interest as recognised on the balance sheet at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Accrued_Interest_Balance_On_book">Documentation</a>', null=True)),
                ('amortisation_type', models.IntegerField(blank=True, choices=[(0, '(a) Linear (L)'), (1, '(b) Annuity (A)'), (2, '(c) Interest Only (IO) i.e. no amortisation with a bullet'), (3, '(d) Bespoke Repayment')], help_text='Description of the Amortisation type of the loan as per the latest Loan Agreement e.g. Full amortisation, part amortisation, final bullet, bespoke repayment. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Amortisation_Type">Documentation</a>', null=True)),
                ('asset_class', models.IntegerField(blank=True, choices=[(0, 'Resi'), (1, 'CRE'), (2, 'SME/Corp'), (3, 'Unsecured'), (4, 'Auto'), (5, 'Leasing / ABF'), (6, 'Specialised')], help_text='Asset class of the Loan, i.e. Resi, CRE, SME/Corp, etc.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Asset_Class">Documentation</a>', null=True)),
                ('capitalised_pastdue_amount', models.BigIntegerField(blank=True, help_text='Total capitalised past-due balance as recognised on balance sheet at NPL Portfolio Cut-Off Date i.e. Interest and Legal Fees. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Capitalised_PastDue_Amount">Documentation</a>', null=True)),
                ('channel_of_origination', models.IntegerField(blank=True, choices=[(0, '(a) Branch'), (1, '(b) Internet'), (2, '(c) Broker'), (3, '(d) Other')], help_text='Channel through which the Loan was originated, i.e. Branch, Internet and Broker. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Channel_of_Origination">Documentation</a>', null=True)),
                ('chargeoff_date', models.DateField(blank=True, help_text='Date when the Loan went into charge-off. A charge-off is the declaration by the Institution commonly on Unsecured Retail when the Borrower is severely delinquent, and the Institution starts the recovery process officially.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Chargeoff_Date">Documentation</a>', null=True)),
                ('code_of_conduct', models.TextField(blank=True, help_text='Indicator as to whether the Loan is subject to certain Code of Conduct. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Code_of_Conduct">Documentation</a>', null=True)),
                ('comments_on_code_of_conduct', models.TextField(blank=True, help_text='Further comments / details on Code of Conduct. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Comments_on_Code_of_Conduct">Documentation</a>', null=True)),
                ('comments_on_covenant_waiver', models.TextField(blank=True, help_text='Further comments / details on the covenant waiver if "Yes" is selected in field "Covenant Waiver". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Comments_on_Covenant_Waiver">Documentation</a>', null=True)),
                ('country_of_origination', models.TextField(blank=True, help_text='Country where the Loan was originated. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Country_of_Origination">Documentation</a>', null=True)),
                ('covenant_waiver', models.TextField(blank=True, help_text='Indicator as to whether there has been a covenant waiver sent out for any breaches of the Loan Agreement. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Covenant_Waiver">Documentation</a>', null=True)),
                ('current_covenant_levels', models.BigIntegerField(blank=True, help_text='Current levels of covenants as at NPL Portfolio Cut-Off date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Current_Covenant_Levels">Documentation</a>', null=True)),
                ('current_external_credit_rating', models.TextField(blank=True, help_text='External credit rating issued for the Loan at NPL Portfolio Cut-Off Date. In case several ratings are assigned, the approach described in Art. 138 of the CRR applies.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Current_External_Credit_Rating">Documentation</a>', null=True)),
                ('current_interest_base_rate', models.FloatField(blank=True, help_text='Current base rate of the Loan as at NPL Portfolio Cut-Off Date when "Variable" is selected in field "Current Interest Rate Type". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Current_Interest_Base_Rate">Documentation</a>', null=True)),
                ('current_interest_margin', models.FloatField(blank=True, help_text='is the current margin above the base rate as stated in the Loan Agreement and applicable at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Current_Interest_Margin">Documentation</a>', null=True)),
                ('current_interest_rate', models.FloatField(blank=True, help_text='is the current total interest rate of the loan as stated in the Loan Agreement on and applicable at the NPL Portfolio Cut-Off Date.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Current_Interest_Rate">Documentation</a>', null=True)),
                ('current_interest_rate_reference', models.IntegerField(blank=True, choices=[(0, '(a) 1m EURIBOR'), (1, '(b) 3m EURIBOR'), (2, '(c) 6m EURIBOR'), (3, '(d) 1m LIBOR'), (4, '(e) 3m LIBOR'), (5, '(f) 6m LIBOR'), (6, '(g) Standard Variable Rate (SVR)'), (7, '(h) EONIA')], help_text='Current interest rate base or reference of the loan as stated in the Loan Agreement and applicable at the NPL Portfolio Cut-Off Date when Variable is selected in field Current Interest Rate Type. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Current_Interest_Rate_Reference">Documentation</a>', null=True)),
                ('current_interest_rate_type', models.IntegerField(blank=True, choices=[(0, '(a) Fixed'), (1, '(b) Variable'), (2, '(c) Mixed')], help_text='is the current interest rate type as per Loan Agreement and applicable at the NPL Portfolio Cut-Off Date, i.e. Fixed / Variable / Mixed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Current_Interest_Rate_Type">Documentation</a>', null=True)),
                ('current_internal_credit_rating', models.TextField(blank=True, help_text='Internal credit rating issued to the Loan at NPL Portfolio Cut-Off Date and please provide the internal methodology used to decide the rating as a part of the transaction documents. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Current_Internal_Credit_Rating">Documentation</a>', null=True)),
                ('current_maturity_date', models.DateField(blank=True, help_text='Contractual maturity date of the Loan as at NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Current_Maturity_Date">Documentation</a>', null=True)),
                ('current_reversion_interest_rate', models.FloatField(blank=True, help_text='Current level of reversion interest rate according to the Loan Agreement and applicable as at NPL Portfolio Cut-Off Date, reversion means that after the interest fixed period the Institution would revert the rate to a different type, e.g. the Institutions Standard Variable Rate. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Current_Reversion_Interest_Rate">Documentation</a>', null=True)),
                ('date_of_default', models.DateField(blank=True, help_text='Date that the Loan defaulted. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Date_of_Default">Documentation</a>', null=True)),
                ('date_of_origination', models.DateField(blank=True, help_text='Date that the Loan originated as per the Loan Agreement. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Date_of_Origination">Documentation</a>', null=True)),
                ('days_in_pastdue', models.BigIntegerField(blank=True, help_text='Number of days that the Loan is currently past-due as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Days_in_PastDue">Documentation</a>', null=True)),
                ('default_penalty_interest_margin', models.FloatField(blank=True, help_text='Additional margin charged on the balance of the Loan in default according to the Loan Agreement and applicable as of the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Default_Penalty_Interest_Margin">Documentation</a>', null=True)),
                ('description_of_bespoke_repayment', models.TextField(blank=True, help_text='Description of the bespoke repayment profile when "Bespoke Repayment" is selected in field "Amortisation Type". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Description_of_Bespoke_Repayment">Documentation</a>', null=True)),
                ('description_of_current_interest_rate_type', models.TextField(blank=True, help_text='Description of current interest rate type when "Mixed" is selected in field "Current Interest Rate Type". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Description_of_Current_Interest_Rate_Type">Documentation</a>', null=True)),
                ('description_of_original_interest_rate_type', models.TextField(blank=True, help_text='Description of original interest rate type when "Mixed" is selected in field "Original Interest Rate Type". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Description_of_Original_Interest_Rate_Type">Documentation</a>', null=True)),
                ('description_of_relevant_schemes', models.TextField(blank=True, help_text='Description of the relevant scheme if YES is selected in the field Relevant Schemes. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Description_of_Relevant_Schemes">Documentation</a>', null=True)),
                ('details_of_origination_channel', models.TextField(blank=True, help_text='Description of the origination channel when "Broker" or "Other" is selected in field "Channel of Origination". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Details_of_Origination_Channel">Documentation</a>', null=True)),
                ('early_redemption_penalty', models.FloatField(blank=True, help_text='Additional charge on the early redemption made by the Counterparty according to the Loan Agreement and applicable as of the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Early_Redemption_Penalty">Documentation</a>', null=True)),
                ('end_date_of_current_fixed_interest_period', models.DateField(blank=True, help_text='Date that the current fixed interest period ends according to the Loan Agreement and applicable as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.End_Date_of_Current_Fixed_Interest_Period">Documentation</a>', null=True)),
                ('end_date_of_interest_grace_period', models.DateField(blank=True, help_text='Date that the interest payment ends postponement according to the Loan Agreement and applicable as of the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.End_Date_of_Interest_Grace_Period">Documentation</a>', null=True)),
                ('end_date_of_interest_only_period', models.DateField(blank=True, help_text='Date that the interest repayment only period ends according to the current Loan Agreement and applicable as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.End_Date_of_Interest_Only_Period">Documentation</a>', null=True)),
                ('end_date_of_principal_grace_period', models.DateField(blank=True, help_text='Date that the principal payment ends postponement according to the Loan Agreement and applicable as of the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.End_Date_of_Principal_Grace_Period">Documentation</a>', null=True)),
                ('end_date_of_subsidy', models.DateField(blank=True, help_text='Date that the current subsidy ends. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.End_Date_of_Subsidy">Documentation</a>', null=True)),
                ('external_credit_rating_at_origination', models.TextField(blank=True, help_text='External credit rating issued to the Loan applicable at the point of time when the counterparty became a customer. In case several ratings are assigned, the approach described in Art. 138 of the CRR applies.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.External_Credit_Rating_at_Origination">Documentation</a>', null=True)),
                ('final_bullet_repayment', models.BigIntegerField(blank=True, help_text='Total amount of principal repayment to be paid at the maturity date of the loan. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Final_Bullet_Repayment">Documentation</a>', null=True)),
                ('governing_law_of_loan_agreement', models.TextField(blank=True, help_text='Governing law is the law of the country in which the Loan Agreement was entered into. This does not necessarily correspond to the country where the loan was originated. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Governing_Law_of_Loan_Agreement">Documentation</a>', null=True)),
                ('instrument_identifier', models.TextField(blank=True, help_text='Institution internal identifier for the Loan part. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Instrument_Identifier">Documentation</a>', null=True)),
                ('interest_cap_rate', models.FloatField(blank=True, help_text='Maximum interest rate which can be charged on the Loan as specified in the current Loan Agreement (if applicable). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Interest_Cap_Rate">Documentation</a>', null=True)),
                ('interest_floor_rate', models.FloatField(blank=True, help_text='Minimum interest rate of a loan which can be charged on the Loan as specified in the current Loan Agreement (if applicable). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Interest_Floor_Rate">Documentation</a>', null=True)),
                ('interest_payment_frequency', models.IntegerField(blank=True, choices=[(0, '(a) Monthly'), (1, '(b) Quarterly'), (2, '(c) Semi-Annually'), (3, '(d) Annually'), (4, '(e) Daily'), (5, '(f) Other')], help_text='Frequency of interest payments based on the current Loan Agreement as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Interest_Payment_Frequency">Documentation</a>', null=True)),
                ('interest_reset_interval', models.BigIntegerField(blank=True, help_text='Number of months between two interest reset dates according to the Loan Agreement and applicable as of the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Interest_Reset_Interval">Documentation</a>', null=True)),
                ('internal_credit_rating_at_origination', models.TextField(blank=True, help_text='Internal credit rating issued to the Loan applicable at the point of time when the counterparty became a customer and please provide the internal methodology used to decide the rating as a part of the transaction documents. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Internal_Credit_Rating_at_Origination">Documentation</a>', null=True)),
                ('last_covenant_test_date', models.DateField(blank=True, help_text='Date that the covenant levels were tested last time by the institution. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Last_Covenant_Test_Date">Documentation</a>', null=True)),
                ('last_interest_reset_date', models.DateField(blank=True, help_text='Date that the last interest reset event happened. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Last_Interest_Reset_Date">Documentation</a>', null=True)),
                ('last_payment_amount', models.BigIntegerField(blank=True, help_text='Amount of last payment. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Last_Payment_Amount">Documentation</a>', null=True)),
                ('last_payment_date', models.DateField(blank=True, help_text='Date that the last payment was made. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Last_Payment_Date">Documentation</a>', null=True)),
                ('legal_balance', models.BigIntegerField(blank=True, help_text='Total claim amount, i.e. Total Balance + Accrued Interest Balance (Off book). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Legal_Balance">Documentation</a>', null=True)),
                ('legal_balance_at_chargeoff_date', models.BigIntegerField(blank=True, help_text='Total claim amount when the Loan went into charge-off. A charge-off is the declaration by the Institution commonly on Unsecured Retail when the Borrower is severely delinquent, and the Institution starts the recovery process officially.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Legal_Balance_at_Chargeoff_Date">Documentation</a>', null=True)),
                ('loan_commitment', models.BigIntegerField(blank=True, help_text='Total available credit extended as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Loan_Commitment">Documentation</a>', null=True)),
                ('loan_covenants', models.IntegerField(blank=True, choices=[(0, '(a) Loan to Value (LTV) is the ratio of a loan to the value of the collateral purchased'), (1, '(b) Interest Coverage Ratio (ICR) is the ratio of earnings before interest and tax to the interest expense in the same period'), (2, '(c) Debt Service Coverage Ratio (DSCR) is the ratio of annual net operating income to debt obligations owed in the last 12m'), (3, '(d) Other')], help_text='List of the covenants as agreed in the current Loan Agreement as at the NPL Portfolio Cut-Off Date (LTV, ICR, DSCR etc.), each in a separate column. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Loan_Covenants">Documentation</a>', null=True)),
                ('loan_currency', models.TextField(blank=True, help_text='Currency which the Loan is expressed in as per latest Loan Agreement. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Loan_Currency">Documentation</a>', null=True)),
                ('loan_purpose', models.IntegerField(blank=True, choices=[(0, '(a) Residential real estate - owner occupied'), (1, '(b) Residential real estate investment'), (2, '(c) Commercial Real Estate (CRE)'), (3, '(d) Margin lending where the Counterparty borrows money to invest in shares or managed funds'), (4, '(e) Debt financing'), (5, '(f) Commercial development'), (6, '(g) Residential development'), (7, '(h) Working capital facility'), (8, '(i) Credit card'), (9, '(j) Consumer lending'), (10, '(k) Asset finance')], help_text='ultimate financing purpose of the Loan, e.g. Residential real estate purchase for own use, Residential real estate purchase for investment, Commercial real estate purchase, Margin lending, Debt financing, Imports/Exports, Construction investment, and Working capital facility.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Loan_Purpose">Documentation</a>', null=True)),
                ('loan_status', models.IntegerField(blank=True, choices=[(0, '(a) Performing'), (1, '(b) Non-performing as defined in table F18 in Annex V to Implementing Regulation (EU) No 680/2014')], help_text='Loan status, e.g. performing and non-performing. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Loan_Status">Documentation</a>', null=True)),
                ('next_interest_reset_date', models.DateField(blank=True, help_text='Date that the next interest reset event happened. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Next_Interest_Reset_Date">Documentation</a>', null=True)),
                ('next_interest_scheduled_repayment_amount', models.BigIntegerField(blank=True, help_text='Amount of next scheduled interest repayment as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Next_Interest_Scheduled_Repayment_Amount">Documentation</a>', null=True)),
                ('next_interest_scheduled_repayment_date', models.DateField(blank=True, help_text='Date that the next interest repayment is made as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Next_Interest_Scheduled_Repayment_Date">Documentation</a>', null=True)),
                ('next_principal_scheduled_repayment_amount', models.BigIntegerField(blank=True, help_text='Amount of next scheduled principal repayment as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Next_Principal_Scheduled_Repayment_Amount">Documentation</a>', null=True)),
                ('next_principal_scheduled_repayment_date', models.DateField(blank=True, help_text='Date that the next principal repayment is made as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Next_Principal_Scheduled_Repayment_Date">Documentation</a>', null=True)),
                ('nonperforming_reason', models.IntegerField(blank=True, choices=[(0, '(a) Impaired as defined by IFRS 9.5.5 or the applicable accounting standard'), (1, '(b) Defaulted as defined by CRR Art. 178'), (2, '(c) More than 90 days past due'), (3, '(d) Unlikely to pay')], help_text='Main reason why the non-performing status was provided, i.e. impaired (according to the applicable accounting standard), defaulted (CRR Art. 178), more than 90 ,DPD, unlikely to pay. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.NonPerforming_Reason">Documentation</a>', null=True)),
                ('number_of_pastdue_events', models.BigIntegerField(blank=True, help_text='Number of times that the Loan was previously categorised as past-due. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Number_of_PastDue_Events">Documentation</a>', null=True)),
                ('original_interest_base_rate', models.FloatField(blank=True, help_text='Original base rate of the Loan when "Variable" is selected in field "Original Interest Rate Type". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Original_Interest_Base_Rate">Documentation</a>', null=True)),
                ('original_interest_margin', models.FloatField(blank=True, help_text='Original margin above the base rate at loan origination. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Original_Interest_Margin">Documentation</a>', null=True)),
                ('original_interest_rate', models.FloatField(blank=True, help_text='Original total interest rate of the Loan as states in the Loan Agreement and as applicable as of Loan Origination. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Original_Interest_Rate">Documentation</a>', null=True)),
                ('original_interest_rate_reference', models.IntegerField(blank=True, choices=[(0, '(a) 1m EURIBOR'), (1, '(b) 3m EURIBOR'), (2, '(c) 6m EURIBOR'), (3, '(d) 1m LIBOR'), (4, '(e) 3m LIBOR'), (5, '(f) 6m LIBOR'), (6, '(g) Standard Variable Rate (SVR)'), (7, '(h) EONIA')], help_text='Original interest rate base / reference of the Loan when "Variable" is selected in field "Original Interest Rate Type". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Original_Interest_Rate_Reference">Documentation</a>', null=True)),
                ('original_interest_rate_type', models.IntegerField(blank=True, choices=[(0, '(a) Fixed'), (1, '(b) Variable'), (2, '(c) Mixed')], help_text='Original interest rate type as states in the Loan Agreement and as applicable as of Loan origination i.e. Fixed / Variable / Mixed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Original_Interest_Rate_Type">Documentation</a>', null=True)),
                ('original_maturity_date', models.DateField(blank=True, help_text='Original contractual maturity date of the Loan. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Original_Maturity_Date">Documentation</a>', null=True)),
                ('origination_amount', models.BigIntegerField(blank=True, help_text='Loan amount advanced to the Borrower / drawn down by the Borrower at the origination date on the loan. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Origination_Amount">Documentation</a>', null=True)),
                ('other_balances', models.BigIntegerField(blank=True, help_text='Current amount of other outstanding amounts, e.g. other charges, commissions, fees etc., as recognised on the balance sheet. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Other_Balances">Documentation</a>', null=True)),
                ('other_pastdue_amounts', models.BigIntegerField(blank=True, help_text='Accumulated amount of other past-due amounts, e.g. fees, as recognised on balance sheet at NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Other_PastDue_Amounts">Documentation</a>', null=True)),
                ('other_syndicate_counterparties', models.TextField(blank=True, help_text='Who the other syndicate Counterparties are when "Yes" is selected in field "Syndicated Loan". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Other_Syndicate_Counterparties">Documentation</a>', null=True)),
                ('pastdue_interest_amount', models.BigIntegerField(blank=True, help_text='Accumulated amount of past-due interest as recognised on balance sheet as at NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.PastDue_Interest_Amount">Documentation</a>', null=True)),
                ('pastdue_penalty_interest_margin', models.FloatField(blank=True, help_text='Additional margin charged on the past-due portion of the Loan according to the Loan Agreement and applicable as of the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.PastDue_Penalty_Interest_Margin">Documentation</a>', null=True)),
                ('pastdue_principal_amount', models.BigIntegerField(blank=True, help_text='Accumulated amount of past-due principal as recognised on balance sheet at NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.PastDue_Principal_Amount">Documentation</a>', null=True)),
                ('principal_balance', models.BigIntegerField(blank=True, help_text='Current amount of outstanding principal as recognised on the balance sheet at Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Principal_Balance">Documentation</a>', null=True)),
                ('principal_payment_frequency', models.IntegerField(blank=True, choices=[(0, '(a) Monthly'), (1, '(b) Quarterly'), (2, '(c) Semi-Annually'), (3, '(d) Annually'), (4, '(e) Daily'), (5, '(f) Other')], help_text='Frequency that the principal payment is currently made based on the current Loan Agreement as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Principal_Payment_Frequency">Documentation</a>', null=True)),
                ('product_type', models.IntegerField(blank=True, choices=[(0, '(a) Term Loans'), (1, '(b) Revolving Credit Facility'), (2, '(c) Overdraft')], help_text='Product type of the Loan, e.g. Loan and Overdraft. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Product_Type">Documentation</a>', null=True)),
                ('relevant_schemes', models.TextField(blank=True, help_text='Indicator as to whether the Loan is involved with any relevant schemes, e.g. Right to Buy Scheme in UK. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Relevant_Schemes">Documentation</a>', null=True)),
                ('securitised', models.TextField(blank=True, help_text='Indicator as to whether the Loan has been securitised or within covered bond pool. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Securitised">Documentation</a>', null=True)),
                ('source_of_current_external_credit_rating', models.TextField(blank=True, help_text='From which agency the external credit rating at NPL Portfolio Cut-Off Date was obtained. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Source_of_Current_External_Credit_Rating">Documentation</a>', null=True)),
                ('source_of_external_credit_rating_at_origination', models.TextField(blank=True, help_text='From which agency the external credit rating at origination was obtained. In case several ratings are assigned, the approach described in Art. 138 of the CRR applies.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Source_of_External_Credit_Rating_at_Origination">Documentation</a>', null=True)),
                ('specialised_product', models.TextField(blank=True, help_text='Indicator as to whether the Loan is a specialised product, e.g. Fractioned Loans in Italy. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Specialised_Product">Documentation</a>', null=True)),
                ('start_date_of_current_fixed_interest_period', models.DateField(blank=True, help_text='Date that the current fixed interest period started according to the Loan Agreement and applicable as at the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Start_Date_of_Current_Fixed_Interest_Period">Documentation</a>', null=True)),
                ('start_date_of_interest_grace_period', models.DateField(blank=True, help_text='Date that the interest payment starts being postponed according to the Loan Agreement and applicable as of the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Start_Date_of_Interest_Grace_Period">Documentation</a>', null=True)),
                ('start_date_of_interest_only_period', models.DateField(blank=True, help_text='Date that the interest repayment only period starts according to the most recent Loan Agreement and applicable as  the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Start_Date_of_Interest_Only_Period">Documentation</a>', null=True)),
                ('start_date_of_principal_grace_period', models.DateField(blank=True, help_text='Date that the principal payment starts being postponed according to the Loan Agreement and applicable as of the NPL Portfolio Cut-Off Date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Start_Date_of_Principal_Grace_Period">Documentation</a>', null=True)),
                ('start_date_of_subsidy', models.DateField(blank=True, help_text='Date that the current subsidy starts. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Start_Date_of_Subsidy">Documentation</a>', null=True)),
                ('subsidy', models.TextField(blank=True, help_text='Indicator where contractual payments are subsidised by an external party. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Subsidy">Documentation</a>', null=True)),
                ('subsidy_amount', models.BigIntegerField(blank=True, help_text='Amount of the subsidy received. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Subsidy_Amount">Documentation</a>', null=True)),
                ('subsidy_provider', models.TextField(blank=True, help_text='Name of the external party who provided the subsidy. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Subsidy_Provider">Documentation</a>', null=True)),
                ('syndicated_loan', models.TextField(blank=True, help_text='Indicator as to whether the Loan is provided by a syndicate or consortium of two or more institutions. This means that in the case of a syndicated loan the Institution holds less than 100% of the total loan. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Syndicated_Loan">Documentation</a>', null=True)),
                ('syndicated_portion', models.FloatField(blank=True, help_text='Percentage of the portion held by the Institution when "Yes" is selected in field "Syndicated Loan". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Syndicated_Portion">Documentation</a>', null=True)),
                ('time_in_pastdue', models.BigIntegerField(blank=True, help_text='Total number of months that the Loan has been in past-due in the past 12 months. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Time_in_PastDue">Documentation</a>', null=True)),
                ('total_balance', models.BigIntegerField(blank=True, help_text='Total unpaid balance, i.e. Principal Balance + Accrued Interest Balance (On book) + Other Balances. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Total_Balance">Documentation</a>', null=True)),
                ('total_pastdue_amount', models.BigIntegerField(blank=True, help_text='Total past-due amount, i.e. Past-Due Principal Amount + Past-Due Interest Amount + Other Past-Due Amount. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Total_PastDue_Amount">Documentation</a>', null=True)),
                ('trigger_levels_of_loan_covenants', models.BigIntegerField(blank=True, help_text='Corresponding trigger levels as agreed in the Loan Agreement, as at the NPL Portfolio Cut-Off Date, each in a separate column. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Trigger_Levels_of_Loan_Covenants">Documentation</a>', null=True)),
                ('type_of_reversion_interest_rate', models.TextField(blank=True, help_text='Type of reversion interest rate after the fixed interest period according to the Loan Agreement and applicable as of the NPL Portfolio Cur-Off Date, reversion means that after the interest fixed period the Institution would revert the rate to a different type, e.g. the Institutions Standard Variable Rate. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Loan.Type_of_Reversion_Interest_Rate">Documentation</a>', null=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('last_change_date', models.DateTimeField(auto_now=True)),
                ('counterparty_identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='npl_portfolio.Counterparty')),
            ],
            options={
                'verbose_name': 'Loan',
                'verbose_name_plural': 'Loans',
            },
        ),
        migrations.CreateModel(
            name='NonPropertyCollateral',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('non_property_collateral_identifier', models.TextField(unique=True)),
                ('activation_of_guarantee', models.NullBooleanField(help_text='Indicator as to whether the guarantee has been activated when "Guarantee" is selected in field "Collateral Type". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Activation_of_Guarantee">Documentation</a>')),
                ('collateral_insurance', models.NullBooleanField(help_text='Indicator as to whether there is an insurance on the Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Collateral_Insurance">Documentation</a>')),
                ('collateral_insurance_coverage_amount', models.FloatField(blank=True, help_text='Amount that the collateral insurance covers. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Collateral_Insurance_Coverage_Amount">Documentation</a>', null=True)),
                ('collateral_insurance_provider', models.TextField(blank=True, help_text='Name of the collateral insurance provider. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Collateral_Insurance_Provider">Documentation</a>', null=True)),
                ('collateral_type', models.IntegerField(blank=True, choices=[(0, '(a) Auto Mobile Vehicles'), (1, '(b) Industrial Vehicles'), (2, '(c) Commercial Trucks'), (3, '(d) Rail Vehicles'), (4, '(e) Nautical Commercial Vehicles'), (5, '(f) Nautical Leisure Vehicles'), (6, '(g) Aeroplanes'), (7, '(h) Machine Tools'), (8, '(i) Industrial Equipment'), (9, '(j) Office Equipment'), (10, '(k) Medical Equipment'), (11, '(l) Energy Related Equipment'), (12, '(m) Other Vehicles'), (13, '(n) Other Equipment'), (14, '(o) Other goods/inventory '), (15, '(p) Securities'), (16, '(q) Guarantee'), (17, '(r) Life insurance'), (18, '(s) Deposit'), (19, '(t) Floating Charge'), (20, '(u) Other financial asset')], help_text='Physical type of the Collateral, e.g. Guarantee and Machinery. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Collateral_Type">Documentation</a>', null=True)),
                ('currency_of_collateral', models.TextField(blank=True, help_text='Currency that the valuation and cash flows related to the Collateral are expressed in. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Currency_of_Collateral">Documentation</a>', null=True)),
                ('current_opex_and_overheads', models.FloatField(blank=True, help_text='Current annual operational expenses and overheads of running the Collateral as at cut-off date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Current_Opex_And_Overheads">Documentation</a>', null=True)),
                ('date_of_initial_valuation', models.DateField(blank=True, help_text='Date at which the initial valuation was assessed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.14.01.Date_of_Initial_Valuation">Documentation</a>', null=True)),
                ('date_of_latest_valuation', models.DateField(blank=True, help_text='Date that the latest valuation took place. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Date_of_Latest_Valuation">Documentation</a>', null=True)),
                ('description', models.TextField(blank=True, help_text='Detailed description of the collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Description">Documentation</a>', null=True)),
                ('enforcement_description', models.TextField(blank=True, help_text='Comments/Description of the stage of Enforcement that the Property Collateral is in as at cut-off date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Enforcement_Description">Documentation</a>', null=True)),
                ('enforcement_status', models.NullBooleanField(help_text='Status of the enforcement process that the Collateral is currently in as at cut-off date, e.g. if it is in receivership. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Enforcement_Status">Documentation</a>')),
                ('enforcement_status_third_parties', models.NullBooleanField(help_text='Indicator as to whether any other secured creditors have taken steps to enforce security over the asset? (Y/N). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Enforcement_Status_Third_Parties">Documentation</a>')),
                ('engine_size', models.FloatField(blank=True, help_text='Engine size (litres) of the Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.14.03.Engine_Size">Documentation</a>', null=True)),
                ('guarantee_amount', models.FloatField(blank=True, help_text='Claim amount of the guarantee when "Guarantee" is selected in field "Collateral Type". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Guarantee_Amount">Documentation</a>', null=True)),
                ('initial_valuation_amount', models.FloatField(blank=True, help_text='Value of the Collateral assessed at loan origination. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Initial_Valuation_Amount">Documentation</a>', null=True)),
                ('latest_valuation_amount', models.FloatField(blank=True, help_text='Value of the Collateral when last assessed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Latest_Valuation_Amount">Documentation</a>', null=True)),
                ('legal_owner', models.TextField(blank=True, help_text='Legal owner of the Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Legal_Owner">Documentation</a>', null=True)),
                ('manufacturer_of_collateral', models.TextField(blank=True, help_text='Name used to refer to the manufacturer of the Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Manufacturer_of_Collateral">Documentation</a>', null=True)),
                ('name_or_model_of_collateral', models.TextField(blank=True, help_text='Name / model of the Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Name_or_Model_of_Collateral">Documentation</a>', null=True)),
                ('new_or_used', models.IntegerField(blank=True, choices=[(0, '(a) New'), (1, '(b) Used')], help_text='Condition of the Collateral at loan origination. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.New_Or_Used">Documentation</a>', null=True)),
                ('protection_identifier', models.TextField(blank=True, help_text='Institution internal identifier for the Non-Property Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.14.0.Protection_identifier">Documentation</a>', null=True)),
                ('registration_number', models.TextField(blank=True, help_text='Registration number of the Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Registration_Number">Documentation</a>', null=True)),
                ('type_of_initial_valuation', models.IntegerField(blank=True, choices=[(0, '(a) Full Appraisal'), (1, '(b) Drive-by'), (2, '(c) Automated Valuation Model'), (3, '(d) Indexed'), (4, '(e) Desktop'), (5, '(f) Managing or Estate Agent'), (6, '(g) Purchase Price'), (7, '(h) Hair Cut'), (8, '(i) Mark to market'), (9, '(j) Counterparties Valuation'), (10, '(k) Other')], help_text='Type of the initial valuation. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Type_of_Initial_Valuation">Documentation</a>', null=True)),
                ('type_of_latest_valuation', models.IntegerField(blank=True, choices=[(0, '(a) Full Appraisal'), (1, '(b) Drive-by'), (2, '(c) Automated Valuation Model'), (3, '(d) Indexed'), (4, '(e) Desktop'), (5, '(f) Managing or Estate Agent'), (6, '(g) Purchase Price'), (7, '(h) Hair Cut'), (8, '(i) Mark to market'), (9, '(j) Counterparties Valuation'), (10, '(k) Other')], help_text='Type of the latest valuation for the Collateral, i.e. Full Appraisal, Drive-by, Automated Valuation Model, Indexed, Desktop, Managing / Estate Agent, Purchase Price, Hair Cut, Mark to market and Borrowers Valuation. <a class ="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Type_of_Latest_Valuation" > Documentation </a> ', null=True)),
                ('type_of_legal_owner', models.IntegerField(blank=True, choices=[(0, '(a) Listed Corporate is a Corporate entity whose shares are quoted and traded on a Stock Exchange'), (1, '(b) Unlisted Corporate is a Corporate entity whose shares are not quoted and traded on a stock exchange, however an unlisted corporate may have an unlimited number of shareholders to raise capital for any commercial venture'), (2, '(c) Listed Fund is a fund whose shares are quoted and traded on a Stock exchange'), (3, '(d) Unlisted Fund is a fund whose shares are not quoted and traded on a Stock exchange'), (4, '(e) Partnership is where the Sponsor constitutes a group of individuals who form a legal partnership, where profits and liabilities are shared; or,'), (5, '(f) Private Individual')], help_text='Type of the legal owner, i.e. Private Individual, Listed Corporate, Unlisted Corporate and Partnership. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Type_of_Legal_Owner">Documentation</a>', null=True)),
                ('year_of_manufacture', models.DateField(blank=True, help_text='Year that the Collateral was manufactured / first sold. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Year_of_Manufacture">Documentation</a>', null=True)),
                ('year_of_registration', models.DateField(blank=True, help_text='Year that the Collateral was registered. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.NonProperty Collateral.Year_of_Registration">Documentation</a>', null=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('last_change_date', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Non-Property Collateral',
                'verbose_name_plural': 'Non-Property Collateral',
            },
        ),
        migrations.CreateModel(
            name='PropertyCollateral',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('protection_identifier', models.TextField(blank=True, help_text='Institutions internal identifier for the Property Collateral.<a class ="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Protection_identifier" >Documentation</a>', null=True, unique=True)),
                ('address_of_property', models.TextField(blank=True, help_text='Street address where the Property is located at, including flat / house number or name. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Address_of_Property">Documentation</a>', null=True)),
                ('amount_of_vat_payable', models.FloatField(blank=True, help_text='Amount of VAT payable on the disposal of the Unit. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.11.05.Amount_of_VAT_Payable">Documentation</a>', null=True)),
                ('area_type_of_property', models.IntegerField(blank=True, choices=[(0, '(a) Prime city centre'), (1, '(b) City centre'), (2, '(c) City non-centre'), (3, '(d) Suburban'), (4, '(e) Rural')], help_text='Area type where the Property is located at , i.e. City centre, Suburban and Rural. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Area_Type_of_Property">Documentation</a>', null=True)),
                ('building_area_m2', models.FloatField(blank=True, help_text='Building area (square metres) of the Unit. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Building_Area_M2">Documentation</a>', null=True)),
                ('building_area_m2_lettable', models.FloatField(blank=True, help_text='Building area (square metres) of the Unit that is lettable. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Building_Area_M2_Lettable">Documentation</a>', null=True)),
                ('building_area_m2_occupied', models.FloatField(blank=True, help_text='Building area (square metres) of the Unit that has been occupied by landlord / tenant. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Building_Area_M2_Occupied">Documentation</a>', null=True)),
                ('city_of_property', models.TextField(blank=True, help_text='City where the Property is located at. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.City_of_Property">Documentation</a>', null=True)),
                ('completion_of_property', models.NullBooleanField(help_text='Indicator as to whether the construction of the Unit is complete. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Completion_of_Property">Documentation</a>')),
                ('condition_of_property', models.IntegerField(blank=True, choices=[(0, '(a) Excellent'), (1, '(b) Good'), (2, '(c) Fair'), (3, '(d) Poor')], help_text='Quality classification of the property, e.g. Excellent, Good, Fair, Poor. and include explanation of the category, and please provide the internal methodology used to decide the categories as a part of the transaction documents. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Condition_of_Property">Documentation</a>', null=True)),
                ('currency_of_property', models.TextField(blank=True, help_text='Currency that the valuation and cash flows related to the Unit are expressed in. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Currency_of_Property">Documentation</a>', null=True)),
                ('current_annual_passing_rent', models.FloatField(blank=True, help_text='Current annual passing rent charged to the Tenants of the Unit as at latest valuation date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Current_Annual_Passing_Rent">Documentation</a>', null=True)),
                ('current_net_operating_income', models.FloatField(blank=True, help_text='Current annual net operating income generated by the Unit as at the latest valuation date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Current_Net_Operating_Income">Documentation</a>', null=True)),
                ('current_opex_and_overheads', models.FloatField(blank=True, help_text='Current annual operational expenses and overheads of the Unit as at latest valuation date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Current_Opex_And_Overheads">Documentation</a>', null=True)),
                ('date_of_initial_valuation', models.DateField(blank=True, help_text='Date that the initial valuation was assessed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Date_of_Initial_Valuation">Documentation</a>', null=True)),
                ('date_of_latest_valuation', models.DateField(blank=True, help_text='Date that the latest valuation took place. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Date_of_Latest_Valuation">Documentation</a>', null=True)),
                ('enforcement_description', models.TextField(blank=True, help_text='Comments/Description of the stage of Enforcement that the Property Collateral is in as at cut-off date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Enforcement_Description">Documentation</a>', null=True)),
                ('enforcement_status', models.NullBooleanField(help_text='Indicator as to whether the property collateral has entered into the enforcement process as at cut-off date. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Enforcement_Status">Documentation</a>')),
                ('enforcement_status_third_parties', models.NullBooleanField(help_text='Indicator as to whether any other secured creditors have taken steps to enforce security over the asset? (Y/N). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Enforcement_Status_Third_Parties">Documentation</a>')),
                ('estimated_annual_void_cost', models.FloatField(blank=True, help_text='Additional costs to "Current Opex And Overheads" when the Units are vacant. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Estimated_Annual_Void_Cost">Documentation</a>', null=True)),
                ('estimated_rental_void', models.FloatField(blank=True, help_text='Estimated number of months the property is expected to be void. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Estimated_Rental_Void">Documentation</a>', null=True)),
                ('geographic_region_classification', models.IntegerField(blank=True, choices=[(0, '(a) NUTS3 2013'), (1, '(b) NUTS3 2010'), (2, '(c) NUTS3 2006'), (3, '(d) NUTS3 2003'), (4, '(e) Other')], help_text='NUTS3 classification used for the field "Geographic Region of Property", i.e. NUTS3 2013 (1), NUTS3 2010 (2), NUTS3 2006 (3), NUTS3 2003 (4), Other (5). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Geographic_Region_Classification">Documentation</a>', null=True)),
                ('geographic_region_of_property', models.TextField(blank=True, help_text='Province / Region where the Property is located at. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.11.01.Geographic_Region_of_Property">Documentation</a>', null=True)),
                ('initial_estimated_rental_value', models.FloatField(blank=True, help_text='Estimated annual gross rental value of the Unit assessed at loan origination. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Initial_Estimated_Rental_Value">Documentation</a>', null=True)),
                ('initial_valuation_amount', models.FloatField(blank=True, help_text='Value of the Unit assessed at loan origination. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.11.03.Initial_Valuation_Amount">Documentation</a>', null=True)),
                ('internal_or_external_initial_valuation', models.IntegerField(blank=True, choices=[(0, '(a) Internal'), (1, '(b) Outsourced')], help_text='Indicator as to whether the initial valuation was outsource, or done internally. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Internal_or_External_Initial_Valuation">Documentation</a>', null=True)),
                ('internal_or_external_latest_valuation', models.IntegerField(blank=True, choices=[(0, '(c) Internal'), (1, '(d) Outsourced')], help_text='Indicator as to whether the latest valuation was performed internally or by an external appraiser. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Internal_or_External_Latest_Valuation">Documentation</a>', null=True)),
                ('land_area_m2', models.FloatField(blank=True, help_text='Land area (square metres) of the Property. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Land_Area_M2">Documentation</a>', null=True)),
                ('latest_estimated_rental_value', models.FloatField(blank=True, help_text='Estimated annual gross rental value of the Unit when last assessed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Latest_Estimated_Rental_Value">Documentation</a>', null=True)),
                ('latest_valuation_amount', models.FloatField(blank=True, help_text='Value of the Unit when last assessed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Latest_Valuation_Amount">Documentation</a>', null=True)),
                ('legal_owner_of_the_property', models.TextField(blank=True, help_text='Legal owner of the Property Collateral. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Legal_Owner_of_the_Property">Documentation</a>', null=True)),
                ('number_of_bedrooms', models.FloatField(blank=True, help_text='Number of bedrooms that the Unit has. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Number_of_Bedrooms">Documentation</a>', null=True)),
                ('number_of_car_parking_spaces', models.FloatField(blank=True, help_text='Number of car parking spaces relating to the Unit. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Number_of_Car_Parking_Spaces">Documentation</a>', null=True)),
                ('number_of_lettable_units', models.FloatField(blank=True, help_text='Number of lettable units that the Property has. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Number_of_Lettable_Units">Documentation</a>', null=True)),
                ('number_of_rooms', models.FloatField(blank=True, help_text='Number of rooms that the Unit has excluding kitchen and bathroom(s). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.11.02.Number_of_Rooms">Documentation</a>', null=True)),
                ('number_of_units_occupied', models.FloatField(blank=True, help_text='Number of occupied lettable units that the Property has. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Number_of_Units_Occupied">Documentation</a>', null=True)),
                ('number_of_units_vacant', models.FloatField(blank=True, help_text='Number of vacant lettable units that the Property has. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Number_of_Units_Vacant">Documentation</a>', null=True)),
                ('party_liable_for_vat', models.IntegerField(blank=True, choices=[(0, '(a) Institution'), (1, '(b) Buyer(s)'), (2, '(c) Counterparty')], help_text='Party who is liable to pay the VAT on the disposal of the Unit i.e. the Institution or the buyer(s). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Party_Liable_for_VAT">Documentation</a>', null=True)),
                ('percentage_complete', models.FloatField(blank=True, help_text='The percentage of development completed since construction started (applicable to Units in development). <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Percentage_complete">Documentation</a>', null=True)),
                ('planned_capex_next_12m', models.FloatField(blank=True, help_text='Current planned CAPEX for the next 12 months. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Planned_Capex_next_12m">Documentation</a>', null=True)),
                ('property_country', models.TextField(blank=True, help_text='Country of residence where the Property is located at. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Property_Country">Documentation</a>', null=True)),
                ('property_postcode', models.TextField(blank=True, help_text='Postcode where the Property is located at. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Property_Postcode">Documentation</a>', null=True)),
                ('provider_of_energy_performance_certificate', models.TextField(blank=True, help_text='Name of the provider of the energy performance certificate. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Provider_of_Energy_Performance_Certificate">Documentation</a>', null=True)),
                ('provider_of_initial_valuation', models.TextField(blank=True, help_text='Name of the external appraiser or managing / estate agent is when "Full Appraisal" or "Managing / Estate Agent" is selected in field "Type of Initial Valuation". If the valuation was done internally, please select "Internal". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Provider_of_Initial_Valuation">Documentation</a>', null=True)),
                ('provider_of_latest_valuation', models.TextField(blank=True, help_text='Name of the external appraiser or managing / estate agent when "Full Appraisal" or "Managing / Estate Agent" is selected in field "Type of Latest Valuation". If the valuation was done internally, please select "Internal". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.11.04.Provider_of_Latest_Valuation">Documentation</a>', null=True)),
                ('purpose_of_property', models.IntegerField(blank=True, choices=[(0, '(a) Investment property'), (1, '(b) Owner occupied'), (2, '(c) Buy-to-let'), (3, '(d) Other')], help_text='Purpose of the Property, e.g. Investment property, owner occupied, Business Use, etc.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Purpose_of_Property">Documentation</a>', null=True)),
                ('register_of_deeds_number', models.TextField(blank=True, help_text='Registration number of the Property. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Register_of_Deeds_Number">Documentation</a>', null=True)),
                ('remaining_term_of_leasehold', models.FloatField(blank=True, help_text='Remaining term of the leasehold when "Leasehold" is selected in field "Tenure". <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Remaining_Term_of_Leasehold">Documentation</a>', null=True)),
                ('sector_of_property', models.IntegerField(blank=True, choices=[(0, '(a) Commercial Real Estate'), (1, '(b) Residential Real Estate')], help_text='Sector which the property is used for, e.g. commercial real estate, residential real estate, etc.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Sector_of_Property">Documentation</a>', null=True)),
                ('tenure', models.IntegerField(blank=True, choices=[(0, '(a) Freehold'), (1, '(b) Leasehold'), (2, '(c) Other')], help_text='Conditions that the Property is held or occupied, e.g. freehold and leasehold. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Tenure">Documentation</a>', null=True)),
                ('type_of_initial_valuation', models.IntegerField(blank=True, choices=[(0, '(a) Full Appraisal'), (1, '(b) Drive-by'), (2, '(c) Automated Valuation Model'), (3, '(d) Indexed'), (4, '(e) Desktop'), (5, '(f) Managing or Estate Agent'), (6, '(g) Purchase Price'), (7, '(h) Mark to market'), (8, '(i) Counterparties Valuation'), (9, '(j) Other')], help_text='Type of the initial valuation for the Unit i.e. Full Appraisal, Drive-by, Automated Valuation Model, Indexed, Desktop, Managing / Estate Agent, Purchase Price, Hair Cut, Mark to market and Borrowers Valuation. <a class ="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Type_of_Initial_Valuation" >Documentation</a>', null=True)),
                ('type_of_latest_valuation', models.IntegerField(blank=True, choices=[(0, '(a) Full Appraisal'), (1, '(b) Drive-by'), (2, '(c) Automated Valuation Model'), (3, '(d) Indexed'), (4, '(e) Desktop'), (5, '(f) Managing or Estate Agent'), (6, '(g) Purchase Price'), (7, '(h) Hair Cut'), (8, '(i) Mark to market'), (9, '(j) Counterparties Valuation'), (10, '(k) Other')], help_text='Type of the latest valuation for the Unit i.e. Full Appraisal, Drive-by, Automated Valuation Model, Indexed, Desktop, Managing / Estate Agent, Purchase Price, Hair Cut, Mark to market and Internal Institution Valuation. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Type_of_Latest_Valuation">Documentation</a>', null=True)),
                ('type_of_occupancy', models.IntegerField(blank=True, choices=[(0, '(a) Owner-occupied'), (1, '(b) Partially owner-occupied, defined as a property that is partly rented'), (2, '(c) Tenanted'), (3, '(d) Vacant'), (4, '(e) Other')], help_text='Type of occupancy, i.e. owner occupied, tenanted, not tenanted. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Type_of_Occupancy">Documentation</a>', null=True)),
                ('type_of_property', models.IntegerField(blank=True, choices=[(0, '(a) Semi-detached house'), (1, '(b) Detached house'), (2, '(c) Apartment'), (3, '(d) Terrace'), (4, '(e) Caravan Park'), (5, '(f) Car Park'), (6, '(g) Health Care'), (7, '(h) Hospitality / Hotel'), (8, '(i) Industrial'), (9, '(j) Land – agriculture'), (10, '(k) Land - zoning'), (11, '(l) Land - permit'), (12, '(m) Leisure'), (13, '(n) Multifamily '), (14, '(o) Mixed Use'), (15, '(p) Office'), (16, '(q) Bar / Pub'), (17, '(r) Restaurant'), (18, '(s) Retail'), (19, '(t) High street retail'), (20, '(u) Commercial centre'), (21, '(v) Self-Storage'), (22, '(w) Warehouse'), (23, '(x) Other')], help_text='Type of the Property, e.g. Apartment, Semi Detached House, Terraced House, Land, etc.. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Type_of_Property">Documentation</a>', null=True)),
                ('value_of_energy_performance_certificate', models.IntegerField(blank=True, choices=[(0, '(a) A'), (1, '(b) B'), (2, '(c) C'), (3, '(d) D'), (4, '(e) E'), (5, '(f) F'), (6, '(g) G')], help_text='Value stated on Energy Performance Certificate, i.e. A,B,C,D,E,F and G. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Value_of_Energy_Performance_Certificate">Documentation</a>', null=True)),
                ('vat_payable', models.NullBooleanField(help_text='Indicator as to whether the VAT is payable on the disposal of the Unit. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.VAT_Payable">Documentation</a>')),
                ('year_of_construction', models.DateField(blank=True, help_text='Year that the Property was completed and refurbished. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Year_of_Construction">Documentation</a>', null=True)),
                ('year_of_refurbishment', models.DateField(blank=True, help_text='Year in which the last significantly refurbished was completed. <a class="risk_manual_url" href="https://www.openriskmanual.org/wiki/EBA_NPL.Property Collateral.Year_of_Refurbishment">Documentation</a>', null=True)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('last_change_date', models.DateTimeField(auto_now=True)),
                ('loan_identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='npl_portfolio.Loan')),
            ],
            options={
                'verbose_name': 'Property Collateral',
                'verbose_name_plural': 'Property Collateral',
            },
        ),
        migrations.CreateModel(
            name='PortfolioSnapshot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('creation_date', models.DateTimeField(help_text='Date at which the snapshot has been created. Different from the cutoff date')),
                ('cutoff_date', models.DateTimeField(blank=True, help_text='Portfolio Cutoff Date (If available). Different from the creation date', null=True)),
                ('name', models.CharField(help_text='An assigned name to help identify the snapshot', max_length=200)),
                ('notes', models.CharField(blank=True, help_text='Description of the purpose or other relevant information about the portfolio', max_length=300, null=True)),
                ('user', models.ForeignKey(blank=True, help_text='The user that created the portfolio', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Portfolio Snapshot',
                'verbose_name_plural': 'Portfolio Snapshots',
            },
        ),
        migrations.CreateModel(
            name='Portfolio',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('last_change_date', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Portfolio',
                'verbose_name_plural': 'Portfolios',
            },
        ),
        migrations.AddField(
            model_name='counterparty',
            name='portfolio_id',
            field=models.ForeignKey(blank=True, help_text='The portfolio ID to which the Counterparty belongs (can be more than one)', null=True, on_delete=django.db.models.deletion.CASCADE, to='npl_portfolio.Portfolio'),
        ),
        migrations.AddField(
            model_name='counterparty',
            name='snapshot_id',
            field=models.OneToOneField(blank=True, help_text='The snapshot ID to which the Counterparty belongs (must be unique)', null=True, on_delete=django.db.models.deletion.CASCADE, to='npl_portfolio.PortfolioSnapshot'),
        ),
    ]
