# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BootstrapTimeouts',
    'ConfigurationApplyOnDestroy',
    'Timeout',
    'CertificateResult',
    'CertificatesResult',
    'ClientConfiguration',
    'ClusterResult',
    'KeyResult',
    'KubernetesSecretsResult',
    'MachineSecretsResult',
    'TrustdInfoResult',
    'GetDisksClientConfigurationResult',
    'GetDisksDiskResult',
    'GetDisksFiltersResult',
    'GetDisksTimeoutsResult',
]

@pulumi.output_type
class BootstrapTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")


@pulumi.output_type
class ConfigurationApplyOnDestroy(dict):
    def __init__(__self__, *,
                 graceful: Optional[bool] = None,
                 reboot: Optional[bool] = None,
                 reset: Optional[bool] = None):
        """
        :param bool graceful: Graceful indicates whether node should leave etcd before the upgrade, it also enforces etcd checks before leaving. Default true
        :param bool reboot: Reboot indicates whether node should reboot or halt after resetting. Default false
        :param bool reset: Reset the machine to the initial state (STATE and EPHEMERAL will be wiped). Default false
        """
        if graceful is not None:
            pulumi.set(__self__, "graceful", graceful)
        if reboot is not None:
            pulumi.set(__self__, "reboot", reboot)
        if reset is not None:
            pulumi.set(__self__, "reset", reset)

    @property
    @pulumi.getter
    def graceful(self) -> Optional[bool]:
        """
        Graceful indicates whether node should leave etcd before the upgrade, it also enforces etcd checks before leaving. Default true
        """
        return pulumi.get(self, "graceful")

    @property
    @pulumi.getter
    def reboot(self) -> Optional[bool]:
        """
        Reboot indicates whether node should reboot or halt after resetting. Default false
        """
        return pulumi.get(self, "reboot")

    @property
    @pulumi.getter
    def reset(self) -> Optional[bool]:
        """
        Reset the machine to the initial state (STATE and EPHEMERAL will be wiped). Default false
        """
        return pulumi.get(self, "reset")


@pulumi.output_type
class Timeout(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None,
                 update: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class CertificateResult(dict):
    """
    A Machine Secrets Certificate
    """
    def __init__(__self__, *,
                 cert: str,
                 key: str):
        """
        A Machine Secrets Certificate
        :param str cert: Certificate
        :param str key: Private Key
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def cert(self) -> str:
        """
        Certificate
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Private Key
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class CertificatesResult(dict):
    """
    A complete Machine Secrets Certificates configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "k8sAggregator":
            suggest = "k8s_aggregator"
        elif key == "k8sServiceaccount":
            suggest = "k8s_serviceaccount"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificatesResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificatesResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificatesResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etcd: 'outputs.CertificateResult',
                 k8s: 'outputs.CertificateResult',
                 k8s_aggregator: 'outputs.CertificateResult',
                 k8s_serviceaccount: 'outputs.KeyResult',
                 os: 'outputs.CertificateResult'):
        """
        A complete Machine Secrets Certificates configuration
        """
        pulumi.set(__self__, "etcd", etcd)
        pulumi.set(__self__, "k8s", k8s)
        pulumi.set(__self__, "k8s_aggregator", k8s_aggregator)
        pulumi.set(__self__, "k8s_serviceaccount", k8s_serviceaccount)
        pulumi.set(__self__, "os", os)

    @property
    @pulumi.getter
    def etcd(self) -> 'outputs.CertificateResult':
        return pulumi.get(self, "etcd")

    @property
    @pulumi.getter
    def k8s(self) -> 'outputs.CertificateResult':
        return pulumi.get(self, "k8s")

    @property
    @pulumi.getter(name="k8sAggregator")
    def k8s_aggregator(self) -> 'outputs.CertificateResult':
        return pulumi.get(self, "k8s_aggregator")

    @property
    @pulumi.getter(name="k8sServiceaccount")
    def k8s_serviceaccount(self) -> 'outputs.KeyResult':
        return pulumi.get(self, "k8s_serviceaccount")

    @property
    @pulumi.getter
    def os(self) -> 'outputs.CertificateResult':
        return pulumi.get(self, "os")


@pulumi.output_type
class ClientConfiguration(dict):
    """
    A Client Configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: str,
                 client_key: str):
        """
        A Client Configuration
        :param str ca_certificate: The client CA certificate
        :param str client_certificate: The client certificate
        :param str client_key: The client private key
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        The client CA certificate
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        The client certificate
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        The client private key
        """
        return pulumi.get(self, "client_key")


@pulumi.output_type
class ClusterResult(dict):
    """
    A Machine Secrets Cluster Info
    """
    def __init__(__self__, *,
                 id: str,
                 secret: str):
        """
        A Machine Secrets Cluster Info
        :param str id: Certificate
        :param str secret: Private Key
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Certificate
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        Private Key
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class KeyResult(dict):
    """
    A Machine Secrets Private Key
    """
    def __init__(__self__, *,
                 key: str):
        """
        A Machine Secrets Private Key
        :param str key: Private Key
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Private Key
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class KubernetesSecretsResult(dict):
    """
    A Machine Secrets Bootstrap data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootstrapToken":
            suggest = "bootstrap_token"
        elif key == "secretboxEncryptionSecret":
            suggest = "secretbox_encryption_secret"
        elif key == "aescbcEncryptionSecret":
            suggest = "aescbc_encryption_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesSecretsResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesSecretsResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesSecretsResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bootstrap_token: str,
                 secretbox_encryption_secret: str,
                 aescbc_encryption_secret: Optional[str] = None):
        """
        A Machine Secrets Bootstrap data
        :param str bootstrap_token: The bootstrap token for the talos kubernetes cluster
        :param str secretbox_encryption_secret: The secretbox encryption secret for the talos kubernetes cluster
        :param str aescbc_encryption_secret: The aescbc encryption secret for the talos kubernetes cluster
        """
        pulumi.set(__self__, "bootstrap_token", bootstrap_token)
        pulumi.set(__self__, "secretbox_encryption_secret", secretbox_encryption_secret)
        if aescbc_encryption_secret is not None:
            pulumi.set(__self__, "aescbc_encryption_secret", aescbc_encryption_secret)

    @property
    @pulumi.getter(name="bootstrapToken")
    def bootstrap_token(self) -> str:
        """
        The bootstrap token for the talos kubernetes cluster
        """
        return pulumi.get(self, "bootstrap_token")

    @property
    @pulumi.getter(name="secretboxEncryptionSecret")
    def secretbox_encryption_secret(self) -> str:
        """
        The secretbox encryption secret for the talos kubernetes cluster
        """
        return pulumi.get(self, "secretbox_encryption_secret")

    @property
    @pulumi.getter(name="aescbcEncryptionSecret")
    def aescbc_encryption_secret(self) -> Optional[str]:
        """
        The aescbc encryption secret for the talos kubernetes cluster
        """
        return pulumi.get(self, "aescbc_encryption_secret")


@pulumi.output_type
class MachineSecretsResult(dict):
    """
    A complete Machine Secrets configuration
    """
    def __init__(__self__, *,
                 certs: 'outputs.CertificatesResult',
                 cluster: 'outputs.ClusterResult',
                 secrets: 'outputs.KubernetesSecretsResult',
                 trustdinfo: 'outputs.TrustdInfoResult'):
        """
        A complete Machine Secrets configuration
        """
        pulumi.set(__self__, "certs", certs)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "trustdinfo", trustdinfo)

    @property
    @pulumi.getter
    def certs(self) -> 'outputs.CertificatesResult':
        return pulumi.get(self, "certs")

    @property
    @pulumi.getter
    def cluster(self) -> 'outputs.ClusterResult':
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def secrets(self) -> 'outputs.KubernetesSecretsResult':
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def trustdinfo(self) -> 'outputs.TrustdInfoResult':
        return pulumi.get(self, "trustdinfo")


@pulumi.output_type
class TrustdInfoResult(dict):
    """
    A Machine Secrets Trust daemon info
    """
    def __init__(__self__, *,
                 token: str):
        """
        A Machine Secrets Trust daemon info
        :param str token: The trustd token for the talos kubernetes cluster
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The trustd token for the talos kubernetes cluster
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetDisksClientConfigurationResult(dict):
    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: str,
                 client_key: str):
        """
        :param str ca_certificate: The client CA certificate
        :param str client_certificate: The client certificate
        :param str client_key: The client key
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        The client CA certificate
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        The client certificate
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        The client key
        """
        return pulumi.get(self, "client_key")


@pulumi.output_type
class GetDisksDiskResult(dict):
    def __init__(__self__, *,
                 bus_path: str,
                 modalias: str,
                 model: str,
                 name: str,
                 serial: str,
                 size: str,
                 type: str,
                 uuid: str,
                 wwid: str):
        """
        :param str bus_path: The bus path of the disk
        :param str modalias: The modalias of the disk
        :param str model: The model of the disk
        :param str name: The name of the disk
        :param str serial: The serial number of the disk
        :param str size: The size of the disk
        :param str type: The type of the disk
        :param str uuid: The uuid of the disk
        :param str wwid: The wwid of the disk
        """
        pulumi.set(__self__, "bus_path", bus_path)
        pulumi.set(__self__, "modalias", modalias)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "serial", serial)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "wwid", wwid)

    @property
    @pulumi.getter(name="busPath")
    def bus_path(self) -> str:
        """
        The bus path of the disk
        """
        return pulumi.get(self, "bus_path")

    @property
    @pulumi.getter
    def modalias(self) -> str:
        """
        The modalias of the disk
        """
        return pulumi.get(self, "modalias")

    @property
    @pulumi.getter
    def model(self) -> str:
        """
        The model of the disk
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the disk
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def serial(self) -> str:
        """
        The serial number of the disk
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def size(self) -> str:
        """
        The size of the disk
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the disk
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        The uuid of the disk
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter
    def wwid(self) -> str:
        """
        The wwid of the disk
        """
        return pulumi.get(self, "wwid")


@pulumi.output_type
class GetDisksFiltersResult(dict):
    def __init__(__self__, *,
                 bus_path: Optional[str] = None,
                 modalias: Optional[str] = None,
                 model: Optional[str] = None,
                 name: Optional[str] = None,
                 serial: Optional[str] = None,
                 size: Optional[str] = None,
                 type: Optional[str] = None,
                 uuid: Optional[str] = None,
                 wwid: Optional[str] = None):
        """
        :param str bus_path: Filter disks by bus path
        :param str modalias: Filter disks by modalias
        :param str model: Filter disks by model
        :param str name: Filter disks by name
        :param str serial: Filter disks by serial number
        :param str size: Filter disks by size
        :param str type: Filter disks by type
        :param str uuid: Filter disks by uuid
        :param str wwid: Filter disks by wwid
        """
        if bus_path is not None:
            pulumi.set(__self__, "bus_path", bus_path)
        if modalias is not None:
            pulumi.set(__self__, "modalias", modalias)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if wwid is not None:
            pulumi.set(__self__, "wwid", wwid)

    @property
    @pulumi.getter(name="busPath")
    def bus_path(self) -> Optional[str]:
        """
        Filter disks by bus path
        """
        return pulumi.get(self, "bus_path")

    @property
    @pulumi.getter
    def modalias(self) -> Optional[str]:
        """
        Filter disks by modalias
        """
        return pulumi.get(self, "modalias")

    @property
    @pulumi.getter
    def model(self) -> Optional[str]:
        """
        Filter disks by model
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Filter disks by name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def serial(self) -> Optional[str]:
        """
        Filter disks by serial number
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        Filter disks by size
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Filter disks by type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        Filter disks by uuid
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter
    def wwid(self) -> Optional[str]:
        """
        Filter disks by wwid
        """
        return pulumi.get(self, "wwid")


@pulumi.output_type
class GetDisksTimeoutsResult(dict):
    def __init__(__self__, *,
                 read: Optional[str] = None):
        """
        :param str read: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Read operations occur during any refresh or planning operation when refresh is enabled.
        """
        if read is not None:
            pulumi.set(__self__, "read", read)

    @property
    @pulumi.getter
    def read(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Read operations occur during any refresh or planning operation when refresh is enabled.
        """
        return pulumi.get(self, "read")


