# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDisksResult',
    'AwaitableGetDisksResult',
    'get_disks',
    'get_disks_output',
]

@pulumi.output_type
class GetDisksResult:
    """
    A collection of values returned by getDisks.
    """
    def __init__(__self__, client_configuration=None, disks=None, endpoint=None, filters=None, id=None, node=None, timeouts=None):
        if client_configuration and not isinstance(client_configuration, dict):
            raise TypeError("Expected argument 'client_configuration' to be a dict")
        pulumi.set(__self__, "client_configuration", client_configuration)
        if disks and not isinstance(disks, list):
            raise TypeError("Expected argument 'disks' to be a list")
        pulumi.set(__self__, "disks", disks)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if filters and not isinstance(filters, dict):
            raise TypeError("Expected argument 'filters' to be a dict")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if node and not isinstance(node, str):
            raise TypeError("Expected argument 'node' to be a str")
        pulumi.set(__self__, "node", node)
        if timeouts and not isinstance(timeouts, dict):
            raise TypeError("Expected argument 'timeouts' to be a dict")
        pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="clientConfiguration")
    def client_configuration(self) -> 'outputs.GetDisksClientConfigurationResult':
        """
        The client configuration data
        """
        return pulumi.get(self, "client_configuration")

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetDisksDiskResult']:
        """
        The disks that match the filters
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        endpoint to use for the talosclient. If not set, the node value will be used
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def filters(self) -> Optional['outputs.GetDisksFiltersResult']:
        """
        Filters to apply to the disks
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The generated ID of this resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def node(self) -> str:
        """
        controlplane node to retrieve the kubeconfig from
        """
        return pulumi.get(self, "node")

    @property
    @pulumi.getter
    def timeouts(self) -> Optional['outputs.GetDisksTimeoutsResult']:
        return pulumi.get(self, "timeouts")


class AwaitableGetDisksResult(GetDisksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDisksResult(
            client_configuration=self.client_configuration,
            disks=self.disks,
            endpoint=self.endpoint,
            filters=self.filters,
            id=self.id,
            node=self.node,
            timeouts=self.timeouts)


def get_disks(client_configuration: Optional[Union['GetDisksClientConfigurationArgs', 'GetDisksClientConfigurationArgsDict']] = None,
              endpoint: Optional[str] = None,
              filters: Optional[Union['GetDisksFiltersArgs', 'GetDisksFiltersArgsDict']] = None,
              node: Optional[str] = None,
              timeouts: Optional[Union['GetDisksTimeoutsArgs', 'GetDisksTimeoutsArgsDict']] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDisksResult:
    """
    Generate a machine configuration for a node type

    > **Note:** Since Talos natively supports `.machine.install.diskSelector`, the `machine_get_disks` data source maybe just used to query disk information that could be used elsewhere. It's recommended to use `machine.install.diskSelector` in Talos machine configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_talos as talos
    import pulumiverse_talos as talos

    this_secrets = talos.machine.Secrets("this")
    this = talos.machine.get_disks_output(client_configuration=this_secrets.client_configuration,
        node="10.5.0.2",
        filters={
            "size": "> 100GB",
            "type": "nvme",
        })
    pulumi.export("nvmeDisks", this.apply(lambda this: [__item.name for __item in this.disks]))
    ```


    :param Union['GetDisksClientConfigurationArgs', 'GetDisksClientConfigurationArgsDict'] client_configuration: The client configuration data
    :param str endpoint: endpoint to use for the talosclient. If not set, the node value will be used
    :param Union['GetDisksFiltersArgs', 'GetDisksFiltersArgsDict'] filters: Filters to apply to the disks
    :param str node: controlplane node to retrieve the kubeconfig from
    """
    __args__ = dict()
    __args__['clientConfiguration'] = client_configuration
    __args__['endpoint'] = endpoint
    __args__['filters'] = filters
    __args__['node'] = node
    __args__['timeouts'] = timeouts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('talos:machine/getDisks:getDisks', __args__, opts=opts, typ=GetDisksResult).value

    return AwaitableGetDisksResult(
        client_configuration=pulumi.get(__ret__, 'client_configuration'),
        disks=pulumi.get(__ret__, 'disks'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        node=pulumi.get(__ret__, 'node'),
        timeouts=pulumi.get(__ret__, 'timeouts'))
def get_disks_output(client_configuration: Optional[pulumi.Input[Union['GetDisksClientConfigurationArgs', 'GetDisksClientConfigurationArgsDict']]] = None,
                     endpoint: Optional[pulumi.Input[Optional[str]]] = None,
                     filters: Optional[pulumi.Input[Optional[Union['GetDisksFiltersArgs', 'GetDisksFiltersArgsDict']]]] = None,
                     node: Optional[pulumi.Input[str]] = None,
                     timeouts: Optional[pulumi.Input[Optional[Union['GetDisksTimeoutsArgs', 'GetDisksTimeoutsArgsDict']]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDisksResult]:
    """
    Generate a machine configuration for a node type

    > **Note:** Since Talos natively supports `.machine.install.diskSelector`, the `machine_get_disks` data source maybe just used to query disk information that could be used elsewhere. It's recommended to use `machine.install.diskSelector` in Talos machine configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_talos as talos
    import pulumiverse_talos as talos

    this_secrets = talos.machine.Secrets("this")
    this = talos.machine.get_disks_output(client_configuration=this_secrets.client_configuration,
        node="10.5.0.2",
        filters={
            "size": "> 100GB",
            "type": "nvme",
        })
    pulumi.export("nvmeDisks", this.apply(lambda this: [__item.name for __item in this.disks]))
    ```


    :param Union['GetDisksClientConfigurationArgs', 'GetDisksClientConfigurationArgsDict'] client_configuration: The client configuration data
    :param str endpoint: endpoint to use for the talosclient. If not set, the node value will be used
    :param Union['GetDisksFiltersArgs', 'GetDisksFiltersArgsDict'] filters: Filters to apply to the disks
    :param str node: controlplane node to retrieve the kubeconfig from
    """
    __args__ = dict()
    __args__['clientConfiguration'] = client_configuration
    __args__['endpoint'] = endpoint
    __args__['filters'] = filters
    __args__['node'] = node
    __args__['timeouts'] = timeouts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('talos:machine/getDisks:getDisks', __args__, opts=opts, typ=GetDisksResult)
    return __ret__.apply(lambda __response__: GetDisksResult(
        client_configuration=pulumi.get(__response__, 'client_configuration'),
        disks=pulumi.get(__response__, 'disks'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        node=pulumi.get(__response__, 'node'),
        timeouts=pulumi.get(__response__, 'timeouts')))
