# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOverlaysVersionsResult',
    'AwaitableGetOverlaysVersionsResult',
    'get_overlays_versions',
    'get_overlays_versions_output',
]

@pulumi.output_type
class GetOverlaysVersionsResult:
    """
    A collection of values returned by getOverlaysVersions.
    """
    def __init__(__self__, filters=None, id=None, overlays_infos=None, talos_version=None):
        if filters and not isinstance(filters, dict):
            raise TypeError("Expected argument 'filters' to be a dict")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if overlays_infos and not isinstance(overlays_infos, list):
            raise TypeError("Expected argument 'overlays_infos' to be a list")
        pulumi.set(__self__, "overlays_infos", overlays_infos)
        if talos_version and not isinstance(talos_version, str):
            raise TypeError("Expected argument 'talos_version' to be a str")
        pulumi.set(__self__, "talos_version", talos_version)

    @property
    @pulumi.getter
    def filters(self) -> Optional['outputs.GetOverlaysVersionsFiltersResult']:
        """
        The filter to apply to the overlays list.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="overlaysInfos")
    def overlays_infos(self) -> Sequence['outputs.GetOverlaysVersionsOverlaysInfoResult']:
        """
        The list of available extensions for the specified talos version.
        """
        return pulumi.get(self, "overlays_infos")

    @property
    @pulumi.getter(name="talosVersion")
    def talos_version(self) -> str:
        """
        The talos version to get overlays for.
        """
        return pulumi.get(self, "talos_version")


class AwaitableGetOverlaysVersionsResult(GetOverlaysVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOverlaysVersionsResult(
            filters=self.filters,
            id=self.id,
            overlays_infos=self.overlays_infos,
            talos_version=self.talos_version)


def get_overlays_versions(filters: Optional[Union['GetOverlaysVersionsFiltersArgs', 'GetOverlaysVersionsFiltersArgsDict']] = None,
                          talos_version: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOverlaysVersionsResult:
    """
    The image factory overlays versions data source provides a list of available overlays for a specific talos version from the image factory.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_talos as talos

    this = talos.imageFactory.get_overlays_versions(talos_version="v1.7.5",
        filters={
            "name": "rock4cplus",
        })
    ```


    :param Union['GetOverlaysVersionsFiltersArgs', 'GetOverlaysVersionsFiltersArgsDict'] filters: The filter to apply to the overlays list.
    :param str talos_version: The talos version to get overlays for.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['talosVersion'] = talos_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('talos:imageFactory/getOverlaysVersions:getOverlaysVersions', __args__, opts=opts, typ=GetOverlaysVersionsResult).value

    return AwaitableGetOverlaysVersionsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        overlays_infos=pulumi.get(__ret__, 'overlays_infos'),
        talos_version=pulumi.get(__ret__, 'talos_version'))
def get_overlays_versions_output(filters: Optional[pulumi.Input[Optional[Union['GetOverlaysVersionsFiltersArgs', 'GetOverlaysVersionsFiltersArgsDict']]]] = None,
                                 talos_version: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOverlaysVersionsResult]:
    """
    The image factory overlays versions data source provides a list of available overlays for a specific talos version from the image factory.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_talos as talos

    this = talos.imageFactory.get_overlays_versions(talos_version="v1.7.5",
        filters={
            "name": "rock4cplus",
        })
    ```


    :param Union['GetOverlaysVersionsFiltersArgs', 'GetOverlaysVersionsFiltersArgsDict'] filters: The filter to apply to the overlays list.
    :param str talos_version: The talos version to get overlays for.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['talosVersion'] = talos_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('talos:imageFactory/getOverlaysVersions:getOverlaysVersions', __args__, opts=opts, typ=GetOverlaysVersionsResult)
    return __ret__.apply(lambda __response__: GetOverlaysVersionsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        overlays_infos=pulumi.get(__response__, 'overlays_infos'),
        talos_version=pulumi.get(__response__, 'talos_version')))
