# -*- coding: utf-8 -*-

"""
    pagarmecoreapi

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from pagarmecoreapi.api_helper import APIHelper
from pagarmecoreapi.configuration import Configuration
from pagarmecoreapi.controllers.base_controller import BaseController
from pagarmecoreapi.http.auth.basic_auth import BasicAuth
from pagarmecoreapi.models.get_period_response import GetPeriodResponse
from pagarmecoreapi.models.get_subscription_response import GetSubscriptionResponse
from pagarmecoreapi.models.get_usage_response import GetUsageResponse
from pagarmecoreapi.models.get_discount_response import GetDiscountResponse
from pagarmecoreapi.models.list_subscription_items_response import ListSubscriptionItemsResponse
from pagarmecoreapi.models.get_subscription_item_response import GetSubscriptionItemResponse
from pagarmecoreapi.models.list_subscriptions_response import ListSubscriptionsResponse
from pagarmecoreapi.models.get_increment_response import GetIncrementResponse
from pagarmecoreapi.models.list_cycles_response import ListCyclesResponse
from pagarmecoreapi.models.list_discounts_response import ListDiscountsResponse
from pagarmecoreapi.models.list_increments_response import ListIncrementsResponse
from pagarmecoreapi.models.list_usages_response import ListUsagesResponse
from pagarmecoreapi.models.get_usage_report_response import GetUsageReportResponse

class SubscriptionsController(BaseController):

    """A Controller to access Endpoints in the pagarmecoreapi API."""


    def renew_subscription(self,
                           subscription_id,
                           idempotency_key=None):
        """Does a POST request to /subscriptions/{subscription_id}/cycles.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): TODO: type description here. Example: 
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetPeriodResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/cycles'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetPeriodResponse.from_dictionary)

    def update_subscription_card(self,
                                 subscription_id,
                                 request,
                                 idempotency_key=None):
        """Does a PATCH request to /subscriptions/{subscription_id}/card.

        Updates the credit card from a subscription

        Args:
            subscription_id (string): Subscription id
            request (UpdateSubscriptionCardRequest): Request for updating a
                card
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/card'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def delete_usage(self,
                     subscription_id,
                     item_id,
                     usage_id,
                     idempotency_key=None):
        """Does a DELETE request to /subscriptions/{subscription_id}/items/{item_id}/usages/{usage_id}.

        Deletes a usage

        Args:
            subscription_id (string): The subscription id
            item_id (string): The subscription item id
            usage_id (string): The usage id
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetUsageResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/items/{item_id}/usages/{usage_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'item_id': item_id,
            'usage_id': usage_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetUsageResponse.from_dictionary)

    def create_discount(self,
                        subscription_id,
                        request,
                        idempotency_key=None):
        """Does a POST request to /subscriptions/{subscription_id}/discounts.

        Creates a discount

        Args:
            subscription_id (string): Subscription id
            request (CreateDiscountRequest): Request for creating a discount
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetDiscountResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/discounts'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetDiscountResponse.from_dictionary)

    def create_an_usage(self,
                        subscription_id,
                        item_id,
                        idempotency_key=None):
        """Does a POST request to /subscriptions/{subscription_id}/items/{item_id}/usages.

        Create Usage

        Args:
            subscription_id (string): Subscription id
            item_id (string): Item id
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetUsageResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/items/{item_id}/usages'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetUsageResponse.from_dictionary)

    def update_current_cycle_status(self,
                                    subscription_id,
                                    request,
                                    idempotency_key=None):
        """Does a PATCH request to /subscriptions/{subscription_id}/cycle-status.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): Subscription Id
            request (UpdateCurrentCycleStatusRequest): Request for updating
                the end date of the subscription current status
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            void: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/cycle-status'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

    def delete_discount(self,
                        subscription_id,
                        discount_id,
                        idempotency_key=None):
        """Does a DELETE request to /subscriptions/{subscription_id}/discounts/{discount_id}.

        Deletes a discount

        Args:
            subscription_id (string): Subscription id
            discount_id (string): Discount Id
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetDiscountResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/discounts/{discount_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'discount_id': discount_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetDiscountResponse.from_dictionary)

    def get_subscription_items(self,
                               subscription_id,
                               page=None,
                               size=None,
                               name=None,
                               code=None,
                               status=None,
                               description=None,
                               created_since=None,
                               created_until=None):
        """Does a GET request to /subscriptions/{subscription_id}/items.

        Get Subscription Items

        Args:
            subscription_id (string): The subscription id
            page (int, optional): Page number
            size (int, optional): Page size
            name (string, optional): The item name
            code (string, optional): Identification code in the client system
            status (string, optional): The item statis
            description (string, optional): The item description
            created_since (string, optional): Filter for item's creation date
                start range
            created_until (string, optional): Filter for item's creation date
                end range

        Returns:
            ListSubscriptionItemsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/items'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'size': size,
            'name': name,
            'code': code,
            'status': status,
            'description': description,
            'created_since': created_since,
            'created_until': created_until
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListSubscriptionItemsResponse.from_dictionary)

    def update_subscription_payment_method(self,
                                           subscription_id,
                                           request,
                                           idempotency_key=None):
        """Does a PATCH request to /subscriptions/{subscription_id}/payment-method.

        Updates the payment method from a subscription

        Args:
            subscription_id (string): Subscription id
            request (UpdateSubscriptionPaymentMethodRequest): Request for
                updating the paymentmethod from a subscription
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/payment-method'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def get_subscription_item(self,
                              subscription_id,
                              item_id):
        """Does a GET request to /subscriptions/{subscription_id}/items/{item_id}.

        Get Subscription Item

        Args:
            subscription_id (string): Subscription Id
            item_id (string): Item id

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/items/{item_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def get_subscriptions(self,
                          page=None,
                          size=None,
                          code=None,
                          billing_type=None,
                          customer_id=None,
                          plan_id=None,
                          card_id=None,
                          status=None,
                          next_billing_since=None,
                          next_billing_until=None,
                          created_since=None,
                          created_until=None):
        """Does a GET request to /subscriptions.

        Gets all subscriptions

        Args:
            page (int, optional): Page number
            size (int, optional): Page size
            code (string, optional): Filter for subscription's code
            billing_type (string, optional): Filter for subscription's billing
                type
            customer_id (string, optional): Filter for subscription's customer
                id
            plan_id (string, optional): Filter for subscription's plan id
            card_id (string, optional): Filter for subscription's card id
            status (string, optional): Filter for subscription's status
            next_billing_since (datetime, optional): Filter for subscription's
                next billing date start range
            next_billing_until (datetime, optional): Filter for subscription's
                next billing date end range
            created_since (datetime, optional): Filter for subscription's
                creation date start range
            created_until (datetime, optional): Filter for subscriptions
                creation date end range

        Returns:
            ListSubscriptionsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions'
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'size': size,
            'code': code,
            'billing_type': billing_type,
            'customer_id': customer_id,
            'plan_id': plan_id,
            'card_id': card_id,
            'status': status,
            'next_billing_since': APIHelper.when_defined(APIHelper.RFC3339DateTime, next_billing_since),
            'next_billing_until': APIHelper.when_defined(APIHelper.RFC3339DateTime, next_billing_until),
            'created_since': APIHelper.when_defined(APIHelper.RFC3339DateTime, created_since),
            'created_until': APIHelper.when_defined(APIHelper.RFC3339DateTime, created_until)
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListSubscriptionsResponse.from_dictionary)

    def cancel_subscription(self,
                            subscription_id,
                            request=None,
                            idempotency_key=None):
        """Does a DELETE request to /subscriptions/{subscription_id}.

        Cancels a subscription

        Args:
            subscription_id (string): Subscription id
            request (CreateCancelSubscriptionRequest, optional): Request for
                cancelling a subscription
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def create_increment(self,
                         subscription_id,
                         request,
                         idempotency_key=None):
        """Does a POST request to /subscriptions/{subscription_id}/increments.

        Creates a increment

        Args:
            subscription_id (string): Subscription id
            request (CreateIncrementRequest): Request for creating a
                increment
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetIncrementResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/increments'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetIncrementResponse.from_dictionary)

    def create_usage(self,
                     subscription_id,
                     item_id,
                     body,
                     idempotency_key=None):
        """Does a POST request to /subscriptions/{subscription_id}/items/{item_id}/usages.

        Creates a usage

        Args:
            subscription_id (string): Subscription Id
            item_id (string): Item id
            body (CreateUsageRequest): Request for creating a usage
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetUsageResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/items/{item_id}/usages'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetUsageResponse.from_dictionary)

    def get_discount_by_id(self,
                           subscription_id,
                           discount_id):
        """Does a GET request to /subscriptions/{subscription_id}/discounts/{discountId}.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): The subscription id
            discount_id (string): TODO: type description here. Example: 

        Returns:
            GetDiscountResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/discounts/{discountId}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'discountId': discount_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetDiscountResponse.from_dictionary)

    def create_subscription(self,
                            body,
                            idempotency_key=None):
        """Does a POST request to /subscriptions.

        Creates a new subscription

        Args:
            body (CreateSubscriptionRequest): Request for creating a
                subscription
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions'
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def get_increment_by_id(self,
                            subscription_id,
                            increment_id):
        """Does a GET request to /subscriptions/{subscription_id}/increments/{increment_id}.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): The subscription Id
            increment_id (string): The increment Id

        Returns:
            GetIncrementResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/increments/{increment_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'increment_id': increment_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetIncrementResponse.from_dictionary)

    def update_subscription_affiliation_id(self,
                                           subscription_id,
                                           request,
                                           idempotency_key=None):
        """Does a PATCH request to /subscriptions/{subscription_id}/gateway-affiliation-id.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): TODO: type description here. Example: 
            request (UpdateSubscriptionAffiliationIdRequest): Request for
                updating a subscription affiliation id
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/gateway-affiliation-id'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def update_subscription_metadata(self,
                                     subscription_id,
                                     request,
                                     idempotency_key=None):
        """Does a PATCH request to /Subscriptions/{subscription_id}/metadata.

        Updates the metadata from a subscription

        Args:
            subscription_id (string): The subscription id
            request (UpdateMetadataRequest): Request for updating the
                subscrption metadata
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/Subscriptions/{subscription_id}/metadata'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def delete_increment(self,
                         subscription_id,
                         increment_id,
                         idempotency_key=None):
        """Does a DELETE request to /subscriptions/{subscription_id}/increments/{increment_id}.

        Deletes a increment

        Args:
            subscription_id (string): Subscription id
            increment_id (string): Increment id
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetIncrementResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/increments/{increment_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'increment_id': increment_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetIncrementResponse.from_dictionary)

    def get_subscription_cycles(self,
                                subscription_id,
                                page,
                                size):
        """Does a GET request to /subscriptions/{subscription_id}/cycles.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): Subscription Id
            page (string): Page number
            size (string): Page size

        Returns:
            ListCyclesResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/cycles'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'size': size
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListCyclesResponse.from_dictionary)

    def get_discounts(self,
                      subscription_id,
                      page,
                      size):
        """Does a GET request to /subscriptions/{subscription_id}/discounts/.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): The subscription id
            page (int): Page number
            size (int): Page size

        Returns:
            ListDiscountsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/discounts/'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'size': size
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListDiscountsResponse.from_dictionary)

    def update_subscription_billing_date(self,
                                         subscription_id,
                                         request,
                                         idempotency_key=None):
        """Does a PATCH request to /subscriptions/{subscription_id}/billing-date.

        Updates the billing date from a subscription

        Args:
            subscription_id (string): The subscription id
            request (UpdateSubscriptionBillingDateRequest): Request for
                updating the subscription billing date
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/billing-date'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def delete_subscription_item(self,
                                 subscription_id,
                                 subscription_item_id,
                                 idempotency_key=None):
        """Does a DELETE request to /subscriptions/{subscription_id}/items/{subscription_item_id}.

        Deletes a subscription item

        Args:
            subscription_id (string): Subscription id
            subscription_item_id (string): Subscription item id
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/items/{subscription_item_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'subscription_item_id': subscription_item_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def get_increments(self,
                       subscription_id,
                       page=None,
                       size=None):
        """Does a GET request to /subscriptions/{subscription_id}/increments/.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): The subscription id
            page (int, optional): Page number
            size (int, optional): Page size

        Returns:
            ListIncrementsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/increments/'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'size': size
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListIncrementsResponse.from_dictionary)

    def update_subscription_due_days(self,
                                     subscription_id,
                                     request,
                                     idempotency_key=None):
        """Does a PATCH request to /subscriptions/{subscription_id}/boleto-due-days.

        Updates the boleto due days from a subscription

        Args:
            subscription_id (string): Subscription Id
            request (UpdateSubscriptionDueDaysRequest): TODO: type description
                here. Example: 
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/boleto-due-days'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def update_subscription_start_at(self,
                                     subscription_id,
                                     request,
                                     idempotency_key=None):
        """Does a PATCH request to /subscriptions/{subscription_id}/start-at.

        Updates the start at date from a subscription

        Args:
            subscription_id (string): The subscription id
            request (UpdateSubscriptionStartAtRequest): Request for updating
                the subscription start date
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/start-at'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def update_subscription_item(self,
                                 subscription_id,
                                 item_id,
                                 body,
                                 idempotency_key=None):
        """Does a PUT request to /subscriptions/{subscription_id}/items/{item_id}.

        Updates a subscription item

        Args:
            subscription_id (string): Subscription Id
            item_id (string): Item id
            body (UpdateSubscriptionItemRequest): Request for updating a
                subscription item
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/items/{item_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def create_subscription_item(self,
                                 subscription_id,
                                 request,
                                 idempotency_key=None):
        """Does a POST request to /subscriptions/{subscription_id}/items.

        Creates a new Subscription item

        Args:
            subscription_id (string): Subscription id
            request (CreateSubscriptionItemRequest): Request for creating a
                subscription item
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/items'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def get_subscription(self,
                         subscription_id):
        """Does a GET request to /subscriptions/{subscription_id}.

        Gets a subscription

        Args:
            subscription_id (string): Subscription id

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def get_usages(self,
                   subscription_id,
                   item_id,
                   page=None,
                   size=None,
                   code=None,
                   group=None,
                   used_since=None,
                   used_until=None):
        """Does a GET request to /subscriptions/{subscription_id}/items/{item_id}/usages.

        Lists all usages from a subscription item

        Args:
            subscription_id (string): The subscription id
            item_id (string): The subscription item id
            page (int, optional): Page number
            size (int, optional): Page size
            code (string, optional): Identification code in the client system
            group (string, optional): Identification group in the client
                system
            used_since (datetime, optional): TODO: type description here.
                Example: 
            used_until (datetime, optional): TODO: type description here.
                Example: 

        Returns:
            ListUsagesResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/items/{item_id}/usages'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'size': size,
            'code': code,
            'group': group,
            'used_since': APIHelper.when_defined(APIHelper.RFC3339DateTime, used_since),
            'used_until': APIHelper.when_defined(APIHelper.RFC3339DateTime, used_until)
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListUsagesResponse.from_dictionary)

    def update_latest_period_end_at(self,
                                    subscription_id,
                                    request,
                                    idempotency_key=None):
        """Does a PATCH request to /subscriptions/{subscription_id}/periods/latest/end-at.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): TODO: type description here. Example: 
            request (UpdateCurrentCycleEndDateRequest): Request for updating
                the end date of the current signature cycle
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/periods/latest/end-at'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def update_subscription_minium_price(self,
                                         subscription_id,
                                         request,
                                         idempotency_key=None):
        """Does a PATCH request to /subscriptions/{subscription_id}/minimum_price.

        Atualização do valor mínimo da assinatura

        Args:
            subscription_id (string): Subscription Id
            request (UpdateSubscriptionMinimumPriceRequest): Request da
                requisição com o valor mínimo que será configurado
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/minimum_price'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def get_subscription_cycle_by_id(self,
                                     subscription_id,
                                     cycle_id):
        """Does a GET request to /subscriptions/{subscription_id}/cycles/{cycleId}.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): The subscription id
            cycle_id (string): TODO: type description here. Example: 

        Returns:
            GetPeriodResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/cycles/{cycleId}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'cycleId': cycle_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetPeriodResponse.from_dictionary)

    def get_usage_report(self,
                         subscription_id,
                         period_id):
        """Does a GET request to /subscriptions/{subscription_id}/periods/{period_id}/usages/report.

        TODO: type endpoint description here.

        Args:
            subscription_id (string): The subscription Id
            period_id (string): The period Id

        Returns:
            GetUsageReportResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{subscription_id}/periods/{period_id}/usages/report'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'subscription_id': subscription_id,
            'period_id': period_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetUsageReportResponse.from_dictionary)

    def update_split_subscription(self,
                                  id,
                                  request):
        """Does a PATCH request to /subscriptions/{id}/split.

        TODO: type endpoint description here.

        Args:
            id (string): Subscription's id
            request (UpdateSubscriptionSplitRequest): TODO: type description
                here. Example: 

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/subscriptions/{id}/split'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'id': id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)
