# Generated by Django 4.2.15 on 2024-08-25 12:09

from django.conf import settings
import django.core.files.storage
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AglService',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.CharField(max_length=255)),
                ('online', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('port', models.IntegerField(blank=True, null=True)),
                ('protocol', models.CharField(blank=True, max_length=255, null=True)),
                ('url', models.URLField(blank=True, null=True)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='CaseTemplateRuleType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='CaseTemplateRuleValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('fk_value', models.CharField(blank=True, max_length=255, null=True)),
                ('numeric_value', models.FloatField(blank=True, null=True)),
                ('text_value', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='CaseTemplateRuleValueType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('distribution_type', models.CharField(choices=[('single_categorical', 'single_categorical'), ('multiple_categorical', 'multiple_categorical'), ('numeric', 'numeric')], max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='CaseTemplateType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Center',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='DateValueDistribution',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('distribution_type', models.CharField(choices=[('uniform', 'Uniform'), ('normal', 'Normal')], max_length=20)),
                ('mode', models.CharField(choices=[('date', 'Date'), ('timedelta', 'Timedelta')], max_length=20)),
                ('date_min', models.DateField(blank=True, null=True)),
                ('date_max', models.DateField(blank=True, null=True)),
                ('date_mean', models.DateField(blank=True, null=True)),
                ('date_std_dev', models.IntegerField(blank=True, null=True)),
                ('timedelta_days_min', models.IntegerField(blank=True, null=True)),
                ('timedelta_days_max', models.IntegerField(blank=True, null=True)),
                ('timedelta_days_mean', models.IntegerField(blank=True, null=True)),
                ('timedelta_days_std_dev', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Disease',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='DiseaseClassification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('disease', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.disease')),
            ],
        ),
        migrations.CreateModel(
            name='DiseaseClassificationChoice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('disease_classification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.diseaseclassification')),
            ],
        ),
        migrations.CreateModel(
            name='EmissionFactor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('value', models.FloatField()),
            ],
        ),
        migrations.CreateModel(
            name='Endoscope',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('sn', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name': 'Endoscope',
                'verbose_name_plural': 'Endoscopes',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='EndoscopeType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'Endoscope Type',
                'verbose_name_plural': 'Endoscope Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='EndoscopyProcessor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('image_width', models.IntegerField()),
                ('image_height', models.IntegerField()),
                ('endoscope_image_x', models.IntegerField()),
                ('endoscope_image_y', models.IntegerField()),
                ('endoscope_image_width', models.IntegerField()),
                ('endoscope_image_height', models.IntegerField()),
                ('examination_date_x', models.IntegerField()),
                ('examination_date_y', models.IntegerField()),
                ('examination_date_width', models.IntegerField()),
                ('examination_date_height', models.IntegerField()),
                ('examination_time_x', models.IntegerField(blank=True, null=True)),
                ('examination_time_y', models.IntegerField(blank=True, null=True)),
                ('examination_time_width', models.IntegerField(blank=True, null=True)),
                ('examination_time_height', models.IntegerField(blank=True, null=True)),
                ('patient_first_name_x', models.IntegerField()),
                ('patient_first_name_y', models.IntegerField()),
                ('patient_first_name_width', models.IntegerField()),
                ('patient_first_name_height', models.IntegerField()),
                ('patient_last_name_x', models.IntegerField()),
                ('patient_last_name_y', models.IntegerField()),
                ('patient_last_name_width', models.IntegerField()),
                ('patient_last_name_height', models.IntegerField()),
                ('patient_dob_x', models.IntegerField()),
                ('patient_dob_y', models.IntegerField()),
                ('patient_dob_width', models.IntegerField()),
                ('patient_dob_height', models.IntegerField()),
                ('endoscope_type_x', models.IntegerField(blank=True, null=True)),
                ('endoscope_type_y', models.IntegerField(blank=True, null=True)),
                ('endoscope_type_width', models.IntegerField(blank=True, null=True)),
                ('endoscope_type_height', models.IntegerField(blank=True, null=True)),
                ('endoscope_sn_x', models.IntegerField(blank=True, null=True)),
                ('endoscope_sn_y', models.IntegerField(blank=True, null=True)),
                ('endoscope_sn_width', models.IntegerField(blank=True, null=True)),
                ('endoscope_sn_height', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Examination',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('date', models.DateField(blank=True, null=True)),
                ('time', models.TimeField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'Examination',
                'verbose_name_plural': 'Examinations',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ExaminationType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Examiner',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=255)),
                ('last_name', models.CharField(max_length=255)),
                ('dob', models.DateField(blank=True, null=True, verbose_name='Date of Birth')),
                ('email', models.EmailField(blank=True, max_length=255, null=True)),
                ('phone', models.CharField(blank=True, max_length=255, null=True)),
                ('is_real_person', models.BooleanField(default=True)),
                ('center', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FFMpegMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('duration', models.FloatField(blank=True, null=True)),
                ('width', models.IntegerField(blank=True, null=True)),
                ('height', models.IntegerField(blank=True, null=True)),
                ('frame_rate', models.FloatField(blank=True, null=True)),
                ('video_codec', models.CharField(blank=True, max_length=50, null=True)),
                ('audio_codec', models.CharField(blank=True, max_length=50, null=True)),
                ('audio_channels', models.IntegerField(blank=True, null=True)),
                ('audio_sample_rate', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='FirstName',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='Frame',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('frame_number', models.IntegerField()),
                ('image', models.ImageField(upload_to='frames')),
                ('suffix', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Gender',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('abbreviation', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='InformationSource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('url', models.URLField(blank=True, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('date', models.DateField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Label',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='LabelSet',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
                ('version', models.IntegerField()),
                ('labels', models.ManyToManyField(related_name='labels', to='endoreg_db.label')),
            ],
        ),
        migrations.CreateModel(
            name='LabelType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='LabValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=10, null=True)),
                ('numeric_precision', models.IntegerField(default=3)),
                ('default_normal_range', models.JSONField(blank=True, null=True)),
                ('normal_range_age_dependent', models.BooleanField(default=False)),
                ('normal_range_gender_dependent', models.BooleanField(default=False)),
                ('normal_range_special_case', models.BooleanField(default=False)),
                ('default_date_value_distribution', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='default_date_value_distribution', to='endoreg_db.datevaluedistribution')),
            ],
        ),
        migrations.CreateModel(
            name='LastName',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='LegacyImage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to='legacy_images')),
                ('suffix', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='LegacyVideo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('video_hash', models.CharField(max_length=255, unique=True)),
                ('date', models.DateField(blank=True, null=True)),
                ('suffix', models.CharField(max_length=255)),
                ('fps', models.FloatField()),
                ('duration', models.FloatField()),
                ('width', models.IntegerField()),
                ('height', models.IntegerField()),
                ('endoscope_image_x', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_y', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_width', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_height', models.IntegerField(blank=True, null=True)),
                ('frames_extracted', models.BooleanField(default=False)),
                ('meta', models.JSONField(blank=True, null=True)),
                ('file', models.FileField(blank=True, null=True, upload_to='legacy_videos')),
                ('center', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('endoscopy_processor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.endoscopyprocessor')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LogType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.CharField(max_length=255)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Material',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('emission_factor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.emissionfactor')),
            ],
        ),
        migrations.CreateModel(
            name='Medication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('adapt_to_renal_function', models.BooleanField(default=False)),
                ('adapt_to_hepatic_function', models.BooleanField(default=False)),
                ('adapt_to_indication', models.BooleanField(default=False)),
                ('adapt_to_age', models.BooleanField(default=False)),
                ('adapt_to_weight', models.BooleanField(default=False)),
                ('adapt_to_risk', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='MedicationIndication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('classification_choices', models.ManyToManyField(to='endoreg_db.diseaseclassificationchoice')),
                ('diseases', models.ManyToManyField(to='endoreg_db.disease')),
                ('events', models.ManyToManyField(to='endoreg_db.event')),
            ],
        ),
        migrations.CreateModel(
            name='MedicationIndicationType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='MedicationIntakeTime',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('repeats', models.CharField(default='daily', max_length=20)),
                ('time', models.TimeField()),
            ],
        ),
        migrations.CreateModel(
            name='MedicationSchedule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('therapy_duration_d', models.FloatField(blank=True, null=True)),
                ('dose', models.FloatField()),
                ('intake_times', models.ManyToManyField(to='endoreg_db.medicationintaketime')),
                ('medication', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.medication')),
            ],
        ),
        migrations.CreateModel(
            name='ModelMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('version', models.CharField(max_length=255)),
                ('weights', models.FileField(upload_to='weights/')),
                ('description', models.TextField(blank=True, null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('labelset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='models', to='endoreg_db.labelset')),
            ],
        ),
        migrations.CreateModel(
            name='ModelType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='MultipleCategoricalValueDistribution',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('categories', models.JSONField()),
                ('min_count', models.IntegerField()),
                ('max_count', models.IntegerField()),
                ('count_distribution_type', models.CharField(choices=[('uniform', 'Uniform'), ('normal', 'Normal')], max_length=20)),
                ('count_mean', models.FloatField(blank=True, null=True)),
                ('count_std_dev', models.FloatField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NetworkDevice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('ip', models.GenericIPAddressField(blank=True, null=True)),
                ('description', models.CharField(max_length=255)),
                ('online', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
            options={
                'db_table': 'network_devices',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='NetworkDeviceType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.CharField(max_length=255)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
            options={
                'db_table': 'network_device_types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='NumericValueDistribution',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('distribution_type', models.CharField(choices=[('uniform', 'Uniform'), ('normal', 'Normal'), ('skewed_normal', 'Skewed Normal')], max_length=20)),
                ('min_value', models.FloatField()),
                ('max_value', models.FloatField()),
                ('mean', models.FloatField(blank=True, null=True)),
                ('std_dev', models.FloatField(blank=True, null=True)),
                ('skewness', models.FloatField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Patient',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=255)),
                ('last_name', models.CharField(max_length=255)),
                ('dob', models.DateField(blank=True, null=True, verbose_name='Date of Birth')),
                ('email', models.EmailField(blank=True, max_length=255, null=True)),
                ('phone', models.CharField(blank=True, max_length=255, null=True)),
                ('is_real_person', models.BooleanField(default=True)),
                ('center', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('gender', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.gender')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PatientLabSample',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField()),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lab_samples', to='endoreg_db.patient')),
            ],
        ),
        migrations.CreateModel(
            name='PatientLabSampleType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='PatientMedication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dosage', models.JSONField()),
                ('active', models.BooleanField(default=True)),
                ('medication_indication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_medications', to='endoreg_db.medicationindication')),
                ('medication_schedules', models.ManyToManyField(to='endoreg_db.medicationschedule')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient')),
            ],
            options={
                'verbose_name': 'Patient Medication',
                'verbose_name_plural': 'Patient Medications',
            },
        ),
        migrations.CreateModel(
            name='PdfType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ProductGroup',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Profession',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='QuizAnswerType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='QuizQuestionType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ReportReaderFlag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('value', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Rule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('attribute_key', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name': 'Rule',
                'verbose_name_plural': 'Rules',
            },
        ),
        migrations.CreateModel(
            name='RuleAttributeDType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='RuleType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'Rule Type',
                'verbose_name_plural': 'Rule Types',
            },
        ),
        migrations.CreateModel(
            name='SensitiveMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('examination_date', models.DateField(blank=True, null=True)),
                ('patient_first_name', models.CharField(blank=True, max_length=255, null=True)),
                ('patient_last_name', models.CharField(blank=True, max_length=255, null=True)),
                ('patient_dob', models.DateField(blank=True, null=True)),
                ('endoscope_type', models.CharField(blank=True, max_length=255, null=True)),
                ('endoscope_sn', models.CharField(blank=True, max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='SingleCategoricalValueDistribution',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('categories', models.JSONField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TtoQuestionnaire',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('patient_name', models.CharField(max_length=255, verbose_name='Identifikation des Patienten (Name)')),
                ('birth_date', models.DateField(verbose_name='Geburtsdatum')),
                ('emergency_patient', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Notfallpatient/kürzlich untersuchter Patient (Verzicht auf Team-Time-Out möglich)')),
                ('consent_signed', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Einverständniserklärung unterschrieben (Arzt, Patient)')),
                ('documents_present', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Alle Dokumente liegen vor (Labor, Befunde, etc.)')),
                ('communication_possible', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Kommunikation mit Patient möglich')),
                ('work_incapacity_certificate', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Arbeitsunfähigkeitsbescheinigung')),
                ('pregnancy', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Schwangerschaft')),
                ('asa_classification_checked', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='ASA-Klassifikation/Komorbidität geprüft')),
                ('previous_anesthesia_complications', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Komplikationen bei bisherigen Narkosen?')),
                ('last_meal_over_6_hours_ago', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Zeitpunkt letzte Mahlzeit > 6 Stunden')),
                ('allergies', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Allergien, welche?')),
                ('outpatient_accompaniment_post_sedation', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Nur bei ambulanter Vorstellung: Begleitung nach Sedierung?')),
                ('dental_prosthesis', models.BooleanField(default=False, verbose_name='Zahnprothese')),
                ('glasses', models.BooleanField(default=False, verbose_name='Brille')),
                ('implants', models.BooleanField(default=False, verbose_name='Implantate')),
                ('hearing_aids', models.BooleanField(default=False, verbose_name='Hörgeräte')),
                ('anticoagulants_ass', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Antikoagulation, ASS')),
                ('blood_pressure_medication', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Blutdruckmedikamente')),
                ('glaucoma', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Glaukom')),
                ('metal_implants', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Metallimplantate')),
                ('pacemaker_icd', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Herzschrittmacher/ICD')),
                ('copd', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='COPD')),
                ('liver_cirrhosis', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Leberzirrhose')),
                ('ibd', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='CED (Chronisch entzündliche Darmerkrankungen)')),
                ('radiation', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Bestrahlung')),
                ('surgeries', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='OP´s')),
                ('team_introduction', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Teamvorstellung mit Name und Aufgabe')),
                ('instruments_available', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Notwendige Instrumente vorhanden?')),
                ('monitoring_medications_equipment_checked', models.CharField(choices=[('yes', 'Ja'), ('no', 'Nein')], max_length=3, verbose_name='Monitoring, Medikamente, Equipment zum Atemwegsmanagement zur Verfügung und überprüft?')),
                ('complete_documentation_inclusive_care_notes', models.TextField(verbose_name='Vollständige Dokumentation inklusive Hinweise für Nachsorge')),
                ('notes', models.TextField(default='Keine Bemerkungen', verbose_name='Bemerkungen')),
                ('specimens_secured', models.BooleanField(default=False, verbose_name='Histologische Proben gesichert')),
                ('patient_condition_documented', models.TextField(verbose_name='Patientenzustand dokumentiert (je nach Ausgangszustand)')),
            ],
        ),
        migrations.CreateModel(
            name='Unit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('description', models.CharField(blank=True, max_length=100, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=25, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Video',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(blank=True, null=True, upload_to='raw_videos')),
                ('video_hash', models.CharField(max_length=255, unique=True)),
                ('date', models.DateField(blank=True, null=True)),
                ('suffix', models.CharField(max_length=255)),
                ('fps', models.FloatField()),
                ('duration', models.FloatField()),
                ('width', models.IntegerField()),
                ('height', models.IntegerField()),
                ('endoscope_image_x', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_y', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_width', models.IntegerField(blank=True, null=True)),
                ('endoscope_image_height', models.IntegerField(blank=True, null=True)),
                ('frames_extracted', models.BooleanField(default=False)),
                ('meta', models.JSONField(blank=True, null=True)),
                ('center', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('endoscopy_processor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.endoscopyprocessor')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VideoImportMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('video_anonymized', models.BooleanField(default=False)),
                ('video_patient_data_detected', models.BooleanField(default=False)),
                ('outside_detected', models.BooleanField(default=False)),
                ('patient_data_removed', models.BooleanField(default=False)),
                ('outside_removed', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Waste',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='VideoPredictionMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_modified', models.DateTimeField(auto_now=True)),
                ('prediction_array', models.BinaryField(blank=True, null=True)),
                ('model_meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.modelmeta')),
                ('video', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='video_prediction_meta', to='endoreg_db.video')),
            ],
            options={
                'abstract': False,
                'unique_together': {('model_meta', 'video')},
            },
        ),
        migrations.CreateModel(
            name='VideoMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('endoscope', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.endoscope')),
                ('ffmpeg_meta', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.ffmpegmeta')),
                ('import_meta', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.videoimportmeta')),
                ('processor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.endoscopyprocessor')),
            ],
        ),
        migrations.AddField(
            model_name='video',
            name='import_meta',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.videoimportmeta'),
        ),
        migrations.AddField(
            model_name='video',
            name='patient',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient'),
        ),
        migrations.CreateModel(
            name='TransportRoute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('distance', models.FloatField()),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('emission_factor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.emissionfactor')),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.unit')),
            ],
        ),
        migrations.CreateModel(
            name='Ruleset',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=255, null=True)),
                ('name_en', models.CharField(blank=True, max_length=255, null=True)),
                ('rules', models.ManyToManyField(to='endoreg_db.rule')),
            ],
        ),
        migrations.AddField(
            model_name='rule',
            name='attribute_dtype',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.ruleattributedtype'),
        ),
        migrations.AddField(
            model_name='rule',
            name='rule_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.ruletype'),
        ),
        migrations.CreateModel(
            name='ReportReaderConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('locale', models.CharField(default='de_DE', max_length=10)),
                ('text_date_format', models.CharField(default='%d.%m.%Y', max_length=10)),
                ('cut_off_above', models.ManyToManyField(related_name='report_reader_configs_cut_off_above', to='endoreg_db.reportreaderflag')),
                ('cut_off_below', models.ManyToManyField(related_name='report_reader_configs_cut_off_below', to='endoreg_db.reportreaderflag')),
                ('endoscope_info_line_flag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='report_reader_configs_endoscope_info_line', to='endoreg_db.reportreaderflag')),
                ('examiner_info_line_flag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='report_reader_configs_examiner_info_line', to='endoreg_db.reportreaderflag')),
                ('first_names', models.ManyToManyField(related_name='report_reader_configs', to='endoreg_db.firstname')),
                ('last_names', models.ManyToManyField(related_name='report_reader_configs', to='endoreg_db.lastname')),
                ('patient_info_line_flag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='report_reader_configs_patient_info_line', to='endoreg_db.reportreaderflag')),
            ],
        ),
        migrations.CreateModel(
            name='ReportFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pdf', models.FileField(blank=True, null=True, upload_to='raw_report_pdfs')),
                ('pdf_hash', models.CharField(max_length=255, unique=True)),
                ('meta', models.JSONField(blank=True, null=True)),
                ('text', models.TextField(blank=True, null=True)),
                ('text_anonymized', models.TextField(blank=True, null=True)),
                ('date', models.DateField(blank=True, null=True)),
                ('time', models.TimeField(blank=True, null=True)),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('examiner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.examiner')),
                ('patient', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient')),
            ],
        ),
        migrations.CreateModel(
            name='ReferenceProduct',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('emission_factor_package', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reference_product_package', to='endoreg_db.emissionfactor')),
                ('emission_factor_product', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reference_product_product', to='endoreg_db.emissionfactor')),
                ('emission_factor_total', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.emissionfactor')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.product')),
                ('product_group', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='reference_product', to='endoreg_db.productgroup')),
            ],
        ),
        migrations.CreateModel(
            name='RawVideoFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField()),
                ('file', models.FileField(upload_to='raw_data/')),
                ('original_file_name', models.CharField(max_length=255)),
                ('video_hash', models.CharField(max_length=255, unique=True)),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('state_frames_required', models.BooleanField(default=True)),
                ('state_frames_extracted', models.BooleanField(default=False)),
                ('state_initial_prediction_required', models.BooleanField(default=True)),
                ('state_initial_prediction_completed', models.BooleanField(default=False)),
                ('state_initial_prediction_import_required', models.BooleanField(default=True)),
                ('state_initial_prediction_import_completed', models.BooleanField(default=False)),
                ('state_ocr_required', models.BooleanField(default=True)),
                ('state_ocr_completed', models.BooleanField(default=False)),
                ('state_outside_validated', models.BooleanField(default=False)),
                ('state_ocr_result_validated', models.BooleanField(default=False)),
                ('state_sensitive_data_retrieved', models.BooleanField(default=False)),
                ('state_histology_required', models.BooleanField(blank=True, null=True)),
                ('state_histology_available', models.BooleanField(default=False)),
                ('state_follow_up_intervention_required', models.BooleanField(blank=True, null=True)),
                ('state_follow_up_intervention_available', models.BooleanField(default=False)),
                ('state_dataset_complete', models.BooleanField(default=False)),
                ('state_anonym_video_required', models.BooleanField(default=True)),
                ('state_anonym_video_performed', models.BooleanField(default=False)),
                ('state_original_reports_deleted', models.BooleanField(default=False)),
                ('state_original_video_deleted', models.BooleanField(default=False)),
                ('state_finalized', models.BooleanField(default=False)),
                ('frame_dir', models.CharField(max_length=255)),
                ('prediction_dir', models.CharField(max_length=255)),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('processor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.endoscopyprocessor')),
                ('sensitive_meta', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.sensitivemeta')),
                ('video_meta', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.videometa')),
            ],
        ),
        migrations.CreateModel(
            name='RawPdfFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(storage=django.core.files.storage.FileSystemStorage(location='/home/agl-admin/agl-monitor/agl_monitor/agl_monitor/erc_data/raw_pdf'), upload_to='raw_pdf/', validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['pdf'])])),
                ('pdf_hash', models.CharField(max_length=255, unique=True)),
                ('state_report_processing_required', models.BooleanField(default=True)),
                ('state_report_processed', models.BooleanField(default=False)),
                ('text', models.TextField(blank=True, null=True)),
                ('anonymized_text', models.TextField(blank=True, null=True)),
                ('raw_meta', models.JSONField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('pdf_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.pdftype')),
                ('sensitive_meta', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='raw_pdf_file', to='endoreg_db.sensitivemeta')),
            ],
        ),
        migrations.CreateModel(
            name='QuizQuestion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField()),
                ('description', models.TextField(blank=True, null=True)),
                ('question_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.quizquestiontype')),
            ],
        ),
        migrations.CreateModel(
            name='QuizAnswer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text_value', models.CharField(blank=True, max_length=255, null=True)),
                ('number_value', models.FloatField(blank=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('answer_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.quizanswertype')),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.quizquestion')),
            ],
        ),
        migrations.CreateModel(
            name='ProductWeight',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, null=True)),
                ('measured', models.FloatField(null=True)),
                ('verified', models.FloatField(null=True)),
                ('manufacturer', models.FloatField(null=True)),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.product')),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.unit')),
            ],
        ),
        migrations.CreateModel(
            name='ProductMaterial',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('component', models.CharField(max_length=255)),
                ('quantity', models.FloatField()),
                ('material', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.material')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='product_materials', to='endoreg_db.product')),
                ('unit', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit')),
            ],
        ),
        migrations.AddField(
            model_name='product',
            name='product_group',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.productgroup'),
        ),
        migrations.AddField(
            model_name='product',
            name='transport_route',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.transportroute'),
        ),
        migrations.CreateModel(
            name='PortalUserInfo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('works_in_endoscopy', models.BooleanField(blank=True, null=True)),
                ('profession', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.profession')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='pdftype',
            name='cut_off_above_lines',
            field=models.ManyToManyField(related_name='pdf_type_cut_off_above_lines', to='endoreg_db.reportreaderflag'),
        ),
        migrations.AddField(
            model_name='pdftype',
            name='cut_off_below_lines',
            field=models.ManyToManyField(related_name='pdf_type_cut_off_below_lines', to='endoreg_db.reportreaderflag'),
        ),
        migrations.AddField(
            model_name='pdftype',
            name='endoscope_info_line',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pdf_type_endoscopy_info_line', to='endoreg_db.reportreaderflag'),
        ),
        migrations.AddField(
            model_name='pdftype',
            name='examiner_info_line',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pdf_type_examiner_info_line', to='endoreg_db.reportreaderflag'),
        ),
        migrations.AddField(
            model_name='pdftype',
            name='patient_info_line',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pdf_type_patient_info_line', to='endoreg_db.reportreaderflag'),
        ),
        migrations.CreateModel(
            name='PdfMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField()),
                ('time', models.TimeField()),
                ('pdf_hash', models.CharField(max_length=255, unique=True)),
                ('pdf_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.pdftype')),
            ],
        ),
        migrations.CreateModel(
            name='PatientMedicationSchedule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('medication', models.ManyToManyField(related_name='patient_medication_schedules', to='endoreg_db.patientmedication')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient')),
            ],
        ),
        migrations.AddField(
            model_name='patientmedication',
            name='unit',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit'),
        ),
        migrations.CreateModel(
            name='PatientLabValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.FloatField(blank=True, null=True)),
                ('value_str', models.CharField(blank=True, max_length=255, null=True)),
                ('datetime', models.DateTimeField(auto_now_add=True)),
                ('normal_range', models.JSONField(default=dict)),
                ('lab_value', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.labvalue')),
                ('patient', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='lab_values', to='endoreg_db.patient')),
                ('sample', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='values', to='endoreg_db.patientlabsample')),
                ('unit', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit')),
            ],
        ),
        migrations.AddField(
            model_name='patientlabsample',
            name='sample_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patientlabsampletype'),
        ),
        migrations.CreateModel(
            name='PatientExamination',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('examination', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.examination')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='patient_examinations', to='endoreg_db.patient')),
                ('report_file', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_examination', to='endoreg_db.reportfile')),
                ('video', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='patient_examination', to='endoreg_db.video')),
            ],
            options={
                'verbose_name': 'Patient Examination',
                'verbose_name_plural': 'Patient Examinations',
                'ordering': ['patient', 'examination'],
            },
        ),
        migrations.CreateModel(
            name='PatientEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_start', models.DateField()),
                ('date_end', models.DateField(blank=True, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('last_update', models.DateTimeField(auto_now=True)),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.event')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient')),
            ],
        ),
        migrations.CreateModel(
            name='PatientDisease',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('last_update', models.DateTimeField(auto_now=True)),
                ('classification_choices', models.ManyToManyField(to='endoreg_db.diseaseclassificationchoice')),
                ('disease', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.disease')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient')),
            ],
        ),
        migrations.CreateModel(
            name='NetworkDeviceLogEntry',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('ip_address', models.GenericIPAddressField(blank=True, null=True)),
                ('user_agent', models.CharField(blank=True, max_length=256, null=True)),
                ('message', models.TextField()),
                ('json_content', models.JSONField(blank=True, null=True)),
                ('device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.networkdevice')),
                ('log_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.logtype')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Network Device Log Entry',
                'verbose_name_plural': 'Network Device Log Entries',
            },
        ),
        migrations.AddField(
            model_name='networkdevice',
            name='device_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.networkdevicetype'),
        ),
        migrations.AddField(
            model_name='modelmeta',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='models', to='endoreg_db.modeltype'),
        ),
        migrations.AddField(
            model_name='medicationschedule',
            name='unit',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit'),
        ),
        migrations.AddField(
            model_name='medicationindication',
            name='indication_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='medication_indications', to='endoreg_db.medicationindicationtype'),
        ),
        migrations.AddField(
            model_name='medicationindication',
            name='medication_schedules',
            field=models.ManyToManyField(to='endoreg_db.medicationschedule'),
        ),
        migrations.AddField(
            model_name='medicationindication',
            name='sources',
            field=models.ManyToManyField(to='endoreg_db.informationsource'),
        ),
        migrations.AddField(
            model_name='medication',
            name='default_unit',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit'),
        ),
        migrations.CreateModel(
            name='LegacyVideoPredictionMeta',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_modified', models.DateTimeField(auto_now=True)),
                ('prediction_array', models.BinaryField(blank=True, null=True)),
                ('model_meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.modelmeta')),
                ('video', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='video_prediction_meta', to='endoreg_db.legacyvideo')),
            ],
            options={
                'abstract': False,
                'unique_together': {('model_meta', 'video')},
            },
        ),
        migrations.AddField(
            model_name='legacyvideo',
            name='patient',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.patient'),
        ),
        migrations.CreateModel(
            name='LegacyLabelVideoSegment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_frame_number', models.IntegerField()),
                ('end_frame_number', models.IntegerField()),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.label')),
                ('prediction_meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='video_segments', to='endoreg_db.legacyvideopredictionmeta')),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.informationsource')),
                ('video', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.legacyvideo')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LegacyFrame',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('frame_number', models.IntegerField()),
                ('image', models.ImageField(blank=True, null=True, upload_to='legacy_frames')),
                ('suffix', models.CharField(max_length=255)),
                ('video', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='frames', to='endoreg_db.legacyvideo')),
            ],
        ),
        migrations.CreateModel(
            name='LegacyBinaryClassificationAnnotationTask',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_finished', models.BooleanField(default=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_finished', models.DateTimeField(blank=True, null=True)),
                ('image_path', models.CharField(blank=True, max_length=255, null=True)),
                ('labelstudio_project_id', models.IntegerField(blank=True, null=True)),
                ('labelstudio_task_id', models.IntegerField(blank=True, null=True)),
                ('image_type', models.CharField(default='legacy', max_length=255)),
                ('frame', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='binary_classification_annotation_tasks', to='endoreg_db.legacyframe')),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.label')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='labvalue',
            name='default_multiple_categorical_value_distribution',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='default_multiple_categorical_value_distribution', to='endoreg_db.multiplecategoricalvaluedistribution'),
        ),
        migrations.AddField(
            model_name='labvalue',
            name='default_numerical_value_distribution',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='default_numerical_value_distribution', to='endoreg_db.numericvaluedistribution'),
        ),
        migrations.AddField(
            model_name='labvalue',
            name='default_single_categorical_value_distribution',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='default_single_categorical_value_distribution', to='endoreg_db.singlecategoricalvaluedistribution'),
        ),
        migrations.AddField(
            model_name='labvalue',
            name='default_unit',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.unit'),
        ),
        migrations.CreateModel(
            name='LabelVideoSegment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_frame_number', models.IntegerField()),
                ('end_frame_number', models.IntegerField()),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.label')),
                ('prediction_meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='video_segments', to='endoreg_db.videopredictionmeta')),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.informationsource')),
                ('video', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.video')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='label',
            name='label_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='labels', to='endoreg_db.labeltype'),
        ),
        migrations.CreateModel(
            name='ImageClassificationPrediction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.BooleanField()),
                ('confidence', models.FloatField()),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('frame', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_predictions', to='endoreg_db.frame')),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_predictions', to='endoreg_db.label')),
                ('legacy_frame', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_predictions', to='endoreg_db.legacyframe')),
                ('legacy_image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_predictions', to='endoreg_db.legacyimage')),
                ('model_meta', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_predictions', to='endoreg_db.modelmeta')),
            ],
        ),
        migrations.CreateModel(
            name='ImageClassificationAnnotation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.BooleanField()),
                ('annotator', models.CharField(max_length=255)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_modified', models.DateTimeField(auto_now=True)),
                ('frame', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_annotations', to='endoreg_db.frame')),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_annotations', to='endoreg_db.label')),
                ('legacy_frame', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_annotations', to='endoreg_db.legacyframe')),
                ('legacy_image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='image_classification_annotations', to='endoreg_db.legacyimage')),
            ],
        ),
        migrations.AddField(
            model_name='frame',
            name='video',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='frames', to='endoreg_db.video'),
        ),
        migrations.AddField(
            model_name='examiner',
            name='gender',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.gender'),
        ),
        migrations.CreateModel(
            name='ExaminationTimeType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('examinations', models.ManyToManyField(blank=True, to='endoreg_db.examination')),
            ],
            options={
                'verbose_name': 'Examination Time Type',
                'verbose_name_plural': 'Examination Time Types',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ExaminationTime',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('name_de', models.CharField(blank=True, max_length=100, null=True)),
                ('name_en', models.CharField(blank=True, max_length=100, null=True)),
                ('start_time', models.TimeField(blank=True, null=True)),
                ('end_time', models.TimeField(blank=True, null=True)),
                ('time_types', models.ManyToManyField(blank=True, to='endoreg_db.examinationtimetype')),
            ],
            options={
                'verbose_name': 'Examination Time',
                'verbose_name_plural': 'Examination Times',
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='examination',
            name='examination_types',
            field=models.ManyToManyField(blank=True, to='endoreg_db.examinationtype'),
        ),
        migrations.AddField(
            model_name='emissionfactor',
            name='unit',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.unit'),
        ),
        migrations.CreateModel(
            name='CenterWaste',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.IntegerField()),
                ('quantity', models.FloatField()),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('emission_factor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.emissionfactor')),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.unit')),
                ('waste', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.waste')),
            ],
        ),
        migrations.CreateModel(
            name='CenterResource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, null=True)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('quantity', models.FloatField()),
                ('year', models.IntegerField()),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('resource', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.resource')),
                ('transport_emission_factor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='center_resource_transport_emission_factor', to='endoreg_db.emissionfactor')),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.unit')),
                ('use_emission_factor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='center_resource_use_emission_factor', to='endoreg_db.emissionfactor')),
            ],
        ),
        migrations.CreateModel(
            name='CenterProduct',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_used', models.DateField()),
                ('center', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.center')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.product')),
            ],
        ),
        migrations.AddField(
            model_name='center',
            name='first_names',
            field=models.ManyToManyField(related_name='centers', to='endoreg_db.firstname'),
        ),
        migrations.AddField(
            model_name='center',
            name='last_names',
            field=models.ManyToManyField(related_name='centers', to='endoreg_db.lastname'),
        ),
        migrations.CreateModel(
            name='CaseTemplateRule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('name_de', models.CharField(max_length=255, null=True)),
                ('name_en', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('parent_model', models.CharField(blank=True, max_length=255, null=True)),
                ('parent_field', models.CharField(blank=True, max_length=255, null=True)),
                ('target_field', models.CharField(blank=True, max_length=255, null=True)),
                ('target_model', models.CharField(blank=True, max_length=255, null=True)),
                ('rule_values', models.JSONField(blank=True, null=True)),
                ('extra_parameters', models.JSONField(blank=True, null=True)),
                ('chained_rules', models.ManyToManyField(related_name='calling_rules', to='endoreg_db.casetemplaterule')),
                ('date_value_distribution', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.datevaluedistribution')),
                ('multiple_categorical_value_distribution', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.multiplecategoricalvaluedistribution')),
                ('numerical_value_distribution', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.numericvaluedistribution')),
                ('rule_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.casetemplateruletype')),
                ('single_categorical_value_distribution', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.singlecategoricalvaluedistribution')),
                ('value_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.casetemplaterulevaluetype')),
            ],
        ),
        migrations.CreateModel(
            name='CaseTemplate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('rules', models.ManyToManyField(to='endoreg_db.casetemplaterule')),
                ('secondary_rules', models.ManyToManyField(related_name='secondary_rules', to='endoreg_db.casetemplaterule')),
                ('template_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='case_templates', to='endoreg_db.casetemplatetype')),
            ],
        ),
        migrations.CreateModel(
            name='BinaryClassificationAnnotationTask',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_finished', models.BooleanField(default=False)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('date_finished', models.DateTimeField(blank=True, null=True)),
                ('image_path', models.CharField(blank=True, max_length=255, null=True)),
                ('labelstudio_project_id', models.IntegerField(blank=True, null=True)),
                ('labelstudio_task_id', models.IntegerField(blank=True, null=True)),
                ('image_type', models.CharField(default='frame', max_length=255)),
                ('frame', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='binary_classification_annotation_tasks', to='endoreg_db.frame')),
                ('label', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.label')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AglServiceLogEntry',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('ip_address', models.GenericIPAddressField(blank=True, null=True)),
                ('user_agent', models.CharField(blank=True, max_length=256, null=True)),
                ('message', models.TextField()),
                ('json_content', models.JSONField(blank=True, null=True)),
                ('device', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.networkdevice')),
                ('log_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.logtype')),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='endoreg_db.aglservice')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'AGL Service Log Entry',
                'verbose_name_plural': 'AGL Service Log Entries',
            },
        ),
        migrations.AddField(
            model_name='aglservice',
            name='devices',
            field=models.ManyToManyField(related_name='services', to='endoreg_db.networkdevice'),
        ),
        migrations.CreateModel(
            name='ActiveModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('model_meta', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='endoreg_db.modelmeta')),
            ],
        ),
        migrations.AddIndex(
            model_name='legacyframe',
            index=models.Index(fields=['video', 'frame_number'], name='endoreg_db__video_i_e10f1c_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='legacyframe',
            unique_together={('video', 'frame_number')},
        ),
        migrations.AlterUniqueTogether(
            name='imageclassificationprediction',
            unique_together={('label', 'frame', 'model_meta')},
        ),
        migrations.AddIndex(
            model_name='frame',
            index=models.Index(fields=['video', 'frame_number'], name='endoreg_db__video_i_56cc44_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='frame',
            unique_together={('video', 'frame_number')},
        ),
    ]
