/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sources;

import cats.effect.kernel.Async;
import com.github.takezoe.scaladoc.Scaladoc;
import com.jayway.jsonpath.JsonPath;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.GraphBuilder;
import com.raphtory.api.input.Spout;
import com.raphtory.api.input.SpoutBuilderSource;
import com.raphtory.api.input.Type;
import com.raphtory.sources.JSONSource$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.Value$;

@Scaladoc(value="/**\n  * Specific format: NetworkX Node Link Data Format\n  * https://networkx.org/documentation/stable/reference/readwrite/generated/networkx.readwrite.json_graph.node_link_data.html\n  *\n  * This is a generic source to ingest data and build a graph in Raphtory, assuming the data is in Network X JSON node link format,\n  *\n  * You can configure source and target type and edge relationship type when calling this source in your Runner.\n  * You can also configure the key of your time value and edge type value if that exists in your data.\n  * Properties and keys of properties in your NetworkX graph will need to be added manually.\n  *\n  * @param spout state where to ingest your data from (Mandatory field)\n  * @param sourceKey state the key of the source ID in your JSON data (default = \"source\")\n  * @param sourceType state what type of value the source is (default = None)\n  * @param targetKey state the key of the target ID in your JSON data (default = \"target\")\n  * @param targetType state what type of value the target is (default = None)\n  * @param edgeKey state the key of the edge type/relationship in your JSON data (default = None)\n  * @param timeKey state the key of the timestamp in your JSON data (default = 1)\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\u001b7\u0001uB\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0005\u0016\u0005\t1\u0002\u0011\t\u0011)A\u0005+\"A\u0011\f\u0001B\u0001B\u0003%a\t\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003G\u0011!Y\u0006A!A!\u0002\u00131\u0005\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011u\u0003!\u0011!Q\u0001\nyC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\n]\u0002\u0001\r\u00111A\u0005\n=D\u0011\u0002\u001d\u0001A\u0002\u0003\u0007I\u0011B9\t\u0013]\u0004\u0001\u0019!A!B\u00131\u0005\"\u0003=\u0001\u0001\u0004\u0005\r\u0011\"\u0003p\u0011%I\b\u00011AA\u0002\u0013%!\u0010C\u0005}\u0001\u0001\u0007\t\u0011)Q\u0005\r\"9Q\u0010\u0001a\u0001\n\u0013q\b\u0002C@\u0001\u0001\u0004%I!!\u0001\t\u000f\u0005\u0015\u0001\u0001)Q\u0005=\"I\u0011q\u0001\u0001A\u0002\u0013%\u0011\u0011\u0002\u0005\n\u0003'\u0001\u0001\u0019!C\u0005\u0003+A\u0001\"!\u0007\u0001A\u0003&\u00111\u0002\u0005\b\u00037\u0001A\u0011IA\u000f\u000f\u001d\t\tE\u000eE\u0001\u0003\u00072a!\u000e\u001c\t\u0002\u0005\u0015\u0003BB2\u0019\t\u0003\ti\u0005C\u0004\u0002Pa!\t!!\u0015\t\u0013\u0005\u0005\u0004$%A\u0005\u0002\u0005\r\u0004\"CA=1E\u0005I\u0011AA2\u0011%\tY\bGI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002~a\t\n\u0011\"\u0001\u0002d!I\u0011q\u0010\r\u0012\u0002\u0013\u0005\u0011\u0011\u0011\u0005\n\u0003\u000bC\u0012\u0013!C\u0001\u0003\u0003Cq!a\"\u0019\t\u0003\tI\tC\u0005\u0002\u001cb\t\n\u0011\"\u0001\u0002d!I\u0011Q\u0014\r\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003?C\u0012\u0013!C\u0001\u0003GB\u0011\"!)\u0019#\u0003%\t!a\u0019\t\u0013\u0005\r\u0006$%A\u0005\u0002\u0005\u0005\u0005\"CAS1E\u0005I\u0011AAA\u0011\u001d\t9\u000b\u0007C\u0001\u0003SC\u0011\"!/\u0019#\u0003%\t!a\u0019\t\u0013\u0005m\u0006$%A\u0005\u0002\u0005\r\u0004\"CA_1E\u0005I\u0011AA2\u0011%\ty\fGI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002Bb\t\n\u0011\"\u0001\u0002\u0002\"I\u00111\u0019\r\u0012\u0002\u0013\u0005\u0011\u0011\u0011\u0005\n\u0003\u000bD\u0012\u0013!C\u0001\u0003GB\u0011\"a2\u0019#\u0003%\t!a\u0019\t\u0013\u0005%\u0007$%A\u0005\u0002\u0005\r\u0004\"CAf1E\u0005I\u0011AA2\u0011%\ti\rGI\u0001\n\u0003\t\t\tC\u0005\u0002Pb\t\n\u0011\"\u0001\u0002\u0002\nQ!jU(O'>,(oY3\u000b\u0005]B\u0014aB:pkJ\u001cWm\u001d\u0006\u0003si\n\u0001B]1qQR|'/\u001f\u0006\u0002w\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0010\t\u0004\u007f\u00113U\"\u0001!\u000b\u0005\u0005\u0013\u0015!B5oaV$(BA\"9\u0003\r\t\u0007/[\u0005\u0003\u000b\u0002\u0013!c\u00159pkR\u0014U/\u001b7eKJ\u001cv.\u001e:dKB\u0011q\t\u0015\b\u0003\u0011:\u0003\"!\u0013'\u000e\u0003)S!a\u0013\u001f\u0002\rq\u0012xn\u001c;?\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011K\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=c\u0015!B:q_V$X#A+\u0011\u0007}2f)\u0003\u0002X\u0001\n)1\u000b]8vi\u000611\u000f]8vi\u0002\n\u0011b]8ve\u000e,7*Z=\u0002\u0015M|WO]2f)f\u0004X-A\u0005uCJ<W\r^&fs\u0006QA/\u0019:hKR$\u0016\u0010]3\u0002\u000f\u0015$w-Z&fsB\u0019q\f\u0019$\u000e\u00031K!!\u0019'\u0003\r=\u0003H/[8o\u0003\u001d!\u0018.\\3LKf\fa\u0001P5oSRtD\u0003C3hQ&T7\u000e\\7\u0011\u0005\u0019\u0004Q\"\u0001\u001c\t\u000bMK\u0001\u0019A+\t\u000feK\u0001\u0013!a\u0001\r\"9!,\u0003I\u0001\u0002\u00041\u0005bB.\n!\u0003\u0005\rA\u0012\u0005\b9&\u0001\n\u00111\u0001G\u0011\u001di\u0016\u0002%AA\u0002yCqAY\u0005\u0011\u0002\u0003\u0007a,\u0001\u0004t_V\u00148-Z\u000b\u0002\r\u0006Q1o\\;sG\u0016|F%Z9\u0015\u0005I,\bCA0t\u0013\t!HJ\u0001\u0003V]&$\bb\u0002<\f\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\n\u0014aB:pkJ\u001cW\rI\u0001\u0007i\u0006\u0014x-\u001a;\u0002\u0015Q\f'oZ3u?\u0012*\u0017\u000f\u0006\u0002sw\"9aODA\u0001\u0002\u00041\u0015a\u0002;be\u001e,G\u000fI\u0001\u0005if\u0004X-F\u0001_\u0003!!\u0018\u0010]3`I\u0015\fHc\u0001:\u0002\u0004!9a/EA\u0001\u0002\u0004q\u0016!\u0002;za\u0016\u0004\u0013\u0001\u0002;j[\u0016,\"!a\u0003\u0011\t}\u0003\u0017Q\u0002\t\u0004?\u0006=\u0011bAA\t\u0019\n!Aj\u001c8h\u0003!!\u0018.\\3`I\u0015\fHc\u0001:\u0002\u0018!Aa\u000fFA\u0001\u0002\u0004\tY!A\u0003uS6,\u0007%A\u0004ck&dG-\u001a:\u0016\u0005\u0005}\u0001\u0003B \u0002\"\u0019K1!a\tA\u000519%/\u00199i\u0005VLG\u000eZ3sQ\u001d\u0001\u0011qEA\u001e\u0003{\u0001B!!\u000b\u000285\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\t\t$a\r\u0002\u000fQ\f7.\u001a>pK*\u0019\u0011Q\u0007\u001e\u0002\r\u001dLG\u000f[;c\u0013\u0011\tI$a\u000b\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!a\u0010\u0002\u00137{#F\u000b\u0006!A)\u00023\u000b]3dS\u001aL7\r\t4pe6\fGO\u000f\u0011OKR<xN]6YA9{G-\u001a\u0011MS:\\\u0007\u0005R1uC\u00022uN]7bi*\u0001\u0003E\u000b\u0011iiR\u00048OO\u00180]\u0016$xo\u001c:lq:z'oZ\u0018e_\u000e,X.\u001a8uCRLwN\\\u0018ti\u0006\u0014G.Z\u0018sK\u001a,'/\u001a8dK>\u0012X-\u00193xe&$XmL4f]\u0016\u0014\u0018\r^3e_9,Go^8sWbt#/Z1eoJLG/\u001a\u0018kg>twl\u001a:ba\"tcn\u001c3f?2Lgn[0eCR\fg\u0006\u001b;nY*\u0001\u0003E\u000b\u0006!A)\u0002C\u000b[5tA%\u001c\b%\u0019\u0011hK:,'/[2!g>,(oY3!i>\u0004\u0013N\\4fgR\u0004C-\u0019;bA\u0005tG\r\t2vS2$\u0007%\u0019\u0011he\u0006\u0004\b\u000eI5oAI\u000b\u0007\u000f\u001b;pefd\u0003%Y:tk6Lgn\u001a\u0011uQ\u0016\u0004C-\u0019;bA%\u001c\b%\u001b8!\u001d\u0016$xo\u001c:lAa\u0003#jU(OA9|G-\u001a\u0011mS:\\\u0007EZ8s[\u0006$HF\u0003\u0011!U)\u0001\u0003E\u000b\u0011Z_V\u00043-\u00198!G>tg-[4ve\u0016\u00043o\\;sG\u0016\u0004\u0013M\u001c3!i\u0006\u0014x-\u001a;!if\u0004X\rI1oI\u0002*GmZ3!e\u0016d\u0017\r^5p]ND\u0017\u000e\u001d\u0011usB,\u0007e\u001e5f]\u0002\u001a\u0017\r\u001c7j]\u001e\u0004C\u000f[5tAM|WO]2fA%t\u0007%_8ve\u0002\u0012VO\u001c8fe:R\u0001\u0005\t\u0016!3>,\beY1oA\u0005d7o\u001c\u0011d_:4\u0017nZ;sK\u0002\"\b.\u001a\u0011lKf\u0004sN\u001a\u0011z_V\u0014\b\u0005^5nK\u00022\u0018\r\\;fA\u0005tG\rI3eO\u0016\u0004C/\u001f9fAY\fG.^3!S\u001a\u0004C\u000f[1uA\u0015D\u0018n\u001d;tA%t\u0007%_8ve\u0002\"\u0017\r^1/\u0015\u0001\u0002#\u0006\t)s_B,'\u000f^5fg\u0002\ng\u000e\u001a\u0011lKf\u001c\be\u001c4!aJ|\u0007/\u001a:uS\u0016\u001c\b%\u001b8!s>,(\u000f\t(fi^|'o\u001b-!OJ\f\u0007\u000f\u001b\u0011xS2d\u0007E\\3fI\u0002\"x\u000e\t2fA\u0005$G-\u001a3![\u0006tW/\u00197ms:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00119be\u0006l\u0007e\u001d9pkR\u00043\u000f^1uK\u0002:\b.\u001a:fAQ|\u0007%\u001b8hKN$\b%_8ve\u0002\"\u0017\r^1!MJ|W\u000e\t\u0015NC:$\u0017\r^8ss\u00022\u0017.\u001a7eS)\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011t_V\u00148-Z&fs\u0002\u001aH/\u0019;fAQDW\rI6fs\u0002zg\r\t;iK\u0002\u001ax.\u001e:dK\u0002JE\tI5oAe|WO\u001d\u0011K'>s\u0005\u0005Z1uC\u0002BC-\u001a4bk2$\b%\u0010\u0011#g>,(oY3#S)\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011t_V\u00148-\u001a+za\u0016\u00043\u000f^1uK\u0002:\b.\u0019;!if\u0004X\rI8gAY\fG.^3!i\",\u0007e]8ve\u000e,\u0007%[:!Q\u0011,g-Y;mi\u0002j\u0004ET8oK&R\u0001\u0005\t\u0016!\u0001B\f'/Y7!i\u0006\u0014x-\u001a;LKf\u00043\u000f^1uK\u0002\"\b.\u001a\u0011lKf\u0004sN\u001a\u0011uQ\u0016\u0004C/\u0019:hKR\u0004\u0013\n\u0012\u0011j]\u0002Jx.\u001e:!\u0015N{e\n\t3bi\u0006\u0004\u0003\u0006Z3gCVdG\u000fI\u001f!EQ\f'oZ3uE%R\u0001\u0005\t\u0016!\u0001B\f'/Y7!i\u0006\u0014x-\u001a;UsB,\u0007e\u001d;bi\u0016\u0004s\u000f[1uAQL\b/\u001a\u0011pM\u00022\u0018\r\\;fAQDW\r\t;be\u001e,G\u000fI5tA!\"WMZ1vYR\u0004S\b\t(p]\u0016L#\u0002\t\u0011+A\u0001\u0003\u0018M]1nA\u0015$w-Z&fs\u0002\u001aH/\u0019;fAQDW\rI6fs\u0002zg\r\t;iK\u0002*GmZ3!if\u0004Xm\f:fY\u0006$\u0018n\u001c8tQ&\u0004\b%\u001b8!s>,(\u000f\t&T\u001f:\u0003C-\u0019;bA!\"WMZ1vYR\u0004S\b\t(p]\u0016L#\u0002\t\u0011+A\u0001\u0003\u0018M]1nAQLW.Z&fs\u0002\u001aH/\u0019;fAQDW\rI6fs\u0002zg\r\t;iK\u0002\"\u0018.\\3ti\u0006l\u0007\u000fI5oAe|WO\u001d\u0011K'>s\u0005\u0005Z1uC\u0002BC-\u001a4bk2$\b%\u0010\u00112S)\u0001\u0003EK\u0018\u0002\u0015)\u001bvJT*pkJ\u001cW\r\u0005\u0002g1M\u0019\u0001$a\u0012\u0011\u0007}\u000bI%C\u0002\u0002L1\u0013a!\u00118z%\u00164GCAA\"\u0003\u0015\t\u0007\u000f\u001d7z)=)\u00171KA+\u0003/\nI&a\u0017\u0002^\u0005}\u0003\"B*\u001b\u0001\u0004)\u0006bB-\u001b!\u0003\u0005\rA\u0012\u0005\b5j\u0001\n\u00111\u0001G\u0011\u001dY&\u0004%AA\u0002\u0019Cq\u0001\u0018\u000e\u0011\u0002\u0003\u0007a\tC\u0004^5A\u0005\t\u0019\u00010\t\u000f\tT\u0002\u0013!a\u0001=\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0002\u0002f)\u001aa)a\u001a,\u0005\u0005%\u0004\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001dM\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\niGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$S'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\t\u0019IK\u0002_\u0003O\nq\"\u00199qYf$C-\u001a4bk2$HeN\u0001\tMJ|WNR5mKRyQ-a#\u0002\u0010\u0006E\u00151SAK\u0003/\u000bI\n\u0003\u0004\u0002\u000e\u0006\u0002\rAR\u0001\u0005a\u0006$\b\u000eC\u0004ZCA\u0005\t\u0019\u0001$\t\u000fi\u000b\u0003\u0013!a\u0001\r\"91,\tI\u0001\u0002\u00041\u0005b\u0002/\"!\u0003\u0005\rA\u0012\u0005\b;\u0006\u0002\n\u00111\u0001_\u0011\u001d\u0011\u0017\u0005%AA\u0002y\u000b!C\u001a:p[\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u0011bM]8n\r&dW\r\n3fM\u0006,H\u000e\u001e\u00134\u0003I1'o\\7GS2,G\u0005Z3gCVdG\u000f\n\u001b\u0002%\u0019\u0014x.\u001c$jY\u0016$C-\u001a4bk2$H%N\u0001\u0013MJ|WNR5mK\u0012\"WMZ1vYR$c'\u0001\nge>lg)\u001b7fI\u0011,g-Y;mi\u0012:\u0014\u0001\u00044s_6\u0014Vm]8ve\u000e,GcD3\u0002,\u00065\u0016qVAY\u0003g\u000b),a.\t\r\u00055\u0005\u00061\u0001G\u0011\u001dI\u0006\u0006%AA\u0002\u0019CqA\u0017\u0015\u0011\u0002\u0003\u0007a\tC\u0004\\QA\u0005\t\u0019\u0001$\t\u000fqC\u0003\u0013!a\u0001\r\"9Q\f\u000bI\u0001\u0002\u0004q\u0006b\u00022)!\u0003\u0005\rAX\u0001\u0017MJ|WNU3t_V\u00148-\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u00051bM]8n%\u0016\u001cx.\u001e:dK\u0012\"WMZ1vYR$3'\u0001\fge>l'+Z:pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00135\u0003Y1'o\\7SKN|WO]2fI\u0011,g-Y;mi\u0012*\u0014A\u00064s_6\u0014Vm]8ve\u000e,G\u0005Z3gCVdG\u000f\n\u001c\u0002-\u0019\u0014x.\u001c*fg>,(oY3%I\u00164\u0017-\u001e7uI]\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%o\u0001")
public class JSONSource
extends SpoutBuilderSource<String> {
    private final Spout<String> spout;
    private final String sourceKey;
    private final String sourceType;
    private final String targetKey;
    private final String targetType;
    private final Option<String> edgeKey;
    private final Option<String> timeKey;
    private String source;
    private String target;
    private Option<String> type;
    private Option<Object> time;

    public static Option<String> $lessinit$greater$default$7() {
        return JSONSource$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<String> $lessinit$greater$default$6() {
        return JSONSource$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return JSONSource$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return JSONSource$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return JSONSource$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return JSONSource$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<String> fromResource$default$7() {
        return JSONSource$.MODULE$.fromResource$default$7();
    }

    public static Option<String> fromResource$default$6() {
        return JSONSource$.MODULE$.fromResource$default$6();
    }

    public static String fromResource$default$5() {
        return JSONSource$.MODULE$.fromResource$default$5();
    }

    public static String fromResource$default$4() {
        return JSONSource$.MODULE$.fromResource$default$4();
    }

    public static String fromResource$default$3() {
        return JSONSource$.MODULE$.fromResource$default$3();
    }

    public static String fromResource$default$2() {
        return JSONSource$.MODULE$.fromResource$default$2();
    }

    public static JSONSource fromResource(String path, String sourceKey, String sourceType, String targetKey, String targetType, Option<String> edgeKey, Option<String> timeKey) {
        return JSONSource$.MODULE$.fromResource(path, sourceKey, sourceType, targetKey, targetType, edgeKey, timeKey);
    }

    public static Option<String> fromFile$default$7() {
        return JSONSource$.MODULE$.fromFile$default$7();
    }

    public static Option<String> fromFile$default$6() {
        return JSONSource$.MODULE$.fromFile$default$6();
    }

    public static String fromFile$default$5() {
        return JSONSource$.MODULE$.fromFile$default$5();
    }

    public static String fromFile$default$4() {
        return JSONSource$.MODULE$.fromFile$default$4();
    }

    public static String fromFile$default$3() {
        return JSONSource$.MODULE$.fromFile$default$3();
    }

    public static String fromFile$default$2() {
        return JSONSource$.MODULE$.fromFile$default$2();
    }

    public static JSONSource fromFile(String path, String sourceKey, String sourceType, String targetKey, String targetType, Option<String> edgeKey, Option<String> timeKey) {
        return JSONSource$.MODULE$.fromFile(path, sourceKey, sourceType, targetKey, targetType, edgeKey, timeKey);
    }

    public static Option<String> apply$default$7() {
        return JSONSource$.MODULE$.apply$default$7();
    }

    public static Option<String> apply$default$6() {
        return JSONSource$.MODULE$.apply$default$6();
    }

    public static String apply$default$5() {
        return JSONSource$.MODULE$.apply$default$5();
    }

    public static String apply$default$4() {
        return JSONSource$.MODULE$.apply$default$4();
    }

    public static String apply$default$3() {
        return JSONSource$.MODULE$.apply$default$3();
    }

    public static String apply$default$2() {
        return JSONSource$.MODULE$.apply$default$2();
    }

    public static JSONSource apply(Spout<String> spout, String sourceKey, String sourceType, String targetKey, String targetType, Option<String> edgeKey, Option<String> timeKey) {
        return JSONSource$.MODULE$.apply(spout, sourceKey, sourceType, targetKey, targetType, edgeKey, timeKey);
    }

    @Override
    public Spout<String> spout() {
        return this.spout;
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private String target() {
        return this.target;
    }

    private void target_$eq(String x$1) {
        this.target = x$1;
    }

    private Option<String> type() {
        return this.type;
    }

    private void type_$eq(Option<String> x$1) {
        this.type = x$1;
    }

    private Option<Object> time() {
        return this.time;
    }

    private void time_$eq(Option<Object> x$1) {
        this.time = x$1;
    }

    @Override
    public GraphBuilder<String> builder() {
        return new GraphBuilder<String>(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ JSONSource $outer;

            public final <F> F make(Async<F> evidence$1) {
                return (F)GraphBuilder.make$(this, evidence$1);
            }

            public boolean apply$mcZDD$sp(double v1, double v2) {
                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public float apply$mcFDD$sp(double v1, double v2) {
                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public int apply$mcIDD$sp(double v1, double v2) {
                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public long apply$mcJDD$sp(double v1, double v2) {
                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public void apply$mcVDD$sp(double v1, double v2) {
                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public boolean apply$mcZDI$sp(double v1, int v2) {
                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public double apply$mcDDI$sp(double v1, int v2) {
                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public float apply$mcFDI$sp(double v1, int v2) {
                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public int apply$mcIDI$sp(double v1, int v2) {
                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public long apply$mcJDI$sp(double v1, int v2) {
                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public void apply$mcVDI$sp(double v1, int v2) {
                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public boolean apply$mcZDJ$sp(double v1, long v2) {
                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public double apply$mcDDJ$sp(double v1, long v2) {
                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public float apply$mcFDJ$sp(double v1, long v2) {
                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public int apply$mcIDJ$sp(double v1, long v2) {
                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public long apply$mcJDJ$sp(double v1, long v2) {
                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public void apply$mcVDJ$sp(double v1, long v2) {
                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public boolean apply$mcZID$sp(int v1, double v2) {
                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public double apply$mcDID$sp(int v1, double v2) {
                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public float apply$mcFID$sp(int v1, double v2) {
                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public int apply$mcIID$sp(int v1, double v2) {
                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public long apply$mcJID$sp(int v1, double v2) {
                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public void apply$mcVID$sp(int v1, double v2) {
                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public double apply$mcDII$sp(int v1, int v2) {
                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public float apply$mcFII$sp(int v1, int v2) {
                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public long apply$mcJII$sp(int v1, int v2) {
                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public void apply$mcVII$sp(int v1, int v2) {
                Function2.apply$mcVII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public boolean apply$mcZIJ$sp(int v1, long v2) {
                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public double apply$mcDIJ$sp(int v1, long v2) {
                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public float apply$mcFIJ$sp(int v1, long v2) {
                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public int apply$mcIIJ$sp(int v1, long v2) {
                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public long apply$mcJIJ$sp(int v1, long v2) {
                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public void apply$mcVIJ$sp(int v1, long v2) {
                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public boolean apply$mcZJD$sp(long v1, double v2) {
                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public double apply$mcDJD$sp(long v1, double v2) {
                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public float apply$mcFJD$sp(long v1, double v2) {
                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public int apply$mcIJD$sp(long v1, double v2) {
                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public long apply$mcJJD$sp(long v1, double v2) {
                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public void apply$mcVJD$sp(long v1, double v2) {
                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public boolean apply$mcZJI$sp(long v1, int v2) {
                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public double apply$mcDJI$sp(long v1, int v2) {
                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public float apply$mcFJI$sp(long v1, int v2) {
                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public int apply$mcIJI$sp(long v1, int v2) {
                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public long apply$mcJJI$sp(long v1, int v2) {
                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public void apply$mcVJI$sp(long v1, int v2) {
                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public boolean apply$mcZJJ$sp(long v1, long v2) {
                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public double apply$mcDJJ$sp(long v1, long v2) {
                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public float apply$mcFJJ$sp(long v1, long v2) {
                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public int apply$mcIJJ$sp(long v1, long v2) {
                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public long apply$mcJJJ$sp(long v1, long v2) {
                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public void apply$mcVJJ$sp(long v1, long v2) {
                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public Function1<Graph, Function1<String, BoxedUnit>> curried() {
                return Function2.curried$((Function2)this);
            }

            public Function1<Tuple2<Graph, String>, BoxedUnit> tupled() {
                return Function2.tupled$((Function2)this);
            }

            public String toString() {
                return Function2.toString$((Function2)this);
            }

            public final void apply(Graph v1, String v2) {
                this.$outer.com$raphtory$sources$JSONSource$$$anonfun$builder$1(v1, v2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Function2.$init$((Function2)this);
                GraphBuilder.$init$(this);
            }
        };
    }

    public static final /* synthetic */ void $anonfun$builder$2(JSONSource $this, Graph graph$1, Value json) {
        block4: {
            $this.source_$eq(JsonPath.read((String)json.toString(), (String)new StringBuilder(2).append("$.").append($this.sourceKey).toString()).toString());
            $this.target_$eq(JsonPath.read((String)json.toString(), (String)new StringBuilder(2).append("$.").append($this.targetKey).toString()).toString());
            if ($this.timeKey.nonEmpty()) {
                $this.time_$eq((Option<Object>)StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(JsonPath.read((String)json.toString(), (String)new StringBuilder(2).append("$.").append($this.timeKey).toString()).toString())));
            }
            if ($this.edgeKey.nonEmpty()) {
                $this.type_$eq((Option<String>)Option$.MODULE$.apply((Object)JsonPath.read((String)json.toString(), (String)new StringBuilder(2).append("$.").append($this.edgeKey).toString()).toString()));
            }
            long srcID = Graph$.MODULE$.assignID($this.source());
            long dstID = Graph$.MODULE$.assignID($this.target());
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString($this.source()))) {
                graph$1.addVertex(BoxesRunTime.unboxToLong((Object)$this.time().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L)), srcID, new Type($this.sourceType));
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString($this.target()))) {
                graph$1.addVertex(BoxesRunTime.unboxToLong((Object)$this.time().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L)), dstID, new Type($this.targetType));
            }
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString($this.source())) || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString($this.target()))) break block4;
            graph$1.addEdge(BoxesRunTime.unboxToLong((Object)$this.time().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L)), srcID, dstID, new Type((String)$this.type().getOrElse((Function0 & Serializable)() -> "")));
        }
    }

    public final /* synthetic */ void com$raphtory$sources$JSONSource$$$anonfun$builder$1(Graph graph, String jsonString) {
        Seq networkXGraph = ((Value)Value$.MODULE$.apply((Readable)Readable$.MODULE$.fromString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(jsonString))))).obj().values().toSeq();
        ((Value)networkXGraph.apply(4)).arr().map((Function1 & Serializable)json -> {
            JSONSource.$anonfun$builder$2(this, graph, json);
            return BoxedUnit.UNIT;
        });
    }

    public JSONSource(Spout<String> spout, String sourceKey, String sourceType, String targetKey, String targetType, Option<String> edgeKey, Option<String> timeKey) {
        this.spout = spout;
        this.sourceKey = sourceKey;
        this.sourceType = sourceType;
        this.targetKey = targetKey;
        this.targetType = targetType;
        this.edgeKey = edgeKey;
        this.timeKey = timeKey;
        this.type = None$.MODULE$;
        this.time = None$.MODULE$;
    }
}

