/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.storage.arrow.entities;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.visitor.ConcreteExplodedEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.HistoricEvent;
import com.raphtory.api.analysis.visitor.PropertyValue;
import com.raphtory.api.analysis.visitor.ReducedEdge;
import com.raphtory.arrowcore.model.Edge;
import com.raphtory.arrowcore.model.Entity;
import com.raphtory.arrowcore.model.PropertySchema;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.internals.components.querymanager.VertexMessage;
import com.raphtory.internals.storage.arrow.ArrowEntityStateRepository;
import com.raphtory.internals.storage.arrow.entities.ArrowExEntity;
import java.io.Serializable;
import java.util.Collection;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\n\u0015\u0001\u0005B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005k!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003?\u0011!9\u0005A!b\u0001\n#A\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000b9\u0003A\u0011A(\t\u000bQ\u0003A\u0011I+\u0006\t)\u0004\u0001%\u000e\u0005\u0006W\u0002!\t\u0005\u000e\u0005\u0006u\u0002!\t\u0005\u000e\u0005\u0006}\u0002!\te \u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\u000b\u0001\t\u0003\ni#\u0002\u0004\u0002:\u0001\u0001\u00131\b\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u0019\t\t\u0006\u0001C!+\nY\u0011I\u001d:po\u0016CX\tZ4f\u0015\t)b#\u0001\u0005f]RLG/[3t\u0015\t9\u0002$A\u0003beJ|wO\u0003\u0002\u001a5\u000591\u000f^8sC\u001e,'BA\u000e\u001d\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002\u001e=\u0005A!/\u00199ii>\u0014\u0018PC\u0001 \u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001!\u0005L\u0018\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013a\u0002<jg&$xN\u001d\u0006\u0003O!\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003Sq\t1!\u00199j\u0013\tYCEA\u0007F]RLG/\u001f,jg&$xN\u001d\t\u0003G5J!A\f\u0013\u0003\u0017I+G-^2fI\u0016#w-\u001a\t\u0003aEj\u0011\u0001F\u0005\u0003eQ\u0011Q\"\u0011:s_^,\u00050\u00128uSRL\u0018AA%E+\u0005)\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$\u0001\u0002'p]\u001e\f1!\u0013#!\u0003\u0011)GmZ3\u0016\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u000b5|G-\u001a7\u000b\u0005\rc\u0012!C1se><8m\u001c:f\u0013\t)\u0005I\u0001\u0003FI\u001e,\u0017!B3eO\u0016\u0004\u0013\u0001\u0002:fa>,\u0012!\u0013\t\u0003\u0015.k\u0011AF\u0005\u0003\u0019Z\u0011!$\u0011:s_^,e\u000e^5usN#\u0018\r^3SKB|7/\u001b;pef\fQA]3q_\u0002\na\u0001P5oSRtD\u0003\u0002)R%N\u0003\"\u0001\r\u0001\t\u000bM:\u0001\u0019A\u001b\t\u000bq:\u0001\u0019\u0001 \t\u000b\u001d;\u0001\u0019A%\u0002\u0017\u001d,Go\u0015;bi\u0016\u001cV\r\u001e\u000b\u0002-B\u0019qk\u00182\u000f\u0005akfBA-]\u001b\u0005Q&BA.!\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002_o\u00059\u0001/Y2lC\u001e,\u0017B\u00011b\u0005\u0011a\u0015n\u001d;\u000b\u0005y;\u0004CA2h\u001d\t!W\r\u0005\u0002Zo%\u0011amN\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002go\t1\u0011\n\u0012+za\u0016\f1a\u001d:dQ\u0011QQn\u001e=\u0011\u00059,X\"A8\u000b\u0005A\f\u0018\u0001C:dC2\fGm\\2\u000b\u0005I\u001c\u0018a\u0002;bW\u0016Tx.\u001a\u0006\u0003iz\taaZ5uQV\u0014\u0017B\u0001<p\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%A=\u0002U=R#\u0006I%EA=4\u0007\u0005\u001e5fAM|WO]2fAY,'\u000f^3yA=4\u0007\u0005\u001e5fA\u0015$w-\u001a\u0011+_\u0005\u0019Am\u001d;)\t-iw\u000f`\u0011\u0002{\u0006ysF\u000b\u0016!\u0013\u0012\u0003sN\u001a\u0011uQ\u0016\u0004C-Z:uS:\fG/[8oAY,'\u000f^3yA=4\u0007\u0005\u001e5fA\u0015$w-\u001a\u0011+_\u00051!/Z7pm\u0016$\"!!\u0001\u0011\u0007Y\n\u0019!C\u0002\u0002\u0006]\u0012A!\u00168ji\"*A\"\\<\u0002\n\u0005\u0012\u00111B\u00014_)R\u0003ER5mi\u0016\u0014\b\u0005\u001e5fA\u0015$w-\u001a\u0011ge>l\u0007\u0005\u001e5fA\u0001<%/\u00199i!\u0016\u00148\u000f]3di&4X\r\u0019\u0018!U=\nAa]3oIR!\u0011\u0011AA\t\u0011\u001d\t\u0019\"\u0004a\u0001\u0003+\tA\u0001Z1uCB\u0019a'a\u0006\n\u0007\u0005eqGA\u0002B]fDS!D7x\u0003;\t#!a\b\u0002y>R#\u0006I*f]\u0012\u0004\u0013\rI7fgN\fw-\u001a\u0011u_\u0002\"\b.\u001a\u0011wKJ$X\r\u001f\u0011d_:tWm\u0019;fI\u0002zg\u000e\t;iK\u0002zG\u000f[3sAMLG-\u001a\u0011pM\u0002\"\b.\u001a\u0011fI\u001e,'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\"\u0017\r^1!\u001b\u0016\u001c8/Y4fA\u0011\fG/\u0019\u0011u_\u0002\u001aXM\u001c3\u000bA\u0001\u0002\u0003EK\u0018\u0002\r\u0015tG/\u001b;z+\t\t)\u0003E\u0002@\u0003OI1!!\u000bA\u0005\u0019)e\u000e^5us\u0006Q1\r\\3beN#\u0018\r^3\u0015\t\u0005\u0005\u0011q\u0006\u0005\u0007\u0003cy\u0001\u0019\u00012\u0002\u0007-,\u0017\u0010K\u0003\u0010[^\f)$\t\u0002\u00028\u0005ItF\u000b\u0016!%\u0016lwN^3!C:\u0004SM\u001c;ss\u0002Jg\u000e\t;iK\u0002*g\u000e^5us\u001e\u001a\b%\u00197h_JLG\u000f[7jG\u0002\u001aH/\u0019;f]\u0001RsF\u0001\u0007FqBdw\u000eZ3e\u000b\u0012<W\r\u0005\u0003$\u0003{)\u0014bAA I\t!2i\u001c8de\u0016$X-\u0012=qY>$W\rZ#eO\u0016\fq!\u001a=qY>$W\r\u0006\u0002\u0002FA!qkXA$!\r\tI\u0005E\u0007\u0002\u0001!*\u0011#\\<\u0002N\u0005\u0012\u0011qJ\u0001k_)R\u0003EU3ukJt\u0007%\u00198!7n+\u0005\u0010\u001d7pI\u0016$W\tZ4f;v\u0003\u0013N\\:uC:\u001cW\r\t4pe\u0002*\u0017m\u00195!i&lW\r\t;iK\u0002*GmZ3!SNT\u0001\u0005\t\u0011!U\u0001\n7\r^5wK\u0002Jg\u000e\t;iK\u0002\u001aWO\u001d:f]R\u0004c/[3x])\u0001\u0003\u0005\t\u0011+_\u0005qq-\u001a;Qe>\u0004XM\u001d;z'\u0016$\b&\u0002\nno\u0006U\u0013EAA,\u0003\u0011{#F\u000b\u0011SKR,(O\u001c\u0011bA1L7\u000f\u001e\u0011pM\u0002ZW-_:!M>\u0014\b%\u0019<bS2\f'\r\\3!aJ|\u0007/\u001a:uS\u0016\u001c\bEZ8sAQDW\rI3oi&$\u0018\u0010\t\u00160\u0001")
public class ArrowExEdge
extends EntityVisitor
implements ReducedEdge,
ArrowExEntity {
    private final long ID;
    private final Edge edge;
    private final ArrowEntityStateRepository repo;

    @Override
    @Scaladoc(value="/** Return the type of the entity */")
    public String Type() {
        return ArrowExEntity.Type$(this);
    }

    @Override
    @Scaladoc(value="/** Return the next event (addition or deletion) after the given timestamp `time` as an\n    * [[com.raphtory.api.analysis.visitor.HistoricEvent HistoricEvent]]. This is wrapped in an option as\n    * it is possible that no activity occurred after the given time. An optional `strict` Boolean argument is also\n    * available which allows events exactly at the given time to be returned if set to `false`.\n    *\n    * @param time   The time after which to return the next occurring event\n    * @param strict Whether events occurring exactly at the given time should be excluded or not\n    * @return an optional historic event containing the event if one exists\n    */")
    public Option<HistoricEvent> firstActivityAfter(long time, boolean strict) {
        return ArrowExEntity.firstActivityAfter$(this, time, strict);
    }

    @Override
    @Scaladoc(value="/** Return the last event (addition or deletion) before the given timestamp `time` as an\n    * [[com.raphtory.api.analysis.visitor.HistoricEvent HistoricEvent]].  The result is wrapped in an option as it is\n    * possible that no activity occurred before the given time. An optional `strict` Boolean argument is also\n    * available which allows events exactly at the given time to be returned if set to `false`.\n    *\n    * @param time   The time before which to return the latest occurring event\n    * @param strict Whether events occurring exactly at the given time should be excluded or not\n    * @return an optional historic event containing the event if one exists\n    */")
    public Option<HistoricEvent> lastActivityBefore(long time, boolean strict) {
        return ArrowExEntity.lastActivityBefore$(this, time, strict);
    }

    @Override
    @Scaladoc(value="/** Return the most recent event (addition or deletion) in the current view as a\n    * [[com.raphtory.api.analysis.visitor.HistoricEvent HistoricEvent]]\n    */")
    public HistoricEvent latestActivity() {
        return ArrowExEntity.latestActivity$(this);
    }

    @Override
    @Scaladoc(value="/** Return the first event (addition or deltion) in the current view as a\n    * [[com.raphtory.api.analysis.visitor.HistoricEvent HistoricEvent]]\n    */")
    public HistoricEvent earliestActivity() {
        return ArrowExEntity.earliestActivity$(this);
    }

    @Override
    @Scaladoc(value="/** Returns a history of values for the property `key`. Returns `None` if no property with name `key` exists.\n    * Otherwise returns a list of `(timestamp, value)` tuples (which may be empty).\n    *\n    * The exact behaviour depends on the type of the property:\n    *\n    * In case of a\n    * [[com.raphtory.api.input.ImmutableString]], the history\n    * depends only on the creation time of the property. If the property was created within the current view, the\n    * history contains a single tuple with the value of the property and the timestamp given by the creation time\n    * of the property. If the property creation time is before the start of the current view, the history contains\n    * a single tuple with the value of the property and the timestamp given by the start time of the current view.\n    * If the property creation time is after the end of the current view, the history is empty.\n    *\n    * For the other property types, the history contains\n    * the timestamps and values for all addition events within the current view and is empty if the property exists\n    * but no addition events occurred in the current view.\n    *\n    * @note More property types with different value semantics are likely going to be added in the future.\n    * @param key    Name of property\n    * @param after  Only consider addition events in the current view that happened no earlier than time `after`\n    * @param before Only consider addition events in the current view that happened no later than time `before`\n    */")
    public <T> Option<Iterable<PropertyValue<T>>> getPropertyHistory(String key, long after, long before) {
        return ArrowExEntity.getPropertyHistory$(this, key, after, before);
    }

    @Override
    @Scaladoc(value="/**\n    * check if the property is field or versioned property\n    * @param key\n    * @return\n    */")
    public boolean isField(String key) {
        return ArrowExEntity.isField$(this, key);
    }

    @Override
    @Scaladoc(value="/** Set algorithmic state for this entity. Note that for edges, algorithmic state is stored locally to the vertex endpoint\n    * which sets this state (default being the source node when set during an edge step).\n    *\n    * @param key   key to use for setting value\n    * @param value new value for state\n    */")
    public void setState(String key, Object value) {
        ArrowExEntity.setState$(this, key, value);
    }

    @Override
    @Scaladoc(value="/** Retrieve value from algorithmic state. Note that for edges, algorithmic state is stored locally to the vertex endpoint\n    * which sets this state (default being the source node when set during an edge step).\n    *\n    * @tparam `T` value type for state\n    * @param key               key to use for retrieving state\n    * @param includeProperties set this to `true` to fall-through to vertex properties if `key` is not found\n    */")
    public <T> T getState(String key, boolean includeProperties) {
        return (T)ArrowExEntity.getState$(this, key, includeProperties);
    }

    @Override
    @Scaladoc(value="/** Retrieve value from algorithmic state if it exists or return a default value otherwise. Note that for edges,\n    * algorithmic state is stored locally to the vertex endpoint which set this state (default being the source node\n    * when set during an edge step).\n    *\n    * @tparam `T` value type for state\n    * @param key               key to use for retrieving state\n    * @param value             default value to return if state does not exist\n    * @param includeProperties set this to `true` to fall-through to entity properties\n    *                          if `key` is not found in algorithmic state\n    */")
    public <T> T getStateOrElse(String key, T value, boolean includeProperties) {
        return (T)ArrowExEntity.getStateOrElse$(this, key, value, includeProperties);
    }

    @Override
    @Scaladoc(value="/** Checks if algorithmic state with key `key` exists. Note that for edges, algorithmic state is stored locally to\n    * the vertex endpoint which set this state (default being the source node when set during an edge step).\n    *\n    * @param key               state key to check\n    * @param includeProperties Set this to `true` to fall-through to vertex properties if `key` is not found.\n    *                          If set, this function only returns `false` if `key` is not included in either algorithmic state\n    *                          or entity properties\n    */")
    public boolean containsState(String key, boolean includeProperties) {
        return ArrowExEntity.containsState$(this, key, includeProperties);
    }

    @Override
    @Scaladoc(value="/** Retrieve value from algorithmic state if it exists or set this state to a default value and return otherwise. Note that for edges,\n    * algorithmic state is stored locally to the vertex endpoint which set this state (default being the source node\n    * when set during an edge step).\n    *\n    * @tparam `T` value type for state\n    * @param key               key to use for retrieving state\n    * @param value             default value to set and return if state does not exist\n    * @param includeProperties set this to `true` to fall-through to vertex properties\n    *                          if `key` is not found in algorithmic state. State is only set if this is also not found.\n    */")
    public <T> T getOrSetState(String key, T value, boolean includeProperties) {
        return (T)ArrowExEntity.getOrSetState$(this, key, value, includeProperties);
    }

    @Override
    @Scaladoc(value="/** Append new value to existing array or initialise new array if state does not exist. Note that for edges,\n    * algorithmic state is stored locally to the vertex endpoint which set this state (default being the source node\n    * when set during an edge step).\n    * The value type of the state is assumed to be `Array[T]` if the state already exists.\n    *\n    * @tparam `T` value type for state (needs to have a `ClassTag` available due to Scala `Array` implementation)\n    * @param key   key to use for retrieving state\n    * @param value value to append to state\n    */")
    public <T> void appendToState(String key, T value, ClassTag<T> evidence$1) {
        ArrowExEntity.appendToState$(this, key, value, evidence$1);
    }

    @Override
    public List<HistoricEvent> history() {
        return ArrowExEntity.history$(this);
    }

    @Override
    @Scaladoc(value="/** Return `true` if any event (addition or deletion) occurred during the time window starting at\n    * `after` and ending at `before`. Otherwise returns `false`.\n    *\n    * @param after  inclusive lower bound for the time window (defaults to oldest data point)\n    * @param before inclusive upper bound for the time window (defaults to newest data point)\n    */")
    public boolean active(long after, long before) {
        return ArrowExEntity.active$(this, after, before);
    }

    @Override
    @Scaladoc(value="/** Check if the entity is currently alive (i.e, the last event was an addition) at time `time`.\n    *\n    * @param time   time point to check\n    * @param window If a value for `window` is given, the entity is considered as having been deleted if more\n    *               than `window` time has passed since the last addition event.\n    */")
    public boolean aliveAt(long time, long window) {
        return ArrowExEntity.aliveAt$(this, time, window);
    }

    @Override
    @Scaladoc(value="/** `true` if the edge is an out-edge */")
    public boolean isOutgoing() {
        return com.raphtory.api.analysis.visitor.Edge.isOutgoing$(this);
    }

    @Override
    @Scaladoc(value="/** `true` if the edge is an in-edge */")
    public boolean isIncoming() {
        return com.raphtory.api.analysis.visitor.Edge.isIncoming$(this);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge using a custom merge strategy\n    *\n    * @tparam A value type for the edge weight property (if `mergeStrategy` is not given, this needs to be a numeric type)\n    * @tparam B return type of the merge strategy (only specify if using a custom merge strategy)\n    *\n    * @param weightProperty  edge property to use for computing edge weight\n    * @param mergeStrategy merge strategy to use for converting property history to edge weight\n    *                      (see [[PropertyMergeStrategy]] for predefined options or provide custom function). By default this returns the\n    *                      sum of property values.\n    * @param default default value for the weight property before applying the merge strategy.\n    *                This defaults to `1` if `A` is a numeric type. This default value is applied before applying the\n    *                merge strategy. In the case where, e.g., `mergeStrategy =  PropertyMergeStrategy.sum[A]`, the\n    *                computed weight is the number of times the edge was active in the current view if the weight\n    *                property is not found.\n    */")
    public <A, B> B weight(String weightProperty, Function1<Iterable<PropertyValue<A>>, B> mergeStrategy, A a) {
        return (B)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, weightProperty, mergeStrategy, a);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge using a custom merge strategy\n    *\n    * @tparam A value type for the edge weight property (this needs to be a numeric type)\n    * @tparam B return type of the merge strategy (only specify if using a custom merge strategy)\n    *\n    *  @param weightProperty  edge property to use for computing edge weight\n    *  @param mergeStrategy merge strategy to use for converting property history to edge weight\n    *                       (see [[PropertyMergeStrategy]]\n    *                       for predefined options or provide custom function). By default this returns the\n    *                       sum of property values.\n    */")
    public <A, B> B weight(String weightProperty, Function1<Iterable<PropertyValue<A>>, B> mergeStrategy, Numeric<A> evidence$1) {
        return (B)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, weightProperty, mergeStrategy, evidence$1);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge using a custom merge strategy\n    *\n    * @tparam A value type for the edge weight property (if `mergeStrategy` is not given, this needs to be a numeric type)\n    * @tparam B return type of the merge strategy (only specify if using a custom merge strategy)\n    *\n    *  @param mergeStrategy merge strategy to use for converting property history to edge weight\n    *                       (see [[PropertyMergeStrategy]]\n    *                       for predefined options or provide custom function). By default this returns the\n    *                       sum of property values.\n    */")
    public <A, B> B weight(Function1<Iterable<PropertyValue<A>>, B> mergeStrategy, Numeric<A> evidence$2) {
        return (B)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, mergeStrategy, evidence$2);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    *\n    *  @param weightProperty  edge property to use for computing edge weight\n    *  @param default default value for the weight property before applying the merge strategy.\n    *                 This defaults to `1`.\n    */")
    public <A> A weight(String weightProperty, A a, Numeric<A> evidence$3) {
        return (A)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, weightProperty, a, evidence$3);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    *\n    *  @param default default value for the weight property before applying the merge strategy. This defaults to `1`.\n    */")
    public <A> A weight(A a, Numeric<A> evidence$4) {
        return (A)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, a, evidence$4);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    * @param weightProperty  edge property to use for computing edge weight\n    */")
    public <A> A weight(String weightProperty, Numeric<A> evidence$5) {
        return (A)com.raphtory.api.analysis.visitor.Edge.weight$((com.raphtory.api.analysis.visitor.Edge)this, weightProperty, evidence$5);
    }

    @Override
    @Scaladoc(value="/** Compute the weight of the edge by sum\n    *\n    * @tparam A value type for the edge weight property - this needs to be a numeric type\n    */")
    public <A> A weight(Numeric<A> evidence$6) {
        return (A)com.raphtory.api.analysis.visitor.Edge.weight$(this, evidence$6);
    }

    @Override
    public <A, B> String weight$default$1() {
        return com.raphtory.api.analysis.visitor.Edge.weight$default$1$(this);
    }

    public long ID() {
        return this.ID;
    }

    public Edge edge() {
        return this.edge;
    }

    @Override
    public ArrowEntityStateRepository repo() {
        return this.repo;
    }

    @Override
    public List<String> getStateSet() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Scaladoc(value="/** ID of the source vertex of the edge */")
    public long src() {
        return !this.edge().isSrcGlobal() ? this.repo().asGlobal(this.edge().getSrcVertex()) : this.edge().getSrcVertex();
    }

    @Scaladoc(value="/** ID of the destination vertex of the edge */")
    public long dst() {
        return !this.edge().isDstGlobal() ? this.repo().asGlobal(this.edge().getDstVertex()) : this.edge().getDstVertex();
    }

    @Override
    @Scaladoc(value="/** Filter the edge from the `GraphPerspective`. */")
    public void remove() {
        this.repo().removeEdge(this.edge().getGlobalId());
    }

    @Override
    @Scaladoc(value="/** Send a message to the vertex connected on the other side of the edge\n    *\n    * @param data Message data to send\n    */")
    public void send(Object data) {
        this.repo().sendMessage(new VertexMessage<Object, Long>(this.repo().superStep() + 1, BoxesRunTime.boxToLong((long)this.ID()), data, SchemaProviderInstances$.MODULE$.genericSchemaProvider()));
    }

    @Override
    public Entity entity() {
        return this.edge();
    }

    @Override
    @Scaladoc(value="/** Remove an entry in the entity's algorithmic state. */")
    public void clearState(String key) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Scaladoc(value="/** Return an [[ExplodedEdge]] instance for each time the edge is\n    * active in the current view.\n    */")
    public List<ConcreteExplodedEdge<Object>> explode() {
        return package$.MODULE$.List().empty();
    }

    @Override
    @Scaladoc(value="/** Return a list of keys for available properties for the entity */")
    public List<String> getPropertySet() {
        PropertySchema schema = this.edge().getRaphtory().getPropertySchema();
        Iterable versioned = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)schema.versionedEdgeProperties()).asScala().map((Function1 & Serializable)x$1 -> x$1.name());
        Iterable nonVersioned = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)schema.nonversionedEdgeProperties()).asScala().map((Function1 & Serializable)x$2 -> x$2.name());
        return ((IterableOnceOps)versioned.$plus$plus((IterableOnce)nonVersioned)).toList();
    }

    public ArrowExEdge(long ID, Edge edge, ArrowEntityStateRepository repo) {
        this.ID = ID;
        this.edge = edge;
        this.repo = repo;
        com.raphtory.api.analysis.visitor.Edge.$init$(this);
        ArrowExEntity.$init$(this);
    }
}

