/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.serialisers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public class DependencyFinder {
    private static final byte CONSTANT_Utf8 = 1;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_FieldRef = 9;
    private static final byte CONSTANT_MethodRef = 10;
    private static final byte CONSTANT_InterfaceMethodRef = 11;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_MethodHandle = 15;
    private static final byte CONSTANT_MethodType = 16;
    private static final byte CONSTANT_InvokeDynamic = 18;

    public static Set<Class<?>> getDependencies(Class<?> clazz, byte[] byArray) throws IOException, ClassNotFoundException {
        Set<String> set = DependencyFinder.getDependencies(ByteBuffer.wrap(byArray));
        HashSet hashSet = new HashSet(set.size());
        ClassLoader classLoader = clazz.getClassLoader();
        for (String string : set) {
            hashSet.add(Class.forName(string, false, classLoader));
        }
        hashSet.remove(clazz);
        return hashSet;
    }

    public static Set<String> getDependencies(ByteBuffer byteBuffer) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (byteBuffer.getInt() != -889275714) {
            throw new IllegalArgumentException("Not a class file");
        }
        byteBuffer.position(8);
        int n6 = byteBuffer.getChar();
        BitSet bitSet = new BitSet(n6);
        BitSet bitSet2 = new BitSet(n6);
        block17: for (n5 = 1; n5 < n6; ++n5) {
            switch (byteBuffer.get()) {
                case 1: {
                    byteBuffer.position(byteBuffer.getChar() + byteBuffer.position());
                    continue block17;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 18: {
                    byteBuffer.position(byteBuffer.position() + 4);
                    continue block17;
                }
                case 5: 
                case 6: {
                    byteBuffer.position(byteBuffer.position() + 8);
                    ++n5;
                    continue block17;
                }
                case 8: {
                    byteBuffer.position(byteBuffer.position() + 2);
                    continue block17;
                }
                case 12: {
                    byteBuffer.position(byteBuffer.position() + 2);
                }
                case 16: {
                    bitSet2.set(byteBuffer.getChar());
                    continue block17;
                }
                case 7: {
                    bitSet.set(byteBuffer.getChar());
                    continue block17;
                }
                case 15: {
                    byteBuffer.position(byteBuffer.position() + 3);
                    continue block17;
                }
                default: {
                    throw new IllegalArgumentException("constant pool item type " + (byteBuffer.get(byteBuffer.position() - 1) & 0xFF));
                }
            }
        }
        byteBuffer.position(byteBuffer.position() + 6);
        byteBuffer.position(byteBuffer.getChar() * 2 + byteBuffer.position());
        for (n5 = 0; n5 < 2; ++n5) {
            n4 = byteBuffer.getChar();
            for (n3 = 0; n3 < n4; ++n3) {
                byteBuffer.position(byteBuffer.position() + 4);
                bitSet2.set(byteBuffer.getChar());
                n2 = byteBuffer.getChar();
                for (n = 0; n < n2; ++n) {
                    byteBuffer.position(byteBuffer.position() + 2);
                    byteBuffer.position(byteBuffer.getInt() + byteBuffer.position());
                }
            }
        }
        byteBuffer.position(10);
        HashSet<String> hashSet = new HashSet<String>();
        block21: for (n4 = 1; n4 < n6; ++n4) {
            switch (byteBuffer.get()) {
                case 1: {
                    n3 = byteBuffer.getChar();
                    n2 = byteBuffer.position();
                    n = bitSet2.get(n4);
                    if (bitSet.get(n4)) {
                        if (byteBuffer.get(byteBuffer.position()) == 91) {
                            n = 1;
                        } else {
                            DependencyFinder.addName(hashSet, byteBuffer, n2, n3);
                        }
                    }
                    if (n != 0) {
                        DependencyFinder.addNames(hashSet, byteBuffer, n2, n3);
                    }
                    byteBuffer.position(n2 + n3);
                    continue block21;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    byteBuffer.position(byteBuffer.position() + 4);
                    continue block21;
                }
                case 5: 
                case 6: {
                    byteBuffer.position(byteBuffer.position() + 8);
                    ++n4;
                    continue block21;
                }
                case 7: 
                case 8: 
                case 16: {
                    byteBuffer.position(byteBuffer.position() + 2);
                    continue block21;
                }
                case 15: {
                    byteBuffer.position(byteBuffer.position() + 3);
                    continue block21;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return hashSet;
    }

    private static void addName(HashSet<String> hashSet, ByteBuffer byteBuffer, int n, int n2) {
        int n3;
        StringBuilder stringBuilder;
        int n4;
        block3: {
            n4 = n + n2;
            stringBuilder = new StringBuilder(n2);
            while (n < n4) {
                n3 = byteBuffer.get(n);
                if (n3 >= 0) {
                    stringBuilder.append((char)(n3 == 47 ? 46 : n3));
                    ++n;
                    continue;
                }
                break block3;
            }
            hashSet.add(stringBuilder.toString());
            return;
        }
        n3 = byteBuffer.limit();
        int n5 = stringBuilder.length();
        byteBuffer.limit(n4).position(n);
        stringBuilder.append(StandardCharsets.UTF_8.decode(byteBuffer));
        byteBuffer.limit(n3);
        int n6 = stringBuilder.length();
        for (int i = n5; i < n6; ++i) {
            if (stringBuilder.charAt(i) != '/') continue;
            stringBuilder.setCharAt(i, '.');
        }
        hashSet.add(stringBuilder.toString());
    }

    private static void addNames(HashSet<String> hashSet, ByteBuffer byteBuffer, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            if (byteBuffer.get(n) == 76) {
                int n4 = n + 1;
                while (byteBuffer.get(n4) != 59) {
                    ++n4;
                }
                DependencyFinder.addName(hashSet, byteBuffer, n + 1, n4 - n - 1);
                n = n4;
            }
            ++n;
        }
    }
}

