/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.graph;

import com.raphtory.api.analysis.graphview.Alignment$;
import com.raphtory.api.time.DiscreteInterval;
import com.raphtory.api.time.Interval;
import com.raphtory.internals.components.querymanager.NullPointSet$;
import com.raphtory.internals.components.querymanager.PointPath;
import com.raphtory.internals.components.querymanager.PointSet;
import com.raphtory.internals.components.querymanager.Query;
import com.raphtory.internals.components.querymanager.SinglePoint;
import com.raphtory.internals.graph.Perspective;
import com.raphtory.internals.graph.PerspectiveController;
import com.raphtory.internals.time.TimeConverters$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class PerspectiveController$ {
    public static final PerspectiveController$ MODULE$ = new PerspectiveController$();
    private static final long DEFAULT_PERSPECTIVE_TIME = -1L;
    private static final Some<Interval> DEFAULT_PERSPECTIVE_WINDOW = new Some((Object)new DiscreteInterval(-1L));
    private static final Logger logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(MODULE$.getClass()));

    public final long DEFAULT_PERSPECTIVE_TIME() {
        return DEFAULT_PERSPECTIVE_TIME;
    }

    public final Some<Interval> DEFAULT_PERSPECTIVE_WINDOW() {
        return DEFAULT_PERSPECTIVE_WINDOW;
    }

    private Logger logger() {
        return logger;
    }

    public PerspectiveController apply(long firstAvailableTimestamp, long lastAvailableTimestamp, Query query) {
        PerspectiveController perspectiveController;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(0).append("Defining perspective list using: ").append(new StringBuilder(28).append("firstAvailableTimestamp='").append(firstAvailableTimestamp).append("', ").toString()).append(new StringBuilder(27).append("lastAvailableTimestamp='").append(lastAvailableTimestamp).append("', ").toString()).append(new StringBuilder(8).append("query='").append(query).append("'").toString()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (firstAvailableTimestamp > lastAvailableTimestamp || query.timelineStart() > query.timelineEnd()) {
            perspectiveController = new PerspectiveController((LazyList[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(LazyList.class)));
        } else if (query.timelineStart() > lastAvailableTimestamp || query.timelineEnd() < firstAvailableTimestamp) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("first/last available timestamps [{}, {}] outside of query timeline [{}, {}]", new Object[]{BoxesRunTime.boxToLong((long)firstAvailableTimestamp), BoxesRunTime.boxToLong((long)lastAvailableTimestamp), BoxesRunTime.boxToLong((long)query.timelineStart()), BoxesRunTime.boxToLong((long)query.timelineEnd())});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            perspectiveController = new PerspectiveController((LazyList[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(LazyList.class)));
        } else {
            Seq<LazyList<Perspective>> seq;
            PointSet pointSet = query.points();
            if (NullPointSet$.MODULE$.equals(pointSet)) {
                seq = this.perspectivesFromTimestamps(query.timelineStart(), query.timelineEnd(), (LazyList<Object>)((LazyList)package$.MODULE$.LazyList().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(query.timelineEnd()), lastAvailableTimestamp)}))), (Seq<Interval>)((Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)), Alignment$.MODULE$.END(), query.datetimeQuery());
            } else if (pointSet instanceof SinglePoint) {
                SinglePoint singlePoint = (SinglePoint)pointSet;
                long time = singlePoint.time();
                seq = this.perspectivesFromTimestamps(query.timelineStart(), query.timelineEnd(), (LazyList<Object>)((LazyList)package$.MODULE$.LazyList().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{time}))), (Seq<Interval>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)query.windows()), query.windowAlignment(), query.datetimeQuery());
            } else if (pointSet instanceof PointPath) {
                PointPath pointPath = (PointPath)pointSet;
                Interval increment = pointPath.increment();
                Option<Object> pathStart = pointPath.start();
                Option<Object> pathEnd = pointPath.end();
                long start = BoxesRunTime.unboxToLong((Object)pathStart.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(query.timelineStart()), firstAvailableTimestamp)));
                long end = BoxesRunTime.unboxToLong((Object)pathEnd.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(query.timelineEnd()), lastAvailableTimestamp)));
                LazyList timestamps = package$.MODULE$.LazyList().iterate((Function0)(JFunction0.mcJ.sp & Serializable)() -> start, (Function1)(JFunction1.mcJJ.sp & Serializable)x$4 -> TimeConverters$.MODULE$.TimeHolder(x$4).$plus(increment)).takeWhile((Function1)(JFunction1.mcZJ.sp & Serializable)x$5 -> x$5 < end).appended((Object)BoxesRunTime.boxToLong((long)end));
                seq = this.perspectivesFromTimestamps(query.timelineStart(), query.timelineEnd(), (LazyList<Object>)timestamps, (Seq<Interval>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)query.windows()), query.windowAlignment(), query.datetimeQuery());
            } else {
                throw new MatchError((Object)pointSet);
            }
            Seq<LazyList<Perspective>> perspectives = seq;
            perspectiveController = new PerspectiveController((LazyList[])perspectives.toArray(ClassTag$.MODULE$.apply(LazyList.class)));
        }
        return perspectiveController;
    }

    private Seq<LazyList<Perspective>> perspectivesFromTimestamps(long timelineStart, long timelineEnd, LazyList<Object> timestamps, Seq<Interval> windows, Enumeration.Value alignment, boolean formatAsDate) {
        SeqOps seqOps;
        Seq<Interval> seq = windows;
        Seq seq2 = seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0 ? (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LazyList[]{timestamps.map((Function1 & Serializable)timestamp -> PerspectiveController$.$anonfun$perspectivesFromTimestamps$1(alignment, timelineStart, timelineEnd, formatAsDate, BoxesRunTime.unboxToLong((Object)timestamp)))})) : (Seq)seq.map((Function1 & Serializable)window -> timestamps.map((Function1 & Serializable)timestamp -> PerspectiveController$.$anonfun$perspectivesFromTimestamps$3(alignment, window, timelineStart, timelineEnd, formatAsDate, BoxesRunTime.unboxToLong((Object)timestamp))));
        return seq2;
    }

    public static final /* synthetic */ Perspective $anonfun$perspectivesFromTimestamps$1(Enumeration.Value alignment$1, long timelineStart$1, long timelineEnd$1, boolean formatAsDate$1, long timestamp) {
        Perspective perspective;
        Enumeration.Value value = alignment$1;
        Enumeration.Value value2 = Alignment$.MODULE$.START();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            perspective = new Perspective(timestamp, (Option<Interval>)None$.MODULE$, RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(timestamp), timelineStart$1), timelineEnd$1, -1L, formatAsDate$1);
        } else {
            Enumeration.Value value4 = Alignment$.MODULE$.MIDDLE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                perspective = new Perspective(timestamp, (Option<Interval>)None$.MODULE$, timelineStart$1, timelineEnd$1, -1L, formatAsDate$1);
            } else {
                Enumeration.Value value6 = Alignment$.MODULE$.END();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    perspective = new Perspective(timestamp, (Option<Interval>)None$.MODULE$, timelineStart$1, RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timestamp), timelineEnd$1), -1L, formatAsDate$1);
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return perspective;
    }

    public static final /* synthetic */ Perspective $anonfun$perspectivesFromTimestamps$3(Enumeration.Value alignment$1, Interval window$1, long timelineStart$1, long timelineEnd$1, boolean formatAsDate$1, long timestamp) {
        Perspective perspective;
        Enumeration.Value value = alignment$1;
        Enumeration.Value value2 = Alignment$.MODULE$.START();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            perspective = new Perspective(timestamp, (Option<Interval>)new Some((Object)window$1), RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(timestamp), timelineStart$1), RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(TimeConverters$.MODULE$.TimeHolder(timestamp).$plus(window$1)), timelineEnd$1) - 1L, -1L, formatAsDate$1);
        } else {
            Enumeration.Value value4 = Alignment$.MODULE$.MIDDLE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                perspective = new Perspective(timestamp, (Option<Interval>)new Some((Object)window$1), RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(TimeConverters$.MODULE$.TimeHolder(timestamp).$minus(window$1.$div(2L))), timelineStart$1) + 1L, RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(TimeConverters$.MODULE$.TimeHolder(timestamp).$plus(window$1.$div(2L))), timelineEnd$1) - 1L, -1L, formatAsDate$1);
            } else {
                Enumeration.Value value6 = Alignment$.MODULE$.END();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    perspective = new Perspective(timestamp, (Option<Interval>)new Some((Object)window$1), RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(TimeConverters$.MODULE$.TimeHolder(timestamp).$minus(window$1)), timelineStart$1) + 1L, RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timestamp), timelineEnd$1), -1L, formatAsDate$1);
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return perspective;
    }

    private PerspectiveController$() {
    }
}

