/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.components.ingestion;

import cats.UnorderedFoldable$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.syntax.package;
import com.google.protobuf.empty.Empty;
import com.raphtory.api.input.Source;
import com.raphtory.internals.components.ingestion.IngestionExecutor$;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.management.Partitioner;
import com.raphtory.internals.management.Partitioner$;
import com.raphtory.internals.management.telemetry.TelemetryReporter$;
import com.raphtory.protocol.EndIngestion;
import com.raphtory.protocol.EndIngestion$;
import com.raphtory.protocol.GraphAlterations;
import com.raphtory.protocol.GraphAlterations$;
import com.raphtory.protocol.GraphId;
import com.raphtory.protocol.GraphId$;
import com.raphtory.protocol.PartitionService;
import com.raphtory.protocol.QueryService;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import io.prometheus.client.Counter;
import java.io.Serializable;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\rc!\u0002\u001d:\u0001}\u001a\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011a\u0003!\u0011!Q\u0001\neC\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\to\u0002\u0011\t\u0011)A\u0005q\"I\u0011\u0011\u0007\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\u000b\u0003g\u0001!\u0011!Q\u0001\n\u0005U\u0002BCA#\u0001\t\u0005\t\u0015a\u0003\u0002H!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004\"CAA\u0001\t\u0007I\u0011BAB\u0011!\t\t\n\u0001Q\u0001\n\u0005\u0015\u0005\"CAJ\u0001\t\u0007I\u0011BAK\u0011!\t\u0019\f\u0001Q\u0001\n\u0005]\u0005\"CA[\u0001\t\u0007I\u0011BA\\\u0011!\ti\f\u0001Q\u0001\n\u0005e\u0006\"CA`\u0001\t\u0007I\u0011BA\\\u0011!\t\t\r\u0001Q\u0001\n\u0005e\u0006\"CAb\u0001\t\u0007I\u0011BAc\u0011!\t\u0019\u000e\u0001Q\u0001\n\u0005\u001d\u0007bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003C\u0004A\u0011BAr\u0011\u001d\tI\u000f\u0001C\u0005\u0003WDq!!<\u0001\t\u0013\tyoB\u0004\u0002\u0000fB\tA!\u0001\u0007\raJ\u0004\u0012\u0001B\u0002\u0011\u001d\t\u0019\u0007\u0007C\u0001\u0005\u000b1aAa\u0002\u0019\u0001\n%\u0001B\u0003B\f5\tU\r\u0011\"\u0001\u0003\u001a!Q!\u0011\u0005\u000e\u0003\u0012\u0003\u0006IAa\u0007\t\u0015\t\r\"D!f\u0001\n\u0003\u0011I\u0002\u0003\u0006\u0003&i\u0011\t\u0012)A\u0005\u00057A!Ba\n\u001b\u0005+\u0007I\u0011\u0001B\r\u0011)\u0011IC\u0007B\tB\u0003%!1\u0004\u0005\b\u0003GRB\u0011\u0001B\u0016\u0011\u001d\u00119D\u0007C\u0001\u0005sA\u0011Ba\u0010\u001b\u0003\u0003%\tA!\u0011\t\u0013\t%#$%A\u0005\u0002\t-\u0003\"\u0003B15E\u0005I\u0011\u0001B&\u0011%\u0011\u0019GGI\u0001\n\u0003\u0011Y\u0005C\u0005\u0003fi\t\t\u0011\"\u0011\u0003h!I!q\u000f\u000e\u0002\u0002\u0013\u0005!\u0011\u0010\u0005\n\u0005wR\u0012\u0011!C\u0001\u0005{B\u0011Ba!\u001b\u0003\u0003%\tE!\"\t\u0013\tM%$!A\u0005\u0002\tU\u0005\"\u0003BP5\u0005\u0005I\u0011\tBQ\u0011%\u0011)KGA\u0001\n\u0003\u00129\u000bC\u0005\u0003*j\t\t\u0011\"\u0011\u0003,\"I!Q\u0016\u000e\u0002\u0002\u0013\u0005#qV\u0004\n\u0005gC\u0012\u0011!E\u0001\u0005k3\u0011Ba\u0002\u0019\u0003\u0003E\tAa.\t\u000f\u0005\r\u0014\u0007\"\u0001\u0003N\"I!\u0011V\u0019\u0002\u0002\u0013\u0015#1\u0016\u0005\n\u0005\u001f\f\u0014\u0011!CA\u0005#D\u0011B!72\u0003\u0003%\tIa7\t\u0013\t5\u0018'!A\u0005\n\t=\bb\u0002Bh1\u0011\u0005!q\u001f\u0002\u0012\u0013:<Wm\u001d;j_:,\u00050Z2vi>\u0014(B\u0001\u001e<\u0003%IgnZ3ti&|gN\u0003\u0002={\u0005Q1m\\7q_:,g\u000e^:\u000b\u0005yz\u0014!C5oi\u0016\u0014h.\u00197t\u0015\t\u0001\u0015)\u0001\u0005sCBDGo\u001c:z\u0015\u0005\u0011\u0015aA2p[V!A)YA8'\t\u0001Q\t\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0004B]f\u0014VMZ\u0001\bOJ\f\u0007\u000f[%E\u0007\u0001\u0001\"AT+\u000f\u0005=\u001b\u0006C\u0001)H\u001b\u0005\t&B\u0001*M\u0003\u0019a$o\\8u}%\u0011AkR\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U\u000f\u0006a\u0011/^3ssN+'O^5dKB\u0019!,X0\u000e\u0003mS!\u0001X \u0002\u0011A\u0014x\u000e^8d_2L!AX.\u0003\u0019E+XM]=TKJ4\u0018nY3\u0011\u0005\u0001\fG\u0002\u0001\u0003\u0006E\u0002\u0011\ra\u0019\u0002\u0002\rV\u0011Am[\t\u0003K\"\u0004\"A\u00124\n\u0005\u001d<%a\u0002(pi\"Lgn\u001a\t\u0003\r&L!A[$\u0003\u0007\u0005s\u0017\u0010B\u0003mC\n\u0007AM\u0001\u0003`I\u0011\n\u0014A\u00039beRLG/[8ogB!aj\\9u\u0013\t\u0001xKA\u0002NCB\u0004\"A\u0012:\n\u0005M<%aA%oiB\u0019!,^0\n\u0005Y\\&\u0001\u0005)beRLG/[8o'\u0016\u0014h/[2f\u0003\u0019\u0019HO]3b[B!\u0011\u0010`0\u007f\u001b\u0005Q(\"A>\u0002\u0007\u0019\u001c('\u0003\u0002~u\n11\u000b\u001e:fC6\u0004Ra`A\u0005\u0003\u001fqA!!\u0001\u0002\u00069\u0019\u0001+a\u0001\n\u0003!K1!a\u0002H\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0003\u0002\u000e\t\u00191+Z9\u000b\u0007\u0005\u001dq\t\u0005\u0003\u0002\u0012\u0005-b\u0002BA\n\u0003KqA!!\u0006\u0002\"9!\u0011qCA\u0010\u001d\u0011\tI\"!\b\u000f\u0007A\u000bY\"C\u0001C\u0013\t\u0001\u0015)\u0003\u0002?\u007f%\u0019\u00111E\u001f\u0002\u000b\u001d\u0014\u0018\r\u001d5\n\t\u0005\u001d\u0012\u0011F\u0001\u0010\u000fJ\f\u0007\u000f[!mi\u0016\u0014\u0018\r^5p]*\u0019\u00111E\u001f\n\t\u00055\u0012q\u0006\u0002\f\u000fJ\f\u0007\u000f[+qI\u0006$XM\u0003\u0003\u0002(\u0005%\u0012\u0001C:pkJ\u001cW-\u0013#\u0002\t\r|gN\u001a\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0019\u0019wN\u001c4jO*\u0019\u0011qH!\u0002\u0011QL\b/Z:bM\u0016LA!a\u0011\u0002:\t11i\u001c8gS\u001e\f\u0011A\u0012\t\u0006\u0003\u0013\nif\u0018\b\u0005\u0003\u0017\nIF\u0004\u0003\u0002N\u0005Mcb\u0001)\u0002P%\u0011\u0011\u0011K\u0001\u0005G\u0006$8/\u0003\u0003\u0002V\u0005]\u0013AB3gM\u0016\u001cGO\u0003\u0002\u0002R%!\u0011qAA.\u0015\u0011\t)&a\u0016\n\t\u0005}\u0013\u0011\r\u0002\u0006\u0003NLhn\u0019\u0006\u0005\u0003\u000f\tY&\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003O\n)(a\u001e\u0002z\u0005m\u0014QPA@)\u0011\tI'a\u001d\u0011\r\u0005-\u0004aXA7\u001b\u0005I\u0004c\u00011\u0002p\u00111\u0011\u0011\u000f\u0001C\u0002\u0011\u0014\u0011\u0001\u0016\u0005\b\u0003\u000bB\u00019AA$\u0011\u0015Y\u0005\u00021\u0001N\u0011\u0015A\u0006\u00021\u0001Z\u0011\u0015i\u0007\u00021\u0001o\u0011\u00159\b\u00021\u0001y\u0011\u0019\t\t\u0004\u0003a\u0001c\"9\u00111\u0007\u0005A\u0002\u0005U\u0012A\u00027pO\u001e,'/\u0006\u0002\u0002\u0006B!\u0011qQAG\u001b\t\tII\u0003\u0003\u0002\f\u0006u\u0012\u0001D:dC2\fGn\\4hS:<\u0017\u0002BAH\u0003\u0013\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0015i>$\u0018\r\u001c+va2,7\u000f\u0015:pG\u0016\u001c8/\u001a3\u0016\u0005\u0005]\u0005\u0003BAM\u0003[sA!a'\u0002*6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+\u0001\u0004dY&,g\u000e\u001e\u0006\u0005\u0003G\u000b)+\u0001\u0006qe>lW\r\u001e5fkNT!!a*\u0002\u0005%|\u0017\u0002BAV\u0003;\u000bqaQ8v]R,'/\u0003\u0003\u00020\u0006E&!B\"iS2$'\u0002BAV\u0003;\u000bQ\u0003^8uC2$V\u000f\u001d7fgB\u0013xnY3tg\u0016$\u0007%\u0001\twKJ$X\r_!eI\u000e{WO\u001c;feV\u0011\u0011\u0011\u0018\t\u0005\u0003w\u000bi+\u0004\u0002\u00022\u0006\tb/\u001a:uKb\fE\rZ\"pk:$XM\u001d\u0011\u0002\u001d\u0015$w-Z!eI\u000e{WO\u001c;fe\u0006yQ\rZ4f\u0003\u0012$7i\\;oi\u0016\u0014\b%A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014XCAAd!\u0011\tI-a4\u000e\u0005\u0005-'bAAg{\u0005QQ.\u00198bO\u0016lWM\u001c;\n\t\u0005E\u00171\u001a\u0002\f!\u0006\u0014H/\u001b;j_:,'/\u0001\u0007qCJ$\u0018\u000e^5p]\u0016\u0014\b%A\u0002sk:$\"!!7\u0011\t\u0001\f\u00171\u001c\t\u0004\r\u0006u\u0017bAAp\u000f\n!QK\\5u\u0003-\u0019XM\u001c3Va\u0012\fG/Z:\u0015\t\u0005e\u0017Q\u001d\u0005\u0007\u0003O$\u0002\u0019\u0001@\u0002\u000fU\u0004H-\u0019;fg\u0006)a\r\\;tQV\u0011\u0011\u0011\\\u0001\u0013]>$\u0018NZ=Rk\u0016\u0014\u0018pU3sm&\u001cW\r\u0006\u0003\u0002Z\u0006E\bbBAz-\u0001\u0007\u0011Q_\u0001\fO2|'-\u00197Ti\u0006$8\u000fE\u0004\u0002J\u0005]x,a?\n\t\u0005e\u0018\u0011\r\u0002\u0004%\u00164\u0007cAA\u007f59\u0019\u00111N\f\u0002#%sw-Z:uS>tW\t_3dkR|'\u000fE\u0002\u0002la\u0019\"\u0001G#\u0015\u0005\t\u0005!aC*pkJ\u001cWm\u0015;biN\u001cbAG#\u0003\f\tE\u0001c\u0001$\u0003\u000e%\u0019!qB$\u0003\u000fA\u0013x\u000eZ;diB\u0019qPa\u0005\n\t\tU\u0011Q\u0002\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\rK\u0006\u0014H.[3tiRKW.Z\u000b\u0003\u00057\u00012A\u0012B\u000f\u0013\r\u0011yb\u0012\u0002\u0005\u0019>tw-A\u0007fCJd\u0017.Z:u)&lW\rI\u0001\fQ&<\u0007.Z:u'\u0016,g.\u0001\u0007iS\u001eDWm\u001d;TK\u0016t\u0007%A\u0006tK:$X\u000b\u001d3bi\u0016\u001c\u0018\u0001D:f]R,\u0006\u000fZ1uKN\u0004C\u0003\u0003B\u0017\u0005c\u0011\u0019D!\u000e\u0011\u0007\t=\"$D\u0001\u0019\u0011\u001d\u00119\"\ta\u0001\u00057AqAa\t\"\u0001\u0004\u0011Y\u0002C\u0004\u0003(\u0005\u0002\rAa\u0007\u0002\u0007\u0005$G\r\u0006\u0003\u0003.\tm\u0002B\u0002B\u001fE\u0001\u0007a0\u0001\u0007he\u0006\u0004\b.\u00169eCR,7/\u0001\u0003d_BLH\u0003\u0003B\u0017\u0005\u0007\u0012)Ea\u0012\t\u0013\t]1\u0005%AA\u0002\tm\u0001\"\u0003B\u0012GA\u0005\t\u0019\u0001B\u000e\u0011%\u00119c\tI\u0001\u0002\u0004\u0011Y\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t5#\u0006\u0002B\u000e\u0005\u001fZ#A!\u0015\u0011\t\tM#QL\u0007\u0003\u0005+RAAa\u0016\u0003Z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00057:\u0015AC1o]>$\u0018\r^5p]&!!q\fB+\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B5!\u0011\u0011YG!\u001e\u000e\u0005\t5$\u0002\u0002B8\u0005c\nA\u0001\\1oO*\u0011!1O\u0001\u0005U\u00064\u0018-C\u0002W\u0005[\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012!]\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rA'q\u0010\u0005\t\u0005\u0003K\u0013\u0011!a\u0001c\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\"\u0011\u000b\t%%q\u00125\u000e\u0005\t-%b\u0001BG\u000f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tE%1\u0012\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0018\nu\u0005c\u0001$\u0003\u001a&\u0019!1T$\u0003\u000f\t{w\u000e\\3b]\"A!\u0011Q\u0016\u0002\u0002\u0003\u0007\u0001.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B5\u0005GC\u0001B!!-\u0003\u0003\u0005\r!]\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0011/\u0001\u0005u_N#(/\u001b8h)\t\u0011I'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005/\u0013\t\f\u0003\u0005\u0003\u0002>\n\t\u00111\u0001i\u0003-\u0019v.\u001e:dKN#\u0018\r^:\u0011\u0007\t=\u0012gE\u00032\u0005s\u0013)\r\u0005\u0007\u0003<\n\u0005'1\u0004B\u000e\u00057\u0011i#\u0004\u0002\u0003>*\u0019!qX$\u0002\u000fI,h\u000e^5nK&!!1\u0019B_\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005\u000f\u0014Y-\u0004\u0002\u0003J*!\u0011q\u0015B9\u0013\u0011\u0011)B!3\u0015\u0005\tU\u0016!B1qa2LH\u0003\u0003B\u0017\u0005'\u0014)Na6\t\u000f\t]A\u00071\u0001\u0003\u001c!9!1\u0005\u001bA\u0002\tm\u0001b\u0002B\u0014i\u0001\u0007!1D\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iN!;\u0011\u000b\u0019\u0013yNa9\n\u0007\t\u0005xI\u0001\u0004PaRLwN\u001c\t\n\r\n\u0015(1\u0004B\u000e\u00057I1Aa:H\u0005\u0019!V\u000f\u001d7fg!I!1^\u001b\u0002\u0002\u0003\u0007!QF\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001By!\u0011\u0011YGa=\n\t\tU(Q\u000e\u0002\u0007\u001f\nTWm\u0019;\u0016\t\te(q \u000b\u0011\u0005w\u001cIba\u0007\u0004 \rM2QGB\u001e\u0007{!BA!@\u0004\u0014A)\u0001Ma@\u0004\b\u00111!m\u000eb\u0001\u0007\u0003)2\u0001ZB\u0002\t\u001d\u0019)Aa@C\u0002\u0011\u0014Aa\u0018\u0013%eA\"1\u0011BB\b!\u001d\tY\u0007AB\u0006\u0007\u001b\u00012\u0001\u0019B\u0000!\r\u00017q\u0002\u0003\u000b\u0007#9\u0014\u0011!A\u0001\u0006\u0003!'aA0%c!I1QC\u001c\u0002\u0002\u0003\u000f1qC\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004CBA%\u0003;\u001aY\u0001C\u0003Lo\u0001\u0007Q\n\u0003\u0004Yo\u0001\u00071Q\u0004\t\u00055v\u001bY\u0001C\u0004\u0004\"]\u0002\raa\t\u0002\rM|WO]2f!\u0011\u0019)ca\f\u000e\u0005\r\u001d\"\u0002BB\u0015\u0007W\tQ!\u001b8qkRT1a!\f@\u0003\r\t\u0007/[\u0005\u0005\u0007c\u00199C\u0001\u0004T_V\u00148-\u001a\u0005\u0007\u0003c9\u0004\u0019A9\t\u000f\r]r\u00071\u0001\u0004:\u0005Yq\r\\8cC2Le\u000eZ3y!!\tI%a>\u0004\f\tm\u0001bBA\u001eo\u0001\u0007\u0011Q\u0007\u0005\u0007[^\u0002\raa\u0010\u0011\u000b9{\u0017o!\u0011\u0011\ti+81\u0002")
public class IngestionExecutor<F, T> {
    private final String graphID;
    private final QueryService<F> queryService;
    private final Map<Object, PartitionService<F>> partitions;
    private final Stream<F, Seq<GraphAlteration.GraphUpdate>> stream;
    private final int sourceID;
    private final Async<F> F;
    private final Logger logger;
    private final Counter.Child totalTuplesProcessed;
    private final Counter.Child vertexAddCounter;
    private final Counter.Child edgeAddCounter;
    private final Partitioner partitioner;

    public static <F> F apply(String graphID, QueryService<F> queryService, Source source, int sourceID, Ref<F, Object> globalIndex, Config config, Map<Object, PartitionService<F>> partitions, Async<F> evidence$1) {
        return IngestionExecutor$.MODULE$.apply(graphID, queryService, source, sourceID, globalIndex, config, partitions, evidence$1);
    }

    private Logger logger() {
        return this.logger;
    }

    private Counter.Child totalTuplesProcessed() {
        return this.totalTuplesProcessed;
    }

    private Counter.Child vertexAddCounter() {
        return this.vertexAddCounter;
    }

    private Counter.Child edgeAddCounter() {
        return this.edgeAddCounter;
    }

    private Partitioner partitioner() {
        return this.partitioner;
    }

    public F run() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Running ingestion executor");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }), this.F).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            Object object = package.all$.MODULE$.toFlatMapOps(cats.effect.package$.MODULE$.Ref().of((Object)new SourceStats(Long.MAX_VALUE, Long.MIN_VALUE, 0L), Ref.Make$.MODULE$.concurrentInstance($this.F)), $this.F).flatMap((Function1 & Serializable)globalStats -> package.all$.MODULE$.toFlatMapOps(cats.effect.package$.MODULE$.Clock().apply($this.F).monotonic(), $this.F).flatMap((Function1 & Serializable)start -> package.all$.MODULE$.toFunctorOps($this.stream.parEvalMapUnordered(4, (Function1 & Serializable)updates -> package.all$.MODULE$.toFlatMapOps(this.sendUpdates((Seq<GraphAlteration.GraphUpdate>)updates), $this.F).flatMap((Function1 & Serializable)x$5 -> {
                BoxedUnit boxedUnit = x$5;
                Object object = package.all$.MODULE$.toFlatMapOps(globalStats.update((Function1 & Serializable)stats -> stats.add((Seq<GraphAlteration.GraphUpdate>)updates)), $this.F).flatMap((Function1 & Serializable)x$4 -> {
                    BoxedUnit boxedUnit = x$4;
                    Object object = package.all$.MODULE$.toFunctorOps($this.F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        this.vertexAddCounter().inc((double)updates.count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)IngestionExecutor.$anonfun$run$10(x$1))));
                        this.edgeAddCounter().inc((double)updates.count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)IngestionExecutor.$anonfun$run$11(x$2))));
                        this.totalTuplesProcessed().inc((double)updates.size());
                    }), $this.F).map((Function1 & Serializable)x$3 -> {
                        IngestionExecutor.$anonfun$run$12(x$3);
                        return BoxedUnit.UNIT;
                    });
                    return object;
                });
                return object;
            }), $this.F).onFinalizeCase((Function1 & Serializable)x0$1 -> {
                Resource.ExitCase exitCase = x0$1;
                Object object = Resource.ExitCase$.Succeeded$.MODULE$.equals(exitCase) ? package.all$.MODULE$.toFlatMapOps(this.flush(), $this.F).flatMap((Function1 & Serializable)x$8 -> {
                    BoxedUnit boxedUnit = x$8;
                    Object object = package.all$.MODULE$.toFlatMapOps(cats.effect.package$.MODULE$.Clock().apply($this.F).monotonic(), $this.F).flatMap((Function1 & Serializable)end -> package.all$.MODULE$.toFlatMapOps($this.F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("INNER INGESTION TOOK {}s ", (Object)BoxesRunTime.boxToLong((long)end.$minus(start).toSeconds()));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }), $this.F).flatMap((Function1 & Serializable)x$7 -> {
                        BoxedUnit boxedUnit = x$7;
                        Object object = package.all$.MODULE$.toFunctorOps(this.notifyQueryService((Ref)globalStats), $this.F).map((Function1 & Serializable)x$6 -> {
                            IngestionExecutor.$anonfun$run$18(x$6);
                            return BoxedUnit.UNIT;
                        });
                        return object;
                    }));
                    return object;
                }) : package.all$.MODULE$.toFlatMapOps($this.F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Ingestion failed. Unblocking query service");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }), $this.F).flatMap((Function1 & Serializable)x$10 -> {
                    BoxedUnit boxedUnit = x$10;
                    Object object = package.all$.MODULE$.toFunctorOps(this.notifyQueryService((Ref)globalStats), $this.F).map((Function1 & Serializable)x$9 -> {
                        IngestionExecutor.$anonfun$run$21(x$9);
                        return BoxedUnit.UNIT;
                    });
                    return object;
                });
                return object;
            }, $this.F).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent($this.F))).drain(), $this.F).map((Function1 & Serializable)x$11 -> {
                IngestionExecutor.$anonfun$run$22(x$11);
                return BoxedUnit.UNIT;
            })));
            return object;
        });
    }

    private F sendUpdates(Seq<GraphAlteration.GraphUpdate> updates) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.F.delay((Function0 & Serializable)() -> ((IterableOps)updates.flatMap((Function1 & Serializable)x0$1 -> {
            Seq seq;
            GraphAlteration.GraphUpdate graphUpdate = x0$1;
            if (graphUpdate instanceof GraphAlteration.EdgeAdd) {
                GraphAlteration.EdgeAdd edgeAdd = (GraphAlteration.EdgeAdd)graphUpdate;
                seq = (Seq)this.partitioner().getPartitionsForEdge(edgeAdd.srcId(), edgeAdd.dstId()).toSeq().map((Function1 & Serializable)x$13 -> IngestionExecutor.$anonfun$sendUpdates$3(edgeAdd, BoxesRunTime.unboxToInt((Object)x$13)));
            } else {
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.partitioner().getPartitionForId(graphUpdate.srcId())), (Object)graphUpdate)}));
            }
            return seq;
        })).groupMap((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)IngestionExecutor.$anonfun$sendUpdates$4(x0$2)), (Function1 & Serializable)x0$3 -> {
            GraphAlteration.GraphUpdate update;
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GraphAlteration.GraphUpdate graphUpdate = update = (GraphAlteration.GraphUpdate)tuple2._2();
            return graphUpdate;
        })), this.F).flatMap((Function1 & Serializable)groupedUpdates -> package.all$.MODULE$.toFunctorOps($this.F.parSequenceN($this.partitions.size(), groupedUpdates.toSeq().map((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int partition = tuple2._1$mcI$sp();
            Seq updates = (Seq)tuple2._2();
            Object f = ((PartitionService)$this.partitions.apply((Object)BoxesRunTime.boxToInteger((int)partition))).processUpdates(new GraphAlterations($this.graphID, (Seq<GraphAlteration>)updates, GraphAlterations$.MODULE$.apply$default$3()));
            return f;
        }), UnorderedFoldable$.MODULE$.catsTraverseForSeq()), $this.F).map((Function1 & Serializable)x$14 -> {
            IngestionExecutor.$anonfun$sendUpdates$8(x$14);
            return BoxedUnit.UNIT;
        }));
    }

    private F flush() {
        return (F)package.all$.MODULE$.toFunctorOps(this.F.parSequenceN(this.partitions.size(), (Object)((IterableOnceOps)this.partitions.values().map((Function1 & Serializable)x$15 -> x$15.flush(new GraphId($this.graphID, GraphId$.MODULE$.apply$default$2())))).toVector(), UnorderedFoldable$.MODULE$.catsTraverseForVector()), this.F).void();
    }

    private F notifyQueryService(Ref<F, SourceStats> globalStats) {
        return (F)package.all$.MODULE$.toFlatMapOps(globalStats.get(), this.F).flatMap((Function1 & Serializable)stats -> package.all$.MODULE$.toFunctorOps($this.queryService.endIngestion(new EndIngestion($this.graphID, $this.sourceID, stats.earliestTime(), stats.highestSeen(), EndIngestion$.MODULE$.apply$default$5())), $this.F).map((Function1 & Serializable)x$16 -> {
            IngestionExecutor.$anonfun$notifyQueryService$2(x$16);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$run$10(GraphAlteration.GraphUpdate x$1) {
        return x$1 instanceof GraphAlteration.VertexAdd;
    }

    public static final /* synthetic */ boolean $anonfun$run$11(GraphAlteration.GraphUpdate x$2) {
        return x$2 instanceof GraphAlteration.EdgeAdd;
    }

    public static final /* synthetic */ void $anonfun$run$12(BoxedUnit x$3) {
        BoxedUnit boxedUnit = x$3;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$run$18(BoxedUnit x$6) {
        BoxedUnit boxedUnit = x$6;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$run$21(BoxedUnit x$9) {
        BoxedUnit boxedUnit = x$9;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$run$22(BoxedUnit x$11) {
        BoxedUnit boxedUnit = x$11;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendUpdates$3(GraphAlteration.EdgeAdd x2$1, int x$13) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)x$13), (Object)x2$1);
    }

    public static final /* synthetic */ int $anonfun$sendUpdates$4(Tuple2 x0$2) {
        int partition;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = partition = tuple2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ void $anonfun$sendUpdates$8(Seq x$14) {
        Seq seq = x$14;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$notifyQueryService$2(Empty x$16) {
        Empty empty = x$16;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public IngestionExecutor(String graphID, QueryService<F> queryService, Map<Object, PartitionService<F>> partitions, Stream<F, Seq<GraphAlteration.GraphUpdate>> stream, int sourceID, Config conf, Async<F> F) {
        this.graphID = graphID;
        this.queryService = queryService;
        this.partitions = partitions;
        this.stream = stream;
        this.sourceID = sourceID;
        this.F = F;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
        this.totalTuplesProcessed = (Counter.Child)TelemetryReporter$.MODULE$.totalTuplesProcessed().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)sourceID)), graphID});
        this.vertexAddCounter = (Counter.Child)TelemetryReporter$.MODULE$.vertexAddCounter().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)sourceID)), graphID});
        this.edgeAddCounter = (Counter.Child)TelemetryReporter$.MODULE$.edgeAddCounter().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)sourceID)), graphID});
        this.partitioner = Partitioner$.MODULE$.apply(conf);
    }

    public static class SourceStats
    implements Product,
    Serializable {
        private final long earliestTime;
        private final long highestSeen;
        private final long sentUpdates;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long earliestTime() {
            return this.earliestTime;
        }

        public long highestSeen() {
            return this.highestSeen;
        }

        public long sentUpdates() {
            return this.sentUpdates;
        }

        public SourceStats add(Seq<GraphAlteration.GraphUpdate> graphUpdates) {
            long minTime = ((GraphAlteration.GraphUpdate)graphUpdates.minBy((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.updateTime()), (Ordering)Ordering.Long$.MODULE$)).updateTime();
            long maxTime = ((GraphAlteration.GraphUpdate)graphUpdates.maxBy((Function1 & Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18.updateTime()), (Ordering)Ordering.Long$.MODULE$)).updateTime();
            return new SourceStats(Math.min(this.earliestTime(), minTime), Math.max(this.highestSeen(), maxTime), this.sentUpdates() + (long)graphUpdates.size());
        }

        public SourceStats copy(long earliestTime, long highestSeen, long sentUpdates) {
            return new SourceStats(earliestTime, highestSeen, sentUpdates);
        }

        public long copy$default$1() {
            return this.earliestTime();
        }

        public long copy$default$2() {
            return this.highestSeen();
        }

        public long copy$default$3() {
            return this.sentUpdates();
        }

        public String productPrefix() {
            return "SourceStats";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.earliestTime());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.highestSeen());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.sentUpdates());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SourceStats;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "earliestTime";
                    break;
                }
                case 1: {
                    string = "highestSeen";
                    break;
                }
                case 2: {
                    string = "sentUpdates";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.earliestTime()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.highestSeen()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sentUpdates()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SourceStats)) return false;
            boolean bl = true;
            if (!bl) return false;
            SourceStats sourceStats = (SourceStats)x$1;
            if (this.earliestTime() != sourceStats.earliestTime()) return false;
            if (this.highestSeen() != sourceStats.highestSeen()) return false;
            if (this.sentUpdates() != sourceStats.sentUpdates()) return false;
            if (!sourceStats.canEqual(this)) return false;
            return true;
        }

        public SourceStats(long earliestTime, long highestSeen, long sentUpdates) {
            this.earliestTime = earliestTime;
            this.highestSeen = highestSeen;
            this.sentUpdates = sentUpdates;
            Product.$init$((Product)this);
        }
    }
}

