/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.formats;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.output.format.Format;
import com.raphtory.api.output.sink.SinkConnector;
import com.raphtory.api.output.sink.SinkExecutor;
import com.raphtory.api.time.DiscreteInterval;
import com.raphtory.api.time.Interval;
import com.raphtory.api.time.Perspective;
import com.raphtory.api.time.TimeInterval;
import com.raphtory.formats.JsonFormat$;
import com.raphtory.formats.JsonFormat$GLOBAL$;
import com.raphtory.formats.JsonFormat$ROW$;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** A `Format` that writes a `Table` in JSON format\n  *\n  * This format can be configured to work in two different ways, depending on the value for `level`:\n  * - `JsonFormat.ROW` (the default option): creates one JSON object per row, following the format defined [here](https://jsonlines.org).\n  * - `JsonFormat.GLOBAL`: creates a global JSON object for every partition of the table\n  *\n  * For a table with just one perspective created from timestamp 10 with no window and 3 rows\n  * the output might look as follows if `level` is set to `JsonFormat.GLOBAL`:\n  * {{{\n  * {\n  *   \"jobID\" : \"EdgeCount\",\n  *   \"partitionID\" : 0,\n  *   \"perspectives\" : [ {\n  *     \"timestamp\" : 10\n  *     \"rows\" : [ [ \"id1\", 12 ], [ \"id2\", 13 ], [ \"id3\", 24 ] ]\n  *   } ]\n  * }\n  * }}}\n  *\n  * If the above query is run with a window, then additionally a field `window` with the window size is returned at the same level as `timestamp`.\n  *\n  * On the other hand, if `level` is not set or is set to `JsonFormat.ROW`, the output might look as follows:\n  *\n  * {{{\n  * {\"timestamp\":10,\"window\":null,\"row\":[\"id1\",12]}\n  * {\"timestamp\":10,\"window\":null,\"row\":[\"id2\",13]}\n  * {\"timestamp\":10,\"window\":null,\"row\":[\"id3\",24]}\n  * }}}\n  *\n  * @param level the table level to create json objects\n  */")
@ScalaSignature(bytes="\u0006\u0005\tmf\u0001B\u001d;\u0001\u0006C\u0001\"\u0019\u0001\u0003\u0016\u0004%\tA\u0019\u0005\n\u0003\u001b\u0004!\u0011#Q\u0001\n\rDa\u0001\u001d\u0001\u0005\u0002\u0005=\u0007bBAj\u0001\u0011\u0005\u0013Q\u001b\u0005\b\u0003K\u0004A\u0011IAk\u0011\u001d\t9\u000f\u0001C!\u0003SDqAa\u0007\u0001\t\u0013\u0011i\u0002C\u0004\u0003N\u0001!IAa\u0014\t\u000f\t]\u0004\u0001\"\u0003\u0003z!9!\u0011\u0012\u0001\u0005\n\t-\u0005b\u0002BH\u0001\u0011%!\u0011\u0013\u0005\n\u00053\u0003\u0011\u0011!C\u0001\u00057C\u0011Ba(\u0001#\u0003%\t!a*\t\u0013\u0005%\u0002!!A\u0005B\u0005-\u0002\"CA\u001d\u0001\u0005\u0005I\u0011AA\u001e\u0011%\t\u0019\u0005AA\u0001\n\u0003\u0011\t\u000bC\u0005\u0002R\u0001\t\t\u0011\"\u0011\u0002T!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005!Q\u0015\u0005\n\u0005S\u0003\u0011\u0011!C!\u0005WC\u0011\"!\u001c\u0001\u0003\u0003%\t%a\u001c\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0004\"\u0003BX\u0001\u0005\u0005I\u0011\tBY\u000f\u00151'\b#\u0001h\r\u0015I$\b#\u0001i\u0011\u0015\u0001\b\u0004\"\u0001r\u0011\u0015\u0011\b\u0004\"\u0001t\u0011\u0019\t9\u0001\u0007C\u0001g\"1\u0011q\u0002\r\u0005\u0002M4\u0011\"a\u0006\u0019!\u0003\r\n#!\u0007\b\u000f\u0005e\u0005\u0004#!\u0002\b\u001a9\u0011\u0011\u0011\r\t\u0002\u0006\r\u0005B\u00029 \t\u0003\t)\tC\u0005\u0002*}\t\t\u0011\"\u0011\u0002,!I\u0011\u0011H\u0010\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007z\u0012\u0011!C\u0001\u0003\u0013C\u0011\"!\u0015 \u0003\u0003%\t%a\u0015\t\u0013\u0005\u0005t$!A\u0005\u0002\u00055\u0005\"CA7?\u0005\u0005I\u0011IA8\u0011%\t\thHA\u0001\n\u0003\n\u0019\bC\u0005\u0002v}\t\t\u0011\"\u0003\u0002x\u001d9\u0011Q\u0014\r\t\u0002\u0006\u001dbaBA\u000f1!\u0005\u0015q\u0004\u0005\u0007a*\"\t!!\n\t\u0013\u0005%\"&!A\u0005B\u0005-\u0002\"CA\u001dU\u0005\u0005I\u0011AA\u001e\u0011%\t\u0019EKA\u0001\n\u0003\t)\u0005C\u0005\u0002R)\n\t\u0011\"\u0011\u0002T!I\u0011\u0011\r\u0016\u0002\u0002\u0013\u0005\u00111\r\u0005\n\u0003[R\u0013\u0011!C!\u0003_B\u0011\"!\u001d+\u0003\u0003%\t%a\u001d\t\u0013\u0005U$&!A\u0005\n\u0005]\u0004\u0002\u0003:\u0019\u0003\u0003%\t)!)\t\u0013\u0005\u0015\u0006$%A\u0005\u0002\u0005\u001d\u0006\"CA_1\u0005\u0005I\u0011QA`\u0011%\tY\rGI\u0001\n\u0003\t9\u000bC\u0005\u0002va\t\t\u0011\"\u0003\u0002x\tQ!j]8o\r>\u0014X.\u0019;\u000b\u0005mb\u0014a\u00024pe6\fGo\u001d\u0006\u0003{y\n\u0001B]1qQR|'/\u001f\u0006\u0002\u007f\u0005\u00191m\\7\u0004\u0001M)\u0001A\u0011%S+B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n1\u0011I\\=SK\u001a\u0004\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\r\u0019|'/\\1u\u0015\tie*\u0001\u0004pkR\u0004X\u000f\u001e\u0006\u0003\u001fr\n1!\u00199j\u0013\t\t&J\u0001\u0004G_Jl\u0017\r\u001e\t\u0003\u0007NK!\u0001\u0016#\u0003\u000fA\u0013x\u000eZ;diB\u0011aK\u0018\b\u0003/rs!\u0001W.\u000e\u0003eS!A\u0017!\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0015BA/E\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005u#\u0015!\u00027fm\u0016dW#A2\u0011\u0005\u0011lbBA3\u0018\u001b\u0005Q\u0014A\u0003&t_:4uN]7biB\u0011Q\rG\n\u00041\tK\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\tIwNC\u0001o\u0003\u0011Q\u0017M^1\n\u0005}[\u0017A\u0002\u001fj]&$h\bF\u0001h\u0003\u0015\t\u0007\u000f\u001d7z)\u0005!\bCA3\u0001Q\u0019Qb/!\u0001\u0002\u0004A\u0011qO`\u0007\u0002q*\u0011\u0011P_\u0001\tg\u000e\fG.\u00193pG*\u00111\u0010`\u0001\bi\u0006\\WM_8f\u0015\tih(\u0001\u0004hSRDWOY\u0005\u0003\u007fb\u0014\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u000b\tad\f\u0016+AAKH\u000f[8oA\r|W\u000e]1oS>t\u0007e\u001c2kK\u000e$\bEK\u0018\u0002\u0011I|w\u000fT3wK2Dca\u0007<\u0002\u0002\u0005-\u0011EAA\u0007\u0003qz#F\u000b\u0011Kg>tgi\u001c:nCR\u0004C.\u001a<fY\u0002\"\b.\u0019;!GJ,\u0017\r^3tA=tW\r\t&T\u001f:\u0003sN\u00196fGR\u0004\u0003/\u001a:!e><\bEK\u0018\u0002\u0017\u001ddwNY1m\u0019\u00164X\r\u001c\u0015\u00079Y\f\t!a\u0005\"\u0005\u0005U\u0011!S\u0018+U\u0001R5o\u001c8G_Jl\u0017\r\u001e\u0011mKZ,G\u000e\t;iCR\u00043M]3bi\u0016\u001c\be\u001c8fA\u001ddwNY1mA)\u001bvJ\u0014\u0011pE*,7\r\u001e\u0011qKJ\u0004\u0003/\u0019:uSRLwN\u001c\u0011+_\t)A*\u001a<fYN\u0011QDQ\u0015\u0004;)z\"AB$M\u001f\n\u000bEj\u0005\u0004+\u0005\u0006\u0005\"+\u0016\t\u0004\u0003GiR\"\u0001\r\u0015\u0005\u0005\u001d\u0002cAA\u0012U\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\rn\u0003\u0011a\u0017M\\4\n\t\u0005]\u0012\u0011\u0007\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0002cA\"\u0002@%\u0019\u0011\u0011\t#\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0013Q\n\t\u0004\u0007\u0006%\u0013bAA&\t\n\u0019\u0011I\\=\t\u0013\u0005=c&!AA\u0002\u0005u\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002VA1\u0011qKA/\u0003\u000fj!!!\u0017\u000b\u0007\u0005mC)\u0001\u0006d_2dWm\u0019;j_:LA!a\u0018\u0002Z\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)'a\u001b\u0011\u0007\r\u000b9'C\u0002\u0002j\u0011\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002PA\n\t\u00111\u0001\u0002H\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002>\u0005AAo\\*ue&tw\r\u0006\u0002\u0002.\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0010\t\u0005\u0003_\tY(\u0003\u0003\u0002~\u0005E\"AB(cU\u0016\u001cG\u000f\u000b\u0004+m\u0006\u0005\u00111\u0003\u0002\u0004%>;6CB\u0010C\u0003C\u0011V\u000b\u0006\u0002\u0002\bB\u0019\u00111E\u0010\u0015\t\u0005\u001d\u00131\u0012\u0005\n\u0003\u001f\u001a\u0013\u0011!a\u0001\u0003{!B!!\u001a\u0002\u0010\"I\u0011qJ\u0013\u0002\u0002\u0003\u0007\u0011q\t\u0015\u0007?Y\f\t!a\u0003)\ru1\u0018\u0011AAKC\t\t9*A\u00190U)\u0002C\u000b[3!Y\u00164X\r\u001c\u0011u_\u0002*8/\u001a\u0011g_J\u00043M]3bi&tw\r\t&T\u001f:\u0003sN\u00196fGR\u001c\bEK\u0018\u0002\u0007I{u\u000b\u000b\u0004\u001fm\u0006\u0005\u00111B\u0001\u0007\u000f2{%)\u0011')\r%2\u0018\u0011AA\n)\r!\u00181\u0015\u0005\bCR\u0002\n\u00111\u0001d\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\nTCAAUU\r\u0019\u00171V\u0016\u0003\u0003[\u0003B!a,\u0002:6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0017#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002<\u0006E&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00069QO\\1qa2LH\u0003BAa\u0003\u000f\u0004BaQAbG&\u0019\u0011Q\u0019#\u0003\r=\u0003H/[8o\u0011!\tIMNA\u0001\u0002\u0004!\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\na\u0001\\3wK2\u0004Cc\u0001;\u0002R\"9\u0011m\u0001I\u0001\u0002\u0004\u0019\u0017\u0001\u00053fM\u0006,H\u000e\u001e#fY&l\u0017\u000e^3s+\t\t9\u000e\u0005\u0003\u0002Z\u0006\u0005h\u0002BAn\u0003;\u0004\"\u0001\u0017#\n\u0007\u0005}G)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\t\u0019OC\u0002\u0002`\u0012\u000b\u0001\u0003Z3gCVdG/\u0012=uK:\u001c\u0018n\u001c8\u0002\u0011\u0015DXmY;u_J$\"\"a;\u0002x\n\u0005!Q\u0001B\u0005!\u0011\ti/a=\u000e\u0005\u0005=(bAAy\u0019\u0006!1/\u001b8l\u0013\u0011\t)0a<\u0003\u0019MKgn[#yK\u000e,Ho\u001c:\t\u000f\u0005eh\u00011\u0001\u0002|\u0006I1m\u001c8oK\u000e$xN\u001d\t\u0005\u0003[\fi0\u0003\u0003\u0002\u0000\u0006=(!D*j].\u001cuN\u001c8fGR|'\u000fC\u0004\u0003\u0004\u0019\u0001\r!a6\u0002\u000b)|'-\u0013#\t\u000f\t\u001da\u00011\u0001\u0002>\u0005Y\u0001/\u0019:uSRLwN\\%E\u0011\u001d\u0011YA\u0002a\u0001\u0005\u001b\taaY8oM&<\u0007\u0003\u0002B\b\u0005/i!A!\u0005\u000b\t\t-!1\u0003\u0006\u0004\u0005+q\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\n\t\te!\u0011\u0003\u0002\u0007\u0007>tg-[4\u00025A\u0014\u0018N\u001c;QKJ\u001c\b/Z2uSZ,\u0007K]8qKJ$\u0018.Z:\u0015\r\t}!Q\u0005B\u001f!\r\u0019%\u0011E\u0005\u0004\u0005G!%\u0001B+oSRDqAa\n\b\u0001\u0004\u0011I#A\u0005hK:,'/\u0019;peB!!1\u0006B\u001d\u001b\t\u0011iC\u0003\u0003\u00030\tE\u0012\u0001B2pe\u0016TAAa\r\u00036\u00059!.Y2lg>t'b\u0001B\u001c}\u0005Ia-Y:uKJDX\u000e\\\u0005\u0005\u0005w\u0011iCA\u0007Kg>tw)\u001a8fe\u0006$xN\u001d\u0005\b\u0005\u007f9\u0001\u0019\u0001B!\u0003-\u0001XM]:qK\u000e$\u0018N^3\u0011\t\t\r#\u0011J\u0007\u0003\u0005\u000bR1Aa\u0012O\u0003\u0011!\u0018.\\3\n\t\t-#Q\t\u0002\f!\u0016\u00148\u000f]3di&4X-\u0001\bqe&tGOU8x\u001f\nTWm\u0019;\u0015\u0011\t}!\u0011\u000bB*\u0005GBqAa\n\t\u0001\u0004\u0011I\u0003C\u0004\u0003V!\u0001\rAa\u0016\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0003\u0003Z\t}SB\u0001B.\u0015\u0011\u0011iF!\r\u0002\u0011\u0011\fG/\u00192j]\u0012LAA!\u0019\u0003\\\taqJ\u00196fGR<&/\u001b;fe\"9!Q\r\u0005A\u0002\t\u001d\u0014a\u0001:poB!!\u0011\u000eB:\u001b\t\u0011YG\u0003\u0003\u0003n\t=\u0014!\u0002;bE2,'b\u0001B9\u001d\u0006A\u0011M\\1msNL7/\u0003\u0003\u0003v\t-$a\u0001*po\u0006)a\r\\;tQRA!q\u0004B>\u0005{\u00129\tC\u0004\u0003(%\u0001\rA!\u000b\t\u000f\t}\u0014\u00021\u0001\u0003\u0002\u0006a1\u000f\u001e:j]\u001e<&/\u001b;feB\u0019!Na!\n\u0007\t\u00155N\u0001\u0007TiJLgnZ,sSR,'\u000fC\u0004\u0002z&\u0001\r!a?\u0002!I|w\u000fT3wK2,\u00050Z2vi>\u0014H\u0003BAv\u0005\u001bCq!!?\u000b\u0001\u0004\tY0A\nhY>\u0014\u0017\r\u001c'fm\u0016dW\t_3dkR|'\u000f\u0006\u0005\u0002l\nM%Q\u0013BL\u0011\u001d\tIp\u0003a\u0001\u0003wDqAa\u0001\f\u0001\u0004\t9\u000eC\u0004\u0003\b-\u0001\r!!\u0010\u0002\t\r|\u0007/\u001f\u000b\u0004i\nu\u0005bB1\r!\u0003\u0005\raY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132)\u0011\t9Ea)\t\u0013\u0005=\u0003#!AA\u0002\u0005uB\u0003BA3\u0005OC\u0011\"a\u0014\u0013\u0003\u0003\u0005\r!a\u0012\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003[\u0011i\u000bC\u0005\u0002PM\t\t\u00111\u0001\u0002>\u00051Q-];bYN$B!!\u001a\u00034\"I\u0011q\n\f\u0002\u0002\u0003\u0007\u0011q\t\u0015\u0007\u0001Y\f\tAa.\"\u0005\te\u0016!c>0U)\u0002\u0013\t\t1G_Jl\u0017\r\u001e1!i\"\fG\u000fI<sSR,7\u000fI1!AR\u000b'\r\\3aA%t\u0007ES*P\u001d\u00022wN]7bi*\u0001\u0003E\u000b\u0006!A)\u0002C\u000b[5tA\u0019|'/\\1uA\r\fg\u000e\t2fA\r|gNZ5hkJ,G\r\t;pA]|'o\u001b\u0011j]\u0002\"xo\u001c\u0011eS\u001a4WM]3oi\u0002:\u0018-_:-A\u0011,\u0007/\u001a8eS:<\u0007e\u001c8!i\",\u0007E^1mk\u0016\u0004cm\u001c:!A2,g/\u001a7au)\u0001\u0003E\u000b\u0011.A\u0001T5o\u001c8G_Jl\u0017\r\u001e\u0018S\u001f^\u0003\u0007\u0005\u000b;iK\u0002\"WMZ1vYR\u0004s\u000e\u001d;j_:L#\bI2sK\u0006$Xm\u001d\u0011p]\u0016\u0004#jU(OA=\u0014'.Z2uAA,'\u000f\t:po2\u0002cm\u001c7m_^Lgn\u001a\u0011uQ\u0016\u0004cm\u001c:nCR\u0004C-\u001a4j]\u0016$\u0007e\u00175fe\u0016l\u0006\u0006\u001b;uaNTtf\f6t_:d\u0017N\\3t]=\u0014x-\u000b\u0018\u000bA\u0001R\u0003%\f\u0011a\u0015N|gNR8s[\u0006$hf\u0012'P\u0005\u0006c\u0005M\u000f\u0011de\u0016\fG/Z:!C\u0002:Gn\u001c2bY\u0002R5k\u0014(!_\nTWm\u0019;!M>\u0014\b%\u001a<fef\u0004\u0003/\u0019:uSRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011uC\ndWM\u0003\u0011!U)\u0001\u0003E\u000b\u0011G_J\u0004\u0013\r\t;bE2,\u0007e^5uQ\u0002RWo\u001d;!_:,\u0007\u0005]3sgB,7\r^5wK\u0002\u001a'/Z1uK\u0012\u0004cM]8nAQLW.Z:uC6\u0004\b%\r\u0019!o&$\b\u000e\t8pA]Lg\u000eZ8xA\u0005tG\rI\u001a!e><8O\u0003\u0011!U\u0001\"\b.\u001a\u0011pkR\u0004X\u000f\u001e\u0011nS\u001eDG\u000f\t7p_.\u0004\u0013m\u001d\u0011g_2dwn^:!S\u001a\u0004\u0003\r\\3wK2\u0004\u0007%[:!g\u0016$\b\u0005^8!A*\u001bxN\u001c$pe6\fGOL$M\u001f\n\u000bE\n\u0019\u001e\u000bA\u0001R\u0003e_>|\u0015\u0001\u0002#\u0006I>\u000bA\u0001R\u0003\u0005\t\u0011#U>\u0014\u0017\n\u0012\u0012!u\u0001\u0012S\tZ4f\u0007>,h\u000e\u001e\u0012-\u0015\u0001\u0002#\u0006\t\u0011!EA\f'\u000f^5uS>t\u0017\n\u0012\u0012!u\u0001\u0002DF\u0003\u0011!U\u0001\u0002\u0003E\t9feN\u0004Xm\u0019;jm\u0016\u001c(\u0005\t\u001e!7\u0002Z(\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t\u0012uS6,7\u000f^1na\n\u0002#\bI\u00191\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\u0012#o\\<tE\u0001R\u0004e\u0017\u0011\\A\tJG-\r\u0012-AE\u0012\u0004%\u0018\u0017!7\u0002\u0012\u0013\u000e\u001a\u001a#Y\u0001\n4\u0007I/-Am\u0003#%\u001b34E1\u0002#\u0007\u000e\u0011^AuS\u0001\u0005\t\u0016!A\u0001j\b%\u0018\u0006!A)\u0002SP\u0003\u0011!U\u0001jX0 \u0006!A)R\u0001\u0005\t\u0016!\u0013\u001a\u0004C\u000f[3!C\n|g/\u001a\u0011rk\u0016\u0014\u0018\u0010I5tAI,h\u000eI<ji\"\u0004\u0013\rI<j]\u0012|w\u000f\f\u0011uQ\u0016t\u0007%\u00193eSRLwN\\1mYf\u0004\u0013\r\t4jK2$\u0007\u0005Y<j]\u0012|w\u000f\u0019\u0011xSRD\u0007\u0005\u001e5fA]Lg\u000eZ8xAML'0\u001a\u0011jg\u0002\u0012X\r^;s]\u0016$\u0007%\u0019;!i\",\u0007e]1nK\u0002bWM^3mA\u0005\u001c\b\u0005\u0019;j[\u0016\u001cH/Y7qA:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003e\u00148!i\",\u0007e\u001c;iKJ\u0004\u0003.\u00198eY\u0001Jg\r\t1mKZ,G\u000e\u0019\u0011jg\u0002rw\u000e\u001e\u0011tKR\u0004sN\u001d\u0011jg\u0002\u001aX\r\u001e\u0011u_\u0002\u0002'j]8o\r>\u0014X.\u0019;/%>;\u0006\r\f\u0011uQ\u0016\u0004s.\u001e;qkR\u0004S.[4ii\u0002bwn\\6!CN\u0004cm\u001c7m_^\u001c(H\u0003\u0011!U)\u0001\u0003E\u000b\u0011|wnT\u0001\u0005\t\u0016!w\n\"\u0018.\\3ti\u0006l\u0007O\t\u001e2a1\u0012s/\u001b8e_^\u0014#H\\;mY2\u0012#o\\<#um\u0013\u0013\u000eZ\u0019#YE\u0012T, \u0006!A)\u00023P\t;j[\u0016\u001cH/Y7qEi\n\u0004\u0007\f\u0012xS:$wn\u001e\u0012;]VdG\u000e\f\u0012s_^\u0014#h\u0017\u0012jIJ\u0012C&M\u001a^{*\u0001\u0003E\u000b\u0011|EQLW.Z:uC6\u0004(EO\u00191Y\t:\u0018N\u001c3po\nRd.\u001e7mY\t\u0012xn\u001e\u0012;7\nJGm\r\u0012-eQjVP\u0003\u0011!U\u0001jX0 \u0006!A)R\u0001\u0005\t\u0016!\u0001B\f'/Y7!Y\u00164X\r\u001c\u0011uQ\u0016\u0004C/\u00192mK\u0002bWM^3mAQ|\u0007e\u0019:fCR,\u0007E[:p]\u0002z'M[3diNT\u0001\u0005\t\u00160\u0001")
public class JsonFormat
implements Format,
Product,
Serializable {
    private final Level level;

    public static Level $lessinit$greater$default$1() {
        return JsonFormat$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Level> unapply(JsonFormat x$0) {
        return JsonFormat$.MODULE$.unapply(x$0);
    }

    public static Level apply$default$1() {
        return JsonFormat$.MODULE$.apply$default$1();
    }

    public static JsonFormat apply(Level level) {
        return JsonFormat$.MODULE$.apply(level);
    }

    @Scaladoc(value="/** JsonFormat level that creates one global JSON object per partition */")
    public static JsonFormat globalLevel() {
        return JsonFormat$.MODULE$.globalLevel();
    }

    @Scaladoc(value="/** JsonFormat level that creates one JSON object per row */")
    public static JsonFormat rowLevel() {
        return JsonFormat$.MODULE$.rowLevel();
    }

    @Scaladoc(value="/** Python companion object */")
    public static JsonFormat apply() {
        return JsonFormat$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Level level() {
        return this.level;
    }

    @Override
    public String defaultDelimiter() {
        return "\n";
    }

    @Override
    public String defaultExtension() {
        return "json";
    }

    @Override
    public SinkExecutor executor(SinkConnector connector, String jobID, int partitionID, Config config) {
        SinkExecutor sinkExecutor;
        Level level = this.level();
        if (JsonFormat$GLOBAL$.MODULE$.equals(level)) {
            sinkExecutor = this.globalLevelExecutor(connector, jobID, partitionID);
        } else if (JsonFormat$ROW$.MODULE$.equals(level)) {
            sinkExecutor = this.rowLevelExecutor(connector);
        } else {
            throw new MatchError((Object)level);
        }
        return sinkExecutor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void com$raphtory$formats$JsonFormat$$printPerspectiveProperties(JsonGenerator generator, Perspective perspective) {
        Interval interval;
        if (perspective.formatAsDate()) {
            generator.writeStringField("timestamp", perspective.timestampAsString());
        } else {
            generator.writeNumberField("timestamp", perspective.timestamp());
        }
        boolean bl = false;
        Some some = null;
        Option<Interval> option = perspective.window();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Interval interval2 = (Interval)some.value();
            if (interval2 instanceof DiscreteInterval) {
                DiscreteInterval discreteInterval = (DiscreteInterval)interval2;
                long interval3 = discreteInterval.size();
                generator.writeNumberField("window", interval3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (interval = (Interval)some.value()) instanceof TimeInterval) {
            TimeInterval timeInterval = (TimeInterval)interval;
            String name = timeInterval.name();
            generator.writeStringField("window", name);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void com$raphtory$formats$JsonFormat$$printRowObject(JsonGenerator generator, ObjectWriter serializer, Row row) {
        serializer.writeValue(generator, row.columns());
    }

    public void com$raphtory$formats$JsonFormat$$flush(JsonGenerator generator, StringWriter stringWriter, SinkConnector connector) {
        generator.flush();
        connector.write(stringWriter.toString());
        stringWriter.getBuffer().setLength(0);
    }

    private SinkExecutor rowLevelExecutor(SinkConnector connector) {
        return new SinkExecutor(this, connector){
            private final StringWriter stringWriter;
            private final JsonMapper mapper;
            private final ObjectWriter serializer;
            private Perspective currentPerspective;
            @Scaladoc(value="/** Logger instance for writing debug messages */")
            private Logger logger;
            private volatile boolean bitmap$0;
            private final /* synthetic */ JsonFormat $outer;
            private final SinkConnector connector$1;

            @Scaladoc(value="/** Thread safe version of `writeRow` used internally by Raphtory to write a `row`.\n    * Override this method to provide a more efficient thread-safe implementation.\n    */")
            public void threadSafeWriteRow(Row row) {
                SinkExecutor.threadSafeWriteRow$(this, row);
            }

            private Logger logger$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.logger = SinkExecutor.logger$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
            }

            private StringWriter stringWriter() {
                return this.stringWriter;
            }

            private JsonMapper mapper() {
                return this.mapper;
            }

            private ObjectWriter serializer() {
                return this.serializer;
            }

            private Perspective currentPerspective() {
                return this.currentPerspective;
            }

            private void currentPerspective_$eq(Perspective x$1) {
                this.currentPerspective = x$1;
            }

            public void setupPerspective(Perspective perspective, List<String> header) {
                this.currentPerspective_$eq(perspective);
            }

            public void writeRow(Row row) {
                JsonGenerator generator = this.mapper().createGenerator((Writer)this.stringWriter());
                generator.writeStartObject();
                this.$outer.com$raphtory$formats$JsonFormat$$printPerspectiveProperties(generator, this.currentPerspective());
                generator.writeFieldName("row");
                this.$outer.com$raphtory$formats$JsonFormat$$printRowObject(generator, this.serializer(), row);
                generator.writeEndObject();
                this.$outer.com$raphtory$formats$JsonFormat$$flush(generator, this.stringWriter(), this.connector$1);
                this.connector$1.closeItem();
            }

            public void closePerspective() {
            }

            public void close() {
                this.connector$1.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connector$1 = connector$1;
                SinkExecutor.$init$(this);
                this.stringWriter = new StringWriter();
                this.mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
                this.serializer = this.mapper().writer();
            }
        };
    }

    private SinkExecutor globalLevelExecutor(SinkConnector connector, String jobID, int partitionID) {
        return new SinkExecutor(this, jobID, partitionID, connector){
            private final StringWriter stringWriter;
            private final JsonMapper mapper;
            private final ObjectWriter serializer;
            private final JsonGenerator generator;
            @Scaladoc(value="/** Logger instance for writing debug messages */")
            private Logger logger;
            private volatile boolean bitmap$0;
            private final /* synthetic */ JsonFormat $outer;
            private final SinkConnector connector$2;

            @Scaladoc(value="/** Thread safe version of `writeRow` used internally by Raphtory to write a `row`.\n    * Override this method to provide a more efficient thread-safe implementation.\n    */")
            public void threadSafeWriteRow(Row row) {
                SinkExecutor.threadSafeWriteRow$(this, row);
            }

            private Logger logger$lzycompute() {
                $anon$2 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.logger = SinkExecutor.logger$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
            }

            private StringWriter stringWriter() {
                return this.stringWriter;
            }

            private JsonMapper mapper() {
                return this.mapper;
            }

            private ObjectWriter serializer() {
                return this.serializer;
            }

            private JsonGenerator generator() {
                return this.generator;
            }

            public void setupPerspective(Perspective perspective, List<String> header) {
                this.generator().writeStartObject();
                this.$outer.com$raphtory$formats$JsonFormat$$printPerspectiveProperties(this.generator(), perspective);
                this.generator().writeArrayFieldStart("rows");
                this.$outer.com$raphtory$formats$JsonFormat$$flush(this.generator(), this.stringWriter(), this.connector$2);
            }

            public void writeRow(Row row) {
                this.$outer.com$raphtory$formats$JsonFormat$$printRowObject(this.generator(), this.serializer(), row);
                this.$outer.com$raphtory$formats$JsonFormat$$flush(this.generator(), this.stringWriter(), this.connector$2);
            }

            public void closePerspective() {
                this.generator().writeEndArray();
                this.generator().writeEndObject();
                this.$outer.com$raphtory$formats$JsonFormat$$flush(this.generator(), this.stringWriter(), this.connector$2);
            }

            public void close() {
                this.generator().writeEndArray();
                this.generator().writeEndObject();
                this.$outer.com$raphtory$formats$JsonFormat$$flush(this.generator(), this.stringWriter(), this.connector$2);
                this.connector$2.closeItem();
                this.connector$2.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connector$2 = connector$2;
                SinkExecutor.$init$(this);
                this.stringWriter = new StringWriter();
                this.mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
                this.serializer = this.mapper().writer();
                this.generator = this.mapper().createGenerator((Writer)this.stringWriter());
                this.generator().setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
                this.generator().writeStartObject();
                this.generator().writeStringField("jobID", jobID$1);
                this.generator().writeNumberField("partitionID", partitionID$1);
                this.generator().writeArrayFieldStart("perspectives");
                $outer.com$raphtory$formats$JsonFormat$$flush(this.generator(), this.stringWriter(), connector$2);
            }
        };
    }

    public JsonFormat copy(Level level) {
        return new JsonFormat(level);
    }

    public Level copy$default$1() {
        return this.level();
    }

    public String productPrefix() {
        return "JsonFormat";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.level();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonFormat;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "level";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonFormat)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonFormat jsonFormat = (JsonFormat)x$1;
        Level level = this.level();
        Level level2 = jsonFormat.level();
        if (level == null) {
            if (level2 != null) {
                return false;
            }
        } else if (!level.equals(level2)) return false;
        if (!jsonFormat.canEqual(this)) return false;
        return true;
    }

    public JsonFormat(Level level) {
        this.level = level;
        Product.$init$((Product)this);
    }

    @Scaladoc(value="/** The level to use for creating JSON objects */")
    public static interface Level {
    }
}

