/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.output.format;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.output.sink.SinkConnector;
import com.raphtory.api.output.sink.SinkExecutor;
import com.typesafe.config.Config;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base trait for formats\n  *\n  * A format is a way to translate a `Table` into one or more text items.\n  *\n  * An item is a piece of information meaningful by itself and isolated from all other entities from the perspective of the format.\n  * For instance, in CSV format, an item might be just a row of the CSV table,\n  * whereas if the entire table is written out within just one JSON object, the entire JSON object would be an item.\n  *\n  * Implementations of this trait need to override the `defaultDelimiter` and `executor` methods.\n  * These shouldn't write out any data by themselves, instead they should rely on the provided `SinkConnector` to output the items.\n  * This allows the format to be used in combination with any implemented sink.\n  *\n  * @see [[com.raphtory.api.analysis.table.Table Table]]\n  *      [[com.raphtory.api.output.sink.Sink Sink]]\n  *      [[com.raphtory.api.output.sink.SinkExecutor SinkExecutor]]\n  *      [[com.raphtory.api.output.sink.SinkConnector SinkConnector]]\n  *      [[com.raphtory.formats.CsvFormat CsvFormat]]\n  *      [[com.raphtory.formats.JsonFormat JsonFormat]]\n  */")
@ScalaSignature(bytes="\u0006\u0005e3q\u0001B\u0003\u0011\u0002G\u0005\u0001\u0003C\u0003\u0018\u0001\u0019\u0005\u0001\u0004C\u00033\u0001\u0019\u0005\u0001\u0004C\u00037\u0001\u0019\u0005qG\u0001\u0004G_Jl\u0017\r\u001e\u0006\u0003\r\u001d\taAZ8s[\u0006$(B\u0001\u0005\n\u0003\u0019yW\u000f\u001e9vi*\u0011!bC\u0001\u0004CBL'B\u0001\u0007\u000e\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g-\u0001\teK\u001a\fW\u000f\u001c;EK2LW.\u001b;feV\t\u0011\u0004\u0005\u0002\u001bC9\u00111d\b\t\u00039Mi\u0011!\b\u0006\u0003==\ta\u0001\u0010:p_Rt\u0014B\u0001\u0011\u0014\u0003\u0019\u0001&/\u001a3fM&\u0011!e\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001\u001a\u0002\u0006B\u0001&_A\u0002\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!AK\u0016\u0002\u000fQ\f7.\u001a>pK*\u0011A&D\u0001\u0007O&$\b.\u001e2\n\u00059:#\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003E\nam\f\u0016+AI+G/\u001e:og\u0002\"\b.\u001a\u0011ji\u0016l\u0007\u0005Z3mS6LG/\u001a:!i>\u0004#-\u001a\u0011vg\u0016$\u0007EY=!i\",\u0007\u0005Y*j].\u001cuN\u001c8fGR|'\u000f\u0019\u0011u_\u0002\u001aX\r]1sCR,\u0007\u0005\u001e5fA%$X-\\:!S\u001a\u0004c.Z2fgN\f'/\u001f\u0011+_\u0005\u0001B-\u001a4bk2$X\t\u001f;f]NLwN\u001c\u0015\u0005\u0005\u0015zC'I\u00016\u0003U{#F\u000b\u0011SKR,(O\\:!i\",\u0007\u0005Z3gCVdG\u000f\t4jY\u0016\u0004S\r\u001f;f]NLwN\u001c\u0011u_\u0002*8/\u001a\u0011jM\u0002rW-\u001a3fI2\u0002SML4/A\u001d\u001a7O^\u0014!M>\u0014\b%\u0019\u0011D'Z\u0003c-\u001b7fA)z\u0013\u0001C3yK\u000e,Ho\u001c:\u0015\u000bar4)\u0012&\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m:\u0011\u0001B:j].L!!\u0010\u001e\u0003\u0019MKgn[#yK\u000e,Ho\u001c:\t\u000b}\u001a\u0001\u0019\u0001!\u0002\u0013\r|gN\\3di>\u0014\bCA\u001dB\u0013\t\u0011%HA\u0007TS:\\7i\u001c8oK\u000e$xN\u001d\u0005\u0006\t\u000e\u0001\r!G\u0001\u0006U>\u0014\u0017\n\u0012\u0005\u0006\r\u000e\u0001\raR\u0001\fa\u0006\u0014H/\u001b;j_:LE\t\u0005\u0002\u0013\u0011&\u0011\u0011j\u0005\u0002\u0004\u0013:$\b\"B&\u0004\u0001\u0004a\u0015AB2p]\u001aLw\r\u0005\u0002N#6\taJ\u0003\u0002L\u001f*\u0011\u0001+D\u0001\tif\u0004Xm]1gK&\u0011!K\u0014\u0002\u0007\u0007>tg-[4)\t\r)s\u0006V\u0011\u0002+\u0006\u0019)f\f\u0016+A\r\u0013X-\u0019;fg\u0002\n\u0007\u0005Y*j].,\u00050Z2vi>\u0014\b\rI5na2,W.\u001a8uS:<\u0007\u0005\u001e5fA\u0005\u001cG/^1mA=\u0004XM]1uS>t\u0007e\u001c4!i\",\u0007EZ8s[\u0006$(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u00043m\u001c8oK\u000e$xN\u001d\u0011uQ\u0016\u0004\u0003mU5oW\u000e{gN\\3di>\u0014\b\r\t;pA\t,\u0007%^:fI\u0002\u0012\u0017\u0010\t;iSN\u0004cm\u001c:nCR\u0004Co\u001c\u0011xe&$X\rI8vi\u0002\"\b.\u001a\u0011ji\u0016l7O\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E[8c\u0013\u0012\u0003C\u000f[3!\u0013\u0012\u0003sN\u001a\u0011uQ\u0016\u0004#n\u001c2!i\"\fG\u000fI4f]\u0016\u0014\u0018\r^3eAQDW\r\t;bE2,'\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004\u0003/\u0019:uSRLwN\\%EAQDW\rI%EA=4\u0007\u0005\u001e5fAA\f'\u000f^5uS>t\u0007e\u001c4!i\",\u0007\u0005^1cY\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001awN\u001c4jO\u0002\"\b.\u001a\u0011d_:4\u0017nZ;sCRLwN\u001c\u0011qe>4\u0018\u000eZ3eA\tL\b\u0005\u001e5fAU\u001cXM\u001d\u0006!A\u0001\u0002#\u0006\t!sKR,(O\u001c\u0011uQ\u0016\u0004\u0003mU5oW\u0016CXmY;u_J\u0004\u0007\u0005^8!E\u0016\u0004So]3eA\u0019|'\u000fI<sSRLgn\u001a\u0011pkR\u0004#/Z:vYR\u001c(\u0002\t\u0011!A)z\u0003\u0006\u0002\u0001&_]\u000b\u0013\u0001W\u0001\t:>R#\u0006\t\"bg\u0016\u0004CO]1ji\u00022wN\u001d\u0011g_Jl\u0017\r^:\u000bA\u0001R#\u0002\t\u0011+A\u0005\u0003cm\u001c:nCR\u0004\u0013n\u001d\u0011bA]\f\u0017\u0010\t;pAQ\u0014\u0018M\\:mCR,\u0007%\u0019\u0011a)\u0006\u0014G.\u001a1!S:$x\u000eI8oK\u0002z'\u000fI7pe\u0016\u0004C/\u001a=uA%$X-\\:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\ne\u000eI5uK6\u0004\u0013n\u001d\u0011bAALWmY3!_\u001a\u0004\u0013N\u001c4pe6\fG/[8oA5,\u0017M\\5oO\u001a,H\u000e\t2zA%$8/\u001a7gA\u0005tG\rI5t_2\fG/\u001a3!MJ|W\u000eI1mY\u0002zG\u000f[3sA\u0015tG/\u001b;jKN\u0004cM]8nAQDW\r\t9feN\u0004Xm\u0019;jm\u0016\u0004sN\u001a\u0011uQ\u0016\u0004cm\u001c:nCRt#\u0002\t\u0011+A\u0019{'\u000fI5ogR\fgnY3-A%t\u0007eQ*WA\u0019|'/\\1uY\u0001\ng\u000eI5uK6\u0004S.[4ii\u0002\u0012W\r\t6vgR\u0004\u0013\r\t:po\u0002zg\r\t;iK\u0002\u001a5K\u0016\u0011uC\ndW\r\f\u0006!A)\u0002s\u000f[3sK\u0006\u001c\b%\u001b4!i\",\u0007%\u001a8uSJ,\u0007\u0005^1cY\u0016\u0004\u0013n\u001d\u0011xe&$H/\u001a8!_V$\be^5uQ&t\u0007E[;ti\u0002zg.\u001a\u0011K'>s\u0005e\u001c2kK\u000e$H\u0006\t;iK\u0002*g\u000e^5sK\u0002R5k\u0014(!_\nTWm\u0019;!o>,H\u000e\u001a\u0011cK\u0002\ng\u000eI5uK6t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I%na2,W.\u001a8uCRLwN\\:!_\u001a\u0004C\u000f[5tAQ\u0014\u0018-\u001b;!]\u0016,G\r\t;pA=4XM\u001d:jI\u0016\u0004C\u000f[3!A\u0012,g-Y;mi\u0012+G.[7ji\u0016\u0014\b\rI1oI\u0002\u0002W\r_3dkR|'\u000f\u0019\u0011nKRDw\u000eZ:/\u0015\u0001\u0002#\u0006\t+iKN,\u0007e\u001d5pk2$gn\n;!oJLG/\u001a\u0011pkR\u0004\u0013M\\=!I\u0006$\u0018\r\t2zAQDW-\\:fYZ,7\u000f\f\u0011j]N$X-\u00193!i\",\u0017\u0010I:i_VdG\r\t:fYf\u0004sN\u001c\u0011uQ\u0016\u0004\u0003O]8wS\u0012,G\r\t1TS:\\7i\u001c8oK\u000e$xN\u001d1!i>\u0004s.\u001e;qkR\u0004C\u000f[3!SR,Wn\u001d\u0018\u000bA\u0001R\u0003\u0005\u00165jg\u0002\nG\u000e\\8xg\u0002\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0011u_\u0002\u0012W\rI;tK\u0012\u0004\u0013N\u001c\u0011d_6\u0014\u0017N\\1uS>t\u0007e^5uQ\u0002\ng.\u001f\u0011j[BdW-\\3oi\u0016$\u0007e]5oW:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005Q:fK\u0002Z6lY8n]I\f\u0007\u000f\u001b;peft\u0013\r]5/C:\fG._:jg:\"\u0018M\u00197f]Q\u000b'\r\\3!)\u0006\u0014G.Z/^\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\u00023lW2p[:\u0012\u0018\r\u001d5u_JLh&\u00199j]=,H\u000f];u]MLgn\u001b\u0018TS:\\\u0007eU5oWvk&\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011\\7\u000e|WN\f:ba\"$xN]=/CBLgf\\;uaV$hf]5oW:\u001a\u0016N\\6Fq\u0016\u001cW\u000f^8sAMKgn[#yK\u000e,Ho\u001c:^;*\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003eW.d_6t#/\u00199ii>\u0014\u0018PL1qS:zW\u000f\u001e9vi:\u001a\u0018N\\6/'&t7nQ8o]\u0016\u001cGo\u001c:!'&t7nQ8o]\u0016\u001cGo\u001c:^;*\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003eW.d_6t#/\u00199ii>\u0014\u0018P\f4pe6\fGo\u001d\u0018DgZ4uN]7bi\u0002\u001a5O\u001e$pe6\fG/X/\u000bA\u0001R\u0003\u0005\t\u0011!A\u0001Z6lY8n]I\f\u0007\u000f\u001b;peftcm\u001c:nCR\u001chFS:p]\u001a{'/\\1uA)\u001bxN\u001c$pe6\fG/X/\u000bA\u0001Rs\u0006")
public interface Format {
    @Scaladoc(value="/** Returns the item delimiter to be used by the `SinkConnector` to separate the items if necessary */")
    public String defaultDelimiter();

    @Scaladoc(value="/** Returns the default file extension to use if needed, e.g. 'csv' for a CSV file */")
    public String defaultExtension();

    @Scaladoc(value="/** Creates a `SinkExecutor` implementing the actual operation of the format\n    * @param connector the `SinkConnector` to be used by this format to write out the items\n    * @param jobID the ID of the job that generated the table\n    * @param partitionID the ID of the partition of the table\n    * @param config the configuration provided by the user\n    * @return the `SinkExecutor` to be used for writing out results\n    */")
    public SinkExecutor executor(SinkConnector var1, String var2, int var3, Config var4);
}

