/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.input;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.MaybeType;
import com.raphtory.api.input.NoType$;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Property;
import com.raphtory.api.input.Type;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.time.DateTimeParser$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** trait for creating a Graph by adding and deleting vertices and edges.\n  *\n  * An implementation of `GraphBuilder` needs to override `parseTuple(tuple: T)` to define parsing of input data.\n  * The input data is generated using a [[com.raphtory.api.input.Spout Spout]] and passed to the\n  * `parseTuple` method which is responsible for turning the raw data into a list of graph updates. Inside the\n  * `parseTuple` implementation, use methods `addVertex` and `addEdge`\n  * for adding vertices and edges. The resulting graph updates are send to the partitions responsible for\n  * handling the vertices and edges.\n  *\n  * @example\n  * {{{\n  * class TwitterGraphBuilder() extends GraphBuilder[String] {\n  *   override def parseTuple(fileLine: String): Unit = {\n  *     val sourceNode = fileLine(0)\n  *     val srcID      = sourceNode.toLong\n  *     val targetNode = fileLine(1)\n  *     val tarID      = targetNode.toLong\n  *     val timeStamp  = fileLine(2).toLong\n  *\n  *     addVertex(timeStamp, srcID, Properties(ImmutableProperty(\"name\", sourceNode)), Type(\"User\"))\n  *     addVertex(timeStamp, tarID, Properties(ImmutableProperty(\"name\", targetNode)), Type(\"User\"))\n  *     addEdge(timeStamp, srcID, tarID, Type(\"Follows\"))\n  *   }\n  * }\n  * }}}\n  * @see [[Properties]] [[Spout]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u00055eaB\u000b\u0017!\u0003\r\ta\b\u0005\u0006M\u0001!\ta\n\u0005\u0006W\u00011\t\u0002\f\u0005\u0006\u000b\u00021\tA\u0012\u0005\u0006\u0015\u0002!\ta\u0013\u0005\u0006\u0015\u0002!\t\u0001\u001a\u0005\u0006m\u0002!\ta\u001e\u0005\u0007m\u0002!\t!a\u0002\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002\"CA$\u0001E\u0005I\u0011AA%\u0011%\ty\u0006AI\u0001\n\u0003\t\t\u0007C\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002h!I\u00111\u000e\u0001\u0012\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003[\u0002\u0011\u0013!C\u0001\u0003CB\u0011\"a\u001c\u0001#\u0003%\t!a\u001a\t\u0013\u0005E\u0004!%A\u0005\u0002\u0005MtaBA?-!\u0005\u0011q\u0010\u0004\u0007+YA\t!!!\t\u000f\u0005\r%\u0003\"\u0001\u0002\u0006\"9\u0011q\u0003\n\u0005\u0002\u0005\u001d%!B$sCBD'BA\f\u0019\u0003\u0015Ig\u000e];u\u0015\tI\"$A\u0002ba&T!a\u0007\u000f\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011!H\u0001\u0004G>l7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001)!\t\t\u0013&\u0003\u0002+E\t!QK\\5u\u0003EA\u0017M\u001c3mK\u001e\u0013\u0018\r\u001d5Va\u0012\fG/\u001a\u000b\u0003Q5BQA\f\u0002A\u0002=\na!\u001e9eCR,\u0007C\u0001\u0019C\u001d\t\ttH\u0004\u00023y9\u00111G\u000f\b\u0003ier!!\u000e\u001d\u000e\u0003YR!a\u000e\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012BA\u000e\u001d\u0013\tY$$A\u0005j]R,'O\\1mg&\u0011QHP\u0001\u0006OJ\f\u0007\u000f\u001b\u0006\u0003wiI!\u0001Q!\u0002\u001f\u001d\u0013\u0018\r\u001d5BYR,'/\u0019;j_:T!!\u0010 \n\u0005\r#%aC$sCBDW\u000b\u001d3bi\u0016T!\u0001Q!\u0002\u000b%tG-\u001a=\u0016\u0003\u001d\u0003\"!\t%\n\u0005%\u0013#\u0001\u0002'p]\u001e\f\u0011\"\u00193e-\u0016\u0014H/\u001a=\u0015\t!be\n\u0015\u0005\u0006\u001b\u0012\u0001\raR\u0001\u000bkB$\u0017\r^3US6,\u0007\"B(\u0005\u0001\u00049\u0015!B:sG&#\u0007\"B)\u0005\u0001\u0004\u0011\u0016A\u00039pgRK\b/Z!sOB\u00111\u000bV\u0007\u0002-%\u0011QK\u0006\u0002\u0005)f\u0004X\r\u000b\u0003\u0005/\u0006\u0014\u0007C\u0001-`\u001b\u0005I&B\u0001.\\\u0003!\u00198-\u00197bI>\u001c'B\u0001/^\u0003\u001d!\u0018m[3{_\u0016T!A\u0018\u000f\u0002\r\u001dLG\u000f[;c\u0013\t\u0001\u0017L\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\u0005\u0019\u0017!a:0U)\u0002\u0013\t\u001a3tA\u0005\u0004c.Z<!m\u0016\u0014H/\u001a=!i>\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0011pe\u0002*\b\u000fZ1uKN\u0004\u0013M\u001c\u0011fq&\u001cH/\u001b8hAY,'\u000f^3y\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011va\u0012\fG/\u001a+j[\u0016\u0004C/[7fgR\fW\u000e\u001d\u0011g_J\u0004c/\u001a:uKb\u0004S\u000f\u001d3bi\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001a(oY%eA\u0001\u0002\u0003\u0005\t\u0011J\t\u0002zg\r\t<feR,\u0007\u0010\t;pA\u0005$GmL;qI\u0006$XM\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007\u0005]8t)f\u0004X-\u0011:hAM\u0004XmY5gs\u0002\n\u0007eW.UsB,\u0007\u0005V=qKvk\u0006EZ8sAQDW\r\t<feR,\u0007P\u0003\u0011!A\u0001Rs\u0006\u0006\u0004)K\u001a<G.\u001d\u0005\u0006\u001b\u0016\u0001\ra\u0012\u0005\u0006\u001f\u0016\u0001\ra\u0012\u0005\bQ\u0016\u0001\n\u00111\u0001j\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003'*L!a\u001b\f\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004n\u000bA\u0005\t\u0019\u00018\u0002\u0015Y,'\u000f^3y)f\u0004X\r\u0005\u0002T_&\u0011\u0001O\u0006\u0002\n\u001b\u0006L(-\u001a+za\u0016DqA]\u0003\u0011\u0002\u0003\u0007q)\u0001\btK\u000e|g\u000eZ1ss&sG-\u001a=)\t\u00159\u0016\r^\u0011\u0002k\u0006!Yi\f\u0016+A\u0005#Gm\u001d\u0011bA9,w\u000f\t<feR,\u0007\u0010\t;pAQDW\rI4sCBD\u0007e\u001c:!kB$\u0017\r^3tA\u0005t\u0007%\u001a=jgRLgn\u001a\u0011wKJ$X\r\u001f\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007%\u001e9eCR,G+[7fAQLW.Z:uC6\u0004\bEZ8sAY,'\u000f^3yAU\u0004H-\u0019;f\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!gJ\u001c\u0017\n\u001a\u0011!A\u0001\u0002\u0003%\u0013#!_\u001a\u0004c/\u001a:uKb\u0004Co\u001c\u0011bI\u0012|S\u000f\u001d3bi\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u0002(o\u001c9feRLWm\u001d\u0011PaRLwN\\1mYf\u00043\u000f]3dS\u001aL\bE^3si\u0016D\b\u0005\u001d:pa\u0016\u0014H/[3tA\u0019|'\u000f\t;iK\u0002*\b\u000fZ1uK\u0002B3/Z3!7n\u001bw.\u001c\u0018sCBDGo\u001c:z]\u0005\u0004\u0018NL5oaV$h\u0006\u0015:pa\u0016\u0014H/[3tAA\u0013x\u000e]3si&,7/X/!M>\u0014\b\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u0019<bS2\f'\r\\3!aJ|\u0007/\u001a:us\u0002\"\u0018\u0010]3tS)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAY,'\u000f^3y)f\u0004X\rI(qi&|g.\u00197ms\u0002\u001a\b/Z2jMf\u0004\u0013\rI.\\)f\u0004X\r\t+za\u0016lV\f\t4pe\u0002\"\b.\u001a\u0011wKJ$X\r\u001f\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI:fG>tG-\u0019:z\u0013:$W\r\u001f\u0011PaRLwN\\1mYf\u00043\u000f]3dS\u001aL\b%\u0019\u0011tK\u000e|g\u000eZ1ss\u0002Jg\u000eZ3yAQD\u0017\r\u001e\u0011jg\u0002*8/\u001a3!i>\u0004C-\u001a;fe6Lg.\u001a\u0011uQ\u0016\u0004sN\u001d3fe\u0002zg\rI;qI\u0006$Xm\u001d\u0011xSRD\u0007\u0005\u001e5fAM\fW.\u001a\u0011akB$\u0017\r^3US6,\u0007M\u0003\u0011!A\u0001Rs&A\u0004bI\u0012,EmZ3\u0015\u000f!B\u0018P\u001f?~\u007f\")QJ\u0002a\u0001\u000f\")qJ\u0002a\u0001\u000f\")1P\u0002a\u0001\u000f\u0006)Am\u001d;JI\"9\u0001N\u0002I\u0001\u0002\u0004I\u0007b\u0002@\u0007!\u0003\u0005\rA\\\u0001\tK\u0012<W\rV=qK\"9!O\u0002I\u0001\u0002\u00049\u0005&\u0002\u0004XC\u0006\r\u0011EAA\u0003\u0003\u0011}vF\u000b\u0016!\u0003\u0012$7\u000fI1!]\u0016<\b%\u001a3hK\u0002\"x\u000e\t;iK\u0002:'/\u00199iA=\u0014\b%\u001e9eCR,7\u000fI1oA\u0015D\u0018n\u001d;j]\u001e\u0004S\rZ4f\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011va\u0012\fG/\u001a+j[\u0016\u0004C/[7fgR\fW\u000e\u001d\u0011g_J\u0004S\rZ4fAU\u0004H-\u0019;f\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!gJ\u001c\u0017\n\u001a\u0011!A\u0001\u0002\u0003%\u0013#!_\u001a\u00043o\\;sG\u0016\u0004c/\u001a:uKb\u0004sN\u001a\u0011uQ\u0016\u0004S\rZ4f\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!IN$\u0018\n\u001a\u0011!A\u0001\u0002\u0003%\u0013#!_\u001a\u0004C-Z:uS:\fG/[8oAY,'\u000f^3yA=4\u0007\u0005\u001e5fA\u0015$w-\u001a\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t9s_B,'\u000f^5fg\u0002*GmZ3!aJ|\u0007/\u001a:uS\u0016\u001c\bEZ8sAQDW\rI;qI\u0006$X\r\t\u0015tK\u0016\u00043lW2p[:\u0012\u0018\r\u001d5u_JLh&\u00199j]%t\u0007/\u001e;/!J|\u0007/\u001a:uS\u0016\u001c\b\u0005\u0015:pa\u0016\u0014H/[3t;v\u0003cm\u001c:!i\",'\u0002\t\u0011!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!CZ\f\u0017\u000e\\1cY\u0016\u0004\u0003O]8qKJ$\u0018\u0010\t;za\u0016\u001c\u0018F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007%\u001a3hKRK\b/\u001a\u0011!AM\u0004XmY5gs\u0002\n\u0007eW.UsB,\u0007\u0005V=qKvk\u0006EZ8sAQDW\rI3eO\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001aXmY8oI\u0006\u0014\u00180\u00138eKb\u0004s\n\u001d;j_:\fG\u000e\\=!gB,7-\u001b4zA\u0005\u00043/Z2p]\u0012\f'/\u001f\u0011j]\u0012,\u0007\u0010\t;iCR\u0004\u0013n\u001d\u0011vg\u0016$\u0007\u0005^8!I\u0016$XM]7j]\u0016\u0004C\u000f[3!_J$WM\u001d\u0011pM\u0002*\b\u000fZ1uKN\u0004s/\u001b;iAQDW\rI:b[\u0016\u0004\u0003-\u001e9eCR,G+[7fA*\u0001\u0003\u0005\t\u0011+_QI\u0001&!\u0003\u0002\f\u00055\u0011q\u0002\u0005\u0006\u001b\u001e\u0001\ra\u0012\u0005\u0006\u001f\u001e\u0001\ra\u0012\u0005\u0006w\u001e\u0001\ra\u0012\u0005\u0006#\u001e\u0001\rA\u0015\u0015\u0006\u000f]\u000b\u00171C\u0011\u0003\u0003+\t!qL\u0018+U\u0001\nE\rZ:!C\u0002rWm\u001e\u0011fI\u001e,\u0007\u0005^8!i\",\u0007e\u001a:ba\"\u0004sN\u001d\u0011va\u0012\fG/Z:!C:\u0004S\r_5ti&tw\rI3eO\u0016T\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAU\u0004H-\u0019;f)&lW\r\t;j[\u0016\u001cH/Y7qA\u0019|'\u000fI3eO\u0016\u0004S\u000f\u001d3bi\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001a(oY%eA\u0001\u0002\u0003\u0005\t\u0011J\t\u0002zg\rI:pkJ\u001cW\r\t<feR,\u0007\u0010I8gAQDW\rI3eO\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\"7\u000f^%eA\u0001\u0002\u0003\u0005\t\u0011J\t\u0002zg\r\t3fgRLg.\u0019;j_:\u0004c/\u001a:uKb\u0004sN\u001a\u0011uQ\u0016\u0004S\rZ4f\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!a>\u001cH+\u001f9f\u0003J<\u0007\u0005\t\u0011ta\u0016\u001c\u0017NZ=!C\u0002Z6\fV=qK\u0002\"\u0016\u0010]3^;\u00022wN\u001d\u0011uQ\u0016\u0004S\rZ4f\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003!\t7o]5h]&#EcA$\u0002\u001c!9\u0011Q\u0004\u0005A\u0002\u0005}\u0011aC;oSF,Xm\u00115beN\u0004B!!\t\u0002*9!\u00111EA\u0013!\t)$%C\u0002\u0002(\t\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0016\u0003[\u0011aa\u0015;sS:<'bAA\u0014E!*\u0001bV1\u00022\u0005\u0012\u00111G\u0001\u0003\\=R#\u0006I\"p]Z,g.[3oG\u0016\u0004S.\u001a;i_\u0012\u0004cm\u001c:!O\u0016tWM]1uS:<\u0007%\u001e8jcV,\u0007%\u0013#tA\t\f7/\u001a3!_:\u0004c/\u001a:uKb\u0004c.Y7fg*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!+N,\u0007e\u001c4!i\"L7\u000fI7fi\"|G\rI5tA=\u0004H/[8oC2t\u0003%\u0011\u0011a\u000fJ\f\u0007\u000f\u001b\"vS2$WM\u001d1!SN\u0004cM]3fAQ|\u0007%Y:tS\u001et\u0007E^3si\u0016D\b%\u0013#tA%t\u0007\u0005Z5gM\u0016\u0014XM\u001c;!o\u0006L8\u000f\f\u0011qe>4\u0018\u000eZ3e\u0015\u0001\u0002\u0003\u0005\t\u0016!i\"\fG\u000fI3bG\"\u0004c/\u001a:uKb\u0004\u0013n\u001d\u0011bgNLwM\\3eA\u0005\u0004SO\\5rk\u0016\u0004\u0013\n\u0012\u0011pM\u0002\"\u0018\u0010]3!A2{gn\u001a1/\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011v]&\fX/Z\"iCJ\u001c\bEV3si\u0016D\bE\\1nK*\u0001\u0003\u0005\t\u0011+_\u0005i\u0001/\u0019:tK\u0012\u000bG/\u001a;j[\u0016$RaRA\u001d\u0003{Aq!a\u000f\n\u0001\u0004\ty\"\u0001\u0005eCR,G+[7f\u0011%\ty$\u0003I\u0001\u0002\u0004\ty\"\u0001\u0004g_Jl\u0017\r\u001e\u0015\u0006\u0013]\u000b\u00171I\u0011\u0003\u0003\u000b\n11Z\u0018+U\u0001\u001auN\u001c<f]&,gnY3![\u0016$\bn\u001c3!M>\u0014\beY8om\u0016\u0014H/\u001b8hA\u0011\fG/Z:!S:$x\u000eI3q_\u000eD7\u000f\t;pA\t,\u0007%^:fI\u0002Jg\u000e^3s]\u0006dG.\u001f\u0011cs\u0002\u0012\u0016\r\u001d5u_JLh\u0006\t+iSN\u0004\u0013n\u001d\u0011uQ\u0016\u00043/Y7fA\u0019,hn\u0019;j_:T\u0001\u0005\t\u0011!U\u0001*8/\u001a3!Ef\u0004C\u000f[3!A\u0006$G\r\t<feR,\u0007\u0010\u0019\u0011b]\u0012\u0004\u0003-\u00193eA\u0015$w-\u001a1!MVt7\r^5p]Nd\u0003e]8!G\u0006t\u0007EY3!G\u0006dG.\u001a3!Kb\u0004H.[2ji2L\b%\u001b8!C\u0002:'/\u00199iA\t,\u0018\u000e\u001c3fe*\u0001\u0003\u0005\t\u0011+AQ|\u0007E]3ek\u000e,\u0007\u0005\u001e5fA9,XNY3sA=4\u0007eY8om\u0016\u00148/[8og\u0002:\b.\u001a8!a\u0016\u0014hm\u001c:nS:<\u0007%\\;mi&\u0004H.\u001a\u0011va\u0012\fG/Z:!a\u0016\u0014\b\u0005^;qY\u0016t#\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\"\u0017\r^3US6,\u0007\u0005\u00165fA\u0011\fG/\u001a\u0011tiJLgn\u001a\u0011z_V\u0004s/[:iAQ|\u0007eY8om\u0016\u0014HO\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007EZ8s[\u0006$\b\u0005\u00165fA\u0019|'/\\1uA=4\u0007\u0005\u001e5fA\u0011\fG/\u001a\u0011tiJLgn\u001a\u0018!)\",\u0007\u0005Z3gCVdG\u000f\t2fS:<\u0007EI=zsflS*T\u0017eIn\u0003\u0003\n\u0013\u001en[j\u001a8o\u0017\u0018T'NkVL\f\u0012\u000bA\u0001\u0002\u0003E\u000b\u0011/\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003M\tG\r\u001a,feR,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYEK\u0002j\u0003\u001bZ#!a\u0014\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033\u0012\u0013AC1o]>$\u0018\r^5p]&!\u0011QLA*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014C\u0012$g+\u001a:uKb$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003GR3A\\A'\u0003M\tG\r\u001a,feR,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\tIGK\u0002H\u0003\u001b\n\u0011#\u00193e\u000b\u0012<W\r\n3fM\u0006,H\u000e\u001e\u00135\u0003E\tG\rZ#eO\u0016$C-\u001a4bk2$H%N\u0001\u0012C\u0012$W\tZ4fI\u0011,g-Y;mi\u00122\u0014a\u00069beN,G)\u0019;fi&lW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t)H\u000b\u0003\u0002 \u00055\u0003&\u0002\u0001XC\u0006e\u0014EAA>\u0003)EqF\u000b\u0016!iJ\f\u0017\u000e\u001e\u0011g_J\u00043M]3bi&tw\rI1!\u000fJ\f\u0007\u000f\u001b\u0011cs\u0002\nG\rZ5oO\u0002\ng\u000e\u001a\u0011eK2,G/\u001b8hAY,'\u000f^5dKN\u0004\u0013M\u001c3!K\u0012<Wm\u001d\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0005s\u0007%[7qY\u0016lWM\u001c;bi&|g\u000eI8gA\u0001<%/\u00199i\u0005VLG\u000eZ3sA\u0002rW-\u001a3tAQ|\u0007e\u001c<feJLG-\u001a\u0011aa\u0006\u00148/\u001a+va2,\u0007\u0006^;qY\u0016T\u0004\u0005V\u0015aAQ|\u0007\u0005Z3gS:,\u0007\u0005]1sg&tw\rI8gA%t\u0007/\u001e;!I\u0006$\u0018M\f\u0006!A)\u0002C\u000b[3!S:\u0004X\u000f\u001e\u0011eCR\f\u0007%[:!O\u0016tWM]1uK\u0012\u0004So]5oO\u0002\n\u0007eW.d_6t#/\u00199ii>\u0014\u0018PL1qS:Jg\u000e];u]M\u0003x.\u001e;!'B|W\u000f^/^A\u0005tG\r\t9bgN,G\r\t;pAQDWM\u0003\u0011!U\u0001\u0002\u0007/\u0019:tKR+\b\u000f\\3aA5,G\u000f[8eA]D\u0017n\u00195!SN\u0004#/Z:q_:\u001c\u0018N\u00197fA\u0019|'\u000f\t;ve:Lgn\u001a\u0011uQ\u0016\u0004#/Y<!I\u0006$\u0018\rI5oi>\u0004\u0013\r\t7jgR\u0004sN\u001a\u0011he\u0006\u0004\b\u000eI;qI\u0006$Xm\u001d\u0018!\u0013:\u001c\u0018\u000eZ3!i\",'\u0002\t\u0011+A\u0001\u0004\u0018M]:f)V\u0004H.\u001a1!S6\u0004H.Z7f]R\fG/[8oY\u0001*8/\u001a\u0011nKRDw\u000eZ:!A\u0006$GMV3si\u0016D\b\rI1oI\u0002\u0002\u0017\r\u001a3FI\u001e,\u0007M\u0003\u0011!U\u00012wN\u001d\u0011bI\u0012Lgn\u001a\u0011wKJ$\u0018nY3tA\u0005tG\rI3eO\u0016\u001ch\u0006\t+iK\u0002\u0012Xm];mi&tw\rI4sCBD\u0007%\u001e9eCR,7\u000fI1sK\u0002\u001aXM\u001c3!i>\u0004C\u000f[3!a\u0006\u0014H/\u001b;j_:\u001c\bE]3ta>t7/\u001b2mK\u00022wN\u001d\u0006!A)\u0002\u0003.\u00198eY&tw\r\t;iK\u00022XM\u001d;jG\u0016\u001c\b%\u00198eA\u0015$w-Z:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002U\r_1na2,'\u0002\t\u0011+Am\\8P\u0003\u0011!U\u0001\u001aG.Y:tAQ;\u0018\u000e\u001e;fe\u001e\u0013\u0018\r\u001d5Ck&dG-\u001a:)S\u0001*\u0007\u0010^3oIN\u0004sI]1qQ\n+\u0018\u000e\u001c3fen\u001bFO]5oOv\u00033P\u0003\u0011!U\u0001\u0002\u0003e\u001c<feJLG-\u001a\u0011eK\u001a\u0004\u0003/\u0019:tKR+\b\u000f\\3)M&dW\rT5oKj\u00023\u000b\u001e:j]\u001eL#\bI+oSR\u0004S\bI>\u000bA\u0001R\u0003\u0005\t\u0011!AY\fG\u000eI:pkJ\u001cWMT8eK\u0002j\u0004EZ5mK2Kg.\u001a\u00151S)\u0001\u0003E\u000b\u0011!A\u0001\u0002c/\u00197!gJ\u001c\u0017\n\u0012\u0011!A\u0001\u0002\u0003%\u0010\u0011t_V\u00148-\u001a(pI\u0016tCo\u001c'p]\u001eT\u0001\u0005\t\u0016!A\u0001\u0002\u0003E^1mAQ\f'oZ3u\u001d>$W\rI\u001f!M&dW\rT5oK\"\n\u0014F\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011wC2\u0004C/\u0019:J\t\u0002\u0002\u0003\u0005\t\u0011!{\u0001\"\u0018M]4fi:{G-\u001a\u0018u_2{gn\u001a\u0006!A)\u0002\u0003\u0005\t\u0011!m\u0006d\u0007\u0005^5nKN#\u0018-\u001c9!Au\u0002c-\u001b7f\u0019&tW\r\u000b\u001a*]Q|Gj\u001c8h\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011bI\u00124VM\u001d;fq\"\"\u0018.\\3Ti\u0006l\u0007\u000f\f\u0011te\u000eLE\t\f\u0011Qe>\u0004XM\u001d;jKND\u0013*\\7vi\u0006\u0014G.\u001a)s_B,'\u000f^=)E9\fW.\u001a\u0012-AM|WO]2f\u001d>$W-K\u0015-AQK\b/\u001a\u0015#+N,'OI\u0015*\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\nG\r\u001a,feR,\u0007\u0010\u000b;j[\u0016\u001cF/Y7qY\u0001\"\u0018M]%EY\u0001\u0002&o\u001c9feRLWm\u001d\u0015J[6,H/\u00192mKB\u0013x\u000e]3sifD#E\\1nK\nb\u0003\u0005^1sO\u0016$hj\u001c3fS%b\u0003\u0005V=qK\"\u0012Sk]3sE%J#\u0002\t\u0011+A\u0001\u0002\u0003\u0005I1eI\u0016#w-\u001a\u0015uS6,7\u000b^1na2\u00023O]2J\t2\u0002C/\u0019:J\t2\u0002C+\u001f9fQ\t2u\u000e\u001c7poN\u0014\u0013&\u000b\u0006!A)\u0002\u0003\u0005I?\u000bA\u0001R\u0003% \u0006!A)\u0002S0`?\u000bA\u0001R\u0003\u0005Q:fK\u0002Z6\f\u0015:pa\u0016\u0014H/[3t;v\u00033lW*q_V$X,\u0018\u0006!A)z\u0013!B$sCBD\u0007CA*\u0013'\t\u0011\u0002%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u007f\"2aRAE\u0011\u001d\ti\u0002\u0006a\u0001\u0003?AS\u0001F,b\u0003c\u0001")
public interface Graph {
    public void handleGraphUpdate(GraphAlteration.GraphUpdate var1);

    public long index();

    public static /* synthetic */ void addVertex$(Graph $this, long updateTime, long srcId, Type posTypeArg) {
        $this.addVertex(updateTime, srcId, posTypeArg);
    }

    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param posTypeArg specify a [[Type Type]] for the vertex\n    */")
    default public void addVertex(long updateTime, long srcId, Type posTypeArg) {
        long x$1 = updateTime;
        long x$2 = srcId;
        Type x$3 = posTypeArg;
        Properties x$4 = this.addVertex$default$3();
        long x$5 = this.addVertex$default$5();
        this.addVertex(x$1, x$2, x$4, x$3, x$5);
    }

    public static /* synthetic */ void addVertex$(Graph $this, long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        $this.addVertex(updateTime, srcId, properties, vertexType, secondaryIndex);
    }

    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param properties Optionally specify vertex properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param vertexType Optionally specify a [[Type Type]] for the vertex\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    default public void addVertex(long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        GraphAlteration.VertexAdd update = new GraphAlteration.VertexAdd(updateTime, secondaryIndex, srcId, properties, vertexType.toOption(), SchemaProviderInstances$.MODULE$.vertexAddSchemaProvider());
        this.handleGraphUpdate(update);
    }

    public static /* synthetic */ Properties addVertex$default$3$(Graph $this) {
        return $this.addVertex$default$3();
    }

    default public Properties addVertex$default$3() {
        return new Properties((Seq<Property>)Nil$.MODULE$);
    }

    public static /* synthetic */ MaybeType addVertex$default$4$(Graph $this) {
        return $this.addVertex$default$4();
    }

    default public MaybeType addVertex$default$4() {
        return NoType$.MODULE$;
    }

    public static /* synthetic */ long addVertex$default$5$(Graph $this) {
        return $this.addVertex$default$5();
    }

    default public long addVertex$default$5() {
        return this.index();
    }

    public static /* synthetic */ void addEdge$(Graph $this, long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        $this.addEdge(updateTime, srcId, dstId, properties, edgeType, secondaryIndex);
    }

    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param properties edge properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param edgeType   specify a [[Type Type]] for the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    default public void addEdge(long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        GraphAlteration.EdgeAdd update = new GraphAlteration.EdgeAdd(updateTime, secondaryIndex, srcId, dstId, properties, edgeType.toOption(), SchemaProviderInstances$.MODULE$.edgeAddSchemaProvider());
        this.handleGraphUpdate(update);
    }

    public static /* synthetic */ void addEdge$(Graph $this, long updateTime, long srcId, long dstId, Type posTypeArg) {
        $this.addEdge(updateTime, srcId, dstId, posTypeArg);
    }

    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param posTypeArg   specify a [[Type Type]] for the edge\n    */")
    default public void addEdge(long updateTime, long srcId, long dstId, Type posTypeArg) {
        long x$1 = updateTime;
        long x$2 = srcId;
        long x$3 = dstId;
        Type x$4 = posTypeArg;
        Properties x$5 = this.addEdge$default$4();
        long x$6 = this.addEdge$default$6();
        this.addEdge(x$1, x$2, x$3, x$5, x$4, x$6);
    }

    public static /* synthetic */ Properties addEdge$default$4$(Graph $this) {
        return $this.addEdge$default$4();
    }

    default public Properties addEdge$default$4() {
        return new Properties((Seq<Property>)Nil$.MODULE$);
    }

    public static /* synthetic */ MaybeType addEdge$default$5$(Graph $this) {
        return $this.addEdge$default$5();
    }

    default public MaybeType addEdge$default$5() {
        return NoType$.MODULE$;
    }

    public static /* synthetic */ long addEdge$default$6$(Graph $this) {
        return $this.addEdge$default$6();
    }

    default public long addEdge$default$6() {
        return this.index();
    }

    public static /* synthetic */ long assignID$(Graph $this, String uniqueChars) {
        return $this.assignID(uniqueChars);
    }

    @Scaladoc(value="/** Convenience method for generating unique IDs based on vertex names\n    *\n    * Use of this method is optional. A `GraphBuilder` is free to assign vertex IDs in different ways, provided\n    * that each vertex is assigned a unique ID of type `Long`.\n    *\n    * @param uniqueChars Vertex name\n    */")
    default public long assignID(String uniqueChars) {
        return Graph$.MODULE$.assignID(uniqueChars);
    }

    public static /* synthetic */ long parseDatetime$(Graph $this, String dateTime, String format) {
        return $this.parseDatetime(dateTime, format);
    }

    @Scaladoc(value="/** Convenience method for converting dates into epochs to be used internally by Raphtory. This is the same function\n    * used by the `add vertex` and `add edge` functions, so can be called explicitly in a graph builder\n    * to reduce the number of conversions when performing multiple updates per tuple.\n    *\n    * @param dateTime The date string you wish to convert\n    * @param format The format of the date string. The default being \"yyyy-MM-dd[ HH:mm:ss[.SSS]].\"\n    * .\n    */")
    default public long parseDatetime(String dateTime, String format) {
        return DateTimeParser$.MODULE$.apply(format).parse(dateTime);
    }

    public static /* synthetic */ String parseDatetime$default$2$(Graph $this) {
        return $this.parseDatetime$default$2();
    }

    default public String parseDatetime$default$2() {
        return "yyyy-MM-dd[ HH:mm:ss[.SSS]]";
    }

    public static void $init$(Graph $this) {
    }
}

