/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.visitor;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.HistoricEvent;
import com.raphtory.api.analysis.visitor.InterlayerEdge;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/** Default builders for constructing interlayer edges\n  *\n  * @define properties @param properties Map of property values for the interlayer edges\n  * @define propertyBuilder @param propertyBuilder Builder function for interlayer edge properties.\n  *                         The input parameters for the builder are the timestamps for the two endpoints of the edge.\n  */")
public final class InterlayerEdgeBuilders$ {
    public static final InterlayerEdgeBuilders$ MODULE$ = new InterlayerEdgeBuilders$();

    @Scaladoc(value="/**\n    * Add an interlayer edge to the [[ExplodedVertex]] representing the next activity of the vertex unless it is\n    * a deletion event.\n    *\n    * $properties\n    */")
    public Function1<Vertex, Seq<InterlayerEdge>> linkNext(Map<String, Object> properties) {
        return this.linkNext((Function2<Object, Object, Map<String, Object>>)(Function2 & Serializable)(x$2, x$3) -> properties);
    }

    @Scaladoc(value="/**\n    * Add an interlayer edge to the [[ExplodedVertex]] representing the next activity of the vertex unless it is a\n    * deletion event.\n    *\n    * $propertyBuilder\n    */")
    public Function1<Vertex, Seq<InterlayerEdge>> linkNext(Function2<Object, Object, Map<String, Object>> propertyBuilder) {
        return (Function1 & Serializable)vertex -> ((EntityVisitor)((Object)vertex)).history().sliding(2).collect((PartialFunction)new Serializable(propertyBuilder){
            private static final long serialVersionUID = 0L;
            private final Function2 propertyBuilder$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<HistoricEvent>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                SeqOps seqOps;
                A1 A1 = x1;
                if (A1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq(A1)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                    HistoricEvent event1 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    HistoricEvent event2 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    if (event1.event() && event2.event()) {
                        object = new InterlayerEdge(event1.time(), event2.time(), (Map<String, Object>)((Map)this.propertyBuilder$1.apply((Object)BoxesRunTime.boxToLong((long)event1.time()), (Object)BoxesRunTime.boxToLong((long)event2.time()))));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<HistoricEvent> x1) {
                List<HistoricEvent> list = x1;
                if (list == null) return false;
                SeqOps seqOps = package$.MODULE$.List().unapplySeq(list);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return false;
                if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return false;
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return false;
                HistoricEvent event1 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                HistoricEvent event2 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (!event1.event()) return false;
                if (!event2.event()) return false;
                return true;
            }
            {
                this.propertyBuilder$1 = propertyBuilder$1;
            }
        }).toSeq();
    }

    public Function2<Object, Object, Map<String, Object>> linkNext$default$1() {
        return (Function2 & Serializable)(x$4, x$5) -> InterlayerEdgeBuilders$.$anonfun$linkNext$default$1$1(BoxesRunTime.unboxToLong((Object)x$4), BoxesRunTime.unboxToLong((Object)x$5));
    }

    @Scaladoc(value="/**\n    * Add an interlayer edge to the [[ExplodedVertex]] representing the prior activity of the vertex unless it is\n    * a deletion event.\n    *\n    * $properties\n    */")
    public Function1<Vertex, Seq<InterlayerEdge>> linkPrevious(Map<String, Object> properties) {
        return this.linkPrevious((Function2<Object, Object, Map<String, Object>>)(Function2 & Serializable)(x$6, x$7) -> properties);
    }

    @Scaladoc(value="/**\n    * Add an interlayer edge to the [[ExplodedVertex]] representing the prior activity of the vertex unless it is\n    * a deletion event.\n    *\n    * $propertyBuilder\n    */")
    public Function1<Vertex, Seq<InterlayerEdge>> linkPrevious(Function2<Object, Object, Map<String, Object>> propertyBuilder) {
        return (Function1 & Serializable)vertex -> ((EntityVisitor)((Object)vertex)).history().sliding(2).collect((PartialFunction)new Serializable(propertyBuilder){
            private static final long serialVersionUID = 0L;
            private final Function2 propertyBuilder$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<HistoricEvent>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                SeqOps seqOps;
                A1 A1 = x1;
                if (A1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq(A1)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                    HistoricEvent event1 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    HistoricEvent event2 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    if (event1.event() && event2.event()) {
                        object = new InterlayerEdge(event2.time(), event1.time(), (Map<String, Object>)((Map)this.propertyBuilder$2.apply((Object)BoxesRunTime.boxToLong((long)event2.time()), (Object)BoxesRunTime.boxToLong((long)event1.time()))));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<HistoricEvent> x1) {
                List<HistoricEvent> list = x1;
                if (list == null) return false;
                SeqOps seqOps = package$.MODULE$.List().unapplySeq(list);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return false;
                if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return false;
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return false;
                HistoricEvent event1 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                HistoricEvent event2 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (!event1.event()) return false;
                if (!event2.event()) return false;
                return true;
            }
            {
                this.propertyBuilder$2 = propertyBuilder$2;
            }
        }).toSeq();
    }

    public Function2<Object, Object, Map<String, Object>> linkPrevious$default$1() {
        return (Function2 & Serializable)(x$8, x$9) -> InterlayerEdgeBuilders$.$anonfun$linkPrevious$default$1$1(BoxesRunTime.unboxToLong((Object)x$8), BoxesRunTime.unboxToLong((Object)x$9));
    }

    @Scaladoc(value="/**\n    * Add an interlayer edge to the [[ExplodedVertex]] representing the next and prior activity of the vertex unless it is\n    * a deletion event.\n    *\n    * $properties\n    */")
    public Function1<Vertex, Seq<InterlayerEdge>> linkPreviousAndNext(Map<String, Object> properties) {
        return this.linkPreviousAndNext((Function2<Object, Object, Map<String, Object>>)(Function2 & Serializable)(x$10, x$11) -> properties);
    }

    @Scaladoc(value="/**\n    * Add an interlayer edge to the [[ExplodedVertex]] representing the next and prior activity of the vertex unless it is\n    * a deletion event.\n    *\n    * $propertyBuilder\n    */")
    public Function1<Vertex, Seq<InterlayerEdge>> linkPreviousAndNext(Function2<Object, Object, Map<String, Object>> propertyBuilder) {
        return (Function1 & Serializable)vertex -> ((EntityVisitor)((Object)vertex)).history().sliding(2).collect((PartialFunction)new Serializable(propertyBuilder){
            private static final long serialVersionUID = 0L;
            private final Function2 propertyBuilder$3;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<HistoricEvent>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                SeqOps seqOps;
                A1 A1 = x1;
                if (A1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq(A1)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                    HistoricEvent event1 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    HistoricEvent event2 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    if (event1.event() && event2.event()) {
                        object = package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InterlayerEdge[]{new InterlayerEdge(event1.time(), event2.time(), (Map<String, Object>)((Map)this.propertyBuilder$3.apply((Object)BoxesRunTime.boxToLong((long)event1.time()), (Object)BoxesRunTime.boxToLong((long)event2.time())))), new InterlayerEdge(event2.time(), event1.time(), (Map<String, Object>)((Map)this.propertyBuilder$3.apply((Object)BoxesRunTime.boxToLong((long)event2.time()), (Object)BoxesRunTime.boxToLong((long)event1.time()))))}));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<HistoricEvent> x1) {
                List<HistoricEvent> list = x1;
                if (list == null) return false;
                SeqOps seqOps = package$.MODULE$.List().unapplySeq(list);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return false;
                if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return false;
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return false;
                HistoricEvent event1 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                HistoricEvent event2 = (HistoricEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (!event1.event()) return false;
                if (!event2.event()) return false;
                return true;
            }
            {
                this.propertyBuilder$3 = propertyBuilder$3;
            }
        }).flatten(Predef$.MODULE$.$conforms()).toSeq();
    }

    public Function2<Object, Object, Map<String, Object>> linkPreviousAndNext$default$1() {
        return (Function2 & Serializable)(x$12, x$13) -> InterlayerEdgeBuilders$.$anonfun$linkPreviousAndNext$default$1$1(BoxesRunTime.unboxToLong((Object)x$12), BoxesRunTime.unboxToLong((Object)x$13));
    }

    public static final /* synthetic */ Map $anonfun$linkNext$default$1$1(long x$4, long x$5) {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ Map $anonfun$linkPrevious$default$1$1(long x$8, long x$9) {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ Map $anonfun$linkPreviousAndNext$default$1$1(long x$12, long x$13) {
        return Predef$.MODULE$.Map().empty();
    }

    private InterlayerEdgeBuilders$() {
    }
}

