/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.graphview;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.Multilayer;
import com.raphtory.api.analysis.algorithm.MultilayerReduction;
import com.raphtory.api.analysis.graphview.ConcreteMultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphView;
import com.raphtory.api.analysis.graphview.MultilayerGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Extends [[GraphView]] with variants of the `transform` and `execute` methods specific to multilayer graphs\n  *\n  * @see [[GraphView]], [[MultilayerGraphPerspective]], [[MultilayerRaphtoryGraph]], [[MultilayerTemporalGraph]]\n  */")
@ScalaSignature(bytes="\u0006\u0005m3q!\u0002\u0004\u0011\u0002G\u0005\u0011\u0003C\u0003 \u0001\u0019\u0005\u0001\u0005C\u0003 \u0001\u0019\u0005!\bC\u0003H\u0001\u0019\u0005\u0001\nC\u0003H\u0001\u0019\u00051KA\nNk2$\u0018\u000e\\1zKJ<%/\u00199i-&,wO\u0003\u0002\b\u0011\u0005IqM]1qQZLWm\u001e\u0006\u0003\u0013)\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u00171\t1!\u00199j\u0015\tia\"\u0001\u0005sCBDGo\u001c:z\u0015\u0005y\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\u00131q\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001b\u001b\u00051\u0011BA\u000e\u0007\u0005iiU\u000f\u001c;jY\u0006LXM]$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f!\tIR$\u0003\u0002\u001f\r\tIqI]1qQZKWm^\u0001\niJ\fgn\u001d4pe6$\"!I\u0013\u0011\u0005\t\u001aS\"\u0001\u0001\n\u0005\u0011R\"!B$sCBD\u0007\"\u0002\u0014\u0002\u0001\u00049\u0013!C1mO>\u0014\u0018\u000e\u001e5n!\tA#&D\u0001*\u0015\t1\u0003\"\u0003\u0002,S\tQQ*\u001e7uS2\f\u00170\u001a:)\t\u0005is\u0007\u000f\t\u0003]Uj\u0011a\f\u0006\u0003aE\n\u0001b]2bY\u0006$wn\u0019\u0006\u0003eM\nq\u0001^1lKj|WM\u0003\u00025\u001d\u00051q-\u001b;ik\nL!AN\u0018\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013!O\u0001\u0003.=R#\u0006I!qa2L\b%\u0019\u0011a\u001bVdG/\u001b7bs\u0016\u0014\b\rI1mO>\u0014\u0018\u000e\u001e5nAQ|\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI1mO>\u0014\u0018\u000e\u001e5nA\u0005cwm\u001c:ji\"l\u0007\u0005^8!CB\u0004H.\u001f\u0011u_\u0002\"\b.\u001a\u0011he\u0006\u0004\bN\u0003\u0011!A\u0001R\u0003\u0005\u0011:fiV\u0014h\u000e\t+sC:\u001chm\u001c:nK\u0012\u0004sM]1qQ*\u0001\u0003\u0005\t\u0011+A\u0001sw\u000e^3!AR\u0014\u0018M\\:g_Jl\u0007\rI6fKB\u001c\b\u0005\u001e:bG.\u0004sN\u001a\u0011uQ\u0016\u0004c.Y7fA=4\u0007\u0005\u001e5fA\u0005\u0004\b\u000f\\5fI\u0002\nGnZ8sSRDW\u000eI1oI\u0002\u001aG.Z1sg\u0002\"\b.\u001a\u0011nKN\u001c\u0018mZ3!cV,W/Z:!CR\u0004C\u000f[3!K:$\u0007e\u001c4!i\",\u0007%\u00197h_JLG\u000f[7\u000bA\u0001\u0002\u0003EK\u0018\u0015\u0005m\u0002\u0005C\u0001\u0012=\u0013\tidH\u0001\u0007SK\u0012,8-\u001a3He\u0006\u0004\b.\u0003\u0002@\r\t\u0001rI]1qQB+'o\u001d9fGRLg/\u001a\u0005\u0006M\t\u0001\r!\u0011\t\u0003Q\tK!aQ\u0015\u0003'5+H\u000e^5mCf,'OU3ek\u000e$\u0018n\u001c8)\t\tis'R\u0011\u0002\r\u0006\u0011yd\f\u0016+A\u0005\u0003\b\u000f\\=!C\u0002\u0002W*\u001e7uS2\f\u00170\u001a:SK\u0012,8\r^5p]\u0002\u0004\u0013\r\\4pe&$\b.\u001c\u0011u_\u0002\"\b.\u001a\u0011he\u0006\u0004\bN\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004\u0013\r\\4pe&$\b.\u001c\u0011BY\u001e|'/\u001b;i[\u0002\"x\u000eI1qa2L\b\u0005^8!i\",\u0007e\u001a:ba\"T\u0001\u0005\t\u0011!U\u0001\u0002%/\u001a;ve:\u0004CK]1og\u001a|'/\\3eA\u001d\u0014\u0018\r\u001d5\u000bA\u0001\u0002\u0003E\u000b\u0011A]>$X\r\t1ue\u0006t7OZ8s[\u0002\u00043.Z3qg\u0002\"(/Y2lA=4\u0007\u0005\u001e5fA9\fW.\u001a\u0011pM\u0002\"\b.\u001a\u0011baBd\u0017.\u001a3!C2<wN]5uQ6\u0004\u0013M\u001c3!G2,\u0017M]:!i\",\u0007%\\3tg\u0006<W\rI9vKV,7\u000fI1uAQDW\rI3oI\u0002zg\r\t;iK\u0002\nGnZ8sSRDWN\u0003\u0011!A\u0001Rs&A\u0004fq\u0016\u001cW\u000f^3\u0015\u0005%{\u0005C\u0001&N\u001b\u0005Y%B\u0001'\t\u0003\u0015!\u0018M\u00197f\u0013\tq5JA\u0003UC\ndW\rC\u0003'\u0007\u0001\u0007q\u0005\u000b\u0003\u0004[]\n\u0016%\u0001*\u0002\u0003+|#F\u000b\u0011Sk:\u0004\u0013\r\t1Nk2$\u0018\u000e\\1zKJ\u0004\u0007%\u00197h_JLG\u000f[7!_:\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0011b]\u0012\u0004#/\u001a;ve:\u0004#/Z:vYR\u001c(\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0003\t]1sC6\u0004\u0013\r\\4pe&$\b.\u001c\u0011BY\u001e|'/\u001b;i[\u0002\"x\u000e\t:v]*\u0001\u0003\u0005\t\u0011+A\u0001\u0002%/\u001a;ve:\u0004C+\u00192mK\u0002:\u0018\u000e\u001e5!C2<wN]5uQ6\u0004#/Z:vYR\u001c(\u0002\t\u0011!A)\u0002\u0003\u0005\u00118pi\u0016\u0004\u0003-\u001a=fGV$X\r\u0019\u0011lK\u0016\u00048\u000f\t;sC\u000e\\\u0007e\u001c4!i\",\u0007E\\1nK\u0002zg\r\t;iK\u0002\n\u0007\u000f\u001d7jK\u0012\u0004\u0013\r\\4pe&$\b.\u001c\u0006!A\u0001\u0002#f\f\u000b\u0003\u0013RCQA\n\u0003A\u0002\u0005CC\u0001B\u00178-\u0006\nq+AAt_)R\u0003EU;oA\u0005\u0004\u0003-T;mi&d\u0017-_3s%\u0016$Wo\u0019;j_:\u0004\u0007%\u00197h_JLG\u000f[7!_:\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0011b]\u0012\u0004#/\u001a;ve:\u0004#/Z:vYR\u001c(\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0003\t]1sC6\u0004\u0013\r\\4pe&$\b.\u001c\u0011BY\u001e|'/\u001b;i[\u0002\"x\u000e\t:v]*\u0001\u0003\u0005\t\u0011+A\u0001\u0002%/\u001a;ve:\u0004C+\u00192mK\u0002:\u0018\u000e\u001e5!C2<wN]5uQ6\u0004#/Z:vYR\u001c(\u0002\t\u0011!A)\u0002\u0003\u0005\u00118pi\u0016\u0004\u0003-\u001a=fGV$X\r\u0019\u0011lK\u0016\u00048\u000f\t;sC\u000e\\\u0007e\u001c4!i\",\u0007E\\1nK\u0002zg\r\t;iK\u0002\n\u0007\u000f\u001d7jK\u0012\u0004\u0013\r\\4pe&$\b.\u001c\u0006!A\u0001\u0002#f\f\u0015\u0005\u00015:\u0014,I\u0001[\u0003\u0005EwF\u000b\u0016!\u000bb$XM\u001c3tAm[vI]1qQZKWm^/^A]LG\u000f\u001b\u0011wCJL\u0017M\u001c;tA=4\u0007\u0005\u001e5fA\u0001$(/\u00198tM>\u0014X\u000e\u0019\u0011b]\u0012\u0004\u0003-\u001a=fGV$X\r\u0019\u0011nKRDw\u000eZ:!gB,7-\u001b4jG\u0002\"x\u000eI7vYRLG.Y=fe\u0002:'/\u00199ig*\u0001\u0003E\u000b\u0006!A)\u0002\u0003i]3fAm[vI]1qQZKWm^/^Y\u0001Z6,T;mi&d\u0017-_3s\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016lV\f\f\u0011\\76+H\u000e^5mCf,'OU1qQR|'/_$sCBDW,\u0018\u0017!7nkU\u000f\u001c;jY\u0006LXM\u001d+f[B|'/\u00197He\u0006\u0004\b.X/\u000bA\u0001Rs\u0006")
public interface MultilayerGraphView
extends MultilayerGraphPerspective,
GraphView {
    @Scaladoc(value="/** Apply a `Multilayer` algorithm to the graph\n    *\n    * @param algorithm Algorithm to apply to the graph\n    * @return Transformed graph\n    * @note `transform` keeps track of the name of the applied algorithm and clears the message queues at the end of the algorithm\n    */")
    public ConcreteMultilayerGraphPerspective transform(Multilayer var1);

    @Scaladoc(value="/** Apply a `MultilayerReduction` algorithm to the graph\n    *\n    * @param algorithm Algorithm to apply to the graph\n    * @return Transformed graph\n    * @note `transform` keeps track of the name of the applied algorithm and clears the message queues at the end of the algorithm\n    */")
    public ConcreteReducedGraphPerspective transform(MultilayerReduction var1);

    @Scaladoc(value="/** Run a `Multilayer` algorithm on the graph and return results\n    *\n    *  @param algorithm Algorithm to run\n    *  @return Table with algorithm results\n    *  @note `execute` keeps track of the name of the applied algorithm\n    */")
    public Table execute(Multilayer var1);

    @Scaladoc(value="/** Run a `MultilayerReduction` algorithm on the graph and return results\n    *\n    *  @param algorithm Algorithm to run\n    *  @return Table with algorithm results\n    *  @note `execute` keeps track of the name of the applied algorithm\n    */")
    public Table execute(MultilayerReduction var1);
}

