/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.graphview;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteMultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.Edge;
import com.raphtory.api.analysis.visitor.InterlayerEdge;
import com.raphtory.api.analysis.visitor.PropertyMergeStrategy$;
import com.raphtory.api.analysis.visitor.PropertyValue;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Scaladoc(value="/** Public interface for graph operations\n  *\n  * The `GraphPerspective` is the interface for defining algorithms in Raphtory and records all operations to be\n  * applied to a graph as a sequence of steps to execute.\n  *\n  * Most operations on a `GraphPerspective` return a graph or multilayer\n  * graph as a result. To support returning the\n  * correct graph type, the `GraphPerspective` has abstract type members\n  *\n  *  - `Graph`: Current graph type (can be multilayer or reduced)\n  *  - `MultilayerGraph`: The type of the [[MultilayerGraphPerspective]] corresponding to the current graph\n  *  - `ReducedGraph`: The type of the [[ReducedGraphPerspective]] corresponding to the current graph\n  */")
@ScalaSignature(bytes="\u0006\u0005\r]baB\u0011#!\u0003\r\t!\f\u0003\u0006i\u0001\u0011\t!\u000e\u0003\u0006}\u0001\u0011\ta\u0010\u0003\u0006\u0011\u0002\u0011\t!\u0013\u0003\u0006\u001d\u0002\u0011\ta\u0014\u0005\u0006'\u00021\t\u0001\u0016\u0005\u0006G\u00021\t\u0001\u001a\u0005\u0006m\u00021\ta\u001e\u0005\u0007m\u00021\t!!\u0001\t\u000f\u0005E\u0001A\"\u0001\u0002\u0014!9\u0011\u0011\u0003\u0001\u0007\u0002\u0005%\u0002bBA\u001c\u0001\u0019\u0005\u0011\u0011\b\u0005\b\u0003o\u0001a\u0011AA!\u0011\u001d\ti\u0007\u0001D\u0001\u0003_Bq!!\u001c\u0001\r\u0003\t9\bC\u0004\u0002n\u00011\t!!+\t\u000f\u00055\u0004A\"\u0001\u0002\\\"9!1\u0002\u0001\u0007\u0002\t5\u0001B\u0002B\u001e\u0001\u0019\u0005A\u000b\u0003\u0004\u0003D\u00011\t\u0001\u0016\u0005\u0007\u0005\u0017\u0002a\u0011\u0001+\t\u000f\tM\u0003A\"\u0001\u0003V!9!1\u000b\u0001\u0007\u0002\t\u0005\u0004b\u0002B7\u0001\u0019\u0005!q\u000e\u0005\b\u0005[\u0002a\u0011\u0001B>\u0011\u001d\u00119\t\u0001D\u0001\u0005\u0013CqAa\"\u0001\r\u0003\u0011\t\u000bC\u0004\u00030\u00021\tA!-\t\u000f\t=\u0007A\"\u0001\u0003R\"9!1\u001c\u0001\u0007\u0002\tu\u0007\"\u0003Bs\u0001E\u0005I\u0011\u0001Bt\u0011%\u0011i\u0010AI\u0001\n\u0003\u0011y\u0010C\u0005\u0004\u001e\u0001\t\n\u0011\"\u0001\u0004 \t\u0001rI]1qQB+'o\u001d9fGRLg/\u001a\u0006\u0003G\u0011\n\u0011b\u001a:ba\"4\u0018.Z<\u000b\u0005\u00152\u0013\u0001C1oC2L8/[:\u000b\u0005\u001dB\u0013aA1qS*\u0011\u0011FK\u0001\te\u0006\u0004\b\u000e^8ss*\t1&A\u0002d_6\u001c\u0001a\u0005\u0002\u0001]A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\u0014aAV3si\u0016D\u0018C\u0001\u001c:!\tys'\u0003\u00029a\t9aj\u001c;iS:<\u0007C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f%\u0003\u001d1\u0018n]5u_JL!\u0001N\u001e\u0003\u000b\u001d\u0013\u0018\r\u001d5\u0012\u0005Y\u0002\u0005CB!C\t\u001a;U*D\u0001#\u0013\t\u0019%E\u0001\rD_:\u001c'/\u001a;f\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016\u0004\"!R\u0001\u000e\u0003\u0001\u0001\"!\u0012\u0002\u0011\u0005\u0015\u001b!\u0001\u0004*fIV\u001cW\rZ$sCBD\u0017C\u0001\u001cK!\u0011\t5jR'\n\u00051\u0013#aH\"p]\u000e\u0014X\r^3SK\u0012,8-\u001a3He\u0006\u0004\b\u000eU3sgB,7\r^5wKB\u0011Q\t\u0002\u0002\u0010\u001bVdG/\u001b7bs\u0016\u0014xI]1qQF\u0011a\u0007\u0015\t\u0005\u0003Fku)\u0003\u0002SE\t\u00113i\u001c8de\u0016$X-T;mi&d\u0017-_3s\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016\f\u0001\"\u001b3f]RLG/_\u000b\u0002\r\"\"QA\u00161b!\t9f,D\u0001Y\u0015\tI&,\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\tYF,A\u0004uC.,'p\\3\u000b\u0005uS\u0013AB4ji\",(-\u0003\u0002`1\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001c\u0003\u0005EqF\u000b\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011SKR,(O\u001c\u0011uQ\u0016\u0004sM]1qQ\u0002*hn\u00195b]\u001e,GM\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002C\u000b[5tA%\u001c\b%^:fI\u0002\"x\u000eI8ci\u0006Lg\u000e\t;iK\u0002\u001awN\u001d:fGR\u0004#/\u001a;ve:\u0004C/\u001f9fA]LG\u000f[8vi\u0002\u0002XM\u001d4pe6Lgn\u001a\u0011b]f\u0004s\u000e]3sCRLwN\\:\u000bA\u0001\u0002\u0003EK\u0018\u0002\u001dM,Go\u00127pE\u0006d7\u000b^1uKR\u0011a)\u001a\u0005\u0006M\u001a\u0001\raZ\u0001\u0002MB!q\u0006\u001b6q\u0013\tI\u0007GA\u0005Gk:\u001cG/[8ocA\u00111N\\\u0007\u0002Y*\u0011Q\u000eJ\u0001\u000bOJ\f\u0007\u000f[:uCR,\u0017BA8m\u0005)9%/\u00199i'R\fG/\u001a\t\u0003_EL!A\u001d\u0019\u0003\tUs\u0017\u000e\u001e\u0015\u0005\rY\u0003G/I\u0001v\u0003\u00055uF\u000b\u0016!\u0003\u0012$\u0007%\u0019\u0011gk:\u001cG/[8oAQ|\u0007%\\1oSB,H.\u0019;fA\u001ddwNY1mA\u001d\u0014\u0018\r\u001d5!gR\fG/\u001a\u0017![\u0006Lg\u000e\\=!kN,G\r\t;pA%t\u0017\u000e^5bY&\u001cX\rI1dGVlW\u000f\\1u_J\u001c\bEY3g_J,\u0007\u0005\u001e5fA9,\u0007\u0010\u001e\u0011bY\u001e|'/\u001b;i[\u0002\u001aH/\u001a9\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t4!MVt7\r^5p]\u0002\"x\u000eI:fi\u0002:'/\u00199iAM$\u0018\r^3!QI,hn\u001d\u0011fq\u0006\u001cG\u000f\\=!_:\u001cW-\u000b\u0006!A\u0001\u0002#fL\u0001\rm\u0016\u0014H/\u001a=GS2$XM\u001d\u000b\u0003\rbDQAZ\u0004A\u0002e\u0004Ba\f5EuB\u0011qf_\u0005\u0003yB\u0012qAQ8pY\u0016\fg\u000e\u000b\u0003\b-\u0002t\u0018%A@\u0002\u0003\u007fz#F\u000b\u0011GS2$XM\u001d\u0011wKJ$\u0018nY3tA=4\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t4!M&dG/\u001a:!MVt7\r^5p]\u0002BsN\u001c7zAY,'\u000f^5dKN\u0004cm\u001c:!o\"L7\r\u001b\u0011aM\u0002\u0004#/\u001a;ve:\u001c\b\u0005\u0019;sk\u0016\u0004\u0007%\u0019:fA-,\u0007\u000f^\u0015/A\u0005cG\u000eI1tg>\u001c\u0017.\u0019;fI\u0002*GmZ3tA=4\u0007EZ5mi\u0016\u0014X\r\u001a\u0011wKJ$\u0018nY3tA\u0005\u0014X\rI1mg>\u0004#/Z7pm\u0016$gF\u0003\u0011!A\u0001Rs\u0006F\u0002G\u0003\u0007AaA\u001a\u0005A\u0002\u0005\u0015\u0001CB\u0018\u0002\b\u0011S'0C\u0002\u0002\nA\u0012\u0011BR;oGRLwN\u001c\u001a)\u000b!1\u0006-!\u0004\"\u0005\u0005=\u0011!!:0U)\u0002c)\u001b7uKJ\u0004c/\u001a:uS\u000e,7\u000fI8gAQDW\rI4sCBD\u0007e^5uQ\u0002:Gn\u001c2bY\u0002:'/\u00199iAM$\u0018\r^3\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t4!M&dG/\u001a:!MVt7\r^5p]\u0002:\u0018\u000e\u001e5!C\u000e\u001cWm]:!i>\u0004sM]1qQ\u0002\u001aH/\u0019;fA!zg\u000e\\=!m\u0016\u0014H/[2fg\u00022wN\u001d\u0011xQ&\u001c\u0007\u000e\t1gA\u0002\u0012X\r^;s]N\u0004\u0003\r\u001e:vK\u0002\u0004\u0013M]3!W\u0016\u0004H/\u000b\u0018!\u00032d\u0007%Y:t_\u000eL\u0017\r^3eA\u0015$w-Z:!_\u001a\u0004c-\u001b7uKJ,G\r\t<feRL7-Z:!CJ,\u0007%\u00197t_\u0002\u0012X-\\8wK\u0012t#\u0002\t\u0011!A)z\u0013AC3eO\u00164\u0015\u000e\u001c;feR)a)!\u0006\u0002 !1a-\u0003a\u0001\u0003/\u0001Ra\f5\u0002\u001ai\u00042AOA\u000e\u0013\r\tib\u000f\u0002\u0005\u000b\u0012<W\r\u0003\u0004\u0002\"%\u0001\rA_\u0001\u000baJ,h.\u001a(pI\u0016\u001c\b&B\u0005WA\u0006\u0015\u0012EAA\u0014\u0003\t%tF\u000b\u0016!\r&dG/\u001a:!K\u0012<Wm\u001d\u0011pM\u0002\"\b.\u001a\u0011he\u0006\u0004\bN\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c\r\t4jYR,'\u000f\t4v]\u000e$\u0018n\u001c8!Q=tG.\u001f\u0011fI\u001e,7\u000f\t4pe\u0002:\b.[2iA\u00014\u0007\r\t:fiV\u0014hn\u001d\u0011aiJ,X\r\u0019\u0011be\u0016\u00043.\u001a9uS)\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!aJ,h.\u001a(pI\u0016\u001c\b%\u001b4!i\"L7\u000fI5tA\u0001$(/^3aAQDWM\u001c\u0011wKJ$\u0018nY3tA]D\u0017n\u00195!E\u0016\u001cw.\\3!SN|G.\u0019;fI\u0002B\u0003.\u0019<fA9|\u0007%\u001b8d_6Lgn\u001a\u0011pe\u0002zW\u000f^4pS:<\u0007%\u001a3hKNL#\u0002\t\u0011!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!C\u001a$XM\u001d\u0011uQ&\u001c\bEZ5mi\u0016\u0014\u0018N\\4!CJ,\u0007%\u00197t_\u0002\u0012X-\\8wK\u0012t#\u0002\t\u0011!A)zC#\u0002$\u0002,\u0005=\u0002B\u00024\u000b\u0001\u0004\ti\u0003E\u00040\u0003\u000f\tIB\u001b>\t\r\u0005\u0005\"\u00021\u0001{Q\u0015Qa\u000bYA\u001aC\t\t)$\u0001Bh_)R\u0003ER5mi\u0016\u0014\b%\u001a3hKN\u0004sN\u001a\u0011uQ\u0016\u0004sM]1qQ\u0002:\u0018\u000e\u001e5!O2|'-\u00197!OJ\f\u0007\u000f\u001b\u0011ti\u0006$XM\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c\r\t4jYR,'\u000f\t4v]\u000e$\u0018n\u001c8!o&$\b\u000eI1dG\u0016\u001c8\u000f\t;pA\u001d\u0014\u0018\r\u001d5!gR\fG/\u001a\u0011)_:d\u0017\u0010I3eO\u0016\u001c\bEZ8sA]D\u0017n\u00195!A\u001a\u0004\u0007E]3ukJt7\u000f\t1ueV,\u0007\rI1sK\u0002ZW\r\u001d;*\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011qeVtWMT8eKN\u0004\u0013N\u001a\u0011uQ&\u001c\b%[:!AR\u0014X/\u001a1!i\",g\u000e\t<feRL7-Z:!o\"L7\r\u001b\u0011cK\u000e|W.\u001a\u0011jg>d\u0017\r^3eA!B\u0017M^3!]>\u0004\u0013N\\2p[&tw\rI8sA=,HoZ8j]\u001e\u0004S\rZ4fg&R\u0001\u0005\t\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011bMR,'\u000f\t;iSN\u0004c-\u001b7uKJLgn\u001a\u0011be\u0016\u0004\u0013\r\\:pAI,Wn\u001c<fI:R\u0001\u0005\t\u0011!U=\na\"\\;mi&d\u0017-_3s-&,w/F\u0001NQ\u0015Ya\u000bYA\u001fC\t\ty$AB[_)R\u0003eU<ji\u000eD\u0007\u0005^8![VdG/\u001b7bs\u0016\u0014\bE^5fo*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0003\u001a$XM\u001d\u0011dC2d\u0017N\\4!A6,H\u000e^5mCf,'OV5fo\u0002d\u0003e];cg\u0016\fX/\u001a8uA5,G\u000f[8eg\u0002\"\b.\u0019;![\u0006t\u0017\u000e];mCR,\u0007E^3si&\u001cWm\u001d\u0011bGR\u0004sN\u001c\u0006!A\u0001\u0002#\u0006I.\\m&\u001c\u0018\u000e^8s]\u0015C\b\u000f\\8eK\u00124VM\u001d;fq\u0002*\u0005\u0010\u001d7pI\u0016$g+\u001a:uS\u000e,7/X/!S:\u001cH/Z1e]\u0001Je\rI.\\m&\u001c\u0018\u000e^8s]\u0015C\b\u000f\\8eK\u00124VM\u001d;fq\u0002*\u0005\u0010\u001d7pI\u0016$g+\u001a:uKblVL\u0003\u0011!A\u0001R\u0003%\u001b8ti\u0006t7-Z:!o\u0016\u0014X\rI1me\u0016\fG-\u001f\u0011de\u0016\fG/\u001a3!Ef\u0004\u0013\r\t9sKZLw.^:!G\u0006dG\u000e\t;pA\u0001lW\u000f\u001c;jY\u0006LXM\u001d,jK^\u0004G\u0006\t;iKf\u0004\u0013M]3!aJ,7/\u001a:wK\u0012t\u0003e\u0014;iKJ<\u0018n]3-AQD\u0017n\u001d\u0006!A\u0001\u0002#\u0006I7fi\"|G\rI2sK\u0006$Xm\u001d\u0011b]\u0002Z6L^5tSR|'OL#ya2|G-\u001a3WKJ$X\r\u001f\u0011FqBdw\u000eZ3e-\u0016\u0014H/\u001a=^;\u0002Jgn\u001d;b]\u000e,\u0007EZ8sA\u0015\f7\r\u001b\u0006!A\u0001\u0002#\u0006\t;j[\u0016\u0004\u0003o\\5oi\u0002\"\b.\u0019;!C\u00022XM\u001d;fq\u0002J7\u000fI1di&4XM\f\u0006!A\u0001\u0002#f\f\u000b\u0004\u001b\u0006\r\u0003\"CA#\u0019A\u0005\t\u0019AA$\u0003UIg\u000e^3sY\u0006LXM]#eO\u0016\u0014U/\u001b7eKJ\u0004Ra\f5:\u0003\u0013\u0002b!a\u0013\u0002\\\u0005\u0005d\u0002BA'\u0003/rA!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'b\u0013A\u0002\u001fs_>$h(C\u00012\u0013\r\tI\u0006M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti&a\u0018\u0003\u0007M+\u0017OC\u0002\u0002ZA\u00022AOA2\u0013\r\t)g\u000f\u0002\u000f\u0013:$XM\u001d7bs\u0016\u0014X\tZ4fQ\u0015aa\u000bYA5C\t\tY'ABU_)R\u0003eU<ji\u000eD\u0007\u0005^8![VdG/\u001b7bs\u0016\u0014\bE^5fo\u0002\ng\u000e\u001a\u0011bI\u0012\u0004\u0013N\u001c;fe2\f\u00170\u001a:!K\u0012<Wm\u001d\u0018\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI5oi\u0016\u0014H.Y=fe\u0016#w-\u001a\"vS2$WM\u001d\u0011J]R,'\u000f\\1zKJ\u0004S\rZ4fA\t,\u0018\u000e\u001c3fe\u0002\"x\u000eI2sK\u0006$X\rI5oi\u0016\u0014H.Y=fe\u0002*GmZ3tA\u0019|'\u000fI3bG\"\u0004c/\u001a:uKbt\u0003eU3f\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!Am[f/[:ji>\u0014h&\u00138uKJd\u0017-_3s\u000b\u0012<WMQ;jY\u0012,'o\u001d\u0011J]R,'\u000f\\1zKJ,EmZ3Ck&dG-\u001a:t;v\u0003cm\u001c:!aJ,G-\u001a4j]\u0016$\u0007e\u001c9uS>t7O\f\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003%\u0012=jgRLgn\u001a\u0011\\7ZL7/\u001b;pe:*\u0005\u0010\u001d7pI\u0016$g+\u001a:uKb\u0004S\t\u001f9m_\u0012,GMV3si\u0016DX,\u0018\u0011j]N$\u0018M\\2fg\u0002\n'/\u001a\u0011qe\u0016\u001cXM\u001d<fI\u0002\u0012W\u000f\u001e\u0011bY2\u0004\u0013N\u001c;fe2\f\u00170\u001a:!K\u0012<Wm\u001d\u0011be\u0016\u0004#/Z2sK\u0006$X\r\u001a\u0011vg&tw\r\t;iK\u0002\u001aX\u000f\u001d9mS\u0016$'\u0002\t\u0011!A)\u0002\u0003-\u001b8uKJd\u0017-_3s\u000b\u0012<WMQ;jY\u0012,'\u000f\u0019\u0018\u000bA\u0001\u0002\u0003EK\u0018\u0002\u0017I,G-^2fIZKWm^\u000b\u0002\u000f\"*QB\u00161\u0002t\u0005\u0012\u0011QO\u0001\u0005b>R#\u0006I*xSR\u001c\u0007\u000eI2p[B,H/\u0019;j_:\u0004Co\u001c\u0011bGR\u0004sN\u001c\u0011\\7ZL7/\u001b;pe:2VM\u001d;fq\u00022VM\u001d;fqvkF\u0006I5om\u0016\u00148/\u001a\u0011pM\u0002\u0002W.\u001e7uS2\f\u00170\u001a:WS\u0016<\bM\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002C\u000b[5tA=\u0004XM]1uS>t\u0007\u0005Z8fg\u0002rw\u000e\u001e5j]\u001e\u0004\u0013N\u001a\u0011uQ\u0016\u0004c/[3xA%\u001c\b%\u00197sK\u0006$\u0017\u0010\t:fIV\u001cW\r\u001a\u0018!\u001fRDWM]<jg\u0016\u0004\u0013\u000e\u001e\u0011to&$8\r[3tA\t\f7m\u001b\u0011u_\u0002\u0012XO\u001c8j]\u001e\u00043m\\7qkR\fG/[8og*\u0001\u0003\u0005\t\u0011+A=t\u0007E^3si&\u001cWm\u001d\u0011ckR\u0004\u0003O]3tKJ4Xm\u001d\u0011b]f\u0004S\r_5ti&tw\rI.\\m&\u001c\u0018\u000e^8s]\u0015C\b\u000f\\8eK\u00124VM\u001d;fq\u0002*\u0005\u0010\u001d7pI\u0016$g+\u001a:uKblV\fI5ogR\fgnY3t\u0015\u0001\u0002\u0003\u0005\t\u0016!GJ,\u0017\r^3eA\tL\b\u0005\u001d:fm&|Wo\u001d\u0011dC2d7\u000f\t;pA\u0001lW\u000f\u001c;jY\u0006LXM\u001d,jK^\u0004\u0007\u0005^8!C2dwn\u001e\u0011to&$8\r[5oO\u0002\u0012\u0017mY6.C:$WFZ8si\"\u0004#-\u001a;xK\u0016t\u0007E^5foN\u0004s\u000f[5mK*\u0001\u0003\u0005\t\u0011+AA\u0014Xm]3sm&tw\rI2p[B,H/\u0019;j_:\fG\u000eI:uCR,g\u0006I\"p[B,H/\u0019;j_:\fG\u000eI:uCR,\u0007e\u001c8!7n3\u0018n]5u_JtS\t\u001f9m_\u0012,GMV3si\u0016D\b%\u0012=qY>$W\r\u001a,feR,\u00070X/\u000bA\u0001\u0002\u0003E\u000b\u0011j]N$\u0018M\\2fg\u0002J7\u000f\t8pi\u0002\n7mY3tg&\u0014G.\u001a\u0011ge>l\u0007\u0005\u001e5fA\u00014VM\u001d;fq\u0002\u0004SO\u001c7fgN\u0004\u0013\rI7fe\u001e,\u0007e\u001d;sCR,w-\u001f\u0011jg\u0002\u001aX\u000f\u001d9mS\u0016$\u0007\u0005K:fK\u0002\u0012W\r\\8xS9R\u0001\u0005\t\u0011!U=\"2aRA=\u0011\u001d\tYH\u0004a\u0001\u0003{\nQ\"\\3sO\u0016\u001cFO]1uK\u001eL\bGBA@\u0003#\u000by\n\u0005\u0005\u0002\u0002\u0006\u001d\u0015QRAO\u001d\rQ\u00141Q\u0005\u0004\u0003\u000b[\u0014!\u0006)s_B,'\u000f^=NKJ<Wm\u0015;sCR,w-_\u0005\u0005\u0003\u0013\u000bYIA\u0007Qe>\u0004XM\u001d;z\u001b\u0016\u0014x-\u001a\u0006\u0004\u0003\u000b[\u0004\u0003BAH\u0003#c\u0001\u0001\u0002\u0007\u0002\u0014\u0006e\u0014\u0011!A\u0001\u0006\u0003\t)JA\u0002`IE\n2ANAL!\ry\u0013\u0011T\u0005\u0004\u00037\u0003$aA!osB!\u0011qRAP\t1\t\t+!\u001f\u0002\u0002\u0003\u0005)\u0011AAK\u0005\ryFE\r\u0015\u0006\u001dY\u0003\u0017QU\u0011\u0003\u0003O\u000b!\u0011G\u0018+U\u0001\u0012V\rZ;dK\u00022\u0018.Z<!C:$\u0007%\u00199qYf\u0004C\u000f[3!g\u0006lW\rI7fe\u001e,\u0007e\u001d;sCR,w-\u001f\u0011u_\u0002\u001awN\u001c<feR\u0004S-Y2iA\u0015D\b\u000f\\8eK\u0012\u00043\u000f^1uK\u0002\"x\u000e\t<feR,\u0007\u0010I:uCR,'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002jWM]4f'R\u0014\u0018mZ3hs\u00022UO\\2uS>t\u0007\u0005^8!G>tg/\u001a:uA\u0005\u0004\u0003.[:u_JL\be\u001c4!m\u0006dW/Z:!_\u001a\u0004C/\u001f9fAQ|\u0007%\u0019\u0011tS:<G.\u001a\u0011wC2,X\rI8gAQL\b/\u001a\u0011)g\u0016,'\u0002\t\u0011!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I.\\!J|\u0007/\u001a:us6+'oZ3TiJ\fG/Z4z;v\u0003cm\u001c:!aJ,G-\u001a4j]\u0016$\u0007e\u001c9uS>t7/\u000b\u0006!A\u0001\u0002#f\f\u000b\u0004\u000f\u0006-\u0006bBAW\u001f\u0001\u0007\u0011qV\u0001\u0011[\u0016\u0014x-Z*ue\u0006$XmZ=NCB\u0004\u0002\"!-\u0002:\u0006}\u0016Q\u0019\b\u0005\u0003g\u000b)\fE\u0002\u0002PAJ1!a.1\u0003\u0019\u0001&/\u001a3fM&!\u00111XA_\u0005\ri\u0015\r\u001d\u0006\u0004\u0003o\u0003\u0004\u0003BAY\u0003\u0003LA!a1\u0002>\n11\u000b\u001e:j]\u001e\u0004d!a2\u0002L\u0006E\u0007\u0003CAA\u0003\u000f\u000bI-a4\u0011\t\u0005=\u00151\u001a\u0003\r\u0003\u001b\fY+!A\u0001\u0002\u000b\u0005\u0011Q\u0013\u0002\u0004?\u0012\u001a\u0004\u0003BAH\u0003#$A\"a5\u0002,\u0006\u0005\t\u0011!B\u0001\u0003+\u00131a\u0018\u00135Q\u0015ya\u000bYAlC\t\tI.\u0001B+_)R\u0003EU3ek\u000e,\u0007E^5fo\u0002\ng\u000e\u001a\u0011nKJ<W\rI:fY\u0016\u001cG/\u001a3!Kb\u0004Hn\u001c3fI\u0002\u001aH/\u0019;fAQ|\u0007E^3si\u0016D\be\u001d;bi\u0016T\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA5,'oZ3TiJ\fG/Z4z\u001b\u0006\u0004\b%T1qA\u0019\u0014x.\u001c\u0011ti\u0006$X\rI6fs\u0002\"x\u000eI7fe\u001e,\u0007e\u001d;sCR,w-\u001f\u0018!\u001f:d\u0017\u0010I:uCR,\u0007%\u001b8dYV$W\r\u001a\u0011j]*\u0001\u0003\u0005\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005Y7fe\u001e,7\u000b\u001e:bi\u0016<\u00170T1qA\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/\u001a3vG\u0016$\u0007%\u00198e\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S.\u00193fA\u00054\u0018-\u001b7bE2,\u0007e\u001c8!i\",\u0007EV3si\u0016DhF\u0003\u0011!A\u0001Rs\u0006F\u0003H\u0003;\f\t\u0010C\u0004\u0002`B\u0001\r!!9\u0002)\u0011,g-Y;mi6+'oZ3TiJ\fG/Z4za\u0019\t\u0019/a:\u0002nBA\u0011\u0011QAD\u0003K\fY\u000f\u0005\u0003\u0002\u0010\u0006\u001dH\u0001DAu\u0003;\f\t\u0011!A\u0003\u0002\u0005U%aA0%kA!\u0011qRAw\t1\ty/!8\u0002\u0002\u0003\u0005)\u0011AAK\u0005\ryFE\u000e\u0005\b\u0003[\u0003\u0002\u0019AAz!!\t\t,!/\u0002@\u0006U\bGBA|\u0003w\u0014\t\u0001\u0005\u0005\u0002\u0002\u0006\u001d\u0015\u0011`A\u0000!\u0011\ty)a?\u0005\u0019\u0005u\u0018\u0011_A\u0001\u0002\u0003\u0015\t!!&\u0003\u0007}#s\u0007\u0005\u0003\u0002\u0010\n\u0005A\u0001\u0004B\u0002\u0003c\f\t\u0011!A\u0003\u0002\u0005U%aA0%q!*\u0001C\u00161\u0003\b\u0005\u0012!\u0011B\u0001\u0003&=R#\u0006\t*fIV\u001cW\r\t<jK^\u0004\u0013M\u001c3![\u0016\u0014x-\u001a\u0011bY2\u0004S\r\u001f9m_\u0012,G\r\t<feR,\u0007\u0010I:uCR,'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\"WMZ1vYRlUM]4f'R\u0014\u0018\r^3hs\u0002jUM]4fAM$(/\u0019;fOf\u0004cm\u001c:!gR\fG/\u001a\u0011o_R\u0004\u0013N\\2mk\u0012,G\rI5oA\u0001lWM]4f'R\u0014\u0018\r^3hs6\u000b\u0007\u000f\u0019\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007%\\3sO\u0016\u001cFO]1uK\u001eLX*\u00199!\u001b\u0006\u0004\bE\u001a:p[\u0002\u001aH/\u0019;fA-,\u0017\u0010\t;pA5,'oZ3!gR\u0014\u0018\r^3hs\u0002BSo]3eAQ|\u0007e\u001c<feJLG-\u001a\u0011aI\u00164\u0017-\u001e7u\u001b\u0016\u0014x-Z*ue\u0006$XmZ=aS9R\u0001\u0005\t\u0011!U=\n\u0011\"Y4he\u0016<\u0017\r^3\u0015\u000b\u001d\u0013yA!\t\t\u0013\u0005}\u0017\u0003%AA\u0002\tE\u0001G\u0002B\n\u0005/\u0011i\u0002\u0005\u0005\u0002\u0002\u0006\u001d%Q\u0003B\u000e!\u0011\tyIa\u0006\u0005\u0019\te!qBA\u0001\u0002\u0003\u0015\t!!&\u0003\u0007}#\u0013\b\u0005\u0003\u0002\u0010\nuA\u0001\u0004B\u0010\u0005\u001f\t\t\u0011!A\u0003\u0002\u0005U%\u0001B0%cAB\u0011\"!,\u0012!\u0003\u0005\rAa\t\u0011\u0011\u0005E\u0016\u0011XA`\u0005K\u0001dAa\n\u0003,\tE\u0002\u0003CAA\u0003\u000f\u0013ICa\f\u0011\t\u0005=%1\u0006\u0003\r\u0005[\u0011\t#!A\u0001\u0002\u000b\u0005\u0011Q\u0013\u0002\u0005?\u0012\n\u0014\u0007\u0005\u0003\u0002\u0010\nEB\u0001\u0004B\u001a\u0005C\t\t\u0011!A\u0003\u0002\u0005U%\u0001B0%cIBS!\u0005,a\u0005o\t#A!\u000f\u0002\u00077{#F\u000b\u0011SK\u0012,8-\u001a\u0011wS\u0016<\b%\u00198eA\u0011,G.\u001a;fA\u0015D\b\u000f\\8eK\u0012\u0004c/\u001a:uS\u000e,7\u000f\t9fe6\fg.\u001a8uYfT\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+AQC\u0017n\u001d\u0011gk:\u001cG/[8oA!\f7\u000f\t;iK\u0002\u001a\u0018-\\3!K\u001a4Wm\u0019;!CN\u0004\u0003M]3ek\u000e,GMV5fo\u0002d\u0003%\u001a=dKB$\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011fqBdw\u000eZ3eAY,'\u000f^5dKN\u0004\u0013M]3!I\u0016dW\r^3eA\u0005tG\r\t8pA1|gnZ3s\u0015\u0001\u0002\u0003\u0005\t\u0016!CZ\f\u0017\u000e\\1cY\u0016\u0004cm\u001c:!gV\u00147/Z9vK:$\beY1mYN\u0004sN\u001a\u0011a[VdG/\u001b7bs\u0016\u0014h+[3xA:R\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA\u0011,g-Y;mi6+'oZ3TiJ\fG/Z4zA5+'oZ3!gR\u0014\u0018\r^3hs\u00022wN\u001d\u0011ti\u0006$X\r\t8pi\u0002Jgn\u00197vI\u0016$\u0007%\u001b8!A6,'oZ3TiJ\fG/Z4z\u001b\u0006\u0004\bM\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004S.\u001a:hKN#(/\u0019;fOfl\u0015\r\u001d\u0011NCB\u0004cM]8nAM$\u0018\r^3!W\u0016L\b\u0005^8![\u0016\u0014x-\u001a\u0011tiJ\fG/Z4zA!*8/\u001a3!i>\u0004sN^3se&$W\r\t1eK\u001a\fW\u000f\u001c;NKJ<Wm\u0015;sCR,w-\u001f1*])\u0001\u0003\u0005\t\u0011+_\u0005qQO\u001c3je\u0016\u001cG/\u001a3WS\u0016<\b&\u0002\nWA\n}\u0012E\u0001B!\u0003\u0005MsF\u000b\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011WS\u0016<\b\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5!CN\u0004\u0013M\u001c\u0011v]\u0012L'/Z2uK\u0012\u0004c.\u001a;x_J\\\u0007\u0005K3eO\u0016\u001c\b\u0005\u001e5bi\u0002*\u00070[:uA=tG.\u001f\u0011j]\u0002zg.\u001a\u0011eSJ,7\r^5p]\u0002\n'/\u001a\u0011ekBd\u0017nY1uK\u0012\u0004\u0013M\u001c3!K\u0012<Wm\u001d\u0011uQ\u0006$\b%\u001a=jgRT\u0001\u0005\t\u0011!U\u0001Jg\u000e\t2pi\"\u0004C-\u001b:fGRLwN\\:!CJ,\u0007%\\3sO\u0016$\u0017F\u0003\u0011!A\u0001Rs&\u0001\u0007eSJ,7\r^3e-&,w\u000fK\u0003\u0014-\u0002\u00149%\t\u0002\u0003J\u0005\tIf\f\u0016+\u0015\u0001\u0002\u0003\u0005\t\u0016!-&,w\u000f\t;iK\u0002:'/\u00199iA\u0005\u001c\b%\u0019\u0011eSJ,7\r^3eA9,Go^8sW\u0002BC-\u001e9mS\u000e\fG/\u001a3!K\u0012<Wm\u001d\u0011de\u0016\fG/\u001a3!Ef\u0004\u0013\r\t9sKZLw.^:!G\u0006dG\u000e\t;pA\u0001,h\u000eZ5sK\u000e$X\r\u001a,jK^\u0004\u0007%\u0019:fAI,Wn\u001c<fI*\u0001\u0003\u0005\t\u0011+A\u0005tG\r\t2j[\u0011L'/Z2uS>t\u0017\r\u001c\u0011fI\u001e,7\u000fI;o[5,'oZ3eS)\u0001\u0003\u0005\t\u0011+_\u0005a!/\u001a<feN,GMV5fo\"*AC\u00161\u0003P\u0005\u0012!\u0011K\u0001\u0002t>R#F\u0003\u0011!A\u0001R\u0003EU3wKJ\u001cX\r\t;iK\u0002\"\u0017N]3di&|g\u000eI8gA\u0015\f7\r\u001b\u0011fI\u001e,\u0007%\u001b8!i\",\u0007e\u001a:ba\"t#\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001ru\u000e^3!i\"\fG\u000fI5gAQDW\rI4sCBD\u0007%[:!GV\u0014(/\u001a8uYf\u0004c/[3xK\u0012\u0004\u0013m\u001d\u0011v]\u0012L'/Z2uK\u0012d\u0003\u0005\u001e5jg\u0002jW\r\u001e5pI\u0002B\u0017m\u001d\u0011o_\u0002JW.\\3eS\u0006$X\rI3gM\u0016\u001cG\u000f\f\u0011i_^,g/\u001a:-\u0015\u0001\u0002\u0003\u0005\t\u0016!K\u0012<Wm\u001d\u0011xS2d\u0007EY3!e\u00164XM]:fI\u0002zg\u000eI1!gV\u00147/Z9vK:$\beY1mY\u0002\"x\u000e\t1eSJ,7\r^3e-&,w\u000f\u0019\u0006!A\u0001\u0002#fL\u0001\u0005gR,\u0007\u000fF\u0002G\u0005/BaAZ\u000bA\u0002\te\u0003\u0003B\u0018i\tBDS!\u0006,a\u0005;\n#Aa\u0018\u0002A>R#\u0006I#yK\u000e,H/\u001a\u0011bY\u001e|'/\u001b;i[\u0002\u001aH/\u001a9\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t4!C2<wN]5uQ6\u00043\u000f^3qA!\u0012XO\u001c\u0011p]\u000e,\u0007EZ8sA\u0015\f7\r\u001b\u0011wKJ$X\r_\u0015\u000bA\u0001\u0002\u0003EK\u0018\u0015\u0007\u0019\u0013\u0019\u0007\u0003\u0004g-\u0001\u0007!Q\r\t\u0007_\u0005\u001dAI\u001b9)\u000bY1\u0006M!\u001b\"\u0005\t-\u0014!!00U)\u0002S\t_3dkR,\u0007%\u00197h_JLG\u000f[7!gR,\u0007\u000fI<ji\"\u0004s\r\\8cC2\u0004sM]1qQ\u0002\u001aH/\u0019;fA!B\u0017m\u001d\u0011bG\u000e,7o\u001d\u0011u_\u0002\n7mY;nk2\fG/\u001a3!gR\fG/\u001a\u0011ge>l'\u0002\t\u0011!A)\u0002\u0003O]3wS>,8\u000fI:uKB\u001c\b%\u00198eA\u0005dGn\\<tA\u0019|'\u000fI1dGVlW\u000f\\1uS>t\u0007e\u001c4!]\u0016<\bE^1mk\u0016\u001c\u0018F\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c\rI1mO>\u0014\u0018\u000e\u001e5nAM$X\r\u001d\u0011)eVt\u0007e\u001c8dK\u00022wN\u001d\u0011fC\u000eD\u0007E^3si\u0016D\u0018F\u0003\u0011!A\u0001Rs&\u0001\u0005fI\u001e,7\u000b^3q)\r1%\u0011\u000f\u0005\u0007M^\u0001\rAa\u001d\u0011\u000b=B\u0017\u0011\u00049)\u000b]1\u0006Ma\u001e\"\u0005\te\u0014\u0001W\u0018+U\u0001*\u00050Z2vi\u0016\u0004\u0013\r\\4pe&$\b.\u001c\u0011ti\u0016\u0004(\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u00022\u0007%\u00197h_JLG\u000f[7!gR,\u0007\u000f\t\u0015sk:\u0004sN\u001c\u0011fC\u000eD\u0007%\u001a3hK&R\u0001\u0005\t\u0011!U=\"2A\u0012B?\u0011\u00191\u0007\u00041\u0001\u0003\u0000A9q&a\u0002\u0002\u001a)\u0004\b&\u0002\rWA\n\r\u0015E\u0001BC\u0003\u00055vF\u000b\u0016!\u000bb,7-\u001e;fA\u0005dwm\u001c:ji\"l\u0007e\u001d;fa\u0002:\u0018\u000e\u001e5!O2|'-\u00197!OJ\f\u0007\u000f\u001b\u0011ti\u0006$X\r\t\u0015iCN\u0004\u0013mY2fgN\u0004Co\u001c\u0011bG\u000e,X.\u001e7bi\u0016$\u0007e\u001d;bi\u0016\u0004cM]8n\u0015\u0001\u0002\u0003\u0005\t\u0016!aJ,g/[8vg\u0002\u001aH/\u001a9tA\u0005tG\rI1mY><8\u000f\t4pe\u0002\n7mY;nk2\fG/[8oA=4\u0007E\\3xAY\fG.^3tS)\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!M\u0002\nGnZ8sSRDW\u000eI:uKB\u0004\u0003F];oA=t\u0007%Z1dQ\u0002*GmZ3*\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003\u001dIG/\u001a:bi\u0016$rA\u0012BF\u0005\u001b\u00139\n\u0003\u0004g3\u0001\u0007!\u0011\f\u0005\b\u0005\u001fK\u0002\u0019\u0001BI\u0003)IG/\u001a:bi&|gn\u001d\t\u0004_\tM\u0015b\u0001BKa\t\u0019\u0011J\u001c;\t\r\te\u0015\u00041\u0001{\u0003M)\u00070Z2vi\u0016lUm]:bO\u0016$wJ\u001c7zQ\u0015Ib\u000b\u0019BOC\t\u0011y*\u0001Bi_)R\u0003%\u0012=fGV$X\rI1mO>\u0014\u0018\u000e\u001e5nAM$X\r\u001d\u0011sKB,\u0017\r^3eYf\u0004cm\u001c:!O&4XM\u001c\u0011ok6\u0014WM\u001d\u0011pM\u0002JG/\u001a:bi&|gn\u001d\u0011pe\u0002*h\u000e^5mA\u0005dG\u000e\t<feRL7-Z:!Q\u00064X\r\t<pi\u0016$\u0007\u0005^8!Q\u0006dGO\f\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\u001a\u0011bY\u001e|'/\u001b;i[\u0002\u001aH/\u001a9!QI,h\u000eI8oG\u0016\u0004cm\u001c:!K\u0006\u001c\u0007\u000e\t<feR,\u0007\u0010\t9fe\u0002JG/\u001a:bi&|g.Kb\u0010\u0016\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011ji\u0016\u0014\u0018\r^5p]N\u0004S.\u0019=j[Vl\u0007E\\;nE\u0016\u0014\be\u001c4!SR,'/\u0019;j_:\u001c(\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002*\u00070Z2vi\u0016lUm]:bO\u0016$wJ\u001c7zA%3\u0007\u0005\u0019;sk\u0016\u0004G\u0006I8oYf\u0004#/\u001e8!gR,\u0007\u000f\t4pe\u00022XM\u001d;jG\u0016\u001c\be\u001e5jG\"\u0004#/Z2fSZ,G\r\t8fo\u0002jWm]:bO\u0016\u001c(\u0002\t\u0011!A)zCc\u0002$\u0003$\n\u0015&q\u0015\u0005\u0007Mj\u0001\rA!\u001a\t\u000f\t=%\u00041\u0001\u0003\u0012\"1!\u0011\u0014\u000eA\u0002iDSA\u0007,a\u0005W\u000b#A!,\u0002\u0007\u0013y#F\u000b\u0011Fq\u0016\u001cW\u000f^3!C2<wN]5uQ6\u00043\u000f^3qA]LG\u000f\u001b\u0011hY>\u0014\u0017\r\u001c\u0011he\u0006\u0004\b\u000eI:uCR,\u0007E]3qK\u0006$X\r\u001a7zA\u0019|'\u000fI4jm\u0016t\u0007E\\;nE\u0016\u0014\be\u001c4!SR,'/\u0019;j_:\u001c\be\u001c:\u000bA\u0001\u0002\u0003E\u000b\u0011v]RLG\u000eI1mY\u00022XM\u001d;jG\u0016\u001c\b\u0005[1wK\u00022x\u000e^3eAQ|\u0007\u0005[1mi:R\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA\u0019\u0004\u0013\r\\4pe&$\b.\u001c\u0011ti\u0016\u0004\b\u0005\u000b:v]\u0002zgnY3!M>\u0014\b%Z1dQ\u00022XM\u001d;fq\u0002\u0002XM\u001d\u0011ji\u0016\u0014\u0018\r^5p]&R\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA%$XM]1uS>t7\u000fI7bq&lW/\u001c\u0011ok6\u0014WM\u001d\u0011pM\u0002JG/\u001a:bi&|gn\u001d\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007%\u001a=fGV$X-T3tg\u0006<W\rZ(oYf\u0004\u0013J\u001a\u0011aiJ,X\r\u0019\u0017!_:d\u0017\u0010\t:v]\u0002\u001aH/\u001a9!M>\u0014\bE^3si&\u001cWm\u001d\u0011xQ&\u001c\u0007\u000e\t:fG\u0016Lg/\u001a3!]\u0016<\b%\\3tg\u0006<Wm\u001d\u0006!A\u0001\u0002#fL\u0001\u0007g\u0016dWm\u0019;\u0015\t\tM&q\u0018\t\u0005\u0005k\u0013Y,\u0004\u0002\u00038*\u0019!\u0011\u0018\u0013\u0002\u000bQ\f'\r\\3\n\t\tu&q\u0017\u0002\u0006)\u0006\u0014G.\u001a\u0005\b\u0005\u0003\\\u0002\u0019\u0001Bb\u0003\u00191\u0018\r\\;fgB)qF!2\u0002@&\u0019!q\u0019\u0019\u0003\u0015q\u0012X\r]3bi\u0016$g\bK\u0003\u001c-\u0002\u0014Y-\t\u0002\u0003N\u0006\u0011\u0019d\f\u0016+AI+G/\u001e:og\u0002\n\u0007\u0005^1cY\u0016\u0004s/\u001b;iA=tW\r\t:po\u0002\u0002XM\u001d\u0011wKJ$X\r\u001f\u0011b]\u0012\u0004sN\\3!G>dW/\u001c8!a\u0016\u0014\be[3zA%t\u0007\u0005\u0019<bYV,7\u000f\u0019\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003%\u00134!]>\u0004c/\u00197vKN\u0004\u0013M]3!aJ|g/\u001b3fI2\u0002\u0013\r\u001c7!_\u001a\u0004C\u000f[3!m\u0006dW/Z:!MJ|W\u000e\t;iK\u0002\u0002(o\u001c9feRLWm\u001d\u0011b]\u0012\u0004C\u000f[3!gR\fG/\u001a\u0011be\u0016\u0004S\r\u001f;sC\u000e$X\r\u001a\u0018\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t<bYV,7\u000f\t;iK\u0002ZW-_:!i>\u0004#-\u001a\u0011fqR\u0014\u0018m\u0019;fI\u00022'o\\7!KZ,'/\u001f\u0011wKJ$X\r\u001f\u0011ti\u0006$X\rI1oI\u0002\u0002(o\u001c9feRLWm\u001d\u0006!A\u0001\u0002#fL\u0001\rO2|'-\u00197TK2,7\r\u001e\u000b\u0005\u0005g\u0013\u0019\u000eC\u0004\u0003Br\u0001\rAa1)\u000bq1\u0006Ma6\"\u0005\te\u0017!!\u001a0U)\u0002#+\u001a;ve:\u001c\b%\u0019\u0011uC\ndW\rI<ji\"\u0004\u0013\rI:j]\u001edW\r\t:po\u00022'o\\7!i\",\u0007e\u001a7pE\u0006d\u0007e\u001a:bQ\u0002\u001aH/\u0019;fA\u0005tG\rI8oK\u0002\u001aw\u000e\\;n]\u0002\u0002XM\u001d\u0011lKf\u0004\u0013N\u001c\u0011am\u0006dW/Z:a\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011wC2,Xm\u001d\u0011uQ\u0016\u00043.Z=tAQ|\u0007EY3!Kb$(/Y2uK\u0012\u0004cM]8nAQDW\rI4sCBD\u0007e\u001d;bi\u0016T\u0001\u0005\t\u0011!U=\nQb\u00197fCJlUm]:bO\u0016\u001cH#\u0001$)\u000bu1\u0006M!9\"\u0005\t\r\u0018!!\u00150U)\u00023\t\\3be\u0002jWm]:bO\u0016\u001c\bE\u001a:p[\u0002\u0002(/\u001a<j_V\u001c\be\u001c9fe\u0006$\u0018n\u001c8t]\u0001\"\u0006.[:!MVt7\r^5p]\u0002J7\u000f\t9sK\u0012|W.\u001b8b]Rd\u0017\u0010I;tK\u0012\u0004\u0013N\u001c;fe:\fG\u000e\\=!C:$\u0007e\u001d5pk2$gn\n;!E\u0016\u00043-\u00197mK\u0012\u0004#-\u001f\u0011uQ\u0016\u0004So]3sAUtG.Z:tAQDW-\u001f\u0011l]><\be\u001e5bi\u0002\"\b.Z=!CJ,\u0007\u0005Z8j]\u001et\u0003EK\u0018\u000215,H\u000e^5mCf,'OV5fo\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003j*\"\u0011q\tBvW\t\u0011i\u000f\u0005\u0003\u0003p\neXB\u0001By\u0015\u0011\u0011\u0019P!>\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B|a\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm(\u0011\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE1hOJ,w-\u0019;fI\u0011,g-Y;mi\u0012\nTCAB\u0001a\u0011\u0019\u0019aa\u0007+\t\r\u0015!1\u001e\t\u0007_!\u001c9!a&\u0011\r\r%1qBB\n\u001b\t\u0019YAC\u0002\u0004\u000eA\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019\tba\u0003\u0003\u0011%#XM]1cY\u0016\u0004RAOB\u000b\u00073I1aa\u0006<\u00055\u0001&o\u001c9feRLh+\u00197vKB!\u0011qRB\u000e\t-\u0011IbHA\u0001\u0002\u0003\u0015\t!!&\u0002'\u0005<wM]3hCR,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r\u0005\"\u0006BB\u0012\u0005W\u0004\u0002\"!-\u0002:\u0006}6Q\u0005\u0019\u0007\u0007O\u0019Yca\f\u0011\u0011\u0005\u0005\u0015qQB\u0015\u0007[\u0001B!a$\u0004,\u0011Y!Q\u0006\u0011\u0002\u0002\u0003\u0005)\u0011AAK!\u0011\tyia\f\u0005\u0017\tM\u0002%!A\u0001\u0002\u000b\u0005\u0011Q\u0013\u0015\u0006\u0001Y\u000371G\u0011\u0003\u0007k\tQqO\u0018+U\u0001\u0002VO\u00197jG\u0002Jg\u000e^3sM\u0006\u001cW\r\t4pe\u0002:'/\u00199iA=\u0004XM]1uS>t7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011UQ\u0016\u0004\u0003m\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3aA%\u001c\b\u0005\u001e5fA%tG/\u001a:gC\u000e,\u0007EZ8sA\u0011,g-\u001b8j]\u001e\u0004\u0013\r\\4pe&$\b.\\:!S:\u0004#+\u00199ii>\u0014\u0018\u0010I1oI\u0002\u0012XmY8sIN\u0004\u0013\r\u001c7!_B,'/\u0019;j_:\u001c\b\u0005^8!E\u0016T\u0001\u0005\t\u0016!CB\u0004H.[3eAQ|\u0007%\u0019\u0011he\u0006\u0004\b\u000eI1tA\u0005\u00043/Z9vK:\u001cW\rI8gAM$X\r]:!i>\u0004S\r_3dkR,gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011N_N$\be\u001c9fe\u0006$\u0018n\u001c8tA=t\u0007%\u0019\u0011a\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016\u0004\u0007E]3ukJt\u0007%\u0019\u0011he\u0006\u0004\b\u000eI8sA5,H\u000e^5mCf,'O\u0003\u0011!U\u0001:'/\u00199iA\u0005\u001c\b%\u0019\u0011sKN,H\u000e\u001e\u0018!)>\u00043/\u001e9q_J$\bE]3ukJt\u0017N\\4!i\",'\u0002\t\u0011+A\r|'O]3di\u0002:'/\u00199iAQL\b/\u001a\u0017!i\",\u0007\u0005Y$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<fA\u0002B\u0017m\u001d\u0011bEN$(/Y2uAQL\b/\u001a\u0011nK6\u0014WM]:\u000bA\u0001R#\u0002\t\u0011+A\u0001j\u0003\u0005Y$sCBD\u0007M\u000f\u0011DkJ\u0014XM\u001c;!OJ\f\u0007\u000f\u001b\u0011usB,\u0007\u0005K2b]\u0002\u0012W\rI7vYRLG.Y=fe\u0002z'\u000f\t:fIV\u001cW\rZ\u0015\u000bA\u0001R\u0003\u0005I\u0017!A6+H\u000e^5mCf,'o\u0012:ba\"\u0004'\b\t+iK\u0002\"\u0018\u0010]3!_\u001a\u0004C\u000f[3!7nkU\u000f\u001c;jY\u0006LXM]$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f;v\u00033m\u001c:sKN\u0004xN\u001c3j]\u001e\u0004Co\u001c\u0011uQ\u0016\u00043-\u001e:sK:$\be\u001a:ba\"T\u0001\u0005\t\u0016!A5\u0002\u0003MU3ek\u000e,Gm\u0012:ba\"\u0004'\b\t+iK\u0002\"\u0018\u0010]3!_\u001a\u0004C\u000f[3!7n\u0013V\rZ;dK\u0012<%/\u00199i!\u0016\u00148\u000f]3di&4X-X/!G>\u0014(/Z:q_:$\u0017N\\4!i>\u0004C\u000f[3!GV\u0014(/\u001a8uA\u001d\u0014\u0018\r\u001d5\u000bA\u0001Rs\u0006")
public interface GraphPerspective {
    @Scaladoc(value="/**\n    * Return the graph unchanged\n    *\n    * This is used to obtain the correct return type without performing any operations\n    */")
    public ConcreteGraphPerspective identity();

    @Scaladoc(value="/** Add a function to manipulate global graph state, mainly used to initialise accumulators before the next algorithm step\n    *\n    * @param f function to set graph state (runs exactly once)\n    */")
    public ConcreteGraphPerspective setGlobalState(Function1<GraphState, BoxedUnit> var1);

    @Scaladoc(value="/** Filter vertices of the graph\n    *\n    * @param f filter function (only vertices for which `f` returns `true` are kept). All associated edges of filtered vertices are also removed.\n    */")
    public ConcreteGraphPerspective vertexFilter(Function1<Vertex, Object> var1);

    @Scaladoc(value="/** Filter vertices of the graph with global graph state\n    *\n    * @param f filter function with access to graph state (only vertices for which `f` returns `true` are kept). All associated edges of filtered vertices are also removed.\n    */")
    public ConcreteGraphPerspective vertexFilter(Function2<Vertex, GraphState, Object> var1);

    @Scaladoc(value="/** Filter edges of the graph\n    *\n    * @param f filter function (only edges for which `f` returns `true` are kept)\n    *\n    * @param pruneNodes if this is `true` then vertices which become isolated (have no incoming or outgoing edges)\n    *                   after this filtering are also removed.\n    */")
    public ConcreteGraphPerspective edgeFilter(Function1<Edge, Object> var1, boolean var2);

    @Scaladoc(value="/** Filter edges of the graph with global graph state\n    *\n    * @param f filter function with access to graph state (only edges for which `f` returns `true` are kept)\n    *\n    * @param pruneNodes if this is `true` then vertices which become isolated (have no incoming or outgoing edges)\n    *                   after this filtering are also removed.\n    */")
    public ConcreteGraphPerspective edgeFilter(Function2<Edge, GraphState, Object> var1, boolean var2);

    @Scaladoc(value="/** Switch to multilayer view\n    *\n    * After calling `multilayerView`, subsequent methods that manipulate vertices act on\n    * [[visitor.ExplodedVertex ExplodedVertices]] instead. If [[visitor.ExplodedVertex ExplodedVertex]]\n    * instances were already created by a previous call to `multilayerView`, they are preserved. Otherwise, this\n    * method creates an [[visitor.ExplodedVertex ExplodedVertex]] instance for each\n    * time point that a vertex is active.\n    */")
    public ConcreteMultilayerGraphPerspective multilayerView();

    @Scaladoc(value="/** Switch to multilayer view and add interlayer edges.\n    *\n    * @param interlayerEdgeBuilder Interlayer edge builder to create interlayer edges for each vertex. See\n    *                              [[visitor.InterlayerEdgeBuilders InterlayerEdgeBuilders]] for predefined options.\n    *\n    * Existing [[visitor.ExplodedVertex ExplodedVertex]] instances are preserved but all interlayer edges are recreated using the supplied\n    * `interlayerEdgeBuilder`.\n    */")
    public ConcreteMultilayerGraphPerspective multilayerView(Function1<Vertex, Seq<InterlayerEdge>> var1);

    public static /* synthetic */ Function1 multilayerView$default$1$(GraphPerspective $this) {
        return $this.multilayerView$default$1();
    }

    default public Function1<Vertex, Seq<InterlayerEdge>> multilayerView$default$1() {
        return (Function1 & Serializable)x$1 -> (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
    }

    @Scaladoc(value="/** Switch computation to act on [[visitor.Vertex Vertex]], inverse of `multilayerView`\n    *\n    * This operation does nothing if the view is already reduced. Otherwise it switches back to running computations\n    * on vertices but preserves any existing [[visitor.ExplodedVertex ExplodedVertex]] instances\n    * created by previous calls to `multilayerView` to allow switching back-and-forth between views while\n    * preserving computational state. Computational state on [[visitor.ExplodedVertex ExplodedVertex]]\n    * instances is not accessible from the `Vertex` unless a merge strategy is supplied (see below).\n    */")
    public ConcreteReducedGraphPerspective reducedView();

    @Scaladoc(value="/** Reduce view and apply the same merge strategy to convert each exploded state to vertex state\n    *\n    * @param mergeStragegy Function to convert a history of values of type to a single value of type (see\n    *          [[PropertyMergeStrategy]] for predefined options)\n    */")
    public ConcreteReducedGraphPerspective reducedView(Function1<Iterable<PropertyValue<Object>>, Object> var1);

    @Scaladoc(value="/** Reduce view and merge selected exploded state to vertex state\n    *\n    * @param mergeStrategyMap Map from state key to merge strategy. Only state included in\n    *                         `mergeStrategyMap` will be reduced and\n    *                         made available on the Vertex.\n    */")
    public ConcreteReducedGraphPerspective reducedView(Map<String, Function1<Iterable<PropertyValue<Object>>, Object>> var1);

    @Scaladoc(value="/** Reduce view and merge all exploded vertex state\n    *\n    * @param defaultMergeStrategy Merge strategy for state not included in `mergeStrategyMap`\n    *\n    * @param mergeStrategyMap Map from state key to merge strategy (used to override `defaultMergeStrategy`).\n    */")
    public ConcreteReducedGraphPerspective reducedView(Function1<Iterable<PropertyValue<Object>>, Object> var1, Map<String, Function1<Iterable<PropertyValue<Object>>, Object>> var2);

    @Scaladoc(value="/** Reduce view and delete exploded vertices permanently\n    *\n    * This function has the same effect as `reducedView`, except that the exploded vertices are deleted and no longer\n    * available for subsequent calls of `multilayerView`.\n    *\n    * @param defaultMergeStrategy Merge strategy for state not included in `mergeStrategyMap`\n    *\n    * @param mergeStrategyMap Map from state key to merge strategy (used to override `defaultMergeStrategy`).\n    */")
    public ConcreteReducedGraphPerspective aggregate(Function1<Iterable<PropertyValue<Object>>, Object> var1, Map<String, Function1<Iterable<PropertyValue<Object>>, Object>> var2);

    public static /* synthetic */ Function1 aggregate$default$1$(GraphPerspective $this) {
        return $this.aggregate$default$1();
    }

    default public Function1<Iterable<PropertyValue<Object>>, Object> aggregate$default$1() {
        return PropertyMergeStrategy$.MODULE$.sequence();
    }

    public static /* synthetic */ Map aggregate$default$2$(GraphPerspective $this) {
        return $this.aggregate$default$2();
    }

    default public Map<String, Function1<Iterable<PropertyValue<Object>>, Object>> aggregate$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    @Scaladoc(value="/**\n    * View the graph as an undirected network (edges that exist only in one direction are duplicated and edges that exist\n    * in both directions are merged)\n    */")
    public ConcreteGraphPerspective undirectedView();

    @Scaladoc(value="/**\n    * View the graph as a directed network (duplicated edges created by a previous call to `undirectedView` are removed\n    * and bi-directional edges un-merged)\n    */")
    public ConcreteGraphPerspective directedView();

    @Scaladoc(value="/**\n    * Reverse the direction of each edge in the graph.\n    *\n    * Note that if the graph is currently viewed as undirected, this method has no immediate effect, however,\n    * edges will be reversed on a subsequent call to `directedView`\n    */")
    public ConcreteGraphPerspective reversedView();

    @Scaladoc(value="/** Execute algorithm step\n    *\n    * @param f algorithm step (run once for each vertex)\n    */")
    public ConcreteGraphPerspective step(Function1<Vertex, BoxedUnit> var1);

    @Scaladoc(value="/** Execute algorithm step with global graph state (has access to accumulated state from\n    * previous steps and allows for accumulation of new values)\n    *\n    * @param f algorithm step (run once for each vertex)\n    */")
    public ConcreteGraphPerspective step(Function2<Vertex, GraphState, BoxedUnit> var1);

    @Scaladoc(value="/** Execute algorithm step\n    *\n    * @param f algorithm step (run on each edge)\n    */")
    public ConcreteGraphPerspective edgeStep(Function1<Edge, BoxedUnit> var1);

    @Scaladoc(value="/** Execute algorithm step with global graph state (has access to accumulated state from\n    * previous steps and allows for accumulation of new values)\n    *\n    * @param f algorithm step (run on each edge)\n    */")
    public ConcreteGraphPerspective edgeStep(Function2<Edge, GraphState, BoxedUnit> var1);

    @Scaladoc(value="/** Execute algorithm step repeatedly for given number of iterations or until all vertices have voted to halt.\n    *\n    * @param f algorithm step (run once for each vertex per iteration)\u00cf\n    *\n    * @param iterations maximum number of iterations\n    *\n    * @param executeMessagedOnly If `true`, only run step for vertices which received new messages\n    */")
    public ConcreteGraphPerspective iterate(Function1<Vertex, BoxedUnit> var1, int var2, boolean var3);

    @Scaladoc(value="/** Execute algorithm step with global graph state repeatedly for given number of iterations or\n    * until all vertices have voted to halt.\n    *\n    * @param f algorithm step (run once for each vertex per iteration)\n    *\n    * @param iterations maximum number of iterations\n    *\n    * @param executeMessagedOnly If `true`, only run step for vertices which received new messages\n    */")
    public ConcreteGraphPerspective iterate(Function2<Vertex, GraphState, BoxedUnit> var1, int var2, boolean var3);

    @Scaladoc(value="/** Returns a table with one row per vertex and one column per key in `values`\n    *\n    * If no values are provided, all of the values from the properties and the state are extracted.\n    *\n    * @param values the keys to be extracted from every vertex state and properties\n    */")
    public Table select(Seq<String> var1);

    @Scaladoc(value="/** Returns a table with a single row from the global grah state and one column per key in `values`\n    *\n    * @param values the keys to be extracted from the graph state\n    */")
    public Table globalSelect(Seq<String> var1);

    @Scaladoc(value="/** Clear messages from previous operations. This function is predominantly used internally and shouldn't be called by the user unless they know what they are doing. */")
    public ConcreteGraphPerspective clearMessages();
}

