/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.graphstate;

import com.github.takezoe.scaladoc.Scaladoc;
import com.google.protobuf.ByteString;
import com.raphtory.api.analysis.graphstate.Accumulator;
import com.raphtory.api.analysis.graphstate.GraphState$;
import com.raphtory.utils.Bounded;
import com.raphtory.utils.Bounded$;
import com.raphtory.utils.ExtendedNumeric$;
import scala.Function2;
import scala.Option;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scalapb.TypeMapper;

@Scaladoc(value="/**\n  * Public interface for global accumulators\n  *\n  *  The GraphState tracks global (graph-level) variables during algorithm execution.\n  *  Graph-level state takes the form of accumulators which expose the value computed during the last step/iteration\n  *  and allow accumulation of new state based on a reduction function.\n  *\n  * @see [[com.raphtory.api.analysis.graphview.GraphPerspective GraphPerspective]], [[Accumulator]]\n  *\n  * @define retainState @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n  *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n  *\n  * @define name @param name Name for the accumulator\n  *\n  * @define initialValue @param initialValue Initial value for accumulator\n  *\n  * @define vType @tparam T Value type of the accumulator\n  *\n  * @define iType @tparam S Input type of the accumulator\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0011eb!\u0002\u0015*\u0003\u0003!\u0004\"B\u001e\u0001\t\u0003a\u0004\"B \u0001\r\u0003\u0001\u0005\"B<\u0001\r\u0003A\b\"CA\u0002\u0001E\u0005I\u0011AA\u0003\u0011\u001d\ty\u0002\u0001D\u0001\u0003CAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u00024\u0001!\t!!\u0018\t\u000f\u0005M\u0002\u0001\"\u0001\u0002x!9\u00111\u0007\u0001\u0007\u0002\u0005E\u0005bBAe\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003\u0013\u0004a\u0011AAi\u0011\u001d\t\t\u000f\u0001C\u0001\u0003GDq!!9\u0001\t\u0003\tY\u0010C\u0004\u0002b\u0002!\tA!\u0006\t\u000f\u0005\u0005\bA\"\u0001\u00030!9!1\n\u0001\u0005\u0002\t5\u0003b\u0002B&\u0001\u0011\u0005!Q\u000f\u0005\b\u0005\u0017\u0002A\u0011\u0001BK\u0011\u001d\u0011Y\u0005\u0001D\u0001\u0005kCqAa6\u0001\t\u0003\u0011I\u000eC\u0004\u0003X\u0002!\tAa>\t\u000f\t]\u0007\u0001\"\u0001\u0004\u0018!9!q\u001b\u0001\u0007\u0002\r]\u0002bBB-\u0001\u0019\u000511\f\u0005\b\u0007\u0003\u0003a\u0011ABB\u0011\u001d\u0019\u0019\n\u0001D\u0001\u0007+Cqa!)\u0001\r\u0003\u0019\u0019\u000bC\u0004\u00040\u00021\ta!-\t\u000f\re\u0006A\"\u0001\u0004<\"91q\u001b\u0001\u0007\u0002\re\u0007bBB{\u0001\u0019\u00051q\u001f\u0005\n\t\u0003\u0001\u0011\u0013!C\u0001\t\u0007A\u0011\u0002b\u0002\u0001#\u0003%\t\u0001\"\u0003\t\u0013\u00115\u0001!%A\u0005\u0002\u0011=\u0001\"\u0003C\n\u0001E\u0005I\u0011AA\u0004\u0011%!)\u0002AI\u0001\n\u0003\t9aB\u0004\u0005\u001e%B\t\u0001b\b\u0007\r!J\u0003\u0012\u0001C\u0011\u0011\u0019Yd\u0005\"\u0001\u00058\tQqI]1qQN#\u0018\r^3\u000b\u0005)Z\u0013AC4sCBD7\u000f^1uK*\u0011A&L\u0001\tC:\fG._:jg*\u0011afL\u0001\u0004CBL'B\u0001\u00192\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\u001a\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001)\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002{A\u0011a\bA\u0007\u0002S\u0005qa.Z<BG\u000e,X.\u001e7bi>\u0014XCA!W)\u0015\u0011UIU0e!\t14)\u0003\u0002Eo\t!QK\\5u\u0011\u00151%\u00011\u0001H\u0003\u0011q\u0017-\\3\u0011\u0005!{eBA%N!\tQu'D\u0001L\u0015\ta5'\u0001\u0004=e>|GOP\u0005\u0003\u001d^\na\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011aj\u000e\u0005\u0006'\n\u0001\r\u0001V\u0001\rS:LG/[1m-\u0006dW/\u001a\t\u0003+Zc\u0001\u0001B\u0003X\u0005\t\u0007\u0001LA\u0001U#\tIF\f\u0005\u000275&\u00111l\u000e\u0002\b\u001d>$\b.\u001b8h!\t1T,\u0003\u0002_o\t\u0019\u0011I\\=\t\u000f\u0001\u0014\u0001\u0013!a\u0001C\u0006Y!/\u001a;bS:\u001cF/\u0019;f!\t1$-\u0003\u0002do\t9!i\\8mK\u0006t\u0007\"B3\u0003\u0001\u00041\u0017AA8q!\u00151t\r\u0016+U\u0013\tAwGA\u0005Gk:\u001cG/[8oe!\"!A\u001b;v!\tY'/D\u0001m\u0015\tig.\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\ty\u0007/A\u0004uC.,'p\\3\u000b\u0005E\f\u0014AB4ji\",(-\u0003\u0002tY\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001w\u0003\r]xF\u000b\u0016!A\r\u0013X-\u0019;fA\u0005\u0004c.Z<!O\u0016tWM]1mA\u0005\u001b7-^7vY\u0006$xN\u001d\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u0011;qCJ\fW\u000e\t+!-\u0006dW/\u001a\u0011usB,\u0007e\u001c4!i\",\u0007%Y2dk6,H.\u0019;pe*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA9\fW.\u001a\u0011OC6,\u0007EZ8sAQDW\rI1dGVlW\u000f\\1u_JT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002Jg.\u001b;jC24\u0016\r\\;fA%s\u0017\u000e^5bY\u00022\u0018\r\\;fA\u0019|'\u000fI1dGVlW\u000f\\1u_JT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u0012X\r^1j]N#\u0018\r^3!\u0013\u001a\u0004\u0003\r\u001e:vK\u0002d\u0003%Y2dk6,H.\u0019;j_:\u0004cm\u001c:!i\",\u0007E\\3yi\u0002\u001aH/\u001a90SR,'/\u0019;j_:\u0004sN\u001a\u0011b]\u0002\nGnZ8sSRDW\u000eI2p]RLg.^3tA]LG\u000f\u001b\u0011uQ\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011qe\u00164\u0018n\\;tYf\u00043m\\7qkR,G\r\t<bYV,G\u0006I8uQ\u0016\u0014x/[:fY\u0001\"\b.\u001a\u0011wC2,X\rI5tAI,7/\u001a;!i>\u0004\u0003-\u001b8ji&\fGNV1mk\u0016\u0004\u0007EY3g_J,\u0007%Z1dQ\u0002\u001aH/\u001a9/\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011pa\u0002\u0012V\rZ;di&|g\u000e\t4v]\u000e$\u0018n\u001c8!M>\u0014\b\u0005\u001e5fA\u0005\u001c7-^7vY\u0006$xN\u001d\u0018\u000bA\u0001\u0002\u0003EK\u0018\u000219,woQ8oGV\u0014(/\u001a8u\u0003\u000e\u001cW/\\;mCR|'/\u0006\u0002z{R)!I_>\u007f\u007f\")ai\u0001a\u0001\u000f\")1k\u0001a\u0001yB\u0011Q+ \u0003\u0006/\u000e\u0011\r\u0001\u0017\u0005\bA\u000e\u0001\n\u00111\u0001b\u0011\u0019)7\u00011\u0001\u0002\u0002A)ag\u001a?}y\u0006\u0011c.Z<D_:\u001cWO\u001d:f]R\f5mY;nk2\fGo\u001c:%I\u00164\u0017-\u001e7uIM*B!a\u0002\u0002\u001eU\u0011\u0011\u0011\u0002\u0016\u0004C\u0006-1FAA\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]q'\u0001\u0006b]:|G/\u0019;j_:LA!a\u0007\u0002\u0012\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b]#!\u0019\u0001-\u0002\u00179,woQ8ogR\fg\u000e^\u000b\u0005\u0003G\tY\u0003F\u0003C\u0003K\t9\u0003C\u0003G\u000b\u0001\u0007q\t\u0003\u0004u\u000b\u0001\u0007\u0011\u0011\u0006\t\u0004+\u0006-B!B,\u0006\u0005\u0004A\u0006&B\u0003ki\u0006=\u0012EAA\u0019\u0003\u0005%uF\u000b\u0016!\u0007J,\u0017\r^3!C\u0002rWm\u001e\u0011d_:\u001cH/\u00198uAQD\u0017\r\u001e\u0011ti>\u0014Xm\u001d\u0011b]\u0002JW.\\;uC\ndW\r\t<bYV,'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002E\u000f]1sC6\u0004C\u000b\t,bYV,\u0007\u0005^=qK\u0002zg\r\t;iK\u0002\u001awN\\:uC:$(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c.Y7fA9\u000bW.\u001a\u0011g_J\u0004C\u000f[3!C\u000e\u001cW/\\;mCR|'O\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E^1mk\u0016\u0004c+\u00197vK\u0002zg\r\t;iK\u0002\u001awN\\:uC:$(\u0002\t\u0011!A)z\u0013\u0001\u00038fo\u0006#G-\u001a:\u0016\t\u0005]\u00121\u000b\u000b\u0005\u0003s\t)\u0006F\u0002C\u0003wA\u0011\"!\u0010\u0007\u0003\u0003\u0005\u001d!a\u0010\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0002B\u0005-\u0013\u0011\u000b\b\u0005\u0003\u0007\n9ED\u0002K\u0003\u000bJ\u0011\u0001O\u0005\u0004\u0003\u0013:\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\nyEA\u0004Ok6,'/[2\u000b\u0007\u0005%s\u0007E\u0002V\u0003'\"Qa\u0016\u0004C\u0002aCQA\u0012\u0004A\u0002\u001dCSA\u00026u\u00033\n#!a\u0017\u0002\u0003\u007fz#F\u000b\u0011De\u0016\fG/\u001a\u0011bA9,w\u000f\t>fe>l\u0013N\\5uS\u0006d\u0017n]3eA\u0005\u001c7-^7vY\u0006$xN\u001d\u0011uQ\u0006$\be];ng\u00022\u0018\r\\;fg\u0002\ng\u000e\u001a\u0011sKN,Go\u001d\u0011bMR,'\u000fI3bG\"\u00043\u000f^3q\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011AiB\f'/Y7!)\u00022\u0016\r\\;fAQL\b/\u001a\u0011pM\u0002\"\b.\u001a\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c.Y7fA9\u000bW.\u001a\u0011g_J\u0004C\u000f[3!C\u000e\u001cW/\\;mCR|'O\u0003\u0011!A\u0001Rs&\u0006\u0003\u0002`\u0005-DCBA1\u0003[\ny\u0007F\u0002C\u0003GB\u0011\"!\u001a\b\u0003\u0003\u0005\u001d!a\u001a\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0004\u0002B\u0005-\u0013\u0011\u000e\t\u0004+\u0006-D!B,\b\u0005\u0004A\u0006\"\u0002$\b\u0001\u00049\u0005BB*\b\u0001\u0004\tI\u0007K\u0003\bUR\f\u0019(\t\u0002\u0002v\u0005\u0001tF\u000b\u0016!\u0007J,\u0017\r^3!C\u0002rWm\u001e\u0011bG\u000e,X.\u001e7bi>\u0014\b\u0005\u001e5bi\u0002\u001aX/\\:!m\u0006dW/Z:!U=*B!!\u001f\u0002\u0006R1\u00111PAD\u0003\u0013#2AQA?\u0011%\ty\bCA\u0001\u0002\b\t\t)\u0001\u0006fm&$WM\\2fIM\u0002b!!\u0011\u0002L\u0005\r\u0005cA+\u0002\u0006\u0012)q\u000b\u0003b\u00011\")a\t\u0003a\u0001\u000f\")\u0001\r\u0003a\u0001C\"*\u0001B\u001b;\u0002\u000e\u0006\u0012\u0011qR\u0001\u0004>=R#\u0006I\"sK\u0006$X\rI1!]\u0016<\bE_3s_6Jg.\u001b;jC2L7/\u001a3!C\u000e\u001cW/\\;mCR|'\u000f\t;iCR\u00043/^7tAY\fG.^3t\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011AiB\f'/Y7!)\u00022\u0016\r\\;fAQL\b/\u001a\u0011pM\u0002\"\b.\u001a\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c.Y7fA9\u000bW.\u001a\u0011g_J\u0004C\u000f[3!C\u000e\u001cW/\\;mCR|'O\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E]3uC&t7\u000b^1uK\u0002Je\r\t1ueV,\u0007\r\f\u0011bG\u000e,X.\u001e7bi&|g\u000e\t4pe\u0002\"\b.\u001a\u0011oKb$\be\u001d;fa>JG/\u001a:bi&|g\u000eI8gA\u0005t\u0007%\u00197h_JLG\u000f[7!G>tG/\u001b8vKN\u0004s/\u001b;iAQDWM\u0003\u0011!A\u0001R\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AA\u0014XM^5pkNd\u0017\u0010I2p[B,H/\u001a3!m\u0006dW/\u001a\u0017!_RDWM]<jg\u0016d\u0003\u0005\u001e5fAY\fG.^3!SN\u0004#/Z:fi\u0002\"x\u000e\t1j]&$\u0018.\u00197WC2,X\r\u0019\u0011cK\u001a|'/\u001a\u0011fC\u000eD\u0007e\u001d;fa:R\u0001\u0005\t\u0011!U=*B!a%\u0002 RA\u0011QSA_\u0003\u007f\u000b\t\rF\u0002C\u0003/C\u0011\"!'\n\u0003\u0003\u0005\u001d!a'\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007\u0005\u0004\u0002B\u0005-\u0013Q\u0014\t\u0004+\u0006}E!C,\nA\u0003\u0005\tQ1\u0001YQ!\ty*a)\u0002*\u0006M\u0006c\u0001\u001c\u0002&&\u0019\u0011qU\u001c\u0003\u0017M\u0004XmY5bY&TX\rZ\u0019\nG\u0005-\u0016QVAY\u0003_s1ANAW\u0013\r\tykN\u0001\u0005\u0019>tw-\r\u0004%\u0003\u0007\n)\u0005O\u0019\nG\u0005U\u0016qWA^\u0003ss1ANA\\\u0013\r\tIlN\u0001\u0007\t>,(\r\\32\r\u0011\n\u0019%!\u00129\u0011\u00151\u0015\u00021\u0001H\u0011\u0019\u0019\u0016\u00021\u0001\u0002\u001e\")\u0001-\u0003a\u0001C\"*\u0011B\u001b;\u0002F\u0006\u0012\u0011qY\u0001\u0004\f>R#\u0006I\"sK\u0006$X\rI1!]\u0016<\b%Y2dk6,H.\u0019;pe\u0002\"\b.\u0019;!gVl7\u000f\t<bYV,7O\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t\u001e9be\u0006l\u0007\u0005\u0016\u0011WC2,X\r\t;za\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013mY2v[Vd\u0017\r^8s\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!]\u0006lW\r\t(b[\u0016\u0004cm\u001c:!i\",\u0007%Y2dk6,H.\u0019;pe*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA%t\u0017\u000e^5bYZ\u000bG.^3!\u0013:LG/[1mAY\fG.^3!M>\u0014\b%Y2dk6,H.\u0019;pe*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAI,G/Y5o'R\fG/\u001a\u0011JM\u0002\u0002GO];fA2\u0002\u0013mY2v[Vd\u0017\r^5p]\u00022wN\u001d\u0011uQ\u0016\u0004c.\u001a=uAM$X\r]\u0018ji\u0016\u0014\u0018\r^5p]\u0002zg\rI1oA\u0005dwm\u001c:ji\"l\u0007eY8oi&tW/Z:!o&$\b\u000e\t;iK*\u0001\u0003\u0005\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t9sKZLw.^:ms\u0002\u001aw.\u001c9vi\u0016$\u0007E^1mk\u0016d\u0003e\u001c;iKJ<\u0018n]3-AQDW\r\t<bYV,\u0007%[:!e\u0016\u001cX\r\u001e\u0011u_\u0002\u0002\u0017N\\5uS\u0006dg+\u00197vK\u0002\u0004#-\u001a4pe\u0016\u0004S-Y2iAM$X\r\u001d\u0018\u000bA\u0001\u0002\u0003EK\u0018\u0002\u00179,w/\u00138u\u0003\u0012$WM\u001d\u000b\u0004\u0005\u00065\u0007BBAh\u0015\u0001\u0007q)A\u0002tiJ$rAQAj\u0003+\fy\u000e\u0003\u0004\u0002P.\u0001\ra\u0012\u0005\b\u0003/\\\u0001\u0019AAm\u0003-Ig.\u001b;bYZ\u000bG.^3\u0011\u0007Y\nY.C\u0002\u0002^^\u00121!\u00138u\u0011\u0015\u00017\u00021\u0001b\u00035qWm^'vYRL\u0007\u000f\\5feV!\u0011Q]Ay)\u0011\t9/a=\u0015\u0007\t\u000bI\u000fC\u0005\u0002l2\t\t\u0011q\u0001\u0002n\u0006QQM^5eK:\u001cW\rJ\u001b\u0011\r\u0005\u0005\u00131JAx!\r)\u0016\u0011\u001f\u0003\u0006/2\u0011\r\u0001\u0017\u0005\u0006\r2\u0001\ra\u0012\u0015\u0006\u0019)$\u0018q_\u0011\u0003\u0003s\f\u0011\u0011R\u0018+U\u0001\u001a%/Z1uK\u0002\n\u0007E\\3xA=tW-L5oSRL\u0017\r\\5tK\u0012\u0004\u0013mY2v[Vd\u0017\r^8sAQD\u0017\r\u001e\u0011nk2$\u0018\u000e\u001d7jKN\u0004c/\u00197vKN\u0004\u0013M\u001c3!e\u0016\u001cX\r^:!C\u001a$XM\u001d\u0011fC\u000eD\u0007e\u001d;fa*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001R\u0004\u0018M]1nAQ\u0003c+\u00197vK\u0002\"\u0018\u0010]3!_\u001a\u0004C\u000f[3!C\u000e\u001cW/\\;mCR|'O\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\\1nK\u0002r\u0015-\\3!M>\u0014\b\u0005\u001e5fA\u0005\u001c7-^7vY\u0006$xN\u001d\u0006!A\u0001\u0002#fL\u000b\u0005\u0003{\u0014I\u0001\u0006\u0004\u0002\u0000\n-!Q\u0002\u000b\u0004\u0005\n\u0005\u0001\"\u0003B\u0002\u001b\u0005\u0005\t9\u0001B\u0003\u0003))g/\u001b3f]\u000e,GE\u000e\t\u0007\u0003\u0003\nYEa\u0002\u0011\u0007U\u0013I\u0001B\u0003X\u001b\t\u0007\u0001\fC\u0003G\u001b\u0001\u0007q\t\u0003\u0004T\u001b\u0001\u0007!q\u0001\u0015\u0006\u001b)$(\u0011C\u0011\u0003\u0005'\t\u0011\u0011\\\u0018+U\u0001\u001a%/Z1uK\u0002\n\u0007E\\3xA\u0005\u001c7-^7vY\u0006$xN\u001d\u0011uQ\u0006$\b%\\;mi&\u0004H.[3tAY\fG.^3tA\u0005tG\r\t:fg\u0016$8\u000fI1gi\u0016\u0014\b%Z1dQ\u0002\u001aH/\u001a9\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!ua\u0006\u0014\u0018-\u001c\u0011UAY\u000bG.^3!if\u0004X\rI8gAQDW\rI1dGVlW\u000f\\1u_JT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002r\u0017-\\3!\u001d\u0006lW\r\t4pe\u0002\"\b.\u001a\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004\u0013N\\5uS\u0006dg+\u00197vK\u0002Je.\u001b;jC2\u0004c/\u00197vK\u00022wN\u001d\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)zS\u0003\u0002B\f\u0005G!bA!\u0007\u0003&\t\u001dBc\u0001\"\u0003\u001c!I!Q\u0004\b\u0002\u0002\u0003\u000f!qD\u0001\u000bKZLG-\u001a8dK\u0012:\u0004CBA!\u0003\u0017\u0012\t\u0003E\u0002V\u0005G!Qa\u0016\bC\u0002aCQA\u0012\bA\u0002\u001dCQ\u0001\u0019\bA\u0002\u0005DSA\u00046u\u0005W\t#A!\f\u0002\u0007\u000fz#F\u000b\u0011De\u0016\fG/\u001a\u0011bA9,w\u000fI8oK6Jg.\u001b;jC2L7/\u001a3!C\u000e\u001cW/\\;mCR|'\u000f\t;iCR\u0004S.\u001e7uSBd\u0017.Z:!m\u0006dW/Z:\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!ua\u0006\u0014\u0018-\u001c\u0011UAY\u000bG.^3!if\u0004X\rI8gAQDW\rI1dGVlW\u000f\\1u_JT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002r\u0017-\\3!\u001d\u0006lW\r\t4pe\u0002\"\b.\u001a\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004#/\u001a;bS:\u001cF/\u0019;fA%3\u0007\u0005\u0019;sk\u0016\u0004G\u0006I1dGVlW\u000f\\1uS>t\u0007EZ8sAQDW\r\t8fqR\u00043\u000f^3q_%$XM]1uS>t\u0007e\u001c4!C:\u0004\u0013\r\\4pe&$\b.\u001c\u0011d_:$\u0018N\\;fg\u0002:\u0018\u000e\u001e5!i\",'\u0002\t\u0011!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!aJ,g/[8vg2L\beY8naV$X\r\u001a\u0011wC2,X\r\f\u0011pi\",'o^5tK2\u0002C\u000f[3!m\u0006dW/\u001a\u0011jg\u0002\u0012Xm]3uAQ|\u0007\u0005Y5oSRL\u0017\r\u001c,bYV,\u0007\r\t2fM>\u0014X\rI3bG\"\u00043\u000f^3q])\u0001\u0003\u0005\t\u0011+_U!!\u0011\u0007B\u001f)!\u0011\u0019Da\u0010\u0003B\t\rCc\u0001\"\u00036!I!qG\b\u0002\u0002\u0003\u000f!\u0011H\u0001\u000bKZLG-\u001a8dK\u0012B\u0004CBA!\u0003\u0017\u0012Y\u0004E\u0002V\u0005{!QaV\bC\u0002aCQAR\bA\u0002\u001dCaaU\bA\u0002\tm\u0002\"\u00021\u0010\u0001\u0004\t\u0007&B\bki\n\u001d\u0013E\u0001B%\u0003\r]uF\u000b\u0016!\u0007J,\u0017\r^3!C\u0002rWm\u001e\u0011bG\u000e,X.\u001e7bi>\u0014\b\u0005\u001e5bi\u0002jW\u000f\u001c;ja2LWm\u001d\u0011wC2,Xm\u001d\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u0011;qCJ\fW\u000e\t+!-\u0006dW/\u001a\u0011usB,\u0007e\u001c4!i\",\u0007%Y2dk6,H.\u0019;pe*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA9\fW.\u001a\u0011OC6,\u0007EZ8sAQDW\rI1dGVlW\u000f\\1u_JT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002Jg.\u001b;jC24\u0016\r\\;fA%s\u0017\u000e^5bY\u00022\u0018\r\\;fA\u0019|'\u000fI1dGVlW\u000f\\1u_JT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u0012X\r^1j]N#\u0018\r^3!\u0013\u001a\u0004\u0003\r\u001e:vK\u0002d\u0003%Y2dk6,H.\u0019;j_:\u0004cm\u001c:!i\",\u0007E\\3yi\u0002\u001aH/\u001a90SR,'/\u0019;j_:\u0004sN\u001a\u0011b]\u0002\nGnZ8sSRDW\u000eI2p]RLg.^3tA]LG\u000f\u001b\u0011uQ\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011qe\u00164\u0018n\\;tYf\u00043m\\7qkR,G\r\t<bYV,G\u0006I8uQ\u0016\u0014x/[:fY\u0001\"\b.\u001a\u0011wC2,X\rI5tAI,7/\u001a;!i>\u0004\u0003-\u001b8ji&\fGNV1mk\u0016\u0004\u0007EY3g_J,\u0007%Z1dQ\u0002\u001aH/\u001a9/\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003\u0019qWm^'bqV!!q\nB.)\u0011\u0011\tF!\u001c\u0015\u000b\t\u0013\u0019F!\u0018\t\u0013\tU\u0003#!AA\u0004\t]\u0013AC3wS\u0012,gnY3%sA1\u0011\u0011IA&\u00053\u00022!\u0016B.\t\u00159\u0006C1\u0001Y\u0011%\u0011y\u0006EA\u0001\u0002\b\u0011\t'A\u0006fm&$WM\\2fIE\u0002\u0004C\u0002B2\u0005S\u0012I&\u0004\u0002\u0003f)\u0019!qM\u0018\u0002\u000bU$\u0018\u000e\\:\n\t\t-$Q\r\u0002\b\u0005>,h\u000eZ3e\u0011\u00151\u0005\u00031\u0001HQ\u0015\u0001\"\u000e\u001eB9C\t\u0011\u0019(AA<_)R\u0003e\u0011:fCR,\u0007%\u0019\u0011oK^\u0004\u0013mY2v[Vd\u0017\r^8sAQD\u0017\r\u001e\u0011ue\u0006\u001c7n\u001d\u0011uQ\u0016\u0004S.\u0019=j[Vl\u0007E^1mk\u0016\u0004\u0013M\u001c3!e\u0016\u001cX\r^:!C\u001a$XM\u001d\u0011fC\u000eD\u0007e\u001d;fa*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001R\u0004\u0018M]1nAQ\u0003c+\u00197vK\u0002\"\u0018\u0010]3!_\u001a\u0004C\u000f[3!C\u000e\u001cW/\\;mCR|'O\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\\1nK\u0002r\u0015-\\3!M>\u0014\b\u0005\u001e5fA\u0005\u001c7-^7vY\u0006$xN\u001d\u0006!A\u0001\u0002#fL\u000b\u0005\u0005o\u0012\u0019\t\u0006\u0004\u0003z\t-%Q\u0012\u000b\u0006\u0005\nm$Q\u0011\u0005\n\u0005{\n\u0012\u0011!a\u0002\u0005\u007f\n1\"\u001a<jI\u0016t7-\u001a\u00132cA1\u0011\u0011IA&\u0005\u0003\u00032!\u0016BB\t\u00159\u0016C1\u0001Y\u0011%\u00119)EA\u0001\u0002\b\u0011I)A\u0006fm&$WM\\2fIE\u0012\u0004C\u0002B2\u0005S\u0012\t\tC\u0003G#\u0001\u0007q\t\u0003\u0004T#\u0001\u0007!\u0011\u0011\u0015\u0006#)$(\u0011S\u0011\u0003\u0005'\u000b\u0011q]\u0018+U\u0001\u001a%/Z1uK\u0002\n\u0007E\\3xA\u0005\u001c7-^7vY\u0006$xN\u001d\u0011uQ\u0006$\b\u0005\u001e:bG.\u001c\b\u0005\u001e5fA5\f\u00070[7v[\u00022\u0018\r\\;fA\u0005tG\r\t:fg\u0016$8\u000fI1gi\u0016\u0014\b%Z1dQ\u0002\u001aH/\u001a9\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!ua\u0006\u0014\u0018-\u001c\u0011UAY\u000bG.^3!if\u0004X\rI8gAQDW\rI1dGVlW\u000f\\1u_JT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002r\u0017-\\3!\u001d\u0006lW\r\t4pe\u0002\"\b.\u001a\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004\u0013N\\5uS\u0006dg+\u00197vK\u0002Je.\u001b;jC2\u0004c/\u00197vK\u00022wN\u001d\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)zS\u0003\u0002BL\u0005G#bA!'\u0003,\n5F#\u0002\"\u0003\u001c\n\u0015\u0006\"\u0003BO%\u0005\u0005\t9\u0001BP\u0003-)g/\u001b3f]\u000e,G%M\u001a\u0011\r\u0005\u0005\u00131\nBQ!\r)&1\u0015\u0003\u0006/J\u0011\r\u0001\u0017\u0005\n\u0005O\u0013\u0012\u0011!a\u0002\u0005S\u000b1\"\u001a<jI\u0016t7-\u001a\u00132iA1!1\rB5\u0005CCQA\u0012\nA\u0002\u001dCQ\u0001\u0019\nA\u0002\u0005DSA\u00056u\u0005c\u000b#Aa-\u0002\u0007ky#F\u000b\u0011De\u0016\fG/\u001a\u0011bA9,w\u000fI1dGVlW\u000f\\1u_J\u0004C\u000f[1uAQ\u0014\u0018mY6tAQDW\rI7bq&lW/\u001c\u0011wC2,XM\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t\u001e9be\u0006l\u0007\u0005\u0016\u0011WC2,X\r\t;za\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013mY2v[Vd\u0017\r^8s\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!]\u0006lW\r\t(b[\u0016\u0004cm\u001c:!i\",\u0007%Y2dk6,H.\u0019;pe*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAI,G/Y5o'R\fG/\u001a\u0011JM\u0002\u0002GO];fA2\u0002\u0013mY2v[Vd\u0017\r^5p]\u00022wN\u001d\u0011uQ\u0016\u0004c.\u001a=uAM$X\r]\u0018ji\u0016\u0014\u0018\r^5p]\u0002zg\rI1oA\u0005dwm\u001c:ji\"l\u0007eY8oi&tW/Z:!o&$\b\u000e\t;iK*\u0001\u0003\u0005\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t9sKZLw.^:ms\u0002\u001aw.\u001c9vi\u0016$\u0007E^1mk\u0016d\u0003e\u001c;iKJ<\u0018n]3-AQDW\r\t<bYV,\u0007%[:!e\u0016\u001cX\r\u001e\u0011u_\u0002\u0002\u0017N\\5uS\u0006dg+\u00197vK\u0002\u0004#-\u001a4pe\u0016\u0004S-Y2iAM$X\r\u001d\u0018\u000bA\u0001\u0002\u0003EK\u0018\u0016\t\t]&1\u0019\u000b\t\u0005s\u0013YM!4\u0003PR)!Ia/\u0003F\"I!QX\n\u0002\u0002\u0003\u000f!qX\u0001\fKZLG-\u001a8dK\u0012\nT\u0007\u0005\u0004\u0002B\u0005-#\u0011\u0019\t\u0004+\n\rG!B,\u0014\u0005\u0004A\u0006\"\u0003Bd'\u0005\u0005\t9\u0001Be\u0003-)g/\u001b3f]\u000e,G%\r\u001c\u0011\r\t\r$\u0011\u000eBa\u0011\u001515\u00031\u0001H\u0011\u0019\u00196\u00031\u0001\u0003B\")\u0001m\u0005a\u0001C\"*1C\u001b;\u0003T\u0006\u0012!Q[\u0001\u0004&>R#\u0006I\"sK\u0006$X\rI1!]\u0016<\b%Y2dk6,H.\u0019;pe\u0002\"\b.\u0019;!iJ\f7m[:!i\",\u0007%\\1yS6,X\u000e\t<bYV,'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002E\u000f]1sC6\u0004C\u000b\t,bYV,\u0007\u0005^=qK\u0002zg\r\t;iK\u0002\n7mY;nk2\fGo\u001c:\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011oC6,\u0007ET1nK\u00022wN\u001d\u0011uQ\u0016\u0004\u0013mY2v[Vd\u0017\r^8s\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!S:LG/[1m-\u0006dW/\u001a\u0011J]&$\u0018.\u00197!m\u0006dW/\u001a\u0011g_J\u0004\u0013mY2v[Vd\u0017\r^8s\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!e\u0016$\u0018-\u001b8Ti\u0006$X\rI%gA\u0001$(/^3aY\u0001\n7mY;nk2\fG/[8oA\u0019|'\u000f\t;iK\u0002rW\r\u001f;!gR,\u0007oL5uKJ\fG/[8oA=4\u0007%\u00198!C2<wN]5uQ6\u00043m\u001c8uS:,Xm\u001d\u0011xSRD\u0007\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001d:fm&|Wo\u001d7zA\r|W\u000e];uK\u0012\u0004c/\u00197vK2\u0002s\u000e\u001e5fe^L7/\u001a\u0017!i\",\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011sKN,G\u000f\t;pA\u0001Lg.\u001b;jC24\u0016\r\\;fA\u0002\u0012WMZ8sK\u0002*\u0017m\u00195!gR,\u0007O\f\u0006!A\u0001\u0002#fL\u0001\u0007]\u0016<X*\u001b8\u0016\t\tm'q\u001d\u000b\u0005\u0005;\u0014y\u000fF\u0003C\u0005?\u0014I\u000fC\u0005\u0003bR\t\t\u0011q\u0001\u0003d\u0006YQM^5eK:\u001cW\rJ\u00198!\u0019\t\t%a\u0013\u0003fB\u0019QKa:\u0005\u000b]#\"\u0019\u0001-\t\u0013\t-H#!AA\u0004\t5\u0018aC3wS\u0012,gnY3%ca\u0002bAa\u0019\u0003j\t\u0015\b\"\u0002$\u0015\u0001\u00049\u0005&\u0002\u000bki\nM\u0018E\u0001B{\u0003\u0005]tF\u000b\u0016!\u0007J,\u0017\r^3!C\u0002rWm\u001e\u0011bG\u000e,X.\u001e7bi>\u0014\b\u0005\u001e5bi\u0002\"(/Y2lg\u0002\"\b.\u001a\u0011nS:LW.^7!m\u0006dW/\u001a\u0011b]\u0012\u0004#/Z:fiN\u0004\u0013M\u001a;fe\u0002*\u0017m\u00195!gR,\u0007O\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t\u001e9be\u0006l\u0007\u0005\u0016\u0011WC2,X\r\t;za\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013mY2v[Vd\u0017\r^8s\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!]\u0006lW\r\t(b[\u0016\u0004cm\u001c:!i\",\u0007%Y2dk6,H.\u0019;pe*\u0001\u0003\u0005\t\u0011+_U!!\u0011`B\u0003)\u0019\u0011Yp!\u0004\u0004\u0010Q)!I!@\u0004\b!I!q`\u000b\u0002\u0002\u0003\u000f1\u0011A\u0001\fKZLG-\u001a8dK\u0012\n\u0014\b\u0005\u0004\u0002B\u0005-31\u0001\t\u0004+\u000e\u0015A!B,\u0016\u0005\u0004A\u0006\"CB\u0005+\u0005\u0005\t9AB\u0006\u0003-)g/\u001b3f]\u000e,GE\r\u0019\u0011\r\t\r$\u0011NB\u0002\u0011\u00151U\u00031\u0001H\u0011\u0019\u0019V\u00031\u0001\u0004\u0004!*QC\u001b;\u0004\u0014\u0005\u00121QC\u0001\u0002h>R#\u0006I\"sK\u0006$X\rI1!]\u0016<\b%Y2dk6,H.\u0019;pe\u0002\"\b.\u0019;!iJ\f7m[:!i\",\u0007%\\5oS6,X\u000e\t<bYV,\u0007%\u00198eAI,7/\u001a;tA\u00054G/\u001a:!K\u0006\u001c\u0007\u000eI:uKBT\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001#\b/\u0019:b[\u0002\"\u0006EV1mk\u0016\u0004C/\u001f9fA=4\u0007\u0005\u001e5fA\u0005\u001c7-^7vY\u0006$xN\u001d\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t8b[\u0016\u0004c*Y7fA\u0019|'\u000f\t;iK\u0002\n7mY;nk2\fGo\u001c:\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011j]&$\u0018.\u00197WC2,X\rI%oSRL\u0017\r\u001c\u0011wC2,X\r\t4pe\u0002\n7mY;nk2\fGo\u001c:\u000bA\u0001\u0002\u0003EK\u0018\u0016\t\re1Q\u0005\u000b\u0007\u00077\u0019ica\f\u0015\u000b\t\u001biba\n\t\u0013\r}a#!AA\u0004\r\u0005\u0012aC3wS\u0012,gnY3%eE\u0002b!!\u0011\u0002L\r\r\u0002cA+\u0004&\u0011)qK\u0006b\u00011\"I1\u0011\u0006\f\u0002\u0002\u0003\u000f11F\u0001\fKZLG-\u001a8dK\u0012\u0012$\u0007\u0005\u0004\u0003d\t%41\u0005\u0005\u0006\rZ\u0001\ra\u0012\u0005\u0006AZ\u0001\r!\u0019\u0015\u0006-)$81G\u0011\u0003\u0007k\t1QG\u0018+U\u0001\u001a%/Z1uK\u0002\n\u0007E\\3xA\u0005\u001c7-^7vY\u0006$xN\u001d\u0011uQ\u0006$\b\u0005\u001e:bG.\u001c\b\u0005\u001e5fA5Lg.[7v[\u00022\u0018\r\\;f\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011AiB\f'/Y7!)\u00022\u0016\r\\;fAQL\b/\u001a\u0011pM\u0002\"\b.\u001a\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c.Y7fA9\u000bW.\u001a\u0011g_J\u0004C\u000f[3!C\u000e\u001cW/\\;mCR|'O\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E]3uC&t7\u000b^1uK\u0002Je\r\t1ueV,\u0007\r\f\u0011bG\u000e,X.\u001e7bi&|g\u000e\t4pe\u0002\"\b.\u001a\u0011oKb$\be\u001d;fa>JG/\u001a:bi&|g\u000eI8gA\u0005t\u0007%\u00197h_JLG\u000f[7!G>tG/\u001b8vKN\u0004s/\u001b;iAQDWM\u0003\u0011!A\u0001R\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AA\u0014XM^5pkNd\u0017\u0010I2p[B,H/\u001a3!m\u0006dW/\u001a\u0017!_RDWM]<jg\u0016d\u0003\u0005\u001e5fAY\fG.^3!SN\u0004#/Z:fi\u0002\"x\u000e\t1j]&$\u0018.\u00197WC2,X\r\u0019\u0011cK\u001a|'/\u001a\u0011fC\u000eD\u0007e\u001d;fa:R\u0001\u0005\t\u0011!U=*Ba!\u000f\u0004FQA11HB'\u0007\u001f\u001a\t\u0006F\u0003C\u0007{\u00199\u0005C\u0005\u0004@]\t\t\u0011q\u0001\u0004B\u0005YQM^5eK:\u001cW\r\n\u001a4!\u0019\t\t%a\u0013\u0004DA\u0019Qk!\u0012\u0005\u000b];\"\u0019\u0001-\t\u0013\r%s#!AA\u0004\r-\u0013aC3wS\u0012,gnY3%eQ\u0002bAa\u0019\u0003j\r\r\u0003\"\u0002$\u0018\u0001\u00049\u0005BB*\u0018\u0001\u0004\u0019\u0019\u0005C\u0003a/\u0001\u0007\u0011\rK\u0003\u0018UR\u001c)&\t\u0002\u0004X\u0005\u0019)k\f\u0016+A\r\u0013X-\u0019;fA\u0005\u0004c.Z<!C\u000e\u001cW/\\;mCR|'\u000f\t;iCR\u0004CO]1dWN\u0004C\u000f[3![&t\u0017.\\;nAY\fG.^3\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!ua\u0006\u0014\u0018-\u001c\u0011UAY\u000bG.^3!if\u0004X\rI8gAQDW\rI1dGVlW\u000f\\1u_JT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002r\u0017-\\3!\u001d\u0006lW\r\t4pe\u0002\"\b.\u001a\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004\u0013N\\5uS\u0006dg+\u00197vK\u0002Je.\u001b;jC2\u0004c/\u00197vK\u00022wN\u001d\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004#/\u001a;bS:\u001cF/\u0019;fA%3\u0007\u0005\u0019;sk\u0016\u0004G\u0006I1dGVlW\u000f\\1uS>t\u0007EZ8sAQDW\r\t8fqR\u00043\u000f^3q_%$XM]1uS>t\u0007e\u001c4!C:\u0004\u0013\r\\4pe&$\b.\u001c\u0011d_:$\u0018N\\;fg\u0002:\u0018\u000e\u001e5!i\",'\u0002\t\u0011!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!aJ,g/[8vg2L\beY8naV$X\r\u001a\u0011wC2,X\r\f\u0011pi\",'o^5tK2\u0002C\u000f[3!m\u0006dW/\u001a\u0011jg\u0002\u0012Xm]3uAQ|\u0007\u0005Y5oSRL\u0017\r\u001c,bYV,\u0007\r\t2fM>\u0014X\rI3bG\"\u00043\u000f^3q])\u0001\u0003\u0005\t\u0011+_\u0005aa.Z<ISN$xn\u001a:b[V!1QLB5)1\u0019yfa\u001b\u0004n\rE4QOB=)\r\u00115\u0011\r\u0005\n\u0007GB\u0012\u0011!a\u0002\u0007K\n1\"\u001a<jI\u0016t7-\u001a\u00133kA1\u0011\u0011IA&\u0007O\u00022!VB5\t\u00159\u0006D1\u0001Y\u0011\u00151\u0005\u00041\u0001H\u0011\u001d\u0019y\u0007\u0007a\u0001\u00033\faA\\8CS:\u001c\bbBB:1\u0001\u00071qM\u0001\t[&tg+\u00197vK\"91q\u000f\rA\u0002\r\u001d\u0014\u0001C7bqZ\u000bG.^3\t\u000f\u0001D\u0002\u0013!a\u0001C\"*\u0001D\u001b;\u0004~\u0005\u00121qP\u0001\u0005\u0010>R#\u0006I\"sK\u0006$X\rI1!]\u0016<\b\u0005[5ti><'/Y7!i\"\fG\u000f\t;sC\u000e\\7\u000f\t;iK\u0002\"\u0017n\u001d;sS\n,H/[8oA=4\u0007%\u0019\u0011he\u0006\u0004\b\u000eI9vC:$\u0018\u000e^=\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t8b[\u0016\u0004c*Y7fA\u0019|'\u000f\t;iK\u0002B\u0017n\u001d;pOJ\fWN\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\\8CS:\u001c\bET;nE\u0016\u0014\be\u001c4!Q&\u001cHo\\4sC6\u0004#-\u001b8t\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7![&tg+\u00197vK\u0002j\u0015N\\5nk6\u0004C-\u0019;bAY\fG.^3!M>\u0014\b\u0005Z5tiJL'-\u001e;j_:T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002j\u0017\r\u001f,bYV,\u0007%T1yS6,X\u000e\t3bi\u0006\u0004c/\u00197vK\u0002\"\u0017n\u001d;sS\n,H/[8o\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!e\u0016$\u0018-\u001b8Ti\u0006$X\rI%gA\u0001$(/^3aY\u0001\n7mY;nk2\fG/[8oA\u0019|'\u000f\t;iK\u0002rW\r\u001f;!gR,\u0007oL5uKJ\fG/[8oA=4\u0007%\u00198!C2<wN]5uQ6\u00043m\u001c8uS:,Xm\u001d\u0011xSRD\u0007\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001d:fm&|Wo\u001d7zA\r|W\u000e];uK\u0012\u0004c/\u00197vK2\u0002s\u000e\u001e5fe^L7/\u001a\u0017!i\",\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011sKN,G\u000f\t;pA\u0001Lg.\u001b;jC24\u0016\r\\;fA\u0002\u0012WMZ8sK\u0002*\u0017m\u00195!gR,\u0007O\f\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u0011;qCJ\fW\u000e\t+!)f\u0004X\rI8gA!L7\u000f^8he\u0006l\u0007E^1mk\u0016\u001c(\u0002\t\u0011!A)z\u0013A\u00038fo\u000e{WO\u001c;feV!1QQBF)\u0015\u00115qQBE\u0011\u00151\u0015\u00041\u0001H\u0011\u001d\u0001\u0017\u0004%AA\u0002\u0005$QaV\rC\u0002aCS!\u00076u\u0007\u001f\u000b#a!%\u0002\u0007+z#F\u000b\u0011De\u0016\fG/\u001a\u0011bA9,w\u000fI2pk:$XM\u001d\u0011uQ\u0006$\b\u0005\u001e:bG.\u001c\b\u0005\u001e5fA\r|WO\u001c;tA=4\u0007%\u0019\u0011dCR,wm\u001c:jG\u0006d\u0007e\u001a:ba\"\u0004\u0013/^1oi&$\u0018P\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c.Y7fA9\u000bW.\u001a\u0011g_J\u0004C\u000f[3!G>,h\u000e^3s\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!e\u0016$\u0018-\u001b8Ti\u0006$X\rI%gA\u0001$(/^3aY\u0001\n7mY;nk2\fG/[8oA\u0019|'\u000f\t;iK\u0002rW\r\u001f;!gR,\u0007oL5uKJ\fG/[8oA=4\u0007%\u00198!C2<wN]5uQ6\u00043m\u001c8uS:,Xm\u001d\u0011xSRD\u0007\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001d:fm&|Wo\u001d7zA\r|W\u000e];uK\u0012\u0004c/\u00197vK2\u0002s\u000e\u001e5fe^L7/\u001a\u0017!i\",\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011sKN,G\u000f\t;pA\u0001Lg.\u001b;jC24\u0016\r\\;fA\u0002\u0012WMZ8sK\u0002*\u0017m\u00195!gR,\u0007O\f\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u0011;qCJ\fW\u000e\t+!)f\u0004X\rI8gA\r|WO\u001c;fI\u00022\u0018\r\\;fg*\u0001\u0003\u0005\t\u0011+_\u00051a.Z<BY2$RAQBL\u00073CQA\u0012\u000eA\u0002\u001dCq\u0001\u0019\u000e\u0011\u0002\u0003\u0007\u0011\rK\u0003\u001bUR\u001ci*\t\u0002\u0004 \u0006\u00199e\f\u0016+A\r\u0013X-\u0019;fA9,w\u000f\t\"p_2,\u0017M\u001c\u0011bG\u000e,X.\u001e7bi>\u0014\b\u0005\u001e5bi\u0002\u0012X\r^;s]N\u0004\u0003\r\u001e:vK\u0002\u0004\u0013N\u001a\u0011bY2\u0004\u0013mY2v[Vd\u0017\r^3eAY\fG.^3tA\u0005\u0014X\r\t1ueV,\u0007\rI1oI\u0002\u0002g-\u00197tK\u0002\u0004s\u000e\u001e5fe^L7/\u001a\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\\1nK\u0002r\u0015-\\3!M>\u0014\b\u0005\u001e5fA\u0005\u001c7-^7vY\u0006$xN\u001d\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t:fi\u0006Lgn\u0015;bi\u0016\u0004\u0013J\u001a\u0011aiJ,X\r\u0019\u0017!C\u000e\u001cW/\\;mCRLwN\u001c\u0011g_J\u0004C\u000f[3!]\u0016DH\u000fI:uKB|\u0013\u000e^3sCRLwN\u001c\u0011pM\u0002\ng\u000eI1mO>\u0014\u0018\u000e\u001e5nA\r|g\u000e^5ok\u0016\u001c\be^5uQ\u0002\"\b.\u001a\u0006!A\u0001\u0002#\u0006\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002(/\u001a<j_V\u001cH.\u001f\u0011d_6\u0004X\u000f^3eAY\fG.^3-A=$\b.\u001a:xSN,G\u0006\t;iK\u00022\u0018\r\\;fA%\u001c\bE]3tKR\u0004Co\u001c\u0011aS:LG/[1m-\u0006dW/\u001a1!E\u00164wN]3!K\u0006\u001c\u0007\u000eI:uKBt#\u0002\t\u0011!A)z\u0013A\u00028fo\u0006s\u0017\u0010F\u0003C\u0007K\u001b9\u000bC\u0003G7\u0001\u0007q\tC\u0004a7A\u0005\t\u0019A1)\u000bmQGoa+\"\u0005\r5\u0016aa\u00110U)\u00023I]3bi\u0016\u0004c.Z<!\u0005>|G.Z1oA\u0005\u001c7-^7vY\u0006$xN\u001d\u0011uQ\u0006$\bE]3ukJt7\u000f\t1ueV,\u0007\rI5gA\u0005t\u0017\u0010I1dGVlW\u000f\\1uK\u0012\u0004c/\u00197vK\u0002J7\u000f\t1ueV,\u0007\rI1oI\u0002\u0002g-\u00197tK\u0002\u0004s\u000e\u001e5fe^L7/\u001a\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\\1nK\u0002r\u0015-\\3!M>\u0014\b\u0005\u001e5fA\u0005\u001c7-^7vY\u0006$xN\u001d\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t:fi\u0006Lgn\u0015;bi\u0016\u0004\u0013J\u001a\u0011aiJ,X\r\u0019\u0017!C\u000e\u001cW/\\;mCRLwN\u001c\u0011g_J\u0004C\u000f[3!]\u0016DH\u000fI:uKB|\u0013\u000e^3sCRLwN\u001c\u0011pM\u0002\ng\u000eI1mO>\u0014\u0018\u000e\u001e5nA\r|g\u000e^5ok\u0016\u001c\be^5uQ\u0002\"\b.\u001a\u0006!A\u0001\u0002#\u0006\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002(/\u001a<j_V\u001cH.\u001f\u0011d_6\u0004X\u000f^3eAY\fG.^3-A=$\b.\u001a:xSN,G\u0006\t;iK\u00022\u0018\r\\;fA%\u001c\bE]3tKR\u0004Co\u001c\u0011aS:LG/[1m-\u0006dW/\u001a1!E\u00164wN]3!K\u0006\u001c\u0007\u000eI:uKBt#\u0002\t\u0011!A)z\u0013!\u00038pI\u0016\u001cu.\u001e8u+\t\tI\u000eK\u0003\u001dUR\u001c),\t\u0002\u00048\u0006YsF\u000b\u0016!\u000f\u0016$\b\u0005\u001e5fA9,XNY3sA=4\u0007E\\8eKN\u0004\u0013N\u001c\u0011uQ\u0016\u0004sM]1qQ\u0002Rs&A\u0003baBd\u00170\u0006\u0004\u0004>\u000e\u001d7Q\u001a\u000b\u0005\u0007\u007f\u001by\rE\u0004?\u0007\u0003\u001c)ma3\n\u0007\r\r\u0017FA\u0006BG\u000e,X.\u001e7bi>\u0014\bcA+\u0004H\u001211\u0011Z\u000fC\u0002a\u0013\u0011a\u0015\t\u0004+\u000e5G!B,\u001e\u0005\u0004A\u0006\"\u0002$\u001e\u0001\u00049\u0005&B\u000fki\u000eM\u0017EABk\u0003\t\u001dtF\u000b\u0016!%\u0016$(/[3wK\u0002\n7mY;nk2\fGo\u001c:\u000bA\u0001\u0002\u0003E\u000b\u0011AiB\f'/Y7!'\u0002Je\u000e];uAQL\b/\u001a\u0011pM\u0002\"\b.\u001a\u0011bG\u000e,X.\u001e7bi>\u0014(\u0002\t\u0011!A)\u0002\u0003\t\u001e9be\u0006l\u0007\u0005\u0016\u0011WC2,X\r\t;za\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013mY2v[Vd\u0017\r^8s\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011oC6,\u0007ET1nK\u00022wN\u001d\u0011uQ\u0016\u0004\u0013mY2v[Vd\u0017\r^8s\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Ai\"\u0014xn^:!\u001d>\u001cVo\u00195FY\u0016lWM\u001c;Fq\u000e,\u0007\u000f^5p]\u0002Jg\rI1dGVlW\u000f\\1u_J\u0004s/\u001b;iA\u0001t\u0017-\\3aA\u0011|Wm\u001d\u0011o_R\u0004S\r_5ti*\u0001\u0003\u0005\t\u0011+A\u0001\u0013X\r^;s]\u0002\"\u0006.\u001a\u0011bG\u000e,X.\u001e7bi>\u0014\be\u001d;pe\u0016$\u0007%\u001e8eKJ\u0004\u0003M\\1nK\u0002T\u0001\u0005\t\u0011!U=\n1aZ3u+\u0019\u0019Yna:\u0004lR!1Q\\Bw!\u001514q\\Br\u0013\r\u0019\to\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fy\u001a\tm!:\u0004jB\u0019Qka:\u0005\r\r%gD1\u0001Y!\r)61\u001e\u0003\u0006/z\u0011\r\u0001\u0017\u0005\u0006\rz\u0001\ra\u0012\u0015\u0006=)$8\u0011_\u0011\u0003\u0007g\f!1B\u0018+U\u0001\u001a\u0016MZ3ms\u0002\u0012X\r\u001e:jKZ,\u0007%Y2dk6,H.\u0019;pe*\u0001\u0003\u0005\t\u0011+A\u0001#\b/\u0019:b[\u0002\u001a\u0006%\u00138qkR\u0004C/\u001f9fA=4\u0007\u0005\u001e5fA\u0005\u001c7-^7vY\u0006$xN\u001d\u0006!A\u0001\u0002#\u0006\t!ua\u0006\u0014\u0018-\u001c\u0011UAY\u000bG.^3!if\u0004X\rI8gAQDW\rI1dGVlW\u000f\\1u_JT\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA9\fW.\u001a\u0011OC6,\u0007EZ8sAQDW\rI1dGVlW\u000f\\1u_JT\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0013X\r^;s]\u0002\"\u0006.\u001a\u0011bG\u000e,X.\u001e7bi>\u0014\be\u001d;pe\u0016$\u0007%\u001e8eKJ\u0004\u0003M\\1nK\u0002\u0004\u0013N\u001a\u0011ji\u0002*\u00070[:ug2\u0002S\r\\:fA\u0001tuN\\3a\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003!\u0019wN\u001c;bS:\u001cHcA1\u0004z\")ai\ba\u0001\u000f\"*qD\u001b;\u0004~\u0006\u00121q`\u0001\u00028=R#\u0006I\"iK\u000e\\\u0007%\u001b4!C\u000e\u001cW/\\;mCR|'\u000fI3ySN$8O\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c.Y7fA9\u000bW.\u001a\u0011g_J\u0004C\u000f[3!C\u000e\u001cW/\\;mCR|'O\u0003\u0011!A\u0001R\u0003\u0005\u0011:fiV\u0014h\u000e\t1ueV,\u0007\rI5gA\u0005\u001c7-^7vY\u0006$xN\u001d\u0011xSRD\u0007\u0005\u00198b[\u0016\u0004\u0007%\u001a=jgR\u001c\b%\u001a7tK\u0002\u0002g-\u00197tK\u0002T\u0001\u0005\t\u0011!U=\n\u0001D\\3x\u0003\u000e\u001cW/\\;mCR|'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\t9\u0001\"\u0002\u0005\u000b]\u0003#\u0019\u0001-\u0002-9,w\u000fS5ti><'/Y7%I\u00164\u0017-\u001e7uIU*B!a\u0002\u0005\f\u0011)q+\tb\u00011\u0006!b.Z<D_VtG/\u001a:%I\u00164\u0017-\u001e7uII*B!a\u0002\u0005\u0012\u0011)qK\tb\u00011\u0006\u0001b.Z<BY2$C-\u001a4bk2$HEM\u0001\u0011]\u0016<\u0018I\\=%I\u00164\u0017-\u001e7uIIBS\u0001\u00016u\t3\t#\u0001b\u0007\u0002\u000f\u001f{#F\u000b\u0006!A)\u0002\u0003+\u001e2mS\u000e\u0004\u0013N\u001c;fe\u001a\f7-\u001a\u0011g_J\u0004s\r\\8cC2\u0004\u0013mY2v[Vd\u0017\r^8sg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005\u00165fA\u001d\u0013\u0018\r\u001d5Ti\u0006$X\r\t;sC\u000e\\7\u000fI4m_\n\fG\u000e\t\u0015he\u0006\u0004\b.\f7fm\u0016d\u0017\u0006\t<be&\f'\r\\3tA\u0011,(/\u001b8hA\u0005dwm\u001c:ji\"l\u0007%\u001a=fGV$\u0018n\u001c8/\u0015\u0001\u0002#\u0006\t\u0011He\u0006\u0004\b.\f7fm\u0016d\u0007e\u001d;bi\u0016\u0004C/Y6fg\u0002\"\b.\u001a\u0011g_Jl\u0007e\u001c4!C\u000e\u001cW/\\;mCR|'o\u001d\u0011xQ&\u001c\u0007\u000eI3ya>\u001cX\r\t;iK\u00022\u0018\r\\;fA\r|W\u000e];uK\u0012\u0004C-\u001e:j]\u001e\u0004C\u000f[3!Y\u0006\u001cH\u000fI:uKB|\u0013\u000e^3sCRLwN\u001c\u0006!A)\u0002\u0003%\u00198eA\u0005dGn\\<!C\u000e\u001cW/\\;mCRLwN\u001c\u0011pM\u0002rWm\u001e\u0011ti\u0006$X\r\t2bg\u0016$\u0007e\u001c8!C\u0002\u0012X\rZ;di&|g\u000e\t4v]\u000e$\u0018n\u001c8/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00025/Z3!7n\u001bw.\u001c\u0018sCBDGo\u001c:z]\u0005\u0004\u0018NL1oC2L8/[:/OJ\f\u0007\u000f\u001b<jK^tsI]1qQB+'o\u001d9fGRLg/\u001a\u0011He\u0006\u0004\b\u000eU3sgB,7\r^5wKvkF\u0006I.\\\u0003\u000e\u001cW/\\;mCR|'/X/\u000bA\u0001R#\u0002\t\u0011+A\u0001#WMZ5oK\u0002\u0012X\r^1j]N#\u0018\r^3!\u0001B\f'/Y7!e\u0016$\u0018-\u001b8Ti\u0006$X\rI%gA\u0001$(/^3aY\u0001\n7mY;nk2\fG/[8oA\u0019|'\u000f\t;iK\u0002rW\r\u001f;!gR,\u0007oL5uKJ\fG/[8oA=4\u0007%\u00198!C2<wN]5uQ6\u00043m\u001c8uS:,Xm\u001d\u0011xSRD\u0007\u0005\u001e5f\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002(/\u001a<j_V\u001cH.\u001f\u0011d_6\u0004X\u000f^3eAY\fG.^3-A=$\b.\u001a:xSN,G\u0006\t;iK\u00022\u0018\r\\;fA%\u001c\bE]3tKR\u0004Co\u001c\u0011aS:LG/[1m-\u0006dW/\u001a1!E\u00164wN]3!K\u0006\u001c\u0007\u000eI:uKBt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t!eK\u001aLg.\u001a\u0011oC6,\u0007\u0005\u00119be\u0006l\u0007E\\1nK\u0002r\u0015-\\3!M>\u0014\b\u0005\u001e5fA\u0005\u001c7-^7vY\u0006$xN\u001d\u0006!A)R\u0001\u0005\t\u0016!\u0001\u0012,g-\u001b8fA%t\u0017\u000e^5bYZ\u000bG.^3!\u0001B\f'/Y7!S:LG/[1m-\u0006dW/\u001a\u0011J]&$\u0018.\u00197!m\u0006dW/\u001a\u0011g_J\u0004\u0013mY2v[Vd\u0017\r^8s\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002E-\u001a4j]\u0016\u0004c\u000fV=qK\u0002\u0002E\u000f]1sC6\u0004C\u000b\t,bYV,\u0007\u0005^=qK\u0002zg\r\t;iK\u0002\n7mY;nk2\fGo\u001c:\u000bA\u0001R#\u0002\t\u0011+A\u0001#WMZ5oK\u0002JG+\u001f9fA\u0001#\b/\u0019:b[\u0002\u001a\u0006%\u00138qkR\u0004C/\u001f9fA=4\u0007\u0005\u001e5fA\u0005\u001c7-^7vY\u0006$xN\u001d\u0006!A)z\u0013AC$sCBD7\u000b^1uKB\u0011aHJ\n\u0005MU\"\u0019\u0003E\u0003\u0005&\u0011MR(\u0004\u0002\u0005()!A\u0011\u0006C\u0016\u00031\tX/\u001a:z[\u0006t\u0017mZ3s\u0015\u0011!i\u0003b\f\u0002\u0015\r|W\u000e]8oK:$8OC\u0002\u00052=\n\u0011\"\u001b8uKJt\u0017\r\\:\n\t\u0011UBq\u0005\u0002\u000b!J|Go\u001c$jK2$GC\u0001C\u0010\u0001")
public abstract class GraphState {
    public static TypeMapper<ByteString, GraphState> tmf() {
        return GraphState$.MODULE$.tmf();
    }

    @Scaladoc(value="/**  Create a new general Accumulator\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param initialValue Initial value for accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    *\n    * @param op Reduction function for the accumulator.\n    */")
    public abstract <T> void newAccumulator(String var1, T var2, boolean var3, Function2<T, T, T> var4);

    public <T> boolean newAccumulator$default$3() {
        return false;
    }

    public abstract <T> void newConcurrentAccumulator(String var1, T var2, boolean var3, Function2<T, T, T> var4);

    public <T> boolean newConcurrentAccumulator$default$3() {
        return false;
    }

    @Scaladoc(value="/** Create a new constant that stores an immutable value\n    *\n    * @tparam T Value type of the constant\n    * @param name Name for the accumulator\n    * @param value Value of the constant\n    */")
    public abstract <T> void newConstant(String var1, T var2);

    @Scaladoc(value="/** Create a new zero-initialised accumulator that sums values and resets after each step\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    */")
    public <T> void newAdder(String name, Numeric<T> evidence$1) {
        this.newAdder(name, ExtendedNumeric$.MODULE$.numericFromInt(0, evidence$1), false, evidence$1);
    }

    @Scaladoc(value="/** Create a new accumulator that sums values */")
    public <T> void newAdder(String name, T initialValue, Numeric<T> evidence$2) {
        this.newAdder(name, initialValue, false, evidence$2);
    }

    @Scaladoc(value="/** Create a new zero-initialised accumulator that sums values\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public <T> void newAdder(String name, boolean retainState, Numeric<T> evidence$3) {
        this.newAdder(name, ExtendedNumeric$.MODULE$.numericFromInt(0, evidence$3), retainState, evidence$3);
    }

    @Scaladoc(value="/** Create a new accumulator that sums values\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param initialValue Initial value for accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public abstract <T> void newAdder(String var1, T var2, boolean var3, Numeric<T> var4);

    public void newIntAdder(String str) {
        this.newIntAdder(str, 0, false);
    }

    public abstract void newIntAdder(String var1, int var2, boolean var3);

    @Scaladoc(value="/** Create a new one-initialised accumulator that multiplies values and resets after each step\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    */")
    public <T> void newMultiplier(String name, Numeric<T> evidence$5) {
        this.newMultiplier(name, ExtendedNumeric$.MODULE$.numericFromInt(1, evidence$5), false, evidence$5);
    }

    @Scaladoc(value="/** Create a new accumulator that multiplies values and resets after each step\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param initialValue Initial value for accumulator\n    */")
    public <T> void newMultiplier(String name, T initialValue, Numeric<T> evidence$6) {
        this.newMultiplier(name, initialValue, false, evidence$6);
    }

    @Scaladoc(value="/** Create a new one-initialised accumulator that multiplies values\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public <T> void newMultiplier(String name, boolean retainState, Numeric<T> evidence$7) {
        this.newMultiplier(name, ExtendedNumeric$.MODULE$.numericFromInt(1, evidence$7), retainState, evidence$7);
    }

    @Scaladoc(value="/** Create a new accumulator that multiplies values\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param initialValue Initial value for accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public abstract <T> void newMultiplier(String var1, T var2, boolean var3, Numeric<T> var4);

    @Scaladoc(value="/** Create a new accumulator that tracks the maximum value and resets after each step\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    */")
    public <T> void newMax(String name, Numeric<T> evidence$9, Bounded<T> evidence$10) {
        this.newMax(name, Bounded$.MODULE$.MIN(evidence$10), false, evidence$9, evidence$10);
    }

    @Scaladoc(value="/** Create a new accumulator that tracks the maximum value and resets after each step\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param initialValue Initial value for accumulator\n    */")
    public <T> void newMax(String name, T initialValue, Numeric<T> evidence$11, Bounded<T> evidence$12) {
        this.newMax(name, initialValue, false, evidence$11, evidence$12);
    }

    @Scaladoc(value="/** Create a new accumulator that tracks the maximum value\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public <T> void newMax(String name, boolean retainState, Numeric<T> evidence$13, Bounded<T> evidence$14) {
        this.newMax(name, Bounded$.MODULE$.MIN(evidence$14), retainState, evidence$13, evidence$14);
    }

    @Scaladoc(value="/** Create a new accumulator that tracks the maximum value\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param initialValue Initial value for accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public abstract <T> void newMax(String var1, T var2, boolean var3, Numeric<T> var4, Bounded<T> var5);

    @Scaladoc(value="/** Create a new accumulator that tracks the minimum value and resets after each step\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    */")
    public <T> void newMin(String name, Numeric<T> evidence$17, Bounded<T> evidence$18) {
        this.newMin(name, Bounded$.MODULE$.MAX(evidence$18), false, evidence$17, evidence$18);
    }

    @Scaladoc(value="/** Create a new accumulator that tracks the minimum value and resets after each step\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param initialValue Initial value for accumulator\n    */")
    public <T> void newMin(String name, T initialValue, Numeric<T> evidence$19, Bounded<T> evidence$20) {
        this.newMin(name, initialValue, false, evidence$19, evidence$20);
    }

    @Scaladoc(value="/** Create a new accumulator that tracks the minimum value\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public <T> void newMin(String name, boolean retainState, Numeric<T> evidence$21, Bounded<T> evidence$22) {
        this.newMin(name, Bounded$.MODULE$.MAX(evidence$22), retainState, evidence$21, evidence$22);
    }

    @Scaladoc(value="/** Create a new accumulator that tracks the minimum value\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param initialValue Initial value for accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public abstract <T> void newMin(String var1, T var2, boolean var3, Numeric<T> var4, Bounded<T> var5);

    @Scaladoc(value="/** Create a new histogram that tracks the distribution of a graph quantity\n    *\n    * @param name Name for the histogram\n    * @param noBins Number of histogram bins\n    * @param minValue Minimum data value for distribution\n    * @param maxValue Maximum data value distribution\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    *\n    * @tparam T Type of histogram values\n    */")
    public abstract <T> void newHistogram(String var1, int var2, T var3, T var4, boolean var5, Numeric<T> var6);

    public <T> boolean newHistogram$default$5() {
        return true;
    }

    @Scaladoc(value="/** Create a new counter that tracks the counts of a categorical graph quantity\n    *\n    * @param name Name for the counter\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    *\n    * @tparam T Type of counted values\n    */")
    public abstract <T> void newCounter(String var1, boolean var2);

    public <T> boolean newCounter$default$2() {
        return true;
    }

    @Scaladoc(value="/** Create new Boolean accumulator that returns `true` if all accumulated values are `true` and `false` otherwise\n    *\n    * @param name Name for the accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public abstract void newAll(String var1, boolean var2);

    public boolean newAll$default$2() {
        return false;
    }

    @Scaladoc(value="/** Create new Boolean accumulator that returns `true` if any accumulated value is `true` and `false` otherwise\n    *\n    * @param name Name for the accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public abstract void newAny(String var1, boolean var2);

    public boolean newAny$default$2() {
        return false;
    }

    @Scaladoc(value="/** Get the number of nodes in the graph */")
    public abstract int nodeCount();

    @Scaladoc(value="/** Retrieve accumulator\n    * @tparam S Input type of the accumulator\n    * @tparam T Value type of the accumulator\n    *\n    * @param name Name for the accumulator\n    *\n    * @throws NoSuchElementException if accumulator with `name` does not exist\n    * @return The accumulator stored under `name`\n    */")
    public abstract <S, T> Accumulator<S, T> apply(String var1);

    @Scaladoc(value="/** Safely retrieve accumulator\n    * @tparam S Input type of the accumulator\n    * @tparam T Value type of the accumulator\n    *\n    * @param name Name for the accumulator\n    *\n    * @return The accumulator stored under `name` if it exists, else `None`\n    */")
    public abstract <S, T> Option<Accumulator<S, T>> get(String var1);

    @Scaladoc(value="/** Check if accumulator exists\n    *\n    * @param name Name for the accumulator\n    * @return `true` if accumulator with `name` exists else `false`\n    */")
    public abstract boolean contains(String var1);

    @Scaladoc(value="/** Create a new accumulator that sums values\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param initialValue Initial value for accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public void newAdder$mDc$sp(String name, double initialValue, boolean retainState, Numeric<Object> evidence$4) {
        throw new RuntimeException("Fatal error in code generation: this should never be called.");
    }

    @Scaladoc(value="/** Create a new accumulator that sums values\n    *\n    * @tparam T Value type of the accumulator\n    * @param name Name for the accumulator\n    * @param initialValue Initial value for accumulator\n    * @param retainState If `true`, accumulation for the next step/iteration of an algorithm continues with the\n    *                                        previously computed value, otherwise, the value is reset to `initialValue` before each step.\n    */")
    public void newAdder$mJc$sp(String name, long initialValue, boolean retainState, Numeric<Object> evidence$4) {
        throw new RuntimeException("Fatal error in code generation: this should never be called.");
    }
}

