/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.graphstate;

import com.github.takezoe.scaladoc.Scaladoc;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.MapView;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * Public interface for the Counter API within [[GraphState]].\n  *\n  *  A Counter maintains the distribution of categorical groupings such as community, connected component or node type.\n  *  This enables measures such as the size/relative size of the largest group or largest k groups, filtering to include\n  *  only the largest/largest k groups etc.\n  *\n  *  @tparam T Value type of the category being grouped (usually long if referring to a group or component id)\n  *\n  * @see\n  * [[GraphState]], [[Histogram]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u00114QAB\u0004\u0002\u0002IAQA\u0007\u0001\u0005\u0002mAQ!\u000b\u0001\u0007\u0002)BQ\u0001\u0010\u0001\u0007\u0002uBQa\u0012\u0001\u0007\u0002!CQa\u0012\u0001\u0007\u0002=\u0013qaQ8v]R,'O\u0003\u0002\t\u0013\u0005QqM]1qQN$\u0018\r^3\u000b\u0005)Y\u0011\u0001C1oC2L8/[:\u000b\u00051i\u0011aA1qS*\u0011abD\u0001\te\u0006\u0004\b\u000e^8ss*\t\u0001#A\u0002d_6\u001c\u0001!\u0006\u0002\u0014AM\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0002cA\u000f\u0001=5\tq\u0001\u0005\u0002 A1\u0001A!B\u0011\u0001\u0005\u0004\u0011#!\u0001+\u0012\u0005\r2\u0003CA\u000b%\u0013\t)cCA\u0004O_RD\u0017N\\4\u0011\u0005U9\u0013B\u0001\u0015\u0017\u0005\r\te._\u0001\u000bi>$\u0018\r\\\"pk:$X#A\u0016\u0011\u0005Ua\u0013BA\u0017\u0017\u0005\rIe\u000e\u001e\u0015\u0005\u0005=J$\b\u0005\u00021o5\t\u0011G\u0003\u00023g\u0005A1oY1mC\u0012|7M\u0003\u00025k\u00059A/Y6fu>,'B\u0001\u001c\u0010\u0003\u00199\u0017\u000e\u001e5vE&\u0011\u0001(\r\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\n1(\u0001\u000e0U)\u0002Ck\u001c;bY\u0002zg\r\t;iK\u0002\u001aw.\u001e8ug\u0002Rs&A\u0005hKR\u001cu.\u001e8ugV\ta\b\u0005\u0003@\u0005zYS\"\u0001!\u000b\u0005\u00053\u0012AC2pY2,7\r^5p]&\u00111\t\u0011\u0002\b\u001b\u0006\u0004h+[3xQ\u0011\u0019q&O#\"\u0003\u0019\u000bAf\f\u0016+A\u001d+G\u000f^3sA\u0019,hn\u0019;j_:\u0004cm\u001c:!i\",\u0007%\\1qA=4\u0007eY8v]R\u001c\bEK\u0018\u0002\u000f1\f'oZ3tiV\t\u0011\n\u0005\u0003\u0016\u0015zY\u0013BA&\u0017\u0005\u0019!V\u000f\u001d7fe!\"AaL\u001dNC\u0005q\u0015\u0001N\u0018+U\u0001\u0012V\r^;s]N\u0004C\u000f[3!S\u0012\u0004\u0013M\u001c3!G>,h\u000e\u001e\u0011pM\u0002\"\b.\u001a\u0011mCJ<Wm\u001d;!OJ|W\u000f\u001d\u0011+_Q\u0011\u0001\u000b\u0018\t\u0004#fKeB\u0001*X\u001d\t\u0019f+D\u0001U\u0015\t)\u0016#\u0001\u0004=e>|GOP\u0005\u0002/%\u0011\u0001LF\u0001\ba\u0006\u001c7.Y4f\u0013\tQ6L\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tAf\u0003C\u0003^\u000b\u0001\u00071&A\u0001lQ\u0011)q&O0\"\u0003\u0001\fqg\f\u0016+AI+G/\u001e:og\u0002\"\b.\u001a\u0011jI\u0002\ng\u000e\u001a\u0011d_VtG\u000fI8gAQDW\rI6!Y\u0006\u0014x-Z:uA\u001d\u0014x.\u001e9tA)z\u0003\u0006\u0002\u00010s\t\f\u0013aY\u0001\u0005\u0018=R#F\u0003\u0011!U\u0001\u0002VO\u00197jG\u0002Jg\u000e^3sM\u0006\u001cW\r\t4pe\u0002\"\b.\u001a\u0011D_VtG/\u001a:!\u0003BK\u0005e^5uQ&t\u0007eW.He\u0006\u0004\bn\u0015;bi\u0016lVL\f\u0006!A)R\u0001\u0005\t\u0016!A\u0005\u00033i\\;oi\u0016\u0014\b%\\1j]R\f\u0017N\\:!i\",\u0007\u0005Z5tiJL'-\u001e;j_:\u0004sN\u001a\u0011dCR,wm\u001c:jG\u0006d\u0007e\u001a:pkBLgnZ:!gV\u001c\u0007\u000eI1tA\r|W.\\;oSRLH\u0006I2p]:,7\r^3eA\r|W\u000e]8oK:$\be\u001c:!]>$W\r\t;za\u0016t#\u0002\t\u0011+A\u0001\"\u0006.[:!K:\f'\r\\3tA5,\u0017m];sKN\u00043/^2iA\u0005\u001c\b\u0005\u001e5fAML'0Z\u0018sK2\fG/\u001b<fAML'0\u001a\u0011pM\u0002\"\b.\u001a\u0011mCJ<Wm\u001d;!OJ|W\u000f\u001d\u0011pe\u0002b\u0017M]4fgR\u00043\u000eI4s_V\u00048\u000f\f\u0011gS2$XM]5oO\u0002\"x\u000eI5oG2,H-\u001a\u0006!A)\u0002\u0003e\u001c8ms\u0002\"\b.\u001a\u0011mCJ<Wm\u001d;0Y\u0006\u0014x-Z:uA-\u0004sM]8vaN\u0004S\r^2/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003\t\u001e9be\u0006l\u0007\u0005\u0016\u0011WC2,X\r\t;za\u0016\u0004sN\u001a\u0011uQ\u0016\u00043-\u0019;fO>\u0014\u0018\u0010\t2fS:<\u0007e\u001a:pkB,G\r\t\u0015vgV\fG\u000e\\=!Y>tw\rI5gAI,g-\u001a:sS:<\u0007\u0005^8!C\u0002:'o\\;qA=\u0014\beY8na>tWM\u001c;!S\u0012L#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t!tK\u0016T\u0001\u0005\t\u0016!7n;%/\u00199i'R\fG/Z/^Y\u0001Z6\fS5ti><'/Y7^;*\u0001\u0003EK\u0018")
public abstract class Counter<T> {
    @Scaladoc(value="/** Total of the counts */")
    public abstract int totalCount();

    @Scaladoc(value="/** Getter function for the map of counts */")
    public abstract MapView<T, Object> getCounts();

    @Scaladoc(value="/** Returns the id and count of the largest group */")
    public abstract Tuple2<T, Object> largest();

    @Scaladoc(value="/** Returns the id and count of the k largest groups */")
    public abstract Iterable<Tuple2<T, Object>> largest(int var1);
}

