/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.algorithm;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.GenericallyApplicable;
import com.raphtory.api.analysis.algorithm.Multilayer;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.algorithm.MultilayerReduction;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteMultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.MultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base class for writing graph algorithms that preserve views\n  *\n  * @define chainBody The new algorithm's `apply` method first applies this algorithm and then the `other`,\n  *                   clearing all messages in-between. The `tabularise` method of the chained algorithm calls only\n  *                   the `tabularise` method of `other`.\n  */")
@ScalaSignature(bytes="\u0006\u0005q3qa\u0002\u0005\u0011\u0002\u0007\u00051\u0003C\u0003\u001f\u0001\u0011\u0005q$\u0002\u0003$\u0001\u0001\"\u0003\"\u0002\u0016\u0001\t\u0003Y\u0003\"B!\u0001\t\u0003\u0012\u0005\"B!\u0001\t\u0003I\u0005\"B!\u0001\t\u0003\t&aB$f]\u0016\u0014\u0018n\u0019\u0006\u0003\u0013)\t\u0011\"\u00197h_JLG\u000f[7\u000b\u0005-a\u0011\u0001C1oC2L8/[:\u000b\u00055q\u0011aA1qS*\u0011q\u0002E\u0001\te\u0006\u0004\b\u000e^8ss*\t\u0011#A\u0002d_6\u001c\u0001aE\u0002\u0001)i\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007CA\u000e\u001d\u001b\u0005A\u0011BA\u000f\t\u0005U9UM\\3sS\u000e\fG\u000e\\=BaBd\u0017nY1cY\u0016\fa\u0001J5oSR$C#\u0001\u0011\u0011\u0005U\t\u0013B\u0001\u0012\u0017\u0005\u0011)f.\u001b;\u0003\u0007=+H\u000f\u0005\u0002&Q5\taE\u0003\u0002(\u0015\u0005IqM]1qQZLWm^\u0005\u0003S\u0019\u0012\u0001c\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00051z\u0003CA\u00172\u001d\tqs\u0006\u0004\u0001\t\u000bA\u001a\u0001\u0019\u0001\u0013\u0002\u000b\u001d\u0014\u0018\r\u001d5\n\u0005IB#!B$sCBD\u0007\u0006B\u00025}}\u0002\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!!\u000f\u001e\u0002\u000fQ\f7.\u001a>pK*\u00111\bE\u0001\u0007O&$\b.\u001e2\n\u0005u2$\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003\u0001\u000b!QJ\u0018+U\u0001j\u0015-\u001b8!C2<wN]5uQ6T\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0011+g-Y;mi\u0002JW\u000e\u001d7f[\u0016tG/\u0019;j_:\u0004#/\u001a;ve:\u001c\b\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5!k:\u001c\u0007.\u00198hK\u0012t#\u0002\t\u0011!A)\u0002C\u000b[5tAMDw.\u001e7eA\t,\u0007e\u001c<feJLG\rZ3oA\tL\be];cG2\f7o]3tAQ|\u0007\u0005Z3gS:,\u0007\u0005\u001e5fA\u0005\u001cG/^1m\u0015\u0001\u0002\u0003\u0005\t\u0016!C2<wN]5uQ6\u00043\u000f^3qg\u0002*h\u000e\\3tg\u0002\"\b.\u001a\u0011bY\u001e|'/\u001b;i[\u0002zg\u000e\\=!_V$\b/\u001e;tA\u0015D\u0018n\u001d;j]\u001e\u00043\u000f^1uK\u0002z'\u000f\t9s_B,'\u000f^5fg:R\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA\u001d\u0014\u0018\r\u001d5!OJ\f\u0007\u000f\u001b\u0011u_\u0002\u0012XO\u001c\u0011gk:\u001cG/[8oAU\u0004xN\u001c\u0006!A\u0001\u0002#fL\u0001\u000fI5Lg.^:%OJ,\u0017\r^3s)\t\u0019E\t\u0005\u0002\u001c\u0001!)Q\t\u0002a\u0001\u0007\u0006)q\u000e\u001e5fe\"\"A\u0001\u000e HC\u0005A\u0015!!\u00060U)\u00023\t[1j]\u0002\"\b.[:!C2<wN]5uQ6\u0004s/\u001b;iA\u0005tw\u000e\u001e5fe\u0002:WM\\3sS\u000e\u0004\u0013\r\\4pe&$\b.\u001c\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005J2iC&t'i\u001c3z\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!_RDWM\u001d\u0011BY\u001e|'/\u001b;i[\u0002\"x\u000eI1qa2L\b%\u00194uKJ\u0004C\u000f[5tA=tWM\u0003\u0011!A\u0001Rs\u0006\u0006\u0002K\u001bB\u00111dS\u0005\u0003\u0019\"\u0011A#T;mi&d\u0017-_3s!J|'.Z2uS>t\u0007\"B#\u0006\u0001\u0004Q\u0005\u0006B\u00035}=\u000b\u0013\u0001U\u0001\u0002j=R#\u0006I\"iC&t\u0007\u0005\u001e5jg\u0002\nGnZ8sSRDW\u000eI<ji\"\u0004\u0013\rI.\\\u001bVdG/\u001b7bs\u0016\u0014\bK]8kK\u000e$\u0018n\u001c8^;\u0002\"x\u000eI2sK\u0006$X\rI1!]\u0016<\beW.Nk2$\u0018\u000e\\1zKJ\u0004&o\u001c6fGRLwN\\/^\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011%G\"\f\u0017N\u001c\"pIfT\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002zG\u000f[3sA\u0005cwm\u001c:ji\"l\u0007\u0005^8!CB\u0004H.\u001f\u0011bMR,'\u000f\t;iSN\u0004sN\\3\u000bA\u0001\u0002\u0003EK\u0018\u0015\u0005I+\u0006CA\u000eT\u0013\t!\u0006B\u0001\tHK:,'/[2SK\u0012,8\r^5p]\")QI\u0002a\u0001%\"\"a\u0001\u000e XC\u0005A\u0016!!\u00170U)\u00023\t[1j]\u0002\"\b.[:!C2<wN]5uQ6\u0004s/\u001b;iA\u0005\u00043lW$f]\u0016\u0014\u0018n\u0019*fIV\u001cG/[8o;v\u0003Co\u001c\u0011de\u0016\fG/\u001a\u0011bA9,w\u000fI.\\\u000f\u0016tWM]5d%\u0016$Wo\u0019;j_:lVL\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002Ce\u00195bS:\u0014u\u000eZ=\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011pi\",'\u000fI!mO>\u0014\u0018\u000e\u001e5nAQ|\u0007%\u00199qYf\u0004\u0013M\u001a;fe\u0002\"\b.[:!_:,'\u0002\t\u0011!A)z\u0003\u0006\u0002\u00015}i\u000b\u0013aW\u0001\u0003F>R#\u0006\t\"bg\u0016\u00043\r\\1tg\u00022wN\u001d\u0011xe&$\u0018N\\4!OJ\f\u0007\u000f\u001b\u0011bY\u001e|'/\u001b;i[N\u0004C\u000f[1uAA\u0014Xm]3sm\u0016\u0004c/[3xg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\tZ3gS:,\u0007e\u00195bS:\u0014u\u000eZ=!)\",\u0007E\\3xA\u0005dwm\u001c:ji\"lwe\u001d\u0011aCB\u0004H.\u001f1![\u0016$\bn\u001c3!M&\u00148\u000f\u001e\u0011baBd\u0017.Z:!i\"L7\u000fI1mO>\u0014\u0018\u000e\u001e5nA\u0005tG\r\t;iK:\u0004C\u000f[3!A>$\b.\u001a:aY)\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00023\r\\3be&tw\rI1mY\u0002jWm]:bO\u0016\u001c\b%\u001b8.E\u0016$x/Z3o]\u0001\"\u0006.\u001a\u0011ai\u0006\u0014W\u000f\\1sSN,\u0007\rI7fi\"|G\rI8gAQDW\rI2iC&tW\r\u001a\u0011bY\u001e|'/\u001b;i[\u0002\u001a\u0017\r\u001c7tA=tG.\u001f\u0006!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i\",\u0007\u0005\u0019;bEVd\u0017M]5tK\u0002\u0004S.\u001a;i_\u0012\u0004sN\u001a\u0011a_RDWM\u001d1/\u0015\u0001\u0002#f\f")
public interface Generic
extends GenericallyApplicable {
    public static /* synthetic */ ConcreteGraphPerspective apply$(Generic $this, GraphPerspective graph) {
        return $this.apply(graph);
    }

    @Override
    @Scaladoc(value="/** Main algorithm\n    *\n    * Default implementation returns the graph unchanged.\n    * This should be overridden by subclasses to define the actual\n    * algorithm steps unless the algorithm only outputs existing state or properties.\n    *\n    * @param graph graph to run function upon\n    */")
    default public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.identity();
    }

    public static /* synthetic */ Generic $minus$greater$(Generic $this, Generic other) {
        return $this.$minus$greater(other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public Generic $minus$greater(Generic other) {
        return new Generic(this, other){

            @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public Generic $minus$greater(Generic other) {
                return Generic.$minus$greater$((Generic)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return Generic.$minus$greater$((Generic)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return Generic.$minus$greater$((Generic)this, other);
            }

            public ConcreteGraphPerspective apply(GraphPerspective graph) {
                return ((Generic)this.second()).apply((GraphPerspective)((Generic)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(GraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                Generic.$init$(this);
            }
        };
    }

    public static /* synthetic */ MultilayerProjection $minus$greater$(Generic $this, MultilayerProjection other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return new MultilayerProjection(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(Generic other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[Multilayer]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(Multilayer other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(MultilayerReduction other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            public ConcreteMultilayerGraphPerspective apply(GraphPerspective graph) {
                return ((MultilayerProjection)this.second()).apply((GraphPerspective)((Generic)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(MultilayerGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                MultilayerProjection.$init$(this);
            }
        };
    }

    public static /* synthetic */ GenericReduction $minus$greater$(Generic $this, GenericReduction other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public GenericReduction $minus$greater(GenericReduction other) {
        return new GenericReduction(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(Generic other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
                return ((GenericReduction)this.second()).apply((GraphPerspective)((Generic)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(ReducedGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                GenericReduction.$init$(this);
            }
        };
    }

    public static void $init$(Generic $this) {
    }
}

