/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal.motif;

import com.raphtory.algorithms.temporal.motif.EdgeEvent;
import com.raphtory.algorithms.temporal.motif.MotifCounter;
import com.raphtory.algorithms.temporal.motif.ThreeNodeMotifs$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LongMap;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\u000e\u001c\u0001\u0019B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005Y!A1\u0007\u0001B\u0001B\u0003%A\u0007C\u0003A\u0001\u0011\u0005\u0011\tC\u0004G\u0001\t\u0007I\u0011A$\t\rM\u0003\u0001\u0015!\u0003I\u0011\u001d!\u0006A1A\u0005\u0002UCaA\u0016\u0001!\u0002\u0013\u0001\u0006bB,\u0001\u0005\u0004%\t\u0001\u0017\u0005\u00079\u0002\u0001\u000b\u0011B-\t\u000fu\u0003!\u0019!C\u00011\"1a\f\u0001Q\u0001\neCqa\u0018\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004a\u0001\u0001\u0006I!\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0001Y\u0011\u0019\u0011\u0007\u0001)A\u00053\"91\r\u0001b\u0001\n\u0003A\u0006B\u00023\u0001A\u0003%\u0011\fC\u0004f\u0001\t\u0007I\u0011\u0001-\t\r\u0019\u0004\u0001\u0015!\u0003Z\u0011\u00159\u0007\u0001\"\u0001i\u0011\u0015)\b\u0001\"\u0001w\u0011\u0015Q\b\u0001\"\u0001|\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u0019\t\t\u0002\u0001C\u00011\n\tBK]5bI6{G/\u001b4D_VtG/\u001a:\u000b\u0005qi\u0012!B7pi&4'B\u0001\u0010 \u0003!!X-\u001c9pe\u0006d'B\u0001\u0011\"\u0003)\tGnZ8sSRDWn\u001d\u0006\u0003E\r\n\u0001B]1qQR|'/\u001f\u0006\u0002I\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\n\t\u0003Q%j\u0011aG\u0005\u0003Um\u0011A\"T8uS\u001a\u001cu.\u001e8uKJ\f1!^5e!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0011auN\\4\u0002\u0007YLG-\u0001\u0006oK&<\u0007NY8veN\u00042!N\u001f-\u001d\t14H\u0004\u00028u5\t\u0001H\u0003\u0002:K\u00051AH]8pizJ\u0011aL\u0005\u0003y9\nq\u0001]1dW\u0006<W-\u0003\u0002?\u007f\tA\u0011\n^3sC\ndWM\u0003\u0002=]\u00051A(\u001b8jiz\"BAQ\"E\u000bB\u0011\u0001\u0006\u0001\u0005\u0006W\u0011\u0001\r\u0001\f\u0005\u0006e\u0011\u0001\r\u0001\f\u0005\u0006g\u0011\u0001\r\u0001N\u0001\u0005k>\u0014h/F\u0001I!\u0011IU\n\f)\u000f\u0005)[\u0005CA\u001c/\u0013\tae&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u00131!T1q\u0015\tae\u0006\u0005\u0002.#&\u0011!K\f\u0002\u0004\u0013:$\u0018!B;peZ\u0004\u0013!\u0001(\u0016\u0003A\u000b!A\u0014\u0011\u0002\u0011A\u0014XMT8eKN,\u0012!\u0017\t\u0004[ic\u0013BA./\u0005\u0015\t%O]1z\u0003%\u0001(/\u001a(pI\u0016\u001c\b%A\u0005q_N$hj\u001c3fg\u0006Q\u0001o\\:u\u001d>$Wm\u001d\u0011\u0002\rA\u0014XmU;n\u0003\u001d\u0001(/Z*v[\u0002\na!\\5e'Vl\u0017aB7jIN+X\u000eI\u0001\ba>\u001cHoU;n\u0003!\u0001xn\u001d;Tk6\u0004\u0013a\u00034j]\u0006d7i\\;oiN\fABZ5oC2\u001cu.\u001e8ug\u0002\nA\u0001];tQR!\u0011\u000e\u001c8q!\ti#.\u0003\u0002l]\t!QK\\5u\u0011\u0015iW\u00031\u0001Z\u0003!\u0019WO\u001d(pI\u0016\u001c\b\"B8\u0016\u0001\u0004I\u0016AB2veN+X\u000eC\u0003r+\u0001\u0007!/A\u0004dkJ,EmZ3\u0011\u0005!\u001a\u0018B\u0001;\u001c\u0005%)EmZ3Fm\u0016tG/A\u0002q_B$B![<ys\")QN\u0006a\u00013\")qN\u0006a\u00013\")\u0011O\u0006a\u0001e\u0006q\u0001O]8dKN\u001c8)\u001e:sK:$HCA5}\u0011\u0015\tx\u00031\u0001s\u000399WM\\3sCR,WI^3oiN$2a`A\u0001!\ri#L\u001d\u0005\b\u0003\u0007A\u0002\u0019AA\u0003\u0003\u0015)GmZ3t!\u0015)\u0014qAA\u0006\u0013\r\tIa\u0010\u0002\u0005\u0019&\u001cH\u000f\u0005\u0004.\u0003\u001baC\u0006L\u0005\u0004\u0003\u001fq#A\u0002+va2,7'A\u0005hKR\u001cu.\u001e8ug\u0002")
public class TriadMotifCounter
extends MotifCounter {
    private final long uid;
    private final long vid;
    private final Iterable<Object> neighbours;
    private final Map<Object, Object> uorv;
    private final int N;
    private final long[] preNodes;
    private final long[] postNodes;
    private final long[] preSum;
    private final long[] midSum;
    private final long[] postSum;
    private final long[] finalCounts;

    public Map<Object, Object> uorv() {
        return this.uorv;
    }

    public int N() {
        return this.N;
    }

    @Override
    public long[] preNodes() {
        return this.preNodes;
    }

    @Override
    public long[] postNodes() {
        return this.postNodes;
    }

    @Override
    public long[] preSum() {
        return this.preSum;
    }

    @Override
    public long[] midSum() {
        return this.midSum;
    }

    @Override
    public long[] postSum() {
        return this.postSum;
    }

    public long[] finalCounts() {
        return this.finalCounts;
    }

    @Override
    public void push(long[] curNodes, long[] curSum, EdgeEvent curEdge) {
        block0: {
            int isUorV = curEdge.uorv();
            int nb = curEdge.nb();
            int dir = curEdge.dir();
            if (nb == -1) break block0;
            int n = ThreeNodeMotifs$.MODULE$.map3D(1 - isUorV, this.incoming(), dir);
            curSum[n] = curSum[n] + curNodes[this.N() * ThreeNodeMotifs$.MODULE$.map2D(this.incoming(), 1 - isUorV) + nb];
            int n2 = ThreeNodeMotifs$.MODULE$.map3D(1 - isUorV, this.outgoing(), dir);
            curSum[n2] = curSum[n2] + curNodes[this.N() * ThreeNodeMotifs$.MODULE$.map2D(this.outgoing(), 1 - isUorV) + nb];
            int n3 = this.N() * ThreeNodeMotifs$.MODULE$.map2D(dir, isUorV) + nb;
            curNodes[n3] = curNodes[n3] + 1L;
        }
    }

    @Override
    public void pop(long[] curNodes, long[] curSum, EdgeEvent curEdge) {
        block0: {
            int isUorV = curEdge.uorv();
            int nb = curEdge.nb();
            int dir = curEdge.dir();
            if (nb == -1) break block0;
            int n = this.N() * ThreeNodeMotifs$.MODULE$.map2D(dir, isUorV) + nb;
            curNodes[n] = curNodes[n] - 1L;
            int n2 = ThreeNodeMotifs$.MODULE$.map3D(isUorV, dir, this.incoming());
            curSum[n2] = curSum[n2] - curNodes[this.N() * ThreeNodeMotifs$.MODULE$.map2D(this.incoming(), 1 - isUorV) + nb];
            int n3 = ThreeNodeMotifs$.MODULE$.map3D(isUorV, dir, this.outgoing());
            curSum[n3] = curSum[n3] - curNodes[this.N() * ThreeNodeMotifs$.MODULE$.map2D(this.outgoing(), 1 - isUorV) + nb];
        }
    }

    @Override
    public void processCurrent(EdgeEvent curEdge) {
        int isUorV = curEdge.uorv();
        int nb = curEdge.nb();
        int dir = curEdge.dir();
        if (nb != -1) {
            int n = ThreeNodeMotifs$.MODULE$.map3D(1 - isUorV, this.incoming(), dir);
            this.midSum()[n] = this.midSum()[n] - this.preNodes()[this.N() * ThreeNodeMotifs$.MODULE$.map2D(this.incoming(), 1 - isUorV) + nb];
            int n2 = ThreeNodeMotifs$.MODULE$.map3D(1 - isUorV, this.outgoing(), dir);
            this.midSum()[n2] = this.midSum()[n2] - this.preNodes()[this.N() * ThreeNodeMotifs$.MODULE$.map2D(this.outgoing(), 1 - isUorV) + nb];
            int n3 = ThreeNodeMotifs$.MODULE$.map3D(isUorV, dir, this.incoming());
            this.midSum()[n3] = this.midSum()[n3] + this.postNodes()[this.N() * ThreeNodeMotifs$.MODULE$.map2D(this.incoming(), 1 - isUorV) + nb];
            int n4 = ThreeNodeMotifs$.MODULE$.map3D(isUorV, dir, this.outgoing());
            this.midSum()[n4] = this.midSum()[n4] + this.postNodes()[this.N() * ThreeNodeMotifs$.MODULE$.map2D(this.outgoing(), 1 - isUorV) + nb];
        } else {
            int utov = 0;
            if (isUorV == 1) {
                utov = 1;
            }
            this.finalCounts()[0] = this.finalCounts()[0] + (this.midSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 0, 0)] + this.postSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 0, 1)] + this.preSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 1, 1)]);
            this.finalCounts()[4] = this.finalCounts()[4] + (this.midSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 1, 0)] + this.postSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 0, 1)] + this.preSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 0, 1)]);
            this.finalCounts()[2] = this.finalCounts()[2] + (this.midSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 0, 0)] + this.postSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 1, 1)] + this.preSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 1, 0)]);
            this.finalCounts()[6] = this.finalCounts()[6] + (this.midSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 1, 0)] + this.postSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 1, 1)] + this.preSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 0, 0)]);
            this.finalCounts()[1] = this.finalCounts()[1] + (this.midSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 0, 1)] + this.postSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 0, 0)] + this.preSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 1, 1)]);
            this.finalCounts()[5] = this.finalCounts()[5] + (this.midSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 1, 1)] + this.postSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 0, 0)] + this.preSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 0, 1)]);
            this.finalCounts()[3] = this.finalCounts()[3] + (this.midSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 0, 1)] + this.postSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 1, 0)] + this.preSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 1, 0)]);
            this.finalCounts()[7] = this.finalCounts()[7] + (this.midSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 1, 1)] + this.postSum()[ThreeNodeMotifs$.MODULE$.map3D(1 - utov, 1, 0)] + this.preSum()[ThreeNodeMotifs$.MODULE$.map3D(utov, 0, 0)]);
        }
    }

    @Override
    public EdgeEvent[] generateEvents(List<Tuple3<Object, Object, Object>> edges) {
        LongMap neighMap = new LongMap(this.N() + 2);
        ((IterableOnceOps)this.neighbours.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long nb = tuple2._1$mcJ$sp();
            int i = tuple2._2$mcI$sp();
            Option option = neighMap.put(nb, (Object)BoxesRunTime.boxToInteger((int)i));
            return option;
        });
        neighMap.put(this.uid, (Object)BoxesRunTime.boxToInteger((int)-1));
        neighMap.put(this.vid, (Object)BoxesRunTime.boxToInteger((int)-1));
        return (EdgeEvent[])edges.map((Function1 & Serializable)e -> BoxesRunTime.unboxToLong((Object)e._2()) == $this.uid || BoxesRunTime.unboxToLong((Object)e._2()) == $this.vid ? new EdgeEvent(BoxesRunTime.unboxToInt((Object)neighMap.apply(BoxesRunTime.unboxToLong((Object)e._1()))), this.incoming(), BoxesRunTime.unboxToInt((Object)this.uorv().apply(e._2())), BoxesRunTime.unboxToLong((Object)e._3())) : new EdgeEvent(BoxesRunTime.unboxToInt((Object)neighMap.apply(BoxesRunTime.unboxToLong((Object)e._2()))), this.outgoing(), BoxesRunTime.unboxToInt((Object)this.uorv().apply(e._1())), BoxesRunTime.unboxToLong((Object)e._3()))).toArray(ClassTag$.MODULE$.apply(EdgeEvent.class));
    }

    public long[] getCounts() {
        return this.finalCounts();
    }

    public TriadMotifCounter(long uid, long vid, Iterable<Object> neighbours) {
        this.uid = uid;
        this.vid = vid;
        this.neighbours = neighbours;
        this.uorv = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)uid)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)vid)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        this.N = neighbours.size();
        this.preNodes = (long[])Array$.MODULE$.fill(4 * this.N(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.postNodes = (long[])Array$.MODULE$.fill(4 * this.N(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.preSum = (long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.midSum = (long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.postSum = (long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        this.finalCounts = (long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
    }
}

