/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.algorithm.NodeListOutput;
import com.raphtory.api.analysis.algorithm.NodeListOutput$;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.ConcreteExplodedEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`MotifAlpha()`\n  *  : count Type1 2-edge-1-node temporal motifs\n  *\n  * The algorithms identifies 2-edge-1-node temporal motifs; It detects one type of motifs:\n  * For each incoming edge a vertex has, the algorithm checks whether there are any outgoing\n  * edges which occur after it and returns a count of these.\n  *\n  * ````{note}\n  * In other words, it detects motifs that exhibit incoming flow followed by outgoing flow in the form\n  *\n  * ```{image} /images/mc1.png\n  * :width: 200px\n  * :alt: mc type 1\n  * :align: center\n  * ```\n  * ````\n  *\n  * ## States\n  *\n  *  {s}`motifAlpha: Int`\n  *    : Number of Type-1 temporal motifs centered on the vertex\n  *\n  * ## Returns\n  *\n  *  | vertex name       | Number of Type-1 motifs |\n  *  | ----------------- | ----------------------- |\n  *  | {s}`name: String` | {s}`motifAlpha: Int`    |\n  */")
public final class MotifAlpha$
extends NodeListOutput
implements GenericReduction {
    public static final MotifAlpha$ MODULE$ = new MotifAlpha$();

    static {
        GenericReduction.$init$(MODULE$);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(Generic other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return (ConcreteReducedGraphPerspective)graph.reducedView().step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            MotifAlpha$.$anonfun$apply$1(vertex);
            return BoxedUnit.UNIT;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MotifAlpha$.class);
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(ConcreteExplodedEdge inEdge$1, ConcreteExplodedEdge e) {
        return e.timestamp() > inEdge$1.timestamp() & BoxesRunTime.unboxToLong((Object)e.dst()) != BoxesRunTime.unboxToLong((Object)inEdge$1.src()) & BoxesRunTime.unboxToLong((Object)e.dst()) != BoxesRunTime.unboxToLong((Object)inEdge$1.dst());
    }

    public static final /* synthetic */ int $anonfun$apply$2(ReducedVertex vertex$1, ConcreteExplodedEdge inEdge) {
        return vertex$1.explodeOutEdges(vertex$1.explodeOutEdges$default$1(), vertex$1.explodeOutEdges$default$2()).count((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)MotifAlpha$.$anonfun$apply$3(inEdge, e)));
    }

    public static final /* synthetic */ void $anonfun$apply$1(ReducedVertex vertex) {
        if (vertex.explodeInEdges(vertex.explodeInEdges$default$1(), vertex.explodeInEdges$default$2()).nonEmpty() & vertex.explodeOutEdges(vertex.explodeOutEdges$default$1(), vertex.explodeOutEdges$default$2()).nonEmpty()) {
            ((EntityVisitor)((Object)vertex)).setState("motifAlpha", vertex.explodeInEdges(vertex.explodeInEdges$default$1(), vertex.explodeInEdges$default$2()).map((Function1 & Serializable)inEdge -> BoxesRunTime.boxToInteger((int)MotifAlpha$.$anonfun$apply$2(vertex, inEdge))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        } else {
            ((EntityVisitor)((Object)vertex)).setState("motifAlpha", BoxesRunTime.boxToInteger((int)0));
        }
    }

    private MotifAlpha$() {
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"motifAlpha"}))), NodeListOutput$.MODULE$.$lessinit$greater$default$2());
    }
}

